/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.util;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ExpiringLruCache<K, V> {
    private final int maxSize;
    private final long expireAfterWriteMillis;
    private final ReentrantLock lock = new ReentrantLock();
    private final LinkedHashMap<K, Entry<V>> map;

    public ExpiringLruCache(int maxSize, long expireAfterWrite, TimeUnit unit) {
        this.maxSize = maxSize;
        this.expireAfterWriteMillis = unit.toMillis(expireAfterWrite);
        this.map = new LinkedHashMap(16, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this.lock.lock();
        try {
            Entry<V> entry = this.map.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            if (entry.isExpired(this.expireAfterWriteMillis)) {
                this.map.remove(key);
                V v = null;
                return v;
            }
            Object v = entry.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.lock.lock();
        try {
            this.map.put(key, new Entry<V>(value));
            while (this.map.size() > this.maxSize) {
                K eldest = this.map.keySet().iterator().next();
                this.map.remove(eldest);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidate(K key) {
        this.lock.lock();
        try {
            this.map.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateAll() {
        this.lock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Entry<V> {
        final V value;
        final long writeTime;

        Entry(V value) {
            this.value = value;
            this.writeTime = System.currentTimeMillis();
        }

        boolean isExpired(long expireAfterMillis) {
            return System.currentTimeMillis() - this.writeTime > expireAfterMillis;
        }
    }
}

