/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.DapServer;
import org.lucee.extension.debugger.EnvUtil;
import org.lucee.extension.debugger.Log;
import org.lucee.extension.debugger.coreinject.NativeLuceeVm;

public class ExtensionActivator {
    private static NativeLuceeVm luceeVm;
    private static ClassLoader luceeLoader;
    private static ClassLoader extensionLoader;
    private static boolean listenerRegistered;
    private static boolean alreadyActivated;
    private static ExtensionActivator instance;

    public ExtensionActivator(lucee.runtime.config.Config luceeConfig) {
        if (alreadyActivated) {
            return;
        }
        alreadyActivated = true;
        instance = this;
        try {
            int debugPort = EnvUtil.getDebuggerPort();
            if (debugPort < 0) {
                Log.info("Debugger disabled - set LUCEE_DAP_SECRET to enable");
                return;
            }
            Log.info("Extension activating");
            extensionLoader = this.getClass().getClassLoader();
            luceeLoader = luceeConfig.getClass().getClassLoader();
            String configPath = luceeConfig.getConfigDir().getAbsolutePath();
            boolean fsCaseSensitive = Config.checkIfFileSystemIsCaseSensitive(configPath);
            Config config = new Config(fsCaseSensitive);
            NativeLuceeVm.setLuceeClassLoader(luceeLoader);
            luceeVm = new NativeLuceeVm(config);
            int port = debugPort;
            Config finalConfig = config;
            Thread dapThread = new Thread(() -> {
                System.out.println("[luceedebug] DAP server thread started");
                System.out.flush();
                try {
                    System.out.println("[luceedebug] Calling DapServer.createForSocket on port " + port);
                    System.out.flush();
                    DapServer.createForSocket(luceeVm, finalConfig, "localhost", port);
                    System.out.println("[luceedebug] DAP server createForSocket returned unexpectedly");
                }
                catch (Throwable t) {
                    System.out.println("[luceedebug] DAP server thread failed: " + t.getClass().getName() + ": " + t.getMessage());
                    t.printStackTrace(System.out);
                    Log.error("DAP server thread failed", t);
                }
                System.out.println("[luceedebug] DAP server thread exiting");
            }, "luceedebug-dap-server");
            dapThread.setDaemon(true);
            dapThread.setUncaughtExceptionHandler((t, e) -> {
                System.out.println("[luceedebug] DAP thread died with uncaught exception: " + e.getClass().getName() + ": " + e.getMessage());
                e.printStackTrace(System.out);
            });
            dapThread.start();
            Log.info("Native mode, DAP server starting on localhost:" + debugPort);
        }
        catch (Throwable t2) {
            System.out.println("[luceedebug] Extension activation failed: " + t2.getClass().getName() + ": " + t2.getMessage());
            t2.printStackTrace(System.out);
            Log.error("Extension activation failed", t2);
        }
    }

    public static synchronized boolean registerListener(String secret) {
        if (luceeLoader == null || extensionLoader == null) {
            Log.error("Cannot register listener - extension not initialized");
            return false;
        }
        if (secret == null || secret.trim().isEmpty()) {
            Log.error("Cannot register listener - no secret provided");
            return false;
        }
        String expectedSecret = EnvUtil.getDebuggerSecret();
        if (expectedSecret == null || !expectedSecret.equals(secret.trim())) {
            Log.error("Invalid secret");
            return false;
        }
        if (!listenerRegistered) {
            if (ExtensionActivator.registerNativeDebuggerListener(luceeLoader, extensionLoader, secret.trim())) {
                listenerRegistered = true;
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean isListenerRegistered() {
        return listenerRegistered;
    }

    public static boolean isNativeModeActive() {
        return alreadyActivated;
    }

    private void enableDebuggerExecutionLog(lucee.runtime.config.Config luceeConfig, ClassLoader luceeLoader) {
        try {
            Class<?> configAdminClass = luceeLoader.loadClass("lucee.runtime.config.ConfigAdmin");
            Class<?> classDefClass = luceeLoader.loadClass("lucee.runtime.db.ClassDefinition");
            Class<?> classDefImplClass = luceeLoader.loadClass("lucee.transformer.library.ClassDefinitionImpl");
            Class<?> structClass = luceeLoader.loadClass("lucee.runtime.type.Struct");
            Class<?> structImplClass = luceeLoader.loadClass("lucee.runtime.type.StructImpl");
            Object configAdmin = null;
            for (Method m : configAdminClass.getMethods()) {
                Class<?>[] params;
                if (!m.getName().equals("newInstance") || m.getParameterCount() < 2 || !(params = m.getParameterTypes())[0].isAssignableFrom(luceeConfig.getClass())) continue;
                try {
                    if (params.length == 2) {
                        configAdmin = m.invoke(null, luceeConfig, null);
                    } else if (params.length == 3 && params[2] == Boolean.TYPE) {
                        configAdmin = m.invoke(null, luceeConfig, null, true);
                    }
                    if (configAdmin == null) continue;
                    Log.info("Created ConfigAdmin using " + String.valueOf(m));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (configAdmin == null) {
                Log.error("Could not create ConfigAdmin - no compatible newInstance method found");
                Log.info("Available newInstance methods:");
                for (Method m : configAdminClass.getMethods()) {
                    if (!m.getName().equals("newInstance")) continue;
                    Log.info("  " + String.valueOf(m));
                }
                return;
            }
            Constructor<?> cdConstructor = classDefImplClass.getConstructor(String.class);
            Object classDefinition = cdConstructor.newInstance("lucee.runtime.engine.DebuggerExecutionLog");
            Object emptyStruct = structImplClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method updateMethod = configAdminClass.getMethod("updateExecutionLog", classDefClass, structClass, Boolean.TYPE);
            updateMethod.invoke(configAdmin, classDefinition, emptyStruct, true);
            Method storeMethod = configAdminClass.getMethod("storeAndReload", new Class[0]);
            storeMethod.invoke(configAdmin, new Object[0]);
            Log.info("Enabled DebuggerExecutionLog - templates will recompile with debugger bytecode");
        }
        catch (ClassNotFoundException e) {
            Log.error("ConfigAdmin not found - cannot enable execution log: " + e.getMessage());
        }
        catch (Throwable e) {
            Log.error("Failed to enable execution log", e);
        }
    }

    private static boolean registerNativeDebuggerListener(ClassLoader luceeLoader, ClassLoader extensionLoader, String secret) {
        try {
            Class<?> registryClass = luceeLoader.loadClass("lucee.runtime.debug.DebuggerRegistry");
            Class<?> listenerInterface = luceeLoader.loadClass("lucee.runtime.debug.DebuggerListener");
            Class<?> pageContextClass = luceeLoader.loadClass("lucee.runtime.PageContext");
            Class<?> nativeListenerClass = extensionLoader.loadClass("org.lucee.extension.debugger.coreinject.NativeDebuggerListener");
            Method getNameMethod = nativeListenerClass.getMethod("getName", new Class[0]);
            Method onSuspendMethod = nativeListenerClass.getMethod("onSuspend", pageContextClass, String.class, Integer.TYPE, String.class);
            Method onResumeMethod = nativeListenerClass.getMethod("onResume", pageContextClass);
            Method shouldSuspendMethod = nativeListenerClass.getMethod("shouldSuspend", pageContextClass, String.class, Integer.TYPE);
            Method isDapClientConnectedMethod = nativeListenerClass.getMethod("isDapClientConnected", new Class[0]);
            Method onExceptionMethod = nativeListenerClass.getMethod("onException", pageContextClass, Throwable.class, Boolean.TYPE);
            Method onOutputMethod = nativeListenerClass.getMethod("onOutput", String.class, Boolean.TYPE);
            Method onFunctionEntryMethod = nativeListenerClass.getMethod("onFunctionEntry", pageContextClass, String.class, String.class, String.class, Integer.TYPE);
            Object listenerProxy = Proxy.newProxyInstance(luceeLoader, new Class[]{listenerInterface}, (proxy, method, args) -> {
                try {
                    switch (method.getName()) {
                        case "getName": {
                            return getNameMethod.invoke(null, new Object[0]);
                        }
                        case "isClientConnected": {
                            return isDapClientConnectedMethod.invoke(null, new Object[0]);
                        }
                        case "onSuspend": {
                            return onSuspendMethod.invoke(null, args);
                        }
                        case "onResume": {
                            return onResumeMethod.invoke(null, args);
                        }
                        case "shouldSuspend": {
                            return shouldSuspendMethod.invoke(null, args);
                        }
                        case "onException": {
                            return onExceptionMethod.invoke(null, args);
                        }
                        case "onOutput": {
                            return onOutputMethod.invoke(null, args);
                        }
                        case "onFunctionEntry": {
                            return onFunctionEntryMethod.invoke(null, args);
                        }
                    }
                    return null;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    Log.error("Proxy invocation failed for " + method.getName(), cause);
                    if (method.getReturnType() == Boolean.TYPE) {
                        return false;
                    }
                    return null;
                }
            });
            Method setListener = registryClass.getMethod("setListener", listenerInterface, String.class);
            Boolean success = (Boolean)setListener.invoke(null, listenerProxy, secret);
            if (success.booleanValue()) {
                Log.info("Registered native debugger listener");
                return true;
            }
            Log.error("Debugger registration rejected - secret mismatch");
            return false;
        }
        catch (ClassNotFoundException e) {
            Log.info("DebuggerRegistry not found - requires Lucee 7.1+");
            return false;
        }
        catch (NoSuchMethodException e) {
            Log.error("DebuggerRegistry.setListener(listener, secret) not found - requires updated Lucee 7.1+");
            return false;
        }
        catch (Throwable e) {
            Log.error("Failed to register listener", e);
            return false;
        }
    }

    static {
        listenerRegistered = false;
        alreadyActivated = false;
    }
}

