/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ValTracker {
    private final Cleaner cleaner;
    private final Map<Object, WeakTaggedObject> wrapperByObj = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Long, WeakTaggedObject> wrapperByID = new ConcurrentHashMap<Long, WeakTaggedObject>();
    private final Map<Long, String> pathById = new ConcurrentHashMap<Long, String>();
    private final Map<Long, Long> frameIdById = new ConcurrentHashMap<Long, Long>();

    public ValTracker(Cleaner cleaner) {
        this.cleaner = cleaner;
    }

    public TaggedObject idempotentRegisterObject(Object obj) {
        Optional<TaggedObject> maybeStrong;
        Objects.requireNonNull(obj);
        WeakTaggedObject weakTaggedObj = this.wrapperByObj.get(obj);
        if (weakTaggedObj != null && (maybeStrong = weakTaggedObj.maybeToStrong()).isPresent()) {
            return maybeStrong.get();
        }
        WeakTaggedObject fresh = new WeakTaggedObject(obj);
        this.registerCleaner(obj, fresh.id);
        this.wrapperByObj.put(obj, fresh);
        this.wrapperByID.put(fresh.id, fresh);
        return fresh.maybeToStrong().get();
    }

    private void registerCleaner(Object obj, long id) {
        this.cleaner.register(obj, new CleanerRunner(id));
    }

    public Optional<TaggedObject> maybeGetFromId(long id) {
        WeakTaggedObject weakTaggedObj = this.wrapperByID.get(id);
        if (weakTaggedObj == null) {
            return Optional.empty();
        }
        return weakTaggedObj.maybeToStrong();
    }

    public void setPath(long id, String path) {
        if (path != null) {
            this.pathById.put(id, path);
        }
    }

    public String getPath(long id) {
        return this.pathById.get(id);
    }

    public TaggedObject registerObjectWithPath(Object obj, String path) {
        TaggedObject tagged = this.idempotentRegisterObject(obj);
        if (path != null) {
            this.pathById.put(tagged.id, path);
        }
        return tagged;
    }

    public TaggedObject registerObjectWithPathAndFrameId(Object obj, String path, Long frameId) {
        TaggedObject tagged = this.idempotentRegisterObject(obj);
        if (path != null) {
            this.pathById.put(tagged.id, path);
        }
        if (frameId != null) {
            this.frameIdById.put(tagged.id, frameId);
        }
        return tagged;
    }

    public void setFrameId(long id, long frameId) {
        this.frameIdById.put(id, frameId);
    }

    public Long getFrameId(long id) {
        return this.frameIdById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __debug_updatedTracker(String what, long id) {
        Map<Object, WeakTaggedObject> map = this.wrapperByObj;
        synchronized (map) {
            System.out.println(what + " id=" + id + " wrapperByObjSize=" + this.wrapperByObj.entrySet().size() + ", wrapperByIDSize=" + this.wrapperByID.entrySet().size());
            for (Map.Entry<Object, WeakTaggedObject> e : this.wrapperByObj.entrySet()) {
                System.out.println(" entry (K null)=" + (e.getKey() == null ? "y" : "n") + " (V.id)=" + e.getValue().id + " (v.obj null)=" + (e.getValue().wrapped.get() == null ? "y" : "n"));
            }
        }
    }

    private static class WeakTaggedObject {
        private static final AtomicLong nextId = new AtomicLong(1L);
        public final long id = nextId.getAndIncrement();
        public final WeakReference<Object> wrapped;

        public WeakTaggedObject(Object obj) {
            this.wrapped = new WeakReference<Object>(Objects.requireNonNull(obj));
        }

        public Optional<TaggedObject> maybeToStrong() {
            Object obj = this.wrapped.get();
            if (obj == null) {
                return Optional.empty();
            }
            return Optional.of(new TaggedObject(this.id, obj));
        }
    }

    public static class TaggedObject {
        public final long id;
        public final Object obj;

        private TaggedObject(long id, Object obj) {
            this.id = id;
            this.obj = Objects.requireNonNull(obj);
        }
    }

    private class CleanerRunner
    implements Runnable {
        private final long id;

        CleanerRunner(long id) {
            this.id = id;
        }

        @Override
        public void run() {
            ValTracker.this.wrapperByID.remove(this.id);
            ValTracker.this.pathById.remove(this.id);
            ValTracker.this.frameIdById.remove(this.id);
        }
    }
}

