/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.runtime.PageContext;
import lucee.runtime.type.scope.Variables;
import org.eclipse.lsp4j.debug.CompletionItem;
import org.eclipse.lsp4j.debug.CompletionItemType;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.Either;
import org.lucee.extension.debugger.GlobalIDebugManagerHolder;
import org.lucee.extension.debugger.IBreakpoint;
import org.lucee.extension.debugger.ICfValueDebuggerBridge;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.ILuceeVm;
import org.lucee.extension.debugger.Log;
import org.lucee.extension.debugger.ThreadInfo;
import org.lucee.extension.debugger.coreinject.Breakpoint;
import org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge;
import org.lucee.extension.debugger.coreinject.NativeDebuggerListener;
import org.lucee.extension.debugger.coreinject.StepMode;
import org.lucee.extension.debugger.coreinject.ValTracker;
import org.lucee.extension.debugger.coreinject.frame.NativeDebugFrame;
import org.lucee.extension.debugger.strong.CanonicalServerAbsPath;
import org.lucee.extension.debugger.strong.DapBreakpointID;
import org.lucee.extension.debugger.strong.RawIdePath;

public class NativeLuceeVm
implements ILuceeVm {
    private final Config config_;
    private static ClassLoader luceeClassLoader;
    private static final Cleaner cleaner;
    private final ValTracker valTracker = new ValTracker(cleaner);
    private Consumer<Long> stepEventCallback = null;
    private BiConsumer<Long, DapBreakpointID> breakpointEventCallback = null;
    private BiConsumer<Long, String> nativeBreakpointEventCallback = null;
    private Consumer<Long> exceptionEventCallback = null;
    private Consumer<Long> pauseEventCallback = null;
    private Consumer<ILuceeVm.BreakpointsChangedEvent> breakpointsChangedCallback = null;
    private AtomicInteger breakpointID = new AtomicInteger();
    private final ConcurrentHashMap<Long, IDebugFrame> frameCache = new ConcurrentHashMap();
    private static final long ALL_THREADS_VIRTUAL_ID = 1L;

    public static void setLuceeClassLoader(ClassLoader cl) {
        luceeClassLoader = cl;
    }

    public NativeLuceeVm(Config config) {
        this.config_ = config;
        NativeDebuggerListener.setNativeMode(true);
        NativeDebuggerListener.setOnNativeSuspendCallback((javaThreadId, label) -> {
            if (this.nativeBreakpointEventCallback != null) {
                this.nativeBreakpointEventCallback.accept((Long)javaThreadId, (String)label);
            }
        });
        NativeDebuggerListener.setOnNativeStepCallback(javaThreadId -> {
            if (this.stepEventCallback != null) {
                this.stepEventCallback.accept((Long)javaThreadId);
            }
        });
        NativeDebuggerListener.setOnNativeExceptionCallback(javaThreadId -> {
            if (this.exceptionEventCallback != null) {
                this.exceptionEventCallback.accept((Long)javaThreadId);
            }
        });
        NativeDebuggerListener.setOnNativePauseCallback(javaThreadId -> {
            if (this.pauseEventCallback != null) {
                this.pauseEventCallback.accept((Long)javaThreadId);
            }
        });
    }

    private DapBreakpointID nextDapBreakpointID() {
        return new DapBreakpointID(this.breakpointID.incrementAndGet());
    }

    @Override
    public void registerStepEventCallback(Consumer<Long> cb) {
        this.stepEventCallback = cb;
    }

    @Override
    public void registerBreakpointEventCallback(BiConsumer<Long, DapBreakpointID> cb) {
        this.breakpointEventCallback = cb;
    }

    @Override
    public void registerNativeBreakpointEventCallback(BiConsumer<Long, String> cb) {
        this.nativeBreakpointEventCallback = cb;
    }

    @Override
    public void registerBreakpointsChangedCallback(Consumer<ILuceeVm.BreakpointsChangedEvent> cb) {
        this.breakpointsChangedCallback = cb;
    }

    @Override
    public ThreadInfo[] getThreadListing() {
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        HashSet<Long> seenThreadIds = new HashSet<Long>();
        for (Long threadId : NativeDebuggerListener.getSuspendedThreadIds()) {
            Thread thread = this.findThreadById(threadId);
            if (thread == null) continue;
            result.add(new ThreadInfo(thread.getId(), thread.getName() + " (suspended)"));
            seenThreadIds.add(threadId);
        }
        try {
            Object[] factories;
            CFMLEngine engine = CFMLEngineFactory.getInstance();
            Method getEngineMethod = engine.getClass().getMethod("getEngine", new Class[0]);
            Object engineImpl = getEngineMethod.invoke((Object)engine, new Object[0]);
            Method getFactoriesMethod = engineImpl.getClass().getMethod("getCFMLFactories", new Class[0]);
            Map factoriesMap = (Map)getFactoriesMethod.invoke(engineImpl, new Object[0]);
            for (Object factory : factories = factoriesMap.values().toArray()) {
                try {
                    Method getActiveMethod = factory.getClass().getMethod("getActivePageContexts", new Class[0]);
                    Map activeContexts = (Map)getActiveMethod.invoke(factory, new Object[0]);
                    for (Object pc : activeContexts.values()) {
                        try {
                            Method getThreadMethod = pc.getClass().getMethod("getThread", new Class[0]);
                            Thread thread = (Thread)getThreadMethod.invoke(pc, new Object[0]);
                            if (thread == null || seenThreadIds.contains(thread.getId())) continue;
                            result.add(new ThreadInfo(thread.getId(), thread.getName()));
                            seenThreadIds.add(thread.getId());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Log.error("Error getting thread listing", e);
        }
        if (!seenThreadIds.contains(1L)) {
            result.add(0, new ThreadInfo(1L, "All CFML Threads"));
        }
        Log.debug("Thread listing: " + result.size() + " threads");
        return result.toArray(new ThreadInfo[0]);
    }

    @Override
    public IDebugFrame[] getStackTrace(long threadID) {
        PageContext pc = NativeDebuggerListener.getPageContext(threadID);
        if (pc == null) {
            Log.debug("getStackTrace: no PageContext for thread " + threadID);
            return new IDebugFrame[0];
        }
        IDebugFrame[] frames = NativeDebugFrame.getNativeFrames(pc, this.valTracker, threadID, luceeClassLoader);
        if (frames == null) {
            Log.debug("getStackTrace: no native frames for thread " + threadID);
            return new IDebugFrame[0];
        }
        for (IDebugFrame frame : frames) {
            this.frameCache.put(frame.getId(), frame);
        }
        Log.trace("getStackTrace: returning " + frames.length + " frames for thread " + threadID);
        return frames;
    }

    private Thread findThreadById(long threadId) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (t.getId() != threadId) continue;
            return t;
        }
        return null;
    }

    @Override
    public IDebugEntity[] getScopes(long frameID) {
        IDebugFrame frame = this.frameCache.get(frameID);
        if (frame == null) {
            Log.debug("getScopes: frame " + frameID + " not found in cache");
            return new IDebugEntity[0];
        }
        return frame.getScopes();
    }

    @Override
    public IDebugEntity[] getVariables(long ID) {
        return this.getVariablesImpl(ID, null);
    }

    @Override
    public IDebugEntity[] getNamedVariables(long ID) {
        return this.getVariablesImpl(ID, IDebugEntity.DebugEntityType.NAMED);
    }

    @Override
    public IDebugEntity[] getIndexedVariables(long ID) {
        return this.getVariablesImpl(ID, IDebugEntity.DebugEntityType.INDEXED);
    }

    private IDebugEntity[] getVariablesImpl(long variablesReference, IDebugEntity.DebugEntityType which) {
        Optional<ValTracker.TaggedObject> maybeObj = this.valTracker.maybeGetFromId(variablesReference);
        if (maybeObj.isEmpty()) {
            Log.debug("getVariables: variablesReference " + variablesReference + " not found");
            return new IDebugEntity[0];
        }
        Object obj = maybeObj.get().obj;
        String parentPath = this.valTracker.getPath(variablesReference);
        Long frameId = this.valTracker.getFrameId(variablesReference);
        return CfValueDebuggerBridge.getAsDebugEntity(this.valTracker, obj, which, parentPath, frameId);
    }

    @Override
    public IBreakpoint[] bindBreakpoints(RawIdePath idePath, CanonicalServerAbsPath serverPath, int[] lines, String[] exprs) {
        NativeDebuggerListener.clearBreakpointsForFile((String)serverPath.get());
        int[] executableLines = this.getExecutableLines((String)serverPath.get());
        HashSet<Integer> validLines = new HashSet<Integer>();
        for (int line : executableLines) {
            validLines.add(line);
        }
        IBreakpoint[] result = new Breakpoint[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String condition = exprs != null && i < exprs.length ? exprs[i] : null;
            int requestedLine = lines[i];
            if (validLines.contains(requestedLine)) {
                NativeDebuggerListener.addBreakpoint((String)serverPath.get(), requestedLine, condition);
                result[i] = Breakpoint.Bound(requestedLine, this.nextDapBreakpointID());
                continue;
            }
            result[i] = Breakpoint.Unbound(requestedLine, this.nextDapBreakpointID());
        }
        return result;
    }

    @Override
    public void clearAllBreakpoints() {
        NativeDebuggerListener.clearAllBreakpoints();
    }

    @Override
    public void continue_(long threadID) {
        NativeDebuggerListener.resumeNativeThread(threadID);
    }

    @Override
    public void continueAll() {
        NativeDebuggerListener.resumeAllNativeThreads();
    }

    @Override
    public void stepIn(long threadID) {
        int currentDepth = this.getStackDepthForThread(threadID);
        NativeDebuggerListener.startStepping(threadID, StepMode.STEP_INTO, currentDepth);
        this.continue_(threadID);
    }

    @Override
    public void stepOver(long threadID) {
        int currentDepth = this.getStackDepthForThread(threadID);
        NativeDebuggerListener.startStepping(threadID, StepMode.STEP_OVER, currentDepth);
        this.continue_(threadID);
    }

    @Override
    public void stepOut(long threadID) {
        int currentDepth = this.getStackDepthForThread(threadID);
        NativeDebuggerListener.startStepping(threadID, StepMode.STEP_OUT, currentDepth);
        this.continue_(threadID);
    }

    private int getStackDepthForThread(long threadID) {
        PageContext pc = NativeDebuggerListener.getPageContext(threadID);
        return pc != null ? NativeDebuggerListener.getStackDepth(pc) : 0;
    }

    @Override
    public String dump(int dapVariablesReference) {
        return this.doDumpNative(dapVariablesReference, false);
    }

    @Override
    public String dumpAsJSON(int dapVariablesReference) {
        return this.doDumpNative(dapVariablesReference, true);
    }

    @Override
    public String getMetadata(int dapVariablesReference) {
        IDebugFrame frame;
        Optional<ValTracker.TaggedObject> maybeObj = this.valTracker.maybeGetFromId(dapVariablesReference);
        if (maybeObj.isEmpty()) {
            return "\"Variable not found\"";
        }
        Map<?, ?> obj = maybeObj.get().obj;
        if (obj instanceof CfValueDebuggerBridge.MarkerTrait.Scope) {
            obj = ((CfValueDebuggerBridge.MarkerTrait.Scope)((Object)obj)).scopelike;
        }
        PageContext pc = null;
        Long frameId = this.valTracker.getFrameId(dapVariablesReference);
        if (frameId != null && (frame = this.frameCache.get(frameId)) instanceof NativeDebugFrame) {
            pc = ((NativeDebugFrame)frame).getPageContext();
        }
        if (pc == null) {
            for (IDebugFrame frame2 : this.frameCache.values()) {
                if (frame2 instanceof NativeDebugFrame && (pc = ((NativeDebugFrame)frame2).getPageContext()) != null) break;
            }
        }
        if (pc == null) {
            return "\"No PageContext available\"";
        }
        return this.doGetMetadataWithPageContext(pc, obj);
    }

    private String doGetMetadataWithPageContext(PageContext sourcePC, Object target) {
        var result = new Object(){
            String value = "\"getMetadata failed\"";
        };
        PageContext pc = sourcePC;
        Object obj = target;
        Thread thread = new Thread(() -> {
            try {
                ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
                Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
                Method registerMethod = tlpcClass.getMethod("register", PageContext.class);
                Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
                registerMethod.invoke(null, pc);
                try {
                    Class<?> getMetaDataClass = cl.loadClass("lucee.runtime.functions.system.GetMetaData");
                    Method callMethod = getMetaDataClass.getMethod("call", PageContext.class, Object.class);
                    Object metadata = callMethod.invoke(null, pc, obj);
                    Class<?> serializeClass = cl.loadClass("lucee.runtime.functions.conversion.SerializeJSON");
                    Method serializeMethod = serializeClass.getMethod("call", PageContext.class, Object.class, Object.class);
                    result.value = (String)serializeMethod.invoke(null, pc, metadata, "struct");
                }
                finally {
                    releaseMethod.invoke(null, new Object[0]);
                }
            }
            catch (Throwable e) {
                Log.debug("getMetadata failed: " + e.getMessage());
                result.value = "\"Error: " + e.getMessage().replace("\"", "\\\"") + "\"";
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result.value;
    }

    private String doDumpNative(int dapVariablesReference, boolean asJson) {
        IDebugFrame frame;
        Optional<ValTracker.TaggedObject> maybeObj = this.valTracker.maybeGetFromId(dapVariablesReference);
        if (maybeObj.isEmpty()) {
            return asJson ? "\"Variable not found\"" : "<div>Variable not found</div>";
        }
        Map<?, ?> obj = maybeObj.get().obj;
        if (obj instanceof CfValueDebuggerBridge.MarkerTrait.Scope) {
            obj = ((CfValueDebuggerBridge.MarkerTrait.Scope)((Object)obj)).scopelike;
        }
        Long frameId = this.valTracker.getFrameId(dapVariablesReference);
        PageContext pc = null;
        if (frameId != null && (frame = this.frameCache.get(frameId)) instanceof NativeDebugFrame) {
            pc = ((NativeDebugFrame)frame).getPageContext();
        }
        if (pc == null) {
            for (IDebugFrame frame2 : this.frameCache.values()) {
                if (frame2 instanceof NativeDebugFrame && (pc = ((NativeDebugFrame)frame2).getPageContext()) != null) break;
            }
        }
        if (pc == null) {
            return asJson ? "\"No PageContext available\"" : "<div>No PageContext available</div>";
        }
        return this.doDumpWithPageContext(pc, obj, asJson);
    }

    private String doDumpWithPageContext(PageContext sourcePC, Object someDumpable, final boolean asJson) {
        var result = new Object(){
            String value;
            {
                this.value = asJson ? "\"dump failed\"" : "<div>dump failed</div>";
            }
        };
        PageContext pc = sourcePC;
        Object dumpable = someDumpable;
        Thread thread = new Thread(() -> {
            try {
                ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
                Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
                Method registerMethod = tlpcClass.getMethod("register", PageContext.class);
                Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
                registerMethod.invoke(null, pc);
                try {
                    if (asJson) {
                        Class<?> serializeClass = cl.loadClass("lucee.runtime.functions.conversion.SerializeJSON");
                        Method callMethod = serializeClass.getMethod("call", PageContext.class, Object.class, Object.class);
                        result.value = (String)callMethod.invoke(null, pc, dumpable, "struct");
                    } else {
                        result.value = NativeLuceeVm.wrapDumpInHtmlDoc(this.dumpObjectAsHtml(pc, cl, dumpable));
                    }
                }
                finally {
                    releaseMethod.invoke(null, new Object[0]);
                }
            }
            catch (Throwable e) {
                Log.debug("dump failed: " + e.getMessage());
                result.value = asJson ? "\"Error: " + e.getMessage().replace("\"", "\\\"") + "\"" : "<div>Error: " + e.getMessage() + "</div>";
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result.value;
    }

    private String dumpObjectAsHtml(PageContext pc, ClassLoader cl, Object obj) throws Exception {
        Class<?> dumpUtilClass = cl.loadClass("lucee.runtime.dump.DumpUtil");
        Class<?> dumpPropertiesClass = cl.loadClass("lucee.runtime.dump.DumpProperties");
        Class<?> dumpDataClass = cl.loadClass("lucee.runtime.dump.DumpData");
        Field defaultField = dumpPropertiesClass.getField("DEFAULT_RICH");
        Object dumpProps = defaultField.get(null);
        Method toDumpDataMethod = dumpUtilClass.getMethod("toDumpData", PageContext.class, Object.class, Integer.TYPE, dumpPropertiesClass);
        Object dumpData = toDumpDataMethod.invoke(null, pc, obj, 9999, dumpProps);
        Class<?> htmlDumpWriterClass = cl.loadClass("lucee.runtime.dump.HTMLDumpWriter");
        Object htmlWriter = htmlDumpWriterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Method toStringMethod = htmlDumpWriterClass.getMethod("toString", PageContext.class, dumpDataClass);
        return (String)toStringMethod.invoke(htmlWriter, pc, dumpData);
    }

    private static String wrapDumpInHtmlDoc(String dumpHtml) {
        return "<!DOCTYPE html>\n<html>\n<head>\n<style>\nbody { font-family: -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, sans-serif; }\n</style>\n</head>\n<body>\n" + dumpHtml + "</body>\n</html>\n";
    }

    @Override
    public String[] getTrackedCanonicalFileNames() {
        return new String[0];
    }

    @Override
    public String[][] getBreakpointDetail() {
        return NativeDebuggerListener.getBreakpointDetails();
    }

    @Override
    public String getApplicationSettings() {
        PageContext pc = null;
        for (IDebugFrame frame : this.frameCache.values()) {
            if (frame instanceof NativeDebugFrame && (pc = ((NativeDebugFrame)frame).getPageContext()) != null) break;
        }
        if (pc == null) {
            return "\"No PageContext available\"";
        }
        return this.doGetApplicationSettingsWithPageContext(pc);
    }

    private String doGetApplicationSettingsWithPageContext(PageContext sourcePC) {
        var result = new Object(){
            String value = "\"getApplicationSettings failed\"";
        };
        PageContext pc = sourcePC;
        Thread thread = new Thread(() -> {
            try {
                ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
                Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
                Method registerMethod = tlpcClass.getMethod("register", PageContext.class);
                Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
                registerMethod.invoke(null, pc);
                try {
                    Class<?> getAppSettingsClass = cl.loadClass("lucee.runtime.functions.system.GetApplicationSettings");
                    Method callMethod = getAppSettingsClass.getMethod("call", PageContext.class);
                    Object settings = callMethod.invoke(null, pc);
                    Class<?> serializeClass = cl.loadClass("lucee.runtime.functions.conversion.SerializeJSON");
                    Method serializeMethod = serializeClass.getMethod("call", PageContext.class, Object.class, Object.class);
                    result.value = (String)serializeMethod.invoke(null, pc, settings, "struct");
                }
                finally {
                    releaseMethod.invoke(null, new Object[0]);
                }
            }
            catch (Throwable e) {
                Log.debug("getApplicationSettings failed: " + e.getMessage());
                result.value = "\"Error: " + e.getMessage().replace("\"", "\\\"") + "\"";
            }
        });
        thread.start();
        try {
            thread.join(5000L);
        }
        catch (InterruptedException e) {
            return "\"Timeout getting application settings\"";
        }
        return result.value;
    }

    @Override
    public String getSourcePathForVariablesRef(int variablesRef) {
        return this.valTracker.maybeGetFromId(variablesRef).map(taggedObj -> CfValueDebuggerBridge.getSourcePath(taggedObj.obj)).orElse(null);
    }

    @Override
    public CompletionItem[] getCompletions(int frameId, String partialExpr) {
        PageContext pc = null;
        IDebugFrame frame = this.frameCache.get(frameId);
        if (frame instanceof NativeDebugFrame) {
            pc = ((NativeDebugFrame)frame).getPageContext();
        }
        if (pc == null) {
            for (IDebugFrame f : this.frameCache.values()) {
                if (f instanceof NativeDebugFrame && (pc = ((NativeDebugFrame)f).getPageContext()) != null) break;
            }
        }
        if (pc == null) {
            return new CompletionItem[0];
        }
        return this.doGetCompletionsWithPageContext(pc, partialExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionItem[] doGetCompletionsWithPageContext(PageContext pc, String partialExpr) {
        ArrayList<CompletionItem> results;
        block18: {
            results = new ArrayList<CompletionItem>();
            try {
                String[] scopes;
                ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
                String base = null;
                String prefix = partialExpr.toLowerCase();
                int lastDot = partialExpr.lastIndexOf(46);
                if (lastDot > 0) {
                    base = partialExpr.substring(0, lastDot);
                    prefix = partialExpr.substring(lastDot + 1).toLowerCase();
                }
                if (base != null) {
                    try {
                        Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
                        String[] registerMethod = tlpcClass.getMethod("register", PageContext.class);
                        Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
                        Class<?> evaluateClass = cl.loadClass("lucee.runtime.functions.dynamicEvaluation.Evaluate");
                        Method callMethod = evaluateClass.getMethod("call", PageContext.class, Object[].class);
                        registerMethod.invoke(null, pc);
                        try {
                            Object result = callMethod.invoke(null, pc, new Object[]{base});
                            if (result instanceof Map) {
                                Map map = (Map)result;
                                for (Object key : map.keySet()) {
                                    String keyStr = String.valueOf(key);
                                    if (!keyStr.toLowerCase().startsWith(prefix)) continue;
                                    CompletionItem item = new CompletionItem();
                                    item.setLabel(keyStr);
                                    item.setType(CompletionItemType.PROPERTY);
                                    results.add(item);
                                }
                            }
                            break block18;
                        }
                        finally {
                            releaseMethod.invoke(null, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        Log.debug("Completion evaluation failed: " + e.getMessage());
                    }
                    break block18;
                }
                for (String scope : scopes = new String[]{"variables", "local", "arguments", "form", "url", "cgi", "cookie", "session", "application", "server", "request", "this"}) {
                    if (!scope.toLowerCase().startsWith(prefix)) continue;
                    CompletionItem item = new CompletionItem();
                    item.setLabel(scope);
                    item.setType(CompletionItemType.MODULE);
                    results.add(item);
                }
                try {
                    Variables variablesScope = pc.variablesScope();
                    if (variablesScope instanceof Map) {
                        Map map = (Map)variablesScope;
                        for (Object key : map.keySet()) {
                            String keyStr = String.valueOf(key);
                            if (!keyStr.toLowerCase().startsWith(prefix)) continue;
                            CompletionItem item = new CompletionItem();
                            item.setLabel(keyStr);
                            item.setType(CompletionItemType.VARIABLE);
                            results.add(item);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                Log.debug("Completion failed: " + e.getMessage());
            }
        }
        results.sort((a, b) -> a.getLabel().compareToIgnoreCase(b.getLabel()));
        Log.info("Completions for '" + partialExpr + "': returning " + results.size() + " items");
        for (CompletionItem item : results) {
            Log.debug("  - " + item.getLabel());
        }
        if (results.size() > 100) {
            return results.subList(0, 100).toArray(new CompletionItem[0]);
        }
        return results.toArray(new CompletionItem[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Either<String, Either<ICfValueDebuggerBridge, String>> evaluate(int frameID, String expr) {
        IDebugFrame frame = this.frameCache.get(frameID);
        if (frame == null) {
            return Either.Left("Frame not found: " + frameID);
        }
        if (!(frame instanceof NativeDebugFrame)) {
            if (GlobalIDebugManagerHolder.debugManager == null) return Either.Left("evaluate only supported for native frames");
            return GlobalIDebugManagerHolder.debugManager.evaluate(Long.valueOf(frameID), expr);
        }
        NativeDebugFrame nativeFrame = (NativeDebugFrame)frame;
        PageContext pc = nativeFrame.getPageContext();
        if (pc == null) {
            return Either.Left("No PageContext available for frame");
        }
        try {
            ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
            Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
            Method registerMethod = tlpcClass.getMethod("register", PageContext.class);
            Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
            Class<?> evaluateClass = cl.loadClass("lucee.runtime.functions.dynamicEvaluation.Evaluate");
            Method callMethod = evaluateClass.getMethod("call", PageContext.class, Object[].class);
            registerMethod.invoke(null, pc);
            try {
                Object result = callMethod.invoke(null, pc, new Object[]{expr});
                if (result == null) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right("null"));
                    return either;
                }
                if (result instanceof String) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right("\"" + ((String)result).replaceAll("\"", "\\\\\"") + "\""));
                    return either;
                }
                if (result instanceof Number || result instanceof Boolean) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right(result.toString()));
                    return either;
                }
                CfValueDebuggerBridge bridge = new CfValueDebuggerBridge(this.valTracker, result);
                Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Left(bridge));
                return either;
            }
            finally {
                releaseMethod.invoke(null, new Object[0]);
            }
        }
        catch (Throwable e) {
            String msg;
            Throwable cause = e;
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                cause = e.getCause();
            }
            if ((msg = cause.getMessage()) != null) return Either.Left("Evaluation error: " + msg);
            msg = cause.getClass().getName();
            return Either.Left("Evaluation error: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Either<String, Either<ICfValueDebuggerBridge, String>> setVariable(long variablesReference, String name, String value, long frameIdHint) {
        Long trackedFrameId = this.valTracker.getFrameId(variablesReference);
        long actualFrameId = trackedFrameId != null ? trackedFrameId : frameIdHint;
        IDebugFrame frame = this.frameCache.get(actualFrameId);
        if (frame == null) {
            return Either.Left("Frame not found: " + actualFrameId);
        }
        if (!(frame instanceof NativeDebugFrame)) {
            return Either.Left("setVariable only supported for native frames");
        }
        NativeDebugFrame nativeFrame = (NativeDebugFrame)frame;
        PageContext pc = nativeFrame.getPageContext();
        if (pc == null) {
            return Either.Left("No PageContext available for frame");
        }
        String parentPath = this.valTracker.getPath(variablesReference);
        if (parentPath == null) {
            return Either.Left("Cannot determine variable path for variablesReference: " + variablesReference);
        }
        String fullPath = parentPath + "." + name;
        Log.debug("setVariable: " + fullPath + " = " + value);
        try {
            ClassLoader cl = luceeClassLoader != null ? luceeClassLoader : pc.getClass().getClassLoader();
            Class<?> tlpcClass = cl.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
            Method registerMethod = tlpcClass.getMethod("register", PageContext.class);
            Method releaseMethod = tlpcClass.getMethod("release", new Class[0]);
            Class<?> evaluateClass = cl.loadClass("lucee.runtime.functions.dynamicEvaluation.Evaluate");
            Method callMethod = evaluateClass.getMethod("call", PageContext.class, Object[].class);
            registerMethod.invoke(null, pc);
            try {
                Object evaluatedValue = callMethod.invoke(null, pc, new Object[]{value});
                Object result = pc.setVariable(fullPath, evaluatedValue);
                if (result == null) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right("null"));
                    return either;
                }
                if (result instanceof String) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right("\"" + ((String)result).replaceAll("\"", "\\\\\"") + "\""));
                    return either;
                }
                if (result instanceof Number || result instanceof Boolean) {
                    Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Right(result.toString()));
                    return either;
                }
                CfValueDebuggerBridge bridge = new CfValueDebuggerBridge(this.valTracker, result);
                Either<String, Either<ICfValueDebuggerBridge, String>> either = Either.Right(Either.Left(bridge));
                return either;
            }
            finally {
                releaseMethod.invoke(null, new Object[0]);
            }
        }
        catch (Throwable e) {
            String msg;
            Throwable cause = e;
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                cause = e.getCause();
            }
            if ((msg = cause.getMessage()) == null) {
                msg = cause.getClass().getName();
            }
            Log.debug("setVariable failed: " + msg);
            return Either.Left("Error setting variable: " + msg);
        }
    }

    @Override
    public void registerExceptionEventCallback(Consumer<Long> cb) {
        this.exceptionEventCallback = cb;
    }

    @Override
    public void registerPauseEventCallback(Consumer<Long> cb) {
        this.pauseEventCallback = cb;
    }

    @Override
    public void pause(long threadID) {
        NativeDebuggerListener.requestPause(threadID);
    }

    @Override
    public Throwable getExceptionForThread(long threadId) {
        NativeDebuggerListener.SuspendLocation loc = NativeDebuggerListener.getSuspendLocation(threadId);
        return loc != null ? loc.exception : null;
    }

    public int[] getExecutableLines(String serverPath) {
        return NativeDebuggerListener.getExecutableLines(serverPath);
    }

    static {
        cleaner = Cleaner.create();
    }
}

