/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.HashMap;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.strong.CanonicalServerAbsPath;

class KlassMap {
    public final CanonicalServerAbsPath sourceName;
    public final HashMap<Integer, Location> lineMap;
    private final ClassObjectReference objRef;
    public final ReferenceType refType;

    private KlassMap(Config config, ReferenceType refType) throws AbsentInformationException {
        this.objRef = refType.classObject();
        String sourceName = refType.sourceName();
        HashMap<Integer, Location> lineMap = new HashMap<Integer, Location>();
        for (Location loc : refType.allLineLocations()) {
            lineMap.put(loc.lineNumber(), loc);
        }
        this.sourceName = new CanonicalServerAbsPath(Config.canonicalizeFileName(sourceName));
        this.lineMap = lineMap;
        this.refType = refType;
    }

    boolean isCollected() {
        return this.objRef.isCollected();
    }

    static KlassMap maybeNull_tryBuildKlassMap(Config config, ReferenceType refType) {
        try {
            return new KlassMap(config, refType);
        }
        catch (AbsentInformationException e) {
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public boolean equals(Object e) {
        if (e instanceof KlassMap) {
            return ((KlassMap)e).sourceName.equals(this.sourceName);
        }
        return false;
    }
}

