/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Optional;
import lucee.runtime.PageContext;
import lucee.runtime.compiler.Renderer;
import lucee.runtime.type.Collection;
import org.lucee.extension.debugger.Either;
import org.lucee.extension.debugger.coreinject.UnsafeUtils;
import org.lucee.extension.debugger.coreinject.Utils;
import org.lucee.extension.debugger.coreinject.frame.Frame;

class ExprEvaluator {
    public static final Optional<Evaluator> lucee5 = Lucee5Evaluator.maybeGet();
    public static final Optional<Evaluator> lucee6 = Lucee6Evaluator.maybeGet();

    ExprEvaluator() {
    }

    public static Either<String, Object> eval(Frame frame, String expr) {
        return lucee5.map(v -> v.eval(frame, expr)).or(() -> lucee6.map(v -> v.eval(frame, expr))).or(() -> Optional.of(Either.Left("Couldn't find a Lucee engine method to perform evaluation."))).get();
    }

    static {
        if (lucee5.isEmpty() && lucee6.isEmpty()) {
            System.out.println("[luceedebug] No expression evaluator method found.");
            System.out.println("[luceedebug] Tried:");
            System.out.println("[luceedebug]   lucee.runtime.compiler.Renderer.tag(PageContext,String,int,boolean,boolean) (lucee5 signature)");
            System.out.println("[luceedebug]   lucee.runtime.compiler.Renderer.tag(PageContext,String,boolean,boolean) (lucee6 signature)");
        }
    }

    static abstract class Evaluator {
        protected static final String errName = "__luceedebug__error";
        protected static final String resultName = "__luceedebug__evalResult";

        Evaluator() {
        }

        protected static String getEvaluatableSourceText(String expr) {
            return "<cfscript>try { variables['__luceedebug__evalResult'] = {'ok': true, 'result': " + expr + " } }catch (any __luceedebug__error) { variables['__luceedebug__evalResult'] = {'ok': false, 'result': __luceedebug__error.message } }</cfscript>";
        }

        protected abstract void evalIntoVariablesScope(Frame var1, String var2) throws Throwable;

        public Either<String, Object> eval(Frame frame, String expr) {
            try {
                this.evalIntoVariablesScope(frame, expr);
                Object obj = this.consumeResult(frame);
                return this.mungeResult(obj);
            }
            catch (Throwable e) {
                return Either.Left(e.getMessage());
            }
        }

        private Object consumeResult(Frame frame) throws Throwable {
            Object evalResult = UnsafeUtils.deprecatedScopeGet((Collection)frame.getFrameContext().variables, resultName);
            frame.getFrameContext().variables.remove((Object)resultName);
            return evalResult;
        }

        private Either<String, Object> mungeResult(Object evalResult) {
            if (evalResult instanceof Map) {
                Map struct = (Map)UnsafeUtils.uncheckedCast(evalResult);
                Object isOk = struct.get("ok");
                Object result = struct.get("result");
                if (isOk instanceof Boolean) {
                    if (((Boolean)isOk).booleanValue()) {
                        return Either.Right(result);
                    }
                    String msg = result instanceof String ? (String)result : "Couldn't evaluate expression - expression threw an exception, but resulting message was non-string";
                    return Either.Left(msg);
                }
                String isOkClassName = isOk == null ? "null" : isOk.getClass().getName();
                return Either.Left("Couldn't evaluate expression - result `ok` property was non-boolean (got " + isOkClassName + ")");
            }
            String evalResultClassName = evalResult == null ? "null" : evalResult.getClass().getName();
            return Either.Left("Evaluated expression returned non-Map result of type '" + evalResultClassName + "'");
        }
    }

    private static class Lucee5Evaluator
    extends Evaluator {
        private final MethodHandle methodHandle;

        Lucee5Evaluator(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        @Override
        protected void evalIntoVariablesScope(Frame frame, String expr) throws Throwable {
            this.methodHandle.invoke(frame.getFrameContext().pageContext, Evaluator.getEvaluatableSourceText(expr), 1, false, false);
        }

        static Optional<Evaluator> maybeGet() {
            try {
                MethodType lucee5_evaluateExpr = MethodType.methodType(Renderer.Result.class, PageContext.class, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                MethodHandle methodHandle = MethodHandles.lookup().findStatic(Renderer.class, "tag", lucee5_evaluateExpr);
                return Optional.of(new Lucee5Evaluator(methodHandle));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
            catch (Throwable e) {
                return (Optional)Utils.terminate(e);
            }
        }
    }

    private static class Lucee6Evaluator
    extends Evaluator {
        private final MethodHandle methodHandle;

        Lucee6Evaluator(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        @Override
        protected void evalIntoVariablesScope(Frame frame, String expr) throws Throwable {
            this.methodHandle.invoke(frame.getFrameContext().pageContext, Evaluator.getEvaluatableSourceText(expr), false, false);
        }

        static Optional<Evaluator> maybeGet() {
            try {
                MethodType lucee6_evaluateExpr = MethodType.methodType(Renderer.Result.class, PageContext.class, String.class, Boolean.TYPE, Boolean.TYPE);
                MethodHandle methodHandle = MethodHandles.lookup().findStatic(Renderer.class, "tag", lucee6_evaluateExpr);
                return Optional.of(new Lucee6Evaluator(methodHandle));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
            catch (Throwable e) {
                return (Optional)Utils.terminate(e);
            }
        }
    }
}

