/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lucee.extension.debugger.IPathTransform;

class PrefixPathTransform
implements IPathTransform {
    private final String unadjusted_idePrefix;
    private final String unadjusted_serverPrefix;
    private final Pattern caseAndPathSepLenient_idePrefixPattern;
    private final Pattern caseAndPathSepLenient_serverPrefixPattern;

    public PrefixPathTransform(String idePrefix, String serverPrefix) {
        this.unadjusted_idePrefix = idePrefix;
        this.caseAndPathSepLenient_idePrefixPattern = PrefixPathTransform.asCaseAndPathSepLenientPrefixPattern(idePrefix);
        this.unadjusted_serverPrefix = serverPrefix;
        this.caseAndPathSepLenient_serverPrefixPattern = PrefixPathTransform.asCaseAndPathSepLenientPrefixPattern(serverPrefix);
    }

    @Override
    public Optional<String> serverToIde(String s) {
        return PrefixPathTransform.replacePrefix(s, this.caseAndPathSepLenient_serverPrefixPattern, this.unadjusted_idePrefix);
    }

    @Override
    public Optional<String> ideToServer(String s) {
        return PrefixPathTransform.replacePrefix(s, this.caseAndPathSepLenient_idePrefixPattern, this.unadjusted_serverPrefix);
    }

    public String getServerPrefix() {
        return this.unadjusted_serverPrefix;
    }

    @Override
    public String asTraceString() {
        if (this.unadjusted_idePrefix.equals(this.unadjusted_serverPrefix)) {
            return "Path: " + this.unadjusted_idePrefix;
        }
        return "Path mapping: IDE='" + this.unadjusted_idePrefix + "' -> Server='" + this.unadjusted_serverPrefix + "'";
    }

    private static Pattern asCaseAndPathSepLenientPrefixPattern(String prefix) {
        String prefixPattern = Arrays.stream(prefix.split("[\\\\/]+")).map(v -> Pattern.quote(v)).collect(Collectors.joining("[\\\\/]+"));
        return Pattern.compile("(?i)^" + prefixPattern + "(.*)$");
    }

    private static Optional<String> replacePrefix(String unadjustedSource, Pattern lenientPattern, String unadjustedPrefix) {
        Matcher m = lenientPattern.matcher(unadjustedSource);
        if (m.find()) {
            return Optional.of(unadjustedPrefix + m.group(1));
        }
        return Optional.empty();
    }
}

