/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.GlobalIDebugManagerHolder;
import org.lucee.extension.debugger.IDebugManager;
import org.lucee.extension.debugger.instrumenter.CfmOrCfc;
import org.lucee.extension.debugger.instrumenter.ClosureScope;
import org.lucee.extension.debugger.instrumenter.ComponentImpl;
import org.lucee.extension.debugger.instrumenter.PageContextImpl;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodTooLargeException;

public class LuceeTransformer
implements ClassFileTransformer {
    private final String jdwpHost;
    private final int jdwpPort;
    private final String debugHost;
    private final int debugPort;
    private final Config config;
    private ClassInjection[] pendingCoreLoaderClassInjections;

    public LuceeTransformer(ClassInjection[] injections, String jdwpHost, int jdwpPort, String debugHost, int debugPort, Config config) {
        this.pendingCoreLoaderClassInjections = injections;
        this.jdwpHost = jdwpHost;
        this.jdwpPort = jdwpPort;
        this.debugHost = debugHost;
        this.debugPort = debugPort;
        this.config = config;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassReader classReader = new ClassReader(classfileBuffer);
            String superClass = classReader.getSuperName();
            if (className.equals("lucee/runtime/type/scope/ClosureScope")) {
                return this.instrumentClosureScope(classfileBuffer);
            }
            if (className.equals("lucee/runtime/ComponentImpl")) {
                if (loader == null) {
                    throw new RuntimeException("instrumention ComponentImpl but core loader not seen yet");
                }
                return this.instrumentComponentImpl(classfileBuffer, loader);
            }
            if (className.equals("lucee/runtime/PageContextImpl")) {
                GlobalIDebugManagerHolder.luceeCoreLoader = loader;
                try {
                    Method m = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                    m.setAccessible(true);
                    for (ClassInjection injection : this.pendingCoreLoaderClassInjections) {
                        m.invoke((Object)GlobalIDebugManagerHolder.luceeCoreLoader, injection.name, injection.bytes, 0, injection.bytes.length);
                    }
                    this.pendingCoreLoaderClassInjections = null;
                    try {
                        Class<?> klass = GlobalIDebugManagerHolder.luceeCoreLoader.loadClass("org.lucee.extension.debugger.coreinject.DebugManager");
                        GlobalIDebugManagerHolder.debugManager = (IDebugManager)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        System.out.println("[luceedebug] Loaded " + String.valueOf(GlobalIDebugManagerHolder.debugManager) + " with ClassLoader '" + String.valueOf(GlobalIDebugManagerHolder.debugManager.getClass().getClassLoader()) + "'");
                        GlobalIDebugManagerHolder.debugManager.spawnWorker(this.config, this.jdwpHost, this.jdwpPort, this.debugHost, this.debugPort);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    return classfileBuffer;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                    return null;
                }
            }
            if (superClass.equals("lucee/runtime/ComponentPageImpl") || superClass.equals("lucee/runtime/PageImpl") || superClass.equals("lucee/runtime/Page")) {
                if (GlobalIDebugManagerHolder.luceeCoreLoader == null) {
                    System.out.println("Got class " + className + " before receiving PageContextImpl, debugging will fail.");
                    System.exit(1);
                }
                return this.instrumentCfmOrCfc(classfileBuffer, classReader, className);
            }
            return classfileBuffer;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private byte[] instrumentPageContextImpl(byte[] classfileBuffer) {
        ClassWriter classWriter = new ClassWriter(1);
        try {
            PageContextImpl instrumenter = new PageContextImpl(589824, classWriter, this.jdwpHost, this.jdwpPort, this.debugHost, this.debugPort);
            ClassReader classReader = new ClassReader(classfileBuffer);
            classReader.accept((ClassVisitor)instrumenter, 8);
            return classWriter.toByteArray();
        }
        catch (Throwable e) {
            System.err.println("[luceedebug] exception during attempted classfile rewrite");
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private byte[] instrumentClosureScope(byte[] classfileBuffer) {
        ClassWriter classWriter = new ClassWriter(3);
        try {
            ClosureScope instrumenter = new ClosureScope(589824, classWriter);
            ClassReader classReader = new ClassReader(classfileBuffer);
            classReader.accept((ClassVisitor)instrumenter, 8);
            return classWriter.toByteArray();
        }
        catch (Throwable e) {
            System.err.println("[luceedebug] exception during attempted classfile rewrite");
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private byte[] instrumentComponentImpl(byte[] classfileBuffer, final ClassLoader loader) {
        ClassWriter classWriter = new ClassWriter(1){

            protected ClassLoader getClassLoader() {
                return loader;
            }
        };
        try {
            ComponentImpl instrumenter = new ComponentImpl(589824, classWriter);
            ClassReader classReader = new ClassReader(classfileBuffer);
            classReader.accept((ClassVisitor)instrumenter, 8);
            return classWriter.toByteArray();
        }
        catch (Throwable e) {
            System.err.println("[luceedebug] exception during attempted classfile rewrite");
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private byte[] instrumentCfmOrCfc(byte[] classfileBuffer, ClassReader reader, String className) {
        byte[] stepInstrumentedBuffer = classfileBuffer;
        ClassWriter classWriter = new ClassWriter(3){

            protected ClassLoader getClassLoader() {
                return GlobalIDebugManagerHolder.luceeCoreLoader;
            }
        };
        try {
            CfmOrCfc instrumenter = new CfmOrCfc(589824, classWriter, className);
            ClassReader classReader = new ClassReader(stepInstrumentedBuffer);
            classReader.accept((ClassVisitor)instrumenter, 8);
            return classWriter.toByteArray();
        }
        catch (MethodTooLargeException e) {
            String baseName = e.getMethodName();
            boolean targetMethodWasBeingInstrumented = false;
            if (baseName.startsWith("__luceedebug__")) {
                baseName = baseName.replaceFirst("__luceedebug__", "");
                targetMethodWasBeingInstrumented = true;
            }
            if (targetMethodWasBeingInstrumented) {
                System.err.println("[luceedebug] Method '" + baseName + "' in class '" + className + "' became too large after instrumentation (size=" + e.getCodeSize() + "). luceedebug won't be able to hit breakpoints in, or expose frame information for, this file.");
            } else {
                System.err.println("[luceedebug] Method " + baseName + " in class " + className + " was too large to for org.objectweb.asm to reemit.");
            }
            return classfileBuffer;
        }
        catch (Throwable e) {
            System.err.println("[luceedebug] exception during attempted classfile rewrite");
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static class ClassInjection {
        final String name;
        final byte[] bytes;

        ClassInjection(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }
    }
}

