/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import lucee.loader.engine.CFMLEngineFactory;
import lucee.runtime.config.Config;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.lucee.extension.debugger.ExceptionUtil;

public class Log {
    private static final String PREFIX = "[luceedebug] ";
    private static final String APP_NAME = "luceedebug";
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_DIM = "\u001b[2m";
    private static volatile IDebugProtocolClient dapClient = null;
    private static volatile boolean colorLogs = true;
    private static volatile LogLevel logLevel = LogLevel.INFO;
    private static volatile boolean logExceptions = false;
    private static volatile boolean consoleOutput = false;
    private static final boolean internalDebug;

    public static void setDapClient(IDebugProtocolClient client) {
        dapClient = client;
    }

    public static void setColorLogs(boolean enabled) {
        colorLogs = enabled;
    }

    public static void setLogLevel(LogLevel level) {
        logLevel = level;
    }

    public static void setLogExceptions(boolean enabled) {
        logExceptions = enabled;
    }

    public static void setConsoleOutput(boolean enabled) {
        consoleOutput = enabled;
    }

    public static void info(String message) {
        if (!LogLevel.INFO.isEnabled(logLevel)) {
            return;
        }
        if (!consoleOutput) {
            String consoleMsg = colorLogs ? "\u001b[36m[luceedebug] \u001b[0m" + message : PREFIX + message;
            System.out.println(consoleMsg);
        }
        Log.sendToDap(message, "console");
    }

    public static void error(String message) {
        if (!consoleOutput) {
            String consoleMsg = colorLogs ? "\u001b[31m[luceedebug] ERROR: " + message + ANSI_RESET : "[luceedebug] ERROR: " + message;
            System.out.println(consoleMsg);
        }
        Log.sendToDap("ERROR: " + message, "stderr");
        Log.logToLuceeException(message);
    }

    public static void error(String message, Throwable t) {
        Log.error(message + ": " + t.getMessage());
        t.printStackTrace();
        Log.logToLuceeException(message, t);
    }

    public static void debug(String message) {
        if (!internalDebug) {
            return;
        }
        if (!consoleOutput) {
            String consoleMsg = colorLogs ? "\u001b[2m[luceedebug] DEBUG: " + message + ANSI_RESET : "[luceedebug] DEBUG: " + message;
            System.out.println(consoleMsg);
        }
        Log.sendToDap("DEBUG: " + message, "stdout");
    }

    public static void trace(String message) {
        if (!internalDebug) {
            return;
        }
        if (!consoleOutput) {
            String consoleMsg = colorLogs ? "\u001b[2m[luceedebug] TRACE: " + message + ANSI_RESET : "[luceedebug] TRACE: " + message;
            System.out.println(consoleMsg);
        }
        Log.sendToDap("TRACE: " + message, "stdout");
    }

    public static void warn(String message) {
        if (!LogLevel.INFO.isEnabled(logLevel)) {
            return;
        }
        if (!consoleOutput) {
            String consoleMsg = colorLogs ? "\u001b[33m[luceedebug] WARN: " + message + ANSI_RESET : "[luceedebug] WARN: " + message;
            System.out.println(consoleMsg);
        }
        Log.sendToDap("WARN: " + message, "important");
    }

    public static void exception(Throwable t) {
        if (!logExceptions) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        String stackTrace = ExceptionUtil.getCfmlStackTraceOrFallback(t);
        if (stackTrace != null && !stackTrace.isEmpty()) {
            for (String line : stackTrace.split("\n")) {
                if (line.isEmpty()) continue;
                sb.append("\n  at ").append(line);
            }
        } else {
            sb.append("\n  at unknown");
        }
        Log.sendToDap(sb.toString(), "stderr");
    }

    public static void systemOutput(String text, boolean isStdErr) {
        IDebugProtocolClient client = dapClient;
        if (client != null) {
            try {
                OutputEventArguments args = new OutputEventArguments();
                args.setCategory(isStdErr ? "stderr" : "stdout");
                args.setOutput(text);
                client.output(args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void sendToDap(String message, String category) {
        IDebugProtocolClient client = dapClient;
        if (client != null) {
            try {
                OutputEventArguments args = new OutputEventArguments();
                args.setCategory(category);
                args.setOutput(PREFIX + message + "\n");
                client.output(args);
            }
            catch (Exception e) {
                System.out.println("[luceedebug] Failed to send to DAP: " + e.getMessage());
            }
        }
    }

    private static lucee.commons.io.log.Log getLuceeExceptionLog() {
        try {
            Config config = CFMLEngineFactory.getInstance().getThreadConfig();
            if (config != null) {
                return config.getLog("exception");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void logToLuceeException(String message) {
        lucee.commons.io.log.Log luceeLog = Log.getLuceeExceptionLog();
        if (luceeLog != null) {
            luceeLog.error(APP_NAME, message);
        }
    }

    private static void logToLuceeException(String message, Throwable t) {
        lucee.commons.io.log.Log luceeLog = Log.getLuceeExceptionLog();
        if (luceeLog != null) {
            luceeLog.error(APP_NAME, message, t);
        }
    }

    static {
        String env = System.getenv("LUCEE_DEBUGGER_DEBUG");
        internalDebug = env != null && !env.isEmpty() && !env.equals("0") && !env.equalsIgnoreCase("false");
    }

    public static enum LogLevel {
        ERROR(0),
        INFO(1),
        DEBUG(2),
        TRACE(3);

        private final int level;

        private LogLevel(int level) {
            this.level = level;
        }

        public boolean isEnabled(LogLevel threshold) {
            return this.level <= threshold.level;
        }
    }
}

