/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentWeakKeyMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<IdentityWeakReference<K>, V> map = new ConcurrentHashMap();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    public ConcurrentWeakKeyMap() {
    }

    public ConcurrentWeakKeyMap(int concurrencyLevel) {
    }

    private void expungeStaleEntries() {
        IdentityWeakReference ref;
        while ((ref = (IdentityWeakReference)this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        return this.map.get(new LookupKey(key));
    }

    @Override
    public V put(K key, V value) {
        this.expungeStaleEntries();
        return this.map.put(new IdentityWeakReference<K>(key, this.queue), value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.expungeStaleEntries();
        return this.map.putIfAbsent(new IdentityWeakReference<K>(key, this.queue), value);
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        return this.map.remove(new LookupKey(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.expungeStaleEntries();
        return this.map.remove(new LookupKey(key), value);
    }

    @Override
    public V replace(K key, V value) {
        this.expungeStaleEntries();
        return this.map.replace(new IdentityWeakReference<K>(key, this.queue), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.expungeStaleEntries();
        return this.map.replace(new IdentityWeakReference<K>(key, this.queue), oldValue, newValue);
    }

    @Override
    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        return this.map.containsKey(new LookupKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.expungeStaleEntries();
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.expungeStaleEntries();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        this.expungeStaleEntries();
        HashSet keys = new HashSet();
        for (IdentityWeakReference ref : this.map.keySet()) {
            Object key = ref.get();
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        this.expungeStaleEntries();
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<IdentityWeakReference<K>, V> e : this.map.entrySet()) {
            Object key = e.getKey().get();
            if (key == null) continue;
            entries.add(new AbstractMap.SimpleEntry(key, e.getValue()));
        }
        return entries;
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        IdentityWeakReference(T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IdentityWeakReference) {
                Object myReferent = this.get();
                Object otherReferent = ((IdentityWeakReference)obj).get();
                return myReferent != null && myReferent == otherReferent;
            }
            if (obj instanceof LookupKey) {
                Object myReferent = this.get();
                Object otherReferent = ((LookupKey)obj).referent;
                return myReferent != null && myReferent == otherReferent;
            }
            return false;
        }
    }

    private static class LookupKey<T> {
        final T referent;
        final int hashCode;

        LookupKey(Object referent) {
            Object t = referent;
            this.referent = t;
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IdentityWeakReference) {
                Object otherReferent = ((IdentityWeakReference)obj).get();
                return this.referent != null && this.referent == otherReferent;
            }
            if (obj instanceof LookupKey) {
                return this.referent != null && this.referent == ((LookupKey)obj).referent;
            }
            return false;
        }
    }
}

