/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private static final int EOF = -1;
    private int bytesRemaining;
    private final boolean closeWrapped;
    private boolean isClosed;
    private int mark = -1;

    public LimitedInputStream(InputStream wrapped, int maxBytesToRead, boolean closeWrapped) {
        super(wrapped);
        if (maxBytesToRead < 0) {
            throw new IllegalArgumentException("[maxBytesToRead] must be >= 0");
        }
        this.bytesRemaining = maxBytesToRead;
        this.closeWrapped = closeWrapped;
    }

    @Override
    public int available() throws IOException {
        if (this.isClosed) {
            return 0;
        }
        int availableBytes = this.in.available();
        return Math.min(availableBytes, this.bytesRemaining);
    }

    @Override
    public void close() throws IOException {
        if (this.closeWrapped) {
            this.in.close();
        }
        this.isClosed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed || this.bytesRemaining < 1) {
            return -1;
        }
        int data = this.in.read();
        if (data != -1) {
            --this.bytesRemaining;
        }
        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed || this.bytesRemaining < 1) {
            return -1;
        }
        int bytesRead = this.in.read(b, off, Math.min(len, this.bytesRemaining));
        if (bytesRead != -1) {
            this.bytesRemaining -= bytesRead;
        }
        return bytesRead;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.bytesRemaining;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        if (this.mark == -1) {
            throw new IOException("mark not set");
        }
        this.in.reset();
        this.bytesRemaining = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, (long)this.bytesRemaining));
        this.bytesRemaining = (int)((long)this.bytesRemaining - skipped);
        return skipped;
    }
}

