/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.Endpoint;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.services.AnnotationUtil;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.services.ServiceEndpoints;

public class EndpointProxy
implements InvocationHandler {
    private final Method object_equals;
    private final Method object_hashCode;
    private final Method object_toString;
    private final Endpoint delegate;
    private final LinkedHashMap<String, AnnotationUtil.MethodInfo> methodInfos;
    private final LinkedHashMap<String, AnnotationUtil.DelegateInfo> delegatedSegments;

    public EndpointProxy(Endpoint delegate, Class<?> interface_) {
        this(delegate, Collections.singletonList(interface_));
    }

    public EndpointProxy(Endpoint delegate, Collection<Class<?>> interfaces) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        if (interfaces == null) {
            throw new NullPointerException("interfaces");
        }
        if (interfaces.isEmpty()) {
            throw new IllegalArgumentException("interfaces must not be empty.");
        }
        this.delegate = delegate;
        try {
            this.object_equals = Object.class.getDeclaredMethod("equals", Object.class);
            this.object_hashCode = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            this.object_toString = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
        this.methodInfos = new LinkedHashMap();
        this.delegatedSegments = new LinkedHashMap();
        for (Class<?> interf : interfaces) {
            AnnotationUtil.findRpcMethods(interf, new HashSet(), methodInfo -> {
                if (this.methodInfos.put(methodInfo.method.getName(), (AnnotationUtil.MethodInfo)methodInfo) != null) {
                    throw new IllegalStateException("Duplicate RPC method " + methodInfo.method);
                }
            });
            AnnotationUtil.findDelegateSegments(interf, new HashSet(), method -> {
                Object delegateProxy = ServiceEndpoints.toServiceObject(delegate, method.getReturnType());
                AnnotationUtil.DelegateInfo info = new AnnotationUtil.DelegateInfo();
                info.delegate = delegateProxy;
                info.method = method;
                if (this.delegatedSegments.put(method.getName(), info) != null) {
                    throw new IllegalStateException("Duplicate RPC method " + method);
                }
            });
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        args = args == null ? new Object[]{} : args;
        AnnotationUtil.MethodInfo methodInfo = this.methodInfos.get(method.getName());
        if (methodInfo != null) {
            Object params = this.getParams(args, methodInfo);
            if (methodInfo.isNotification) {
                this.delegate.notify(methodInfo.name, params);
                return null;
            }
            return this.delegate.request(methodInfo.name, params);
        }
        AnnotationUtil.DelegateInfo delegateInfo = this.delegatedSegments.get(method.getName());
        if (delegateInfo != null) {
            return delegateInfo.delegate;
        }
        if (this.object_equals.equals(method) && args.length == 1) {
            if (args[0] != null) {
                try {
                    return this.equals(Proxy.getInvocationHandler(args[0]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return this.equals(args[0]);
        }
        if (this.object_hashCode.equals(method)) {
            return this.hashCode();
        }
        if (this.object_toString.equals(method)) {
            return this.toString();
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected Object getParams(Object[] args, AnnotationUtil.MethodInfo methodInfo) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            return args[0];
        }
        return Arrays.asList(args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.delegate.toString();
    }
}

