/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.json.adapters;

import java.io.IOException;
import org.lucee.extension.debugger.shaded.gson.Gson;
import org.lucee.extension.debugger.shaded.gson.JsonElement;
import org.lucee.extension.debugger.shaded.gson.TypeAdapter;
import org.lucee.extension.debugger.shaded.gson.TypeAdapterFactory;
import org.lucee.extension.debugger.shaded.gson.reflect.TypeToken;
import org.lucee.extension.debugger.shaded.gson.stream.JsonReader;
import org.lucee.extension.debugger.shaded.gson.stream.JsonWriter;

public class JsonElementTypeAdapter
extends TypeAdapter<Object> {
    private final Gson gson;
    private final TypeAdapter<JsonElement> adapter;

    public JsonElementTypeAdapter(Gson gson) {
        this.gson = gson;
        this.adapter = gson.getAdapter(JsonElement.class);
    }

    @Override
    public JsonElement read(JsonReader in) throws IOException {
        return this.adapter.read(in);
    }

    @Override
    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else if (value instanceof JsonElement) {
            this.adapter.write(out, (JsonElement)value);
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new JsonElementTypeAdapter(gson);
        }
    }
}

