/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.JsonRpcException;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.MessageConsumer;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.json.MessageConstants;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.messages.Message;

public class StreamMessageConsumer
implements MessageConsumer,
MessageConstants {
    private final String encoding;
    private final MessageJsonHandler jsonHandler;
    private final Object outputLock = new Object();
    private OutputStream output;

    public StreamMessageConsumer(MessageJsonHandler jsonHandler) {
        this(null, StandardCharsets.UTF_8.name(), jsonHandler);
    }

    public StreamMessageConsumer(OutputStream output, MessageJsonHandler jsonHandler) {
        this(output, StandardCharsets.UTF_8.name(), jsonHandler);
    }

    public StreamMessageConsumer(OutputStream output, String encoding, MessageJsonHandler jsonHandler) {
        this.output = output;
        this.encoding = encoding;
        this.jsonHandler = jsonHandler;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Message message) {
        try {
            String content = this.jsonHandler.serialize(message);
            byte[] contentBytes = content.getBytes(this.encoding);
            int contentLength = contentBytes.length;
            String header = this.getHeader(contentLength);
            byte[] headerBytes = header.getBytes(StandardCharsets.US_ASCII);
            Object object = this.outputLock;
            synchronized (object) {
                this.output.write(headerBytes);
                this.output.write(contentBytes);
                this.output.flush();
            }
        }
        catch (IOException exception) {
            throw new JsonRpcException(exception);
        }
    }

    protected String getHeader(int contentLength) {
        StringBuilder headerBuilder = new StringBuilder();
        this.appendHeader(headerBuilder, "Content-Length", contentLength).append("\r\n");
        if (!StandardCharsets.UTF_8.name().equals(this.encoding)) {
            this.appendHeader(headerBuilder, "Content-Type", "application/json");
            headerBuilder.append("; charset=").append(this.encoding).append("\r\n");
        }
        headerBuilder.append("\r\n");
        return headerBuilder.toString();
    }

    protected StringBuilder appendHeader(StringBuilder builder, String name, Object value) {
        return builder.append(name).append(": ").append(value);
    }
}

