/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.lsp4j.jsonrpc;

import java.io.PrintWriter;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.MessageConsumer;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.TracingMessageConsumer;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.json.MessageJsonHandler;

public class MessageTracer
implements Function<MessageConsumer, MessageConsumer> {
    private final PrintWriter printWriter;
    private final Map<String, TracingMessageConsumer.RequestMetadata> sentRequests = new HashMap<String, TracingMessageConsumer.RequestMetadata>();
    private final Map<String, TracingMessageConsumer.RequestMetadata> receivedRequests = new HashMap<String, TracingMessageConsumer.RequestMetadata>();
    private MessageJsonHandler jsonHandler;

    MessageTracer(PrintWriter printWriter) {
        this.printWriter = Objects.requireNonNull(printWriter);
    }

    public void setJsonHandler(MessageJsonHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }

    @Override
    public MessageConsumer apply(MessageConsumer messageConsumer) {
        TracingMessageConsumer tracingMessageConsumer = new TracingMessageConsumer(messageConsumer, this.sentRequests, this.receivedRequests, this.printWriter, Clock.systemDefaultZone());
        tracingMessageConsumer.setJsonHandler(this.jsonHandler);
        return tracingMessageConsumer;
    }
}

