/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.shaded.gson.internal.bind;

import java.io.IOException;
import org.lucee.extension.debugger.shaded.gson.Gson;
import org.lucee.extension.debugger.shaded.gson.JsonSyntaxException;
import org.lucee.extension.debugger.shaded.gson.ToNumberPolicy;
import org.lucee.extension.debugger.shaded.gson.ToNumberStrategy;
import org.lucee.extension.debugger.shaded.gson.TypeAdapter;
import org.lucee.extension.debugger.shaded.gson.TypeAdapterFactory;
import org.lucee.extension.debugger.shaded.gson.reflect.TypeToken;
import org.lucee.extension.debugger.shaded.gson.stream.JsonReader;
import org.lucee.extension.debugger.shaded.gson.stream.JsonToken;
import org.lucee.extension.debugger.shaded.gson.stream.JsonWriter;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        final NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? adapter : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + in.getPath());
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

