/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.instrumenter;

import org.lucee.extension.debugger.shaded.asm.ClassVisitor;
import org.lucee.extension.debugger.shaded.asm.ClassWriter;
import org.lucee.extension.debugger.shaded.asm.MethodVisitor;
import org.lucee.extension.debugger.shaded.asm.Type;
import org.lucee.extension.debugger.shaded.asm.commons.AdviceAdapter;
import org.lucee.extension.debugger.shaded.asm.commons.Method;

public class PageContextImpl
extends ClassVisitor {
    final String jdwpHost;
    final int jdwpPort;
    final String debugHost;
    final int debugPort;

    public PageContextImpl(int api, ClassWriter cw, String jdwpHost, int jdwpPort, String debugHost, int debugPort) {
        super(api, cw);
        this.jdwpHost = jdwpHost;
        this.jdwpPort = jdwpPort;
        this.debugHost = debugHost;
        this.debugPort = debugPort;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (name.equals("<clinit>")) {
            return new AdviceAdapter(this.api, mv, access, name, descriptor){

                @Override
                protected void onMethodEnter() {
                    this.push(PageContextImpl.this.jdwpHost);
                    this.push(PageContextImpl.this.jdwpPort);
                    this.push(PageContextImpl.this.debugHost);
                    this.push(PageContextImpl.this.debugPort);
                    this.invokeStatic(Type.getType("Lorg/lucee/extension/debugger/coreinject/DebugManager;"), Method.getMethod("void spawnWorker(java.lang.String, int, java.lang.String, int)"));
                }
            };
        }
        return mv;
    }
}

