/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.instrumenter;

import org.lucee.extension.debugger.shaded.asm.ClassVisitor;
import org.lucee.extension.debugger.shaded.asm.ClassWriter;
import org.lucee.extension.debugger.shaded.asm.Label;
import org.lucee.extension.debugger.shaded.asm.MethodVisitor;
import org.lucee.extension.debugger.shaded.asm.Type;
import org.lucee.extension.debugger.shaded.asm.commons.AdviceAdapter;
import org.lucee.extension.debugger.shaded.asm.commons.GeneratorAdapter;
import org.lucee.extension.debugger.shaded.asm.commons.Method;

public class CfmOrCfc
extends ClassVisitor {
    private Type thisType = null;
    private String sourceName = "??????";
    private boolean isWrappingMethod = false;

    public CfmOrCfc(int api, ClassWriter cw, String className) {
        super(api, cw);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisType = Type.getType("L" + name + ";");
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceName = source;
        super.visitSource(source, debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWrapperMethod(int access, String name, String descriptor, String signature, String[] exceptions, String delegateToName) {
        try {
            this.isWrappingMethod = true;
            int argCount = Type.getArgumentTypes(descriptor).length;
            MethodVisitor mv = this.visitMethod(access, name, descriptor, signature, exceptions);
            GeneratorAdapter ga = new GeneratorAdapter(mv, access, name, descriptor);
            Label tryStart = ga.mark();
            ga.getStatic(GlobalIDebugManagerHolder_t.type, "debugManager", IDebugManager_t.type);
            ga.loadArg(0);
            ga.push(this.sourceName);
            if (name.startsWith("udfDefaultValue")) {
                ga.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_pushCfFunctionDefaultValueInitializationFrame);
            } else {
                ga.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_pushCfFrame);
            }
            ga.loadThis();
            for (int i = 0; i < argCount; ++i) {
                ga.loadArg(i);
            }
            ga.invokeVirtual(this.thisType, new Method(delegateToName, descriptor));
            ga.getStatic(GlobalIDebugManagerHolder_t.type, "debugManager", IDebugManager_t.type);
            ga.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_popCfFrame);
            if (!name.equals("udfDefaultValue")) {
                ga.getStatic(GlobalIDebugManagerHolder_t.type, "debugManager", IDebugManager_t.type);
                ga.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_stepAfterCompletedUdfCall);
            }
            ga.returnValue();
            Label tryEnd = ga.mark();
            ga.getStatic(GlobalIDebugManagerHolder_t.type, "debugManager", IDebugManager_t.type);
            ga.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_popCfFrame);
            ga.throwException();
            ga.visitTryCatchBlock(tryStart, tryEnd, tryEnd, null);
            ga.endMethod();
        }
        finally {
            this.isWrappingMethod = false;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.isWrappingMethod && (name.equals("call") || name.startsWith("call_") || name.startsWith("udfCall") || name.equals("initComponent") || name.equals("newInstance") || name.equals("threadCall") || name.startsWith("udfDefaultValue") || name.equals("staticConstructor"))) {
            String delegateToName = name.startsWith("udfCall") ? "udfCall__luceedebug__" + name : "__luceedebug__" + name;
            this.createWrapperMethod(access, name, descriptor, signature, exceptions, delegateToName);
            MethodVisitor mv = super.visitMethod(access, delegateToName, descriptor, signature, exceptions);
            return new AdviceAdapter(this.api, mv, access, delegateToName, descriptor){

                @Override
                public void visitLineNumber(int line, Label start) {
                    this.getStatic(GlobalIDebugManagerHolder_t.type, "debugManager", IDebugManager_t.type);
                    this.push(line);
                    this.invokeInterface(IDebugManager_t.type, IDebugManager_t.m_step);
                    super.visitLineNumber(line, this.mark());
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    static class GlobalIDebugManagerHolder_t {
        static final Type type = Type.getType("Lorg/lucee/extension/debugger/GlobalIDebugManagerHolder;");

        GlobalIDebugManagerHolder_t() {
        }
    }

    static class IDebugManager_t {
        static final Type type = Type.getType("Lorg/lucee/extension/debugger/IDebugManager;");
        static final Method m_pushCfFrame = Method.getMethod("void pushCfFrame(lucee.runtime.PageContext, String)");
        static final Method m_pushCfFunctionDefaultValueInitializationFrame = Method.getMethod("void pushCfFunctionDefaultValueInitializationFrame(lucee.runtime.PageContext, String)");
        static final Method m_popCfFrame = Method.getMethod("void popCfFrame()");
        static final Method m_step = Method.getMethod("void luceedebug_stepNotificationEntry_step(int)");
        static final Method m_stepAfterCompletedUdfCall = Method.getMethod("void luceedebug_stepNotificationEntry_stepAfterCompletedUdfCall()");

        IDebugManager_t() {
        }
    }
}

