/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject.frame;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lucee.runtime.PageContext;
import lucee.runtime.exp.PageException;
import lucee.runtime.type.scope.CGI;
import org.lucee.extension.debugger.EnvUtil;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.Log;
import org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge;
import org.lucee.extension.debugger.coreinject.DebugEntity;
import org.lucee.extension.debugger.coreinject.NativeDebuggerListener;
import org.lucee.extension.debugger.coreinject.ValTracker;

public class NativeDebugFrame
implements IDebugFrame {
    private static AtomicLong nextId = new AtomicLong(0L);
    private static volatile Boolean nativeFrameSupportAvailable = null;
    private static Method getDebuggerFramesMethod = null;
    private static Method getLineMethod = null;
    private static Method setLineMethod = null;
    private static Field localField = null;
    private static Field argumentsField = null;
    private static Field variablesField = null;
    private static Field pageSourceField = null;
    private static Field functionNameField = null;
    private static Method getDisplayPathMethod = null;
    private final Object nativeFrame;
    private final PageContext pageContext;
    private final ValTracker valTracker;
    private final String sourceFilePath;
    private final String functionName;
    private final long id;
    private final int depth;
    private int syntheticLine;
    private final Throwable exception;
    private final Object local;
    private final Object arguments;
    private final Object variables;
    private LinkedHashMap<String, CfValueDebuggerBridge> scopes_ = null;

    private NativeDebugFrame(Object nativeFrame, PageContext pageContext, ValTracker valTracker, int depth, Throwable exception) throws Exception {
        this.nativeFrame = nativeFrame;
        this.pageContext = pageContext;
        this.valTracker = valTracker;
        this.id = nextId.incrementAndGet();
        this.depth = depth;
        this.exception = exception;
        this.local = localField.get(nativeFrame);
        this.arguments = argumentsField.get(nativeFrame);
        this.variables = variablesField.get(nativeFrame);
        Object pageSource = pageSourceField.get(nativeFrame);
        this.sourceFilePath = (String)getDisplayPathMethod.invoke(pageSource, new Object[0]);
        this.functionName = (String)functionNameField.get(nativeFrame);
    }

    private NativeDebugFrame(PageContext pageContext, ValTracker valTracker, String file, int line, String label, Throwable exception) {
        String requestUrl;
        this.nativeFrame = null;
        this.pageContext = pageContext;
        this.valTracker = valTracker;
        this.id = nextId.incrementAndGet();
        this.depth = 0;
        this.syntheticLine = line;
        this.sourceFilePath = file;
        this.exception = exception;
        this.functionName = label != null && !label.isEmpty() ? label : ((requestUrl = NativeDebugFrame.getRequestUrl(pageContext)) != null ? requestUrl : "<top-level>");
        this.local = null;
        this.arguments = null;
        try {
            this.variables = pageContext.variablesScope();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getRequestUrl(PageContext pc) {
        try {
            CGI cgiScope = pc.cgiScope();
            if (cgiScope instanceof Map) {
                Map cgi = (Map)cgiScope;
                Object scriptName = cgi.get("script_name");
                if (scriptName == null) {
                    for (Map.Entry entry : cgi.entrySet()) {
                        String keyStr = entry.getKey().toString().toLowerCase();
                        if (!"script_name".equals(keyStr)) continue;
                        scriptName = entry.getValue();
                        break;
                    }
                }
                if (scriptName != null && !scriptName.toString().isEmpty()) {
                    return scriptName.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.functionName == null) {
            return "??";
        }
        if (this.functionName.startsWith("<") || this.functionName.startsWith("/") || this.functionName.contains(":")) {
            return this.functionName;
        }
        return this.functionName + "()";
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getLine() {
        if (this.nativeFrame == null) {
            return this.syntheticLine;
        }
        try {
            return (Integer)getLineMethod.invoke(this.nativeFrame, new Object[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void setLine(int line) {
        if (this.nativeFrame == null) {
            this.syntheticLine = line;
            return;
        }
        try {
            setLineMethod.invoke(this.nativeFrame, line);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    private void checkedPutScopeRef(String name, Object scope) {
        if (scope != null && scope instanceof Map) {
            CfValueDebuggerBridge.MarkerTrait.Scope v = new CfValueDebuggerBridge.MarkerTrait.Scope((Map)scope);
            CfValueDebuggerBridge.pin(v);
            CfValueDebuggerBridge bridge = new CfValueDebuggerBridge(this.valTracker, (Object)v);
            this.valTracker.setPath(bridge.id, name);
            this.valTracker.setFrameId(bridge.id, this.id);
            this.scopes_.put(name, bridge);
        }
    }

    private void lazyInitScopeRefs() {
        if (this.scopes_ != null) {
            return;
        }
        this.scopes_ = new LinkedHashMap();
        if (this.exception != null) {
            this.addCfcatchScope();
        }
        this.checkedPutScopeRef("local", this.local);
        this.checkedPutScopeRef("arguments", this.arguments);
        this.checkedPutScopeRef("variables", this.variables);
        try {
            this.checkedPutScopeRef("application", this.pageContext.applicationScope());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkedPutScopeRef("form", this.pageContext.formScope());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkedPutScopeRef("request", this.pageContext.requestScope());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.pageContext.getApplicationContext().isSetSessionManagement()) {
                this.checkedPutScopeRef("session", this.pageContext.sessionScope());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkedPutScopeRef("server", this.pageContext.serverScope());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkedPutScopeRef("url", this.pageContext.urlScope());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.variables != null && this.variables.getClass().getName().equals("lucee.runtime.ComponentScope")) {
                Method getComponentMethod = this.variables.getClass().getMethod("getComponent", new Class[0]);
                Object component = getComponentMethod.invoke(this.variables, new Object[0]);
                this.checkedPutScopeRef("this", component);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addCfcatchScope() {
        LinkedHashMap<String, String> cfcatch = new LinkedHashMap<String, String>();
        cfcatch.put("type", this.getExceptionType(this.exception));
        cfcatch.put("message", this.exception.getMessage() != null ? this.exception.getMessage() : "");
        String detail = "";
        String errorCode = "";
        String extendedInfo = "";
        if (this.exception instanceof PageException) {
            PageException pe = (PageException)this.exception;
            detail = pe.getDetail() != null ? pe.getDetail() : "";
            errorCode = pe.getErrorCode() != null ? pe.getErrorCode() : "";
            extendedInfo = pe.getExtendedInfo() != null ? pe.getExtendedInfo() : "";
        }
        cfcatch.put("detail", detail);
        cfcatch.put("errorCode", errorCode);
        cfcatch.put("extendedInfo", extendedInfo);
        cfcatch.put("javaClass", this.exception.getClass().getName());
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        cfcatch.put("stackTrace", sw.toString());
        CfValueDebuggerBridge.MarkerTrait.Scope v = new CfValueDebuggerBridge.MarkerTrait.Scope(cfcatch);
        CfValueDebuggerBridge.pin(cfcatch);
        CfValueDebuggerBridge.pin(v);
        CfValueDebuggerBridge bridge = new CfValueDebuggerBridge(this.valTracker, (Object)v);
        this.valTracker.setPath(bridge.id, "cfcatch");
        this.valTracker.setFrameId(bridge.id, this.id);
        this.scopes_.put("cfcatch", bridge);
    }

    private String getExceptionType(Throwable t) {
        PageException pe;
        String type;
        if (t instanceof PageException && (type = (pe = (PageException)t).getTypeAsString()) != null && !type.isEmpty()) {
            return type;
        }
        return t.getClass().getSimpleName();
    }

    @Override
    public IDebugEntity[] getScopes() {
        this.lazyInitScopeRefs();
        IDebugEntity[] result = new DebugEntity[this.scopes_.size()];
        int i = 0;
        for (Map.Entry<String, CfValueDebuggerBridge> kv : this.scopes_.entrySet()) {
            String name = kv.getKey();
            CfValueDebuggerBridge entityRef = kv.getValue();
            DebugEntity entity = new DebugEntity();
            entity.name = name;
            entity.namedVariables = entityRef.getNamedVariablesCount();
            entity.indexedVariables = entityRef.getIndexedVariablesCount();
            entity.expensive = true;
            entity.variablesReference = entityRef.id;
            result[i] = entity;
            ++i;
        }
        return result;
    }

    private static synchronized boolean initReflection(ClassLoader luceeClassLoader) {
        if (nativeFrameSupportAvailable != null) {
            return nativeFrameSupportAvailable;
        }
        try {
            if (!EnvUtil.isDebuggerEnabled()) {
                Log.info("Native frame support disabled: LUCEE_DAP_SECRET not set");
                nativeFrameSupportAvailable = false;
                return false;
            }
            ClassLoader cl = luceeClassLoader;
            if (cl == null) {
                cl = PageContext.class.getClassLoader();
            }
            Class<?> pciClass = cl.loadClass("lucee.runtime.PageContextImpl");
            getDebuggerFramesMethod = pciClass.getMethod("getDebuggerFrames", new Class[0]);
            Class<?> debuggerFrameClass = cl.loadClass("lucee.runtime.PageContextImpl$DebuggerFrame");
            localField = debuggerFrameClass.getField("local");
            argumentsField = debuggerFrameClass.getField("arguments");
            variablesField = debuggerFrameClass.getField("variables");
            pageSourceField = debuggerFrameClass.getField("pageSource");
            functionNameField = debuggerFrameClass.getField("functionName");
            getLineMethod = debuggerFrameClass.getMethod("getLine", new Class[0]);
            setLineMethod = debuggerFrameClass.getMethod("setLine", Integer.TYPE);
            Class<?> pageSourceClass = cl.loadClass("lucee.runtime.PageSource");
            getDisplayPathMethod = pageSourceClass.getMethod("getDisplayPath", new Class[0]);
            nativeFrameSupportAvailable = true;
            return true;
        }
        catch (Throwable e) {
            Log.error("Failed to initialize native frame support: " + e.getMessage());
            nativeFrameSupportAvailable = false;
            return false;
        }
    }

    public static boolean isNativeFrameSupportAvailable(ClassLoader luceeClassLoader) {
        return NativeDebugFrame.initReflection(luceeClassLoader);
    }

    public static IDebugFrame[] getNativeFrames(PageContext pageContext, ValTracker valTracker, long threadId, ClassLoader luceeClassLoader) {
        if (!NativeDebugFrame.isNativeFrameSupportAvailable(luceeClassLoader)) {
            Log.debug("getNativeFrames: native frame support not available");
            return null;
        }
        try {
            Object[] nativeFrames = (Object[])getDebuggerFramesMethod.invoke((Object)pageContext, new Object[0]);
            NativeDebuggerListener.SuspendLocation location = NativeDebuggerListener.getSuspendLocation(threadId);
            Throwable exception = location != null ? location.exception : null;
            ArrayList<NativeDebugFrame> result = new ArrayList<NativeDebugFrame>();
            if (nativeFrames != null && nativeFrames.length > 0) {
                for (int i = nativeFrames.length - 1; i >= 0; --i) {
                    Object nf = nativeFrames[i];
                    int line = (Integer)getLineMethod.invoke(nf, new Object[0]);
                    if (line == 0) continue;
                    Throwable frameException = result.isEmpty() ? exception : null;
                    result.add(new NativeDebugFrame(nf, pageContext, valTracker, i, frameException));
                }
            }
            if (result.isEmpty() && threadId >= 0L) {
                Log.trace("Checking suspend location for thread " + threadId + ": " + (String)(location != null ? location.file + ":" + location.line : "null"));
                if (location != null && location.file != null && location.line > 0) {
                    Log.trace("Creating synthetic frame for top-level code: " + location.file + ":" + location.line + (String)(location.label != null ? " label=" + location.label : ""));
                    result.add(new NativeDebugFrame(pageContext, valTracker, location.file, location.line, location.label, exception));
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new IDebugFrame[0]);
        }
        catch (Throwable e) {
            System.err.println("[luceedebug] Error getting native frames: " + e.getMessage());
            return null;
        }
    }
}

