/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject.frame;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lucee.runtime.Component;
import lucee.runtime.ComponentScope;
import lucee.runtime.PageContext;
import lucee.runtime.PageContextImpl;
import lucee.runtime.type.Collection;
import lucee.runtime.type.Struct;
import lucee.runtime.type.scope.Argument;
import lucee.runtime.type.scope.ClosureScope;
import lucee.runtime.type.scope.Local;
import lucee.runtime.type.scope.LocalNotSupportedScope;
import lucee.runtime.type.scope.Scope;
import lucee.runtime.type.scope.Variables;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge;
import org.lucee.extension.debugger.coreinject.ClosureScopeLocalScopeAccessorShim;
import org.lucee.extension.debugger.coreinject.DebugEntity;
import org.lucee.extension.debugger.coreinject.UnsafeUtils;
import org.lucee.extension.debugger.coreinject.ValTracker;
import org.lucee.extension.debugger.coreinject.frame.DebugFrame;
import org.lucee.extension.debugger.util.ConcurrentWeakKeyMap;

public class Frame
extends DebugFrame {
    private static AtomicLong nextId = new AtomicLong(0L);
    private static boolean closureScopeGloballyDisabled = false;
    public final ValTracker valTracker;
    private final FrameContext frameContext_;
    private final String sourceFilePath;
    private final long id;
    private final String name;
    private final int depth;
    private int line = 0;
    public boolean isUdfDefaultValueInitFrame = false;
    private LinkedHashMap<String, CfValueDebuggerBridge> scopes_ = null;
    private ArrayList<Object> refsToKeepAlive_ = new ArrayList();

    @Override
    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    void pin(Object obj) {
        this.refsToKeepAlive_.add(obj);
    }

    Frame(String sourceFilePath, int depth, ValTracker valTracker, PageContext pageContext, FrameContext root) {
        this(sourceFilePath, depth, valTracker, pageContext, Frame.tryGetFrameName(pageContext), root);
    }

    private Frame(String sourceFilePath, int depth, ValTracker valTracker, PageContext pageContext, String name, FrameContext root) {
        this.frameContext_ = new FrameContext(pageContext, root);
        this.sourceFilePath = Objects.requireNonNull(sourceFilePath);
        this.valTracker = Objects.requireNonNull(valTracker);
        this.id = nextId.incrementAndGet();
        this.name = name;
        this.depth = depth;
    }

    private static String tryGetFrameName(PageContext pageContext) {
        String frameName = "??";
        try {
            PageContextImpl pageContextImpl = (PageContextImpl)pageContext;
            Collection.Key key = pageContextImpl.getActiveUDFCalledName();
            if (key != null) {
                frameName = key.getString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return frameName;
    }

    private void checkedPutScopeRef(String name, Map<?, ?> scope) {
        if (scope != null && !(scope instanceof LocalNotSupportedScope)) {
            CfValueDebuggerBridge.MarkerTrait.Scope v = new CfValueDebuggerBridge.MarkerTrait.Scope(scope);
            this.pin(v);
            this.scopes_.put(name, new CfValueDebuggerBridge(this, (Object)v));
        }
    }

    private void lazyInitScopeRefs() {
        if (this.scopes_ != null) {
            return;
        }
        this.scopes_ = new LinkedHashMap();
        this.checkedPutScopeRef("application", (Map<?, ?>)this.frameContext_.application);
        this.checkedPutScopeRef("arguments", (Map<?, ?>)this.frameContext_.arguments);
        this.checkedPutScopeRef("form", (Map<?, ?>)this.frameContext_.form);
        this.checkedPutScopeRef("local", (Map<?, ?>)this.frameContext_.local);
        this.checkedPutScopeRef("request", (Map<?, ?>)this.frameContext_.request);
        this.checkedPutScopeRef("session", (Map<?, ?>)this.frameContext_.session);
        this.checkedPutScopeRef("static", (Map<?, ?>)this.frameContext_.static_);
        this.checkedPutScopeRef("server", (Map<?, ?>)this.frameContext_.server);
        this.checkedPutScopeRef("this", (Map<?, ?>)this.frameContext_.this_);
        this.checkedPutScopeRef("url", (Map<?, ?>)this.frameContext_.url);
        this.checkedPutScopeRef("variables", (Map<?, ?>)this.frameContext_.variables);
        if (!closureScopeGloballyDisabled) {
            ArrayList<ClosureScope> scopeChain = this.frameContext_.getCapturedScopeChain();
            int captureChainLen = scopeChain.size();
            try {
                for (int i = 0; i < captureChainLen; ++i) {
                    this.checkedPutScopeRef("captured arguments " + i, (Map<?, ?>)scopeChain.get(i).getArgument());
                    this.checkedPutScopeRef("captured local " + i, (Map<?, ?>)((ClosureScopeLocalScopeAccessorShim)scopeChain.get(i)).getLocalScope());
                }
            }
            catch (ClassCastException e) {
                closureScopeGloballyDisabled = true;
                return;
            }
        }
    }

    public FrameContext getFrameContext() {
        return this.frameContext_;
    }

    @Override
    public IDebugEntity[] getScopes() {
        this.lazyInitScopeRefs();
        IDebugEntity[] result = new DebugEntity[this.scopes_.size()];
        int i = 0;
        for (Map.Entry<String, CfValueDebuggerBridge> kv : this.scopes_.entrySet()) {
            String name = kv.getKey();
            CfValueDebuggerBridge entityRef = kv.getValue();
            DebugEntity entity = new DebugEntity();
            entity.name = name;
            entity.namedVariables = entityRef.getNamedVariablesCount();
            entity.indexedVariables = entityRef.getIndexedVariablesCount();
            entity.expensive = true;
            entity.variablesReference = entityRef.id;
            result[i] = entity;
            ++i;
        }
        return result;
    }

    public CfValueDebuggerBridge trackEvalResult(Object obj) {
        CfValueDebuggerBridge v = new CfValueDebuggerBridge(this, obj);
        CfValueDebuggerBridge.pin(obj);
        return v;
    }

    public static class FrameContext {
        public final PageContext pageContext;
        public final Scope application;
        public final Argument arguments;
        public final Scope form;
        public final Local local;
        public final Scope request;
        public final Scope session;
        public final Scope server;
        public final Scope url;
        public final Variables variables;
        public final Struct this_;
        public final Scope static_;
        private ArrayList<ClosureScope> capturedScopeChain = null;
        private static final ConcurrentWeakKeyMap<PageContext, Object> activeFrameLockByPageContext = new ConcurrentWeakKeyMap();

        private FrameContext(PageContext pageContext, FrameContext root) {
            this.pageContext = pageContext;
            this.application = root != null ? root.application : (Scope)this.getScopelikeOrNull(() -> pageContext.applicationScope());
            this.arguments = this.getScopelikeOrNull(() -> pageContext.argumentsScope());
            this.form = root != null ? root.form : (Scope)this.getScopelikeOrNull(() -> pageContext.formScope());
            this.local = this.getScopelikeOrNull(() -> pageContext.localScope());
            this.request = root != null ? root.request : (Scope)this.getScopelikeOrNull(() -> pageContext.requestScope());
            this.session = root != null ? root.session : (Scope)this.getScopelikeOrNull(() -> pageContext.getApplicationContext().isSetSessionManagement() ? pageContext.sessionScope() : null);
            this.server = root != null ? root.server : (Scope)this.getScopelikeOrNull(() -> pageContext.serverScope());
            this.url = root != null ? root.url : (Scope)this.getScopelikeOrNull(() -> pageContext.urlScope());
            this.variables = this.getScopelikeOrNull(() -> pageContext.variablesScope());
            this.this_ = this.getScopelikeOrNull(() -> {
                if (this.variables instanceof ComponentScope) {
                    return ((ComponentScope)this.variables).getComponent();
                }
                if (this.variables instanceof ClosureScope) {
                    return (Struct)UnsafeUtils.deprecatedScopeGet((Collection)this.variables, "this");
                }
                return null;
            });
            this.static_ = this.this_ instanceof Component ? ((Component)this.this_).staticScope() : null;
        }

        public ArrayList<ClosureScope> getCapturedScopeChain() {
            if (this.capturedScopeChain == null) {
                this.capturedScopeChain = FrameContext.getCapturedScopeChain((Scope)this.variables);
            }
            return this.capturedScopeChain;
        }

        private static ArrayList<ClosureScope> getCapturedScopeChain(Scope variables) {
            if (variables instanceof ClosureScope) {
                ClosureScope captured;
                IdentityHashMap<ClosureScope, Boolean> setLike_seen = new IdentityHashMap<ClosureScope, Boolean>();
                ArrayList<ClosureScope> result = new ArrayList<ClosureScope>();
                Scope scope = variables;
                while (scope instanceof ClosureScope && !setLike_seen.containsKey(captured = (ClosureScope)scope)) {
                    setLike_seen.put(captured, true);
                    result.add(captured);
                    scope = captured.getVariables();
                }
                return result;
            }
            return new ArrayList<ClosureScope>();
        }

        private <T> T getScopelikeOrNull(SupplierOrNull<T> f) {
            try {
                return f.get();
            }
            catch (Throwable e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> T withPageContextLock(PageContext pageContext, Supplier<T> f) {
            Object object = activeFrameLockByPageContext.computeIfAbsent(pageContext, _x -> new Object());
            synchronized (object) {
                return f.get();
            }
        }

        public <T> T doWorkInThisFrame(Supplier<T> f) {
            return (T)FrameContext.withPageContextLock(this.pageContext, () -> {
                Argument saved_argumentsScope = this.getScopelikeOrNull(() -> this.pageContext.argumentsScope());
                Local saved_localScope = this.getScopelikeOrNull(() -> this.pageContext.localScope());
                Variables saved_variablesScope = this.getScopelikeOrNull(() -> this.pageContext.variablesScope());
                try {
                    this.pageContext.setFunctionScopes(this.local, this.arguments);
                    this.pageContext.setVariablesScope(this.variables);
                    Object t = f.get();
                    return t;
                }
                finally {
                    this.pageContext.setVariablesScope(saved_variablesScope);
                    this.pageContext.setFunctionScopes(saved_localScope, saved_argumentsScope);
                }
            });
        }

        static interface SupplierOrNull<T> {
            public T get() throws Throwable;
        }
    }
}

