/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lucee.loader.engine.CFMLEngine;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.runtime.PageContext;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.Log;
import org.lucee.extension.debugger.coreinject.StepMode;

public class NativeDebuggerListener {
    private static final Object breakpointLock = new Object();
    private static int[] bpLines = new int[0];
    private static String[] bpFiles = new String[0];
    private static String[] bpConditions = new String[0];
    private static int bpMinLine = Integer.MAX_VALUE;
    private static int bpMaxLine = Integer.MIN_VALUE;
    private static int bpMaxPathLen = 0;
    private static final Object funcBpLock = new Object();
    private static String[] funcBpNames = new String[0];
    private static String[] funcBpComponents = new String[0];
    private static String[] funcBpConditions = new String[0];
    private static boolean[] funcBpIsWildcard = new boolean[0];
    private static int funcBpMinLen = Integer.MAX_VALUE;
    private static int funcBpMaxLen = Integer.MIN_VALUE;
    private static volatile boolean hasFuncBps = false;
    private static final ConcurrentHashMap<Long, WeakReference<PageContext>> nativelySuspendedThreads = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, SuspendLocation> suspendLocations = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Throwable> pendingExceptions = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CachedExecutableLines> executableLinesCache = new ConcurrentHashMap();
    private static volatile BiConsumer<Long, String> onNativeSuspendCallback = null;
    private static volatile Consumer<Long> onNativeStepCallback = null;
    private static volatile Consumer<Long> onNativeExceptionCallback = null;
    private static volatile boolean nativeMode = false;
    private static volatile boolean dapClientConnected = false;
    private static volatile boolean breakOnUncaughtExceptions = false;
    private static volatile boolean consoleOutput = false;
    private static volatile boolean hasSuspendConditions = false;
    private static final ConcurrentHashMap<Long, StepState> steppingThreads = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Boolean> threadsToPause = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Long, Boolean> pausedThreads = new ConcurrentHashMap();
    private static volatile Consumer<Long> onNativePauseCallback = null;
    private static volatile Method debuggerFrameGetLineMethod = null;
    private static final long ALL_THREADS_VIRTUAL_ID = 1L;

    public static String getName() {
        return NativeDebuggerListener.class.getName();
    }

    private static void updateHasSuspendConditions() {
        hasSuspendConditions = dapClientConnected && (bpLines.length > 0 || hasFuncBps || breakOnUncaughtExceptions || !steppingThreads.isEmpty() || !threadsToPause.isEmpty());
    }

    private static void rebuildBreakpointBounds() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int maxLen = 0;
        for (int i = 0; i < bpLines.length; ++i) {
            if (bpLines[i] < min) {
                min = bpLines[i];
            }
            if (bpLines[i] > max) {
                max = bpLines[i];
            }
            if (bpFiles[i].length() <= maxLen) continue;
            maxLen = bpFiles[i].length();
        }
        bpMinLine = min;
        bpMaxLine = max;
        bpMaxPathLen = maxLen;
    }

    public static void setNativeMode(boolean enabled) {
        nativeMode = enabled;
        Log.info("Native mode: " + enabled);
    }

    public static boolean isNativeMode() {
        return nativeMode;
    }

    public static void setOnNativeSuspendCallback(BiConsumer<Long, String> callback) {
        onNativeSuspendCallback = callback;
    }

    public static void setOnNativeStepCallback(Consumer<Long> callback) {
        onNativeStepCallback = callback;
    }

    public static void setOnNativeExceptionCallback(Consumer<Long> callback) {
        onNativeExceptionCallback = callback;
    }

    public static void setOnNativePauseCallback(Consumer<Long> callback) {
        onNativePauseCallback = callback;
    }

    public static void addBreakpoint(String file, int line) {
        NativeDebuggerListener.addBreakpoint(file, line, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBreakpoint(String file, int line, String condition) {
        String canonFile = Config.canonicalizeFileName(file);
        String newCondition = condition != null && !condition.isEmpty() ? condition : null;
        Object object = breakpointLock;
        synchronized (object) {
            for (int i = 0; i < bpLines.length; ++i) {
                if (bpLines[i] != line || !bpFiles[i].equals(canonFile)) continue;
                String[] newConditions = (String[])bpConditions.clone();
                newConditions[i] = newCondition;
                bpConditions = newConditions;
                Log.info("Breakpoint updated: " + Config.shortenPath(canonFile) + ":" + line);
                return;
            }
            int len = bpLines.length;
            int[] newLines = new int[len + 1];
            String[] newFiles = new String[len + 1];
            String[] newConditions = new String[len + 1];
            System.arraycopy(bpLines, 0, newLines, 0, len);
            System.arraycopy(bpFiles, 0, newFiles, 0, len);
            System.arraycopy(bpConditions, 0, newConditions, 0, len);
            newLines[len] = line;
            newFiles[len] = canonFile;
            newConditions[len] = newCondition;
            bpLines = newLines;
            bpFiles = newFiles;
            bpConditions = newConditions;
            NativeDebuggerListener.rebuildBreakpointBounds();
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("Breakpoint set: " + Config.shortenPath(canonFile) + ":" + line + (String)(newCondition != null ? " condition=" + newCondition : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBreakpoint(String file, int line) {
        String canonFile = Config.canonicalizeFileName(file);
        Object object = breakpointLock;
        synchronized (object) {
            int idx = -1;
            for (int i = 0; i < bpLines.length; ++i) {
                if (bpLines[i] != line || !bpFiles[i].equals(canonFile)) continue;
                idx = i;
                break;
            }
            if (idx < 0) {
                return;
            }
            int len = bpLines.length;
            int[] newLines = new int[len - 1];
            String[] newFiles = new String[len - 1];
            String[] newConditions = new String[len - 1];
            System.arraycopy(bpLines, 0, newLines, 0, idx);
            System.arraycopy(bpLines, idx + 1, newLines, idx, len - idx - 1);
            System.arraycopy(bpFiles, 0, newFiles, 0, idx);
            System.arraycopy(bpFiles, idx + 1, newFiles, idx, len - idx - 1);
            System.arraycopy(bpConditions, 0, newConditions, 0, idx);
            System.arraycopy(bpConditions, idx + 1, newConditions, idx, len - idx - 1);
            bpLines = newLines;
            bpFiles = newFiles;
            bpConditions = newConditions;
            NativeDebuggerListener.rebuildBreakpointBounds();
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("Breakpoint removed: " + Config.shortenPath(canonFile) + ":" + line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearBreakpointsForFile(String file) {
        String canonFile = Config.canonicalizeFileName(file);
        Object object = breakpointLock;
        synchronized (object) {
            int keepCount = 0;
            for (int i = 0; i < bpFiles.length; ++i) {
                if (bpFiles[i].equals(canonFile)) continue;
                ++keepCount;
            }
            if (keepCount == bpFiles.length) {
                return;
            }
            int[] newLines = new int[keepCount];
            String[] newFiles = new String[keepCount];
            String[] newConditions = new String[keepCount];
            int j = 0;
            for (int i = 0; i < bpFiles.length; ++i) {
                if (bpFiles[i].equals(canonFile)) continue;
                newLines[j] = bpLines[i];
                newFiles[j] = bpFiles[i];
                newConditions[j] = bpConditions[i];
                ++j;
            }
            bpLines = newLines;
            bpFiles = newFiles;
            bpConditions = newConditions;
            NativeDebuggerListener.rebuildBreakpointBounds();
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.debug("Breakpoints cleared: " + Config.shortenPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllBreakpoints() {
        Object object = breakpointLock;
        synchronized (object) {
            bpLines = new int[0];
            bpFiles = new String[0];
            bpConditions = new String[0];
            bpMinLine = Integer.MAX_VALUE;
            bpMaxLine = Integer.MIN_VALUE;
            bpMaxPathLen = 0;
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.debug("Breakpoints cleared: all");
    }

    public static int getBreakpointCount() {
        return bpLines.length;
    }

    public static String[][] getBreakpointDetails() {
        int[] lines = bpLines;
        String[] files = bpFiles;
        String[][] result = new String[lines.length][2];
        for (int i = 0; i < lines.length; ++i) {
            result[i][0] = files[i];
            result[i][1] = "line:" + lines[i];
        }
        return result;
    }

    public static boolean isNativelySuspended(long javaThreadId) {
        return nativelySuspendedThreads.containsKey(javaThreadId);
    }

    public static Set<Long> getSuspendedThreadIds() {
        return new HashSet<Long>(nativelySuspendedThreads.keySet());
    }

    public static PageContext getAnyPageContext() {
        for (WeakReference<PageContext> ref : nativelySuspendedThreads.values()) {
            PageContext pc = (PageContext)ref.get();
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    public static PageContext getPageContext(long javaThreadId) {
        WeakReference<PageContext> ref = nativelySuspendedThreads.get(javaThreadId);
        if (ref == null) {
            Log.warn("getPageContext: thread " + javaThreadId + " not in map! Map=" + String.valueOf(nativelySuspendedThreads.keySet()));
            return null;
        }
        PageContext pc = (PageContext)ref.get();
        if (pc == null) {
            Log.warn("getPageContext: PageContext for thread " + javaThreadId + " was GC'd!");
        }
        return pc;
    }

    public static SuspendLocation getSuspendLocation(long javaThreadId) {
        return suspendLocations.get(javaThreadId);
    }

    public static boolean resumeNativeThread(long javaThreadId) {
        Log.info("resumeNativeThread: thread=" + javaThreadId + ", map=" + String.valueOf(nativelySuspendedThreads.keySet()));
        WeakReference<PageContext> pcRef = nativelySuspendedThreads.remove(javaThreadId);
        if (pcRef == null) {
            Log.warn("resumeNativeThread: thread " + javaThreadId + " not in map!");
            return false;
        }
        PageContext pc = (PageContext)pcRef.get();
        if (pc == null) {
            Log.warn("resumeNativeThread: PageContext for thread " + javaThreadId + " was GC'd!");
            return false;
        }
        Log.info("resumeNativeThread: calling debuggerResume() for thread " + javaThreadId);
        try {
            Method resumeMethod = pc.getClass().getMethod("debuggerResume", new Class[0]);
            resumeMethod.invoke((Object)pc, new Object[0]);
            Log.info("resumeNativeThread: debuggerResume() completed for thread " + javaThreadId);
            return true;
        }
        catch (NoSuchMethodException e) {
            Log.error("debuggerResume() not available (pre-Lucee7?)");
            return false;
        }
        catch (Exception e) {
            Log.error("Error calling debuggerResume()", e);
            return false;
        }
    }

    public static void resumeAllNativeThreads() {
        for (Long threadId : nativelySuspendedThreads.keySet()) {
            NativeDebuggerListener.resumeNativeThread(threadId);
        }
    }

    public static void requestPause(long threadId) {
        if (threadId == 0L || threadId == 1L) {
            threadsToPause.put(0L, Boolean.TRUE);
        } else {
            threadsToPause.put(threadId, Boolean.TRUE);
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("Pause requested for thread: " + String.valueOf(threadId == 0L || threadId == 1L ? "all" : Long.valueOf(threadId)));
    }

    private static boolean consumePauseRequest(long threadId) {
        if (threadsToPause.remove(threadId) != null) {
            NativeDebuggerListener.updateHasSuspendConditions();
            return true;
        }
        if (threadsToPause.remove(0L) != null) {
            NativeDebuggerListener.updateHasSuspendConditions();
            return true;
        }
        return false;
    }

    public static void startStepping(long threadId, StepMode mode, int currentDepth) {
        steppingThreads.put(threadId, new StepState(mode, currentDepth));
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.debug("Start stepping: thread=" + threadId + " mode=" + String.valueOf((Object)mode) + " depth=" + currentDepth);
    }

    public static void stopStepping(long threadId) {
        steppingThreads.remove(threadId);
        NativeDebuggerListener.updateHasSuspendConditions();
    }

    public static int getStackDepth(PageContext pc) {
        try {
            Method getFrames = pc.getClass().getMethod("getDebuggerFrames", new Class[0]);
            Object[] frames = (Object[])getFrames.invoke((Object)pc, new Object[0]);
            if (frames == null || frames.length == 0) {
                return 0;
            }
            Method getLine = debuggerFrameGetLineMethod;
            if (getLine == null) {
                debuggerFrameGetLineMethod = getLine = frames[0].getClass().getMethod("getLine", new Class[0]);
            }
            int count = 0;
            for (Object frame : frames) {
                int line = (Integer)getLine.invoke(frame, new Object[0]);
                if (line <= 0) continue;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            Log.error("Error getting stack depth: " + e.getMessage());
            return 0;
        }
    }

    public static void onSuspend(PageContext pc, String file, int line, String label) {
        long threadId = Thread.currentThread().getId();
        Log.info("onSuspend: thread=" + threadId + " file=" + Config.shortenPath(file) + " line=" + line);
        StepState stepState = steppingThreads.remove(threadId);
        boolean wasStepping = stepState != null;
        boolean wasPaused = pausedThreads.remove(threadId) != null;
        boolean hitBreakpoint = NativeDebuggerListener.hasBreakpoint(file, line);
        Throwable pendingException = pendingExceptions.remove(threadId);
        nativelySuspendedThreads.put(threadId, new WeakReference<PageContext>(pc));
        Log.info("onSuspend: added thread " + threadId + " to map, map=" + String.valueOf(nativelySuspendedThreads.keySet()));
        suspendLocations.put(threadId, new SuspendLocation(file, line, label, pendingException));
        if (pendingException != null) {
            Consumer<Long> callback = onNativeExceptionCallback;
            if (callback != null) {
                callback.accept(threadId);
            }
        } else if (hitBreakpoint) {
            BiConsumer<Long, String> callback = onNativeSuspendCallback;
            if (callback != null) {
                callback.accept(threadId, null);
            }
        } else if (wasPaused) {
            Consumer<Long> callback = onNativePauseCallback;
            if (callback != null) {
                callback.accept(threadId);
            }
        } else if (wasStepping) {
            Consumer<Long> callback = onNativeStepCallback;
            if (callback != null) {
                callback.accept(threadId);
            }
        } else {
            BiConsumer<Long, String> callback = onNativeSuspendCallback;
            if (callback != null) {
                callback.accept(threadId, label);
            }
        }
    }

    public static void onResume(PageContext pc) {
        long threadId = Thread.currentThread().getId();
        Log.debug("Resume: thread=" + threadId);
        nativelySuspendedThreads.remove(threadId);
        suspendLocations.remove(threadId);
    }

    public static boolean isDapClientConnected() {
        return dapClientConnected;
    }

    public static void setDapClientConnected(boolean connected) {
        dapClientConnected = connected;
        if (!connected) {
            NativeDebuggerListener.onClientDisconnect();
        }
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("DAP client connected: " + connected);
    }

    private static void onClientDisconnect() {
        NativeDebuggerListener.resumeAllNativeThreads();
        steppingThreads.clear();
        threadsToPause.clear();
        pausedThreads.clear();
        pendingExceptions.clear();
        breakOnUncaughtExceptions = false;
        consoleOutput = false;
        Log.info("DAP client disconnected - cleanup complete");
    }

    public static void setBreakOnUncaughtExceptions(boolean enabled) {
        breakOnUncaughtExceptions = enabled;
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("Exception breakpoints: " + (enabled ? "uncaught" : "none"));
    }

    public static boolean shouldBreakOnUncaughtExceptions() {
        return breakOnUncaughtExceptions && dapClientConnected;
    }

    public static void setConsoleOutput(boolean enabled) {
        consoleOutput = enabled;
        Log.setConsoleOutput(enabled);
    }

    public static void onOutput(String text, boolean isStdErr) {
        if (!consoleOutput || !dapClientConnected) {
            return;
        }
        Log.systemOutput(text, isStdErr);
    }

    public static boolean onException(PageContext pc, Throwable exception, boolean caught) {
        Log.debug("onException called: caught=" + caught + ", exception=" + exception.getClass().getName() + ", breakOnUncaught=" + breakOnUncaughtExceptions + ", dapConnected=" + dapClientConnected);
        Log.exception(exception);
        if (caught) {
            return false;
        }
        boolean shouldSuspend = NativeDebuggerListener.shouldBreakOnUncaughtExceptions();
        if (shouldSuspend) {
            long threadId = Thread.currentThread().getId();
            pendingExceptions.put(threadId, exception);
        }
        Log.debug("onException returning: " + shouldSuspend);
        return shouldSuspend;
    }

    public static boolean shouldSuspend(PageContext pc, String file, int line) {
        long threadId;
        if (!hasSuspendConditions) {
            return false;
        }
        int[] lines = bpLines;
        if (lines.length > 0 && line >= bpMinLine && line <= bpMaxLine) {
            String[] files = bpFiles;
            String[] conditions = bpConditions;
            String canonFile = null;
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] != line) continue;
                if (canonFile == null) {
                    if (file.length() > bpMaxPathLen) break;
                    canonFile = Config.canonicalizeFileName(file);
                }
                if (!files[i].equals(canonFile)) continue;
                String condition = conditions[i];
                if (condition != null) {
                    return NativeDebuggerListener.evaluateCondition(pc, condition);
                }
                return true;
            }
        }
        if (NativeDebuggerListener.consumePauseRequest(threadId = Thread.currentThread().getId())) {
            pausedThreads.put(threadId, Boolean.TRUE);
            return true;
        }
        StepState stepState = steppingThreads.get(threadId);
        if (stepState == null) {
            return false;
        }
        int currentDepth = NativeDebuggerListener.getStackDepth(pc);
        switch (stepState.mode) {
            case STEP_INTO: {
                return true;
            }
            case STEP_OVER: {
                return currentDepth <= stepState.startDepth;
            }
            case STEP_OUT: {
                return currentDepth < stepState.startDepth;
            }
        }
        return false;
    }

    private static boolean evaluateCondition(PageContext pc, String condition) {
        try {
            ClassLoader luceeLoader = pc.getClass().getClassLoader();
            Class<?> evaluateClass = luceeLoader.loadClass("lucee.runtime.functions.dynamicEvaluation.Evaluate");
            Method callMethod = evaluateClass.getMethod("call", PageContext.class, Object[].class);
            Object result = callMethod.invoke(null, pc, new Object[]{condition});
            Class<?> casterClass = luceeLoader.loadClass("lucee.runtime.op.Caster");
            Method toBooleanMethod = casterClass.getMethod("toBoolean", Object.class);
            return (Boolean)toBooleanMethod.invoke(null, result);
        }
        catch (Exception e) {
            Log.error("Condition evaluation failed: " + e.getMessage());
            return false;
        }
    }

    public static boolean hasBreakpoint(String file, int line) {
        String canonFile = Config.canonicalizeFileName(file);
        int[] lines = bpLines;
        String[] files = bpFiles;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] != line || !files[i].equals(canonFile)) continue;
            return true;
        }
        return false;
    }

    public static int[] getExecutableLines(String absolutePath) {
        PageContext pc = NativeDebuggerListener.getAnyPageContext();
        if (pc == null) {
            pc = NativeDebuggerListener.getAnyActivePageContext();
        }
        if (pc == null) {
            pc = NativeDebuggerListener.createTemporaryPageContext();
        }
        if (pc == null) {
            Log.debug("getExecutableLines: no PageContext available");
            return new int[0];
        }
        try {
            Object relativePath;
            Object servletContext = pc.getClass().getMethod("getServletContext", new Class[0]).invoke((Object)pc, new Object[0]);
            String webroot = (String)servletContext.getClass().getMethod("getRealPath", String.class).invoke(servletContext, "/");
            String normalizedAbsPath = absolutePath.replace('\\', '/').toLowerCase();
            Object normalizedWebroot = webroot.replace('\\', '/').toLowerCase();
            if (!((String)normalizedWebroot).endsWith("/")) {
                normalizedWebroot = (String)normalizedWebroot + "/";
            }
            if (normalizedAbsPath.startsWith((String)normalizedWebroot)) {
                relativePath = "/" + absolutePath.substring(webroot.length()).replace('\\', '/');
                if (((String)relativePath).startsWith("//")) {
                    relativePath = ((String)relativePath).substring(1);
                }
            } else {
                Log.debug("getExecutableLines: file outside webroot: " + absolutePath);
                return new int[0];
            }
            Method getPageSourceMethod = pc.getClass().getMethod("getPageSource", String.class);
            Object ps = getPageSourceMethod.invoke((Object)pc, relativePath);
            if (ps == null) {
                Log.debug("getExecutableLines: no PageSource for " + absolutePath);
                return new int[0];
            }
            Method loadPageMethod = ps.getClass().getMethod("loadPage", PageContext.class, Boolean.TYPE);
            Object page = loadPageMethod.invoke(ps, pc, false);
            if (page == null) {
                Log.debug("getExecutableLines: failed to load page " + absolutePath);
                return new int[0];
            }
            Method getExecLinesMethod = page.getClass().getMethod("getExecutableLines", new Class[0]);
            Object result = getExecLinesMethod.invoke(page, new Object[0]);
            if (result instanceof int[]) {
                return (int[])result;
            }
            if (result instanceof Object[]) {
                Object[] arr = (Object[])result;
                long compileTime = (Long)arr[0];
                int[] lines = (int[])arr[1];
                CachedExecutableLines cached = executableLinesCache.get(absolutePath);
                if (cached != null && cached.compileTime == compileTime) {
                    Log.debug("getExecutableLines: cache hit for " + absolutePath);
                    return cached.lines;
                }
                int[] resultLines = lines != null ? lines : new int[]{};
                executableLinesCache.put(absolutePath, new CachedExecutableLines(compileTime, resultLines));
                Log.debug("getExecutableLines: cached " + resultLines.length + " lines for " + absolutePath);
                return resultLines;
            }
            Log.debug("getExecutableLines: unexpected return type: " + (result != null ? result.getClass().getName() : "null"));
            return new int[0];
        }
        catch (NoSuchMethodException e) {
            Log.error("getExecutableLines: compiled class for [" + absolutePath + "] is missing debug info (should be auto-generated in debugger mode)");
            return new int[0];
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Log.debug("getExecutableLines failed for " + absolutePath + ": " + (String)(cause != null ? cause.getClass().getName() + ": " + cause.getMessage() : e.getMessage()));
            return new int[0];
        }
        catch (Exception e) {
            Log.debug("getExecutableLines failed for " + absolutePath + ": " + e.getClass().getName() + ": " + e.getMessage());
            return new int[0];
        }
    }

    private static PageContext getAnyActivePageContext() {
        try {
            CFMLEngine engine = CFMLEngineFactory.getInstance();
            Method getEngineMethod = engine.getClass().getMethod("getEngine", new Class[0]);
            Object engineImpl = getEngineMethod.invoke((Object)engine, new Object[0]);
            Method getFactoriesMethod = engineImpl.getClass().getMethod("getCFMLFactories", new Class[0]);
            Map factoriesMap = (Map)getFactoriesMethod.invoke(engineImpl, new Object[0]);
            for (Object factory : factoriesMap.values()) {
                try {
                    Method getActiveMethod = factory.getClass().getMethod("getActivePageContexts", new Class[0]);
                    Map activeContexts = (Map)getActiveMethod.invoke(factory, new Object[0]);
                    for (Object pc : activeContexts.values()) {
                        if (!(pc instanceof PageContext)) continue;
                        return (PageContext)pc;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            Log.debug("getAnyActivePageContext failed: " + e.getMessage());
        }
        return null;
    }

    private static PageContext createTemporaryPageContext() {
        try {
            CFMLEngine engine = CFMLEngineFactory.getInstance();
            for (Method m : engine.getClass().getMethods()) {
                ByteArrayOutputStream devNull;
                File contextRoot;
                Object pc;
                Class<?>[] params;
                if (!m.getName().equals("createPageContext") || m.getParameterCount() != 11 || !(params = m.getParameterTypes())[0].getName().equals("java.io.File") || !((pc = m.invoke((Object)engine, contextRoot = new File("."), "localhost", "/", "", null, null, null, null, devNull = new ByteArrayOutputStream(), -1L, false)) instanceof PageContext)) continue;
                return (PageContext)pc;
            }
        }
        catch (Exception e) {
            Log.debug("createTemporaryPageContext failed: " + e.getMessage());
        }
        return null;
    }

    public static boolean onFunctionEntry(PageContext pc, String functionName, String componentName, String file, int startLine) {
        if (!hasFuncBps || !dapClientConnected) {
            return false;
        }
        int len = functionName.length();
        if (len < funcBpMinLen || len > funcBpMaxLen) {
            return false;
        }
        String lowerFunc = functionName.toLowerCase();
        String lowerComp = componentName != null ? componentName.toLowerCase() : null;
        String[] names = funcBpNames;
        String[] comps = funcBpComponents;
        String[] conds = funcBpConditions;
        boolean[] wilds = funcBpIsWildcard;
        for (int i = 0; i < names.length; ++i) {
            boolean match;
            if (comps[i] != null && (lowerComp == null || !lowerComp.equals(comps[i]))) continue;
            if (wilds[i]) {
                String prefix = names[i].substring(0, names[i].length() - 1);
                match = lowerFunc.startsWith(prefix);
            } else {
                match = lowerFunc.equals(names[i]);
            }
            if (!match || conds[i] != null && !NativeDebuggerListener.evaluateCondition(pc, conds[i])) continue;
            Log.info("Function breakpoint hit: " + functionName + (String)(componentName != null ? " in " + componentName : ""));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFunctionBreakpoints(String[] names, String[] conditions) {
        Object object = funcBpLock;
        synchronized (object) {
            int count = names.length;
            String[] newNames = new String[count];
            String[] newComps = new String[count];
            String[] newConds = new String[count];
            boolean[] newWilds = new boolean[count];
            int minLen = Integer.MAX_VALUE;
            int maxLen = Integer.MIN_VALUE;
            for (int i = 0; i < count; ++i) {
                int effectiveLen;
                String name = names[i].trim();
                String condition = conditions != null && i < conditions.length && conditions[i] != null && !conditions[i].isEmpty() ? conditions[i] : null;
                int dot = name.lastIndexOf(46);
                String compName = null;
                String funcName = name;
                if (dot > 0) {
                    compName = name.substring(0, dot).toLowerCase();
                    funcName = name.substring(dot + 1);
                }
                boolean isWild = funcName.endsWith("*");
                newNames[i] = funcName.toLowerCase();
                newComps[i] = compName;
                newConds[i] = condition;
                newWilds[i] = isWild;
                int n = effectiveLen = isWild ? funcName.length() - 1 : funcName.length();
                if (!isWild) {
                    if (effectiveLen < minLen) {
                        minLen = effectiveLen;
                    }
                    if (effectiveLen > maxLen) {
                        maxLen = effectiveLen;
                    }
                } else {
                    if (effectiveLen < minLen) {
                        minLen = effectiveLen;
                    }
                    maxLen = Integer.MAX_VALUE;
                }
                Log.info("Function breakpoint: " + name + (String)(compName != null ? " (component: " + compName + ")" : "") + (isWild ? " (wildcard)" : "") + (String)(condition != null ? " condition: " + condition : ""));
            }
            funcBpNames = newNames;
            funcBpComponents = newComps;
            funcBpConditions = newConds;
            funcBpIsWildcard = newWilds;
            funcBpMinLen = count > 0 ? minLen : Integer.MAX_VALUE;
            funcBpMaxLen = count > 0 ? maxLen : Integer.MIN_VALUE;
        }
        hasFuncBps = funcBpNames.length > 0;
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.info("Function breakpoints set: " + funcBpNames.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFunctionBreakpoints() {
        Object object = funcBpLock;
        synchronized (object) {
            funcBpNames = new String[0];
            funcBpComponents = new String[0];
            funcBpConditions = new String[0];
            funcBpIsWildcard = new boolean[0];
            funcBpMinLen = Integer.MAX_VALUE;
            funcBpMaxLen = Integer.MIN_VALUE;
        }
        hasFuncBps = false;
        NativeDebuggerListener.updateHasSuspendConditions();
        Log.debug("Function breakpoints cleared");
    }

    public static class SuspendLocation {
        public final String file;
        public final int line;
        public final String label;
        public final Throwable exception;

        public SuspendLocation(String file, int line, String label) {
            this(file, line, label, null);
        }

        public SuspendLocation(String file, int line, String label, Throwable exception) {
            this.file = file;
            this.line = line;
            this.label = label;
            this.exception = exception;
        }
    }

    private static class StepState {
        final StepMode mode;
        final int startDepth;

        StepState(StepMode mode, int startDepth) {
            this.mode = mode;
            this.startDepth = startDepth;
        }
    }

    private static class CachedExecutableLines {
        final long compileTime;
        final int[] lines;

        CachedExecutableLines(long compileTime, int[] lines) {
            this.compileTime = compileTime;
            this.lines = lines;
        }
    }
}

