/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.lang.invoke.CallSite;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.Either;
import org.lucee.extension.debugger.GlobalIDebugManagerHolder;
import org.lucee.extension.debugger.IBreakpoint;
import org.lucee.extension.debugger.ICfValueDebuggerBridge;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.IDebugManager;
import org.lucee.extension.debugger.ILuceeVm;
import org.lucee.extension.debugger.ThreadInfo;
import org.lucee.extension.debugger.coreinject.Breakpoint;
import org.lucee.extension.debugger.coreinject.Iife;
import org.lucee.extension.debugger.coreinject.KlassMap;
import org.lucee.extension.debugger.coreinject.NativeDebuggerListener;
import org.lucee.extension.debugger.shaded.lsp4j.debug.CompletionItem;
import org.lucee.extension.debugger.strong.CanonicalServerAbsPath;
import org.lucee.extension.debugger.strong.DapBreakpointID;
import org.lucee.extension.debugger.strong.JdwpThreadID;
import org.lucee.extension.debugger.strong.RawIdePath;
import org.lucee.extension.debugger.util.ConcurrentWeakKeyMap;

public class LuceeVm
implements ILuceeVm {
    private static final String LUCEEDEBUG_BREAKPOINT_ID = "luceedebug-breakpoint-id";
    private static final String LUCEEDEBUG_BREAKPOINT_EXPR = "luceedebug-breakpoint-expr";
    private final Config config_;
    private final VirtualMachine vm_;
    private final ThreadMap threadMap_ = new ThreadMap();
    private final ExecutorService stepHandlerExecutor = Executors.newSingleThreadExecutor();
    private final ConcurrentHashMap<CanonicalServerAbsPath, Set<ReplayableCfBreakpointRequest>> replayableBreakpointRequestsByAbsPath_ = new ConcurrentHashMap();
    private final ConcurrentHashMap<CanonicalServerAbsPath, Set<KlassMap>> klassMap_ = new ConcurrentHashMap();
    private long JDWP_WORKER_CLASS_ID = 0L;
    private ThreadReference JDWP_WORKER_THREADREF = null;
    private final JdwpStaticCallable jdwp_getThread;
    private static final int SIZEOF_INSTR_INVOKE_INTERFACE = 5;
    private ConcurrentMap<JdwpThreadID, SteppingState> steppingStatesByThread = new ConcurrentHashMap<JdwpThreadID, SteppingState>();
    private Consumer<Long> stepEventCallback = null;
    private BiConsumer<Long, String> nativeBreakpointEventCallback = null;
    private BiConsumer<Long, DapBreakpointID> breakpointEventCallback = null;
    private Consumer<ILuceeVm.BreakpointsChangedEvent> breakpointsChangedCallback = null;
    private AtomicInteger breakpointID = new AtomicInteger();
    private HashSet<JdwpThreadID> suspendedThreads = new HashSet();

    private void bootThreadTracking() {
        ThreadStartRequest threadStartRequest = this.vm_.eventRequestManager().createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        this.initCurrentThreadListing();
        ThreadDeathRequest threadDeathRequest = this.vm_.eventRequestManager().createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
    }

    private void bootClassTracking() {
        List<ReferenceType> pageRef = this.vm_.classesByName("lucee.runtime.Page");
        if (pageRef.size() == 0) {
            ClassPrepareRequest request = this.vm_.eventRequestManager().createClassPrepareRequest();
            request.addClassFilter("lucee.runtime.Page");
            request.setSuspendPolicy(1);
            request.setEnabled(true);
        } else if (pageRef.size() == 1) {
            this.bootClassTracking(pageRef.get(0));
        } else {
            System.out.println("[luceedebug] Expected 0 or 1 ref for class with name 'lucee.runtime.Page', but got " + pageRef.size());
            System.exit(1);
        }
    }

    private void bootClassTracking(ReferenceType lucee_runtime_Page) {
        ClassPrepareRequest classPrepareRequest = this.vm_.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(1);
        classPrepareRequest.addClassFilter(lucee_runtime_Page);
        classPrepareRequest.enable();
        ClassUnloadRequest classUnloadRequest = this.vm_.eventRequestManager().createClassUnloadRequest();
        classUnloadRequest.setSuspendPolicy(0);
    }

    private JdwpStaticCallable bootThreadWorker() {
        JdwpWorker.touch();
        String className = "org.lucee.extension.debugger.coreinject.LuceeVm$JdwpWorker";
        List<ReferenceType> refs = this.vm_.classesByName("org.lucee.extension.debugger.coreinject.LuceeVm$JdwpWorker");
        if (refs.size() != 1) {
            System.out.println("Expected 1 ref for class org.lucee.extension.debugger.coreinject.LuceeVm$JdwpWorker but got " + refs.size());
            System.exit(1);
        }
        ReferenceType refType = refs.get(0);
        Method jdwp_stays_suspended_in_this_method_as_a_worker = null;
        Method jdwp_getThread = null;
        for (Method method : refType.methods()) {
            if (method.name().equals("jdwp_stays_suspended_in_this_method_as_a_worker")) {
                jdwp_stays_suspended_in_this_method_as_a_worker = method;
            }
            if (!method.name().equals("jdwp_getThread")) continue;
            jdwp_getThread = method;
        }
        if (jdwp_stays_suspended_in_this_method_as_a_worker == null) {
            System.out.println("Couldn't find helper method 'jdwp_stays_suspended_in_this_method_as_a_worker'");
            System.exit(1);
            return null;
        }
        if (jdwp_getThread == null) {
            System.out.println("Couldn't find helper method 'jdwp_getThread'");
            System.exit(1);
            return null;
        }
        this.JDWP_WORKER_CLASS_ID = refType.classObject().uniqueID();
        BreakpointRequest bpRequest = this.vm_.eventRequestManager().createBreakpointRequest(jdwp_stays_suspended_in_this_method_as_a_worker.locationOfCodeIndex(0L));
        bpRequest.setSuspendPolicy(1);
        bpRequest.enable();
        JdwpWorker.spawnThreadForJdwpToSuspend();
        JdwpWorker.spinWaitForJdwpBpToSuspendWorkerThread();
        return new JdwpStaticCallable((ClassType)refType.classObject().reflectedType(), jdwp_getThread);
    }

    public LuceeVm(Config config, VirtualMachine vm) {
        this.config_ = config;
        this.vm_ = vm;
        this.initEventPump();
        this.jdwp_getThread = this.bootThreadWorker();
        this.bootClassTracking();
        this.bootThreadTracking();
        GlobalIDebugManagerHolder.debugManager.registerCfStepHandler((thread, minDistanceToLuceedebugBaseFrame) -> {
            ThreadReference threadRef = this.threadMap_.getThreadRefByThreadOrFail(thread);
            AtomicBoolean done = new AtomicBoolean(false);
            CompletableFuture.runAsync(() -> {
                try {
                    threadRef.suspend();
                    for (int i = minDistanceToLuceedebugBaseFrame; i < Integer.MAX_VALUE; ++i) {
                        if (!IDebugManager.isStepNotificationEntryFunc(threadRef.frame(i).location().method().name())) continue;
                        StackFrame stepInvokingCfFrame = threadRef.frame(i + 1);
                        Location location = stepInvokingCfFrame.location().method().locationOfCodeIndex(stepInvokingCfFrame.location().codeIndex() + 5L);
                        BreakpointRequest bp = this.vm_.eventRequestManager().createBreakpointRequest(location);
                        bp.setSuspendPolicy(1);
                        bp.addThreadFilter(threadRef);
                        bp.addCountFilter(1);
                        bp.setEnabled(true);
                        this.steppingStatesByThread.put(JdwpThreadID.of(threadRef), SteppingState.finalizingViaAwaitedBreakpoint);
                        done.set(true);
                        this.continue_(threadRef);
                        return;
                    }
                    throw new RuntimeException("unreachable");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                    return;
                }
            }, this.stepHandlerExecutor);
            while (!done.get()) {
            }
        });
    }

    @Override
    public void registerStepEventCallback(Consumer<Long> cb) {
        this.stepEventCallback = cb;
    }

    @Override
    public void registerBreakpointEventCallback(BiConsumer<Long, DapBreakpointID> cb) {
        this.breakpointEventCallback = cb;
    }

    @Override
    public void registerBreakpointsChangedCallback(Consumer<ILuceeVm.BreakpointsChangedEvent> cb) {
        this.breakpointsChangedCallback = cb;
    }

    @Override
    public void registerNativeBreakpointEventCallback(BiConsumer<Long, String> cb) {
        this.nativeBreakpointEventCallback = cb;
    }

    private void initEventPump() {
        new Thread(() -> {
            try {
                block3: while (true) {
                    EventSet eventSet = this.vm_.eventQueue().remove();
                    Iterator iterator = eventSet.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        Event event = (Event)iterator.next();
                        if (event instanceof ThreadStartEvent) {
                            this.handleThreadStartEvent((ThreadStartEvent)event);
                            continue;
                        }
                        if (event instanceof ThreadDeathEvent) {
                            this.handleThreadDeathEvent((ThreadDeathEvent)event);
                            continue;
                        }
                        if (event instanceof ClassPrepareEvent) {
                            this.handleClassPrepareEvent((ClassPrepareEvent)event);
                            continue;
                        }
                        if (event instanceof BreakpointEvent) {
                            this.handleBreakpointEvent((BreakpointEvent)event);
                            continue;
                        }
                        System.out.println("Unexpected jdwp event " + String.valueOf(event));
                        System.exit(1);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        }).start();
    }

    private void initCurrentThreadListing() {
        for (ThreadReference threadRef : this.vm_.allThreads()) {
            this.trackThreadReference(threadRef);
        }
    }

    private void trackThreadReference(ThreadReference threadRef) {
        try {
            List<ThreadReference> args = Arrays.asList(threadRef);
            LongValue v = (LongValue)this.jdwp_getThread.classType.invokeMethod(this.JDWP_WORKER_THREADREF, this.jdwp_getThread.method, args, 1);
            long key = v.value();
            Thread thread = JdwpWorker.jdwp_getThreadResult(key);
            this.threadMap_.register(thread, threadRef);
        }
        catch (ObjectCollectedException e) {
            if (this.JDWP_WORKER_THREADREF.isCollected()) {
                System.out.println("[luceedebug] fatal: JDWP_WORKER_THREADREF is collected");
                System.exit(1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void untrackThreadReference(ThreadReference threadRef) {
        this.threadMap_.unregister(threadRef);
    }

    private void trackClassRef(ReferenceType refType) {
        try {
            KlassMap maybeNull_klassMap = KlassMap.maybeNull_tryBuildKlassMap(this.config_, refType);
            if (maybeNull_klassMap == null) {
                String name = refType.toString();
                try {
                    name = refType.sourceName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!name.contains("lucee.commons.lang.MemoryClassLoader")) {
                    System.out.println("[luceedebug] class information for reftype " + name + " could not be retrieved.");
                }
                return;
            }
            KlassMap klassMap = maybeNull_klassMap;
            Set<ReplayableCfBreakpointRequest> replayableBreakpointRequests = this.replayableBreakpointRequestsByAbsPath_.get(klassMap.sourceName);
            this.klassMap_.computeIfAbsent(klassMap.sourceName, _z -> new HashSet()).add(klassMap);
            if (replayableBreakpointRequests != null) {
                this.rebindBreakpoints(klassMap.sourceName, replayableBreakpointRequests);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void handleThreadStartEvent(ThreadStartEvent event) {
        this.trackThreadReference(event.thread());
    }

    private void handleThreadDeathEvent(ThreadDeathEvent event) {
        this.untrackThreadReference(event.thread());
    }

    private void handleClassPrepareEvent(ClassPrepareEvent event) {
        if (event.referenceType().name().equals("lucee.runtime.Page")) {
            this.vm_.eventRequestManager().deleteEventRequest(event.request());
            this.bootClassTracking(event.referenceType());
            event.thread().resume();
        } else {
            this.trackClassRef(event.referenceType());
            event.thread().resume();
        }
    }

    private void handleBreakpointEvent(BreakpointEvent event) {
        if (event.location().declaringType().classObject().uniqueID() == this.JDWP_WORKER_CLASS_ID) {
            this.JDWP_WORKER_THREADREF = event.thread();
            JdwpWorker.notifyJdwpSuspendedWorkerThread();
            return;
        }
        JdwpThreadID threadID = JdwpThreadID.of(event.thread());
        this.suspendedThreads.add(threadID);
        if (this.steppingStatesByThread.remove(threadID, (Object)SteppingState.finalizingViaAwaitedBreakpoint)) {
            if (this.stepEventCallback != null) {
                this.stepEventCallback.accept((Long)threadID.get());
            }
        } else {
            JdwpThreadID jdwp_threadID;
            EventRequest request;
            Object maybe_expr;
            if (this.steppingStatesByThread.remove(threadID, (Object)SteppingState.stepping)) {
                GlobalIDebugManagerHolder.debugManager.clearStepRequest(this.threadMap_.getThreadByJdwpIdOrFail(threadID));
            }
            if ((maybe_expr = (request = event.request()).getProperty(LUCEEDEBUG_BREAKPOINT_EXPR)) instanceof String && !GlobalIDebugManagerHolder.debugManager.evaluateAsBooleanForConditionalBreakpoint(this.threadMap_.getThreadByJdwpIdOrFail(jdwp_threadID = JdwpThreadID.of(event.thread())), (String)maybe_expr)) {
                this.continue_(jdwp_threadID);
                return;
            }
            if (this.breakpointEventCallback != null) {
                DapBreakpointID bpID = (DapBreakpointID)request.getProperty(LUCEEDEBUG_BREAKPOINT_ID);
                this.breakpointEventCallback.accept((Long)threadID.get(), bpID);
            }
        }
    }

    @Override
    public ThreadInfo[] getThreadListing() {
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        for (ThreadReference threadRef : this.threadMap_.threadRefByThread.values()) {
            try {
                result.add(new ThreadInfo(threadRef.uniqueID(), threadRef.name()));
            }
            catch (ObjectCollectedException objectCollectedException) {}
        }
        return (ThreadInfo[])result.toArray(ThreadInfo[]::new);
    }

    @Override
    public IDebugFrame[] getStackTrace(long jdwpThreadId) {
        Thread thread = this.threadMap_.getThreadByJdwpIdOrFail(new JdwpThreadID(jdwpThreadId));
        System.out.println("[luceedebug] getStackTrace: jdwpThreadId=" + jdwpThreadId + " -> thread=" + thread.getName() + " (id=" + thread.getId() + ") identity=" + System.identityHashCode(thread));
        IDebugFrame[] frames = GlobalIDebugManagerHolder.debugManager.getCfStack(thread);
        System.out.println("[luceedebug] getStackTrace: returning " + frames.length + " frames");
        return frames;
    }

    @Override
    public IDebugEntity[] getScopes(long frameID) {
        return GlobalIDebugManagerHolder.debugManager.getScopesForFrame(frameID);
    }

    @Override
    public IDebugEntity[] getVariables(long ID) {
        return GlobalIDebugManagerHolder.debugManager.getVariables(ID, null);
    }

    @Override
    public IDebugEntity[] getNamedVariables(long ID) {
        return GlobalIDebugManagerHolder.debugManager.getVariables(ID, IDebugEntity.DebugEntityType.NAMED);
    }

    @Override
    public IDebugEntity[] getIndexedVariables(long ID) {
        return GlobalIDebugManagerHolder.debugManager.getVariables(ID, IDebugEntity.DebugEntityType.INDEXED);
    }

    private DapBreakpointID nextDapBreakpointID() {
        return new DapBreakpointID(this.breakpointID.incrementAndGet());
    }

    public void rebindBreakpoints(CanonicalServerAbsPath serverAbsPath, Collection<ReplayableCfBreakpointRequest> cfBpRequests) {
        IBreakpoint[] changedBreakpoints = this.__internal__bindBreakpoints(serverAbsPath, ReplayableCfBreakpointRequest.getLineInfo(cfBpRequests));
        if (this.breakpointsChangedCallback != null) {
            this.breakpointsChangedCallback.accept(ILuceeVm.BreakpointsChangedEvent.justChanges(changedBreakpoints));
        }
    }

    private BpLineAndId[] freshBpLineAndIdRecordsFromLines(RawIdePath idePath, CanonicalServerAbsPath serverPath, int[] lines, String[] exprs) {
        if (lines.length != exprs.length) {
            throw new AssertionError((Object)"lines.length != exprs.length");
        }
        BpLineAndId[] result = new BpLineAndId[lines.length];
        Set<ReplayableCfBreakpointRequest> bpInfo = this.replayableBreakpointRequestsByAbsPath_.get(serverPath);
        for (int i = 0; i < lines.length; ++i) {
            int line = lines[i];
            DapBreakpointID id = Iife.iife(() -> {
                if (bpInfo == null) {
                    return this.nextDapBreakpointID();
                }
                for (ReplayableCfBreakpointRequest z : bpInfo) {
                    if (z.line != line) continue;
                    return z.id;
                }
                return this.nextDapBreakpointID();
            });
            result[i] = new BpLineAndId(idePath, serverPath, line, id, exprs[i]);
        }
        return result;
    }

    @Override
    public IBreakpoint[] bindBreakpoints(RawIdePath idePath, CanonicalServerAbsPath serverPath, int[] lines, String[] exprs) {
        if (NativeDebuggerListener.isNativeMode()) {
            NativeDebuggerListener.clearBreakpointsForFile((String)serverPath.get());
            for (int line : lines) {
                NativeDebuggerListener.addBreakpoint((String)serverPath.get(), line);
            }
            BpLineAndId[] lineInfo = this.freshBpLineAndIdRecordsFromLines(idePath, serverPath, lines, exprs);
            IBreakpoint[] result = new Breakpoint[lineInfo.length];
            for (int i = 0; i < lineInfo.length; ++i) {
                result[i] = Breakpoint.Bound(lineInfo[i].line, lineInfo[i].id);
            }
            return result;
        }
        return this.__internal__bindBreakpoints(serverPath, this.freshBpLineAndIdRecordsFromLines(idePath, serverPath, lines, exprs));
    }

    private IBreakpoint[] __internal__bindBreakpoints(CanonicalServerAbsPath serverAbsPath, BpLineAndId[] lineInfo) {
        Set<KlassMap> klassMapSet = this.klassMap_.get(serverAbsPath);
        if (klassMapSet == null) {
            Set replayable = this.replayableBreakpointRequestsByAbsPath_.computeIfAbsent(serverAbsPath, _z -> new HashSet());
            IBreakpoint[] result = new Breakpoint[lineInfo.length];
            for (int i = 0; i < lineInfo.length; ++i) {
                RawIdePath ideAbsPath = lineInfo[i].ideAbsPath;
                CanonicalServerAbsPath shadow_serverAbsPath = lineInfo[i].serverAbsPath;
                int line = lineInfo[i].line;
                DapBreakpointID id = lineInfo[i].id;
                String expr = lineInfo[i].expr;
                result[i] = Breakpoint.Unbound(line, id);
                replayable.add(new ReplayableCfBreakpointRequest(ideAbsPath, shadow_serverAbsPath, line, id, expr));
            }
            return result;
        }
        IBreakpoint[] bpListPerMapping = new IBreakpoint[]{};
        this.clearExistingBreakpoints(serverAbsPath);
        ArrayList<KlassMap> garbageCollectedKlassMaps = new ArrayList<KlassMap>();
        for (KlassMap mapping : klassMapSet) {
            if (mapping.isCollected()) {
                garbageCollectedKlassMaps.add(mapping);
                continue;
            }
            try {
                bpListPerMapping = this.__internal__idempotentBindBreakpoints(mapping, lineInfo);
            }
            catch (ObjectCollectedException e) {
                garbageCollectedKlassMaps.add(mapping);
            }
        }
        garbageCollectedKlassMaps.forEach(klassMap -> {
            Set<ReplayableCfBreakpointRequest> z = this.replayableBreakpointRequestsByAbsPath_.get(klassMap.sourceName);
            if (z != null) {
                z.removeIf(bpReq -> bpReq.serverAbsPath.equals(klassMap.sourceName));
            }
            klassMapSet.remove(klassMap);
        });
        return bpListPerMapping;
    }

    private IBreakpoint[] __internal__idempotentBindBreakpoints(KlassMap klassMap, BpLineAndId[] lineInfo) {
        Set replayable = this.replayableBreakpointRequestsByAbsPath_.computeIfAbsent(klassMap.sourceName, _z -> new HashSet());
        ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
        for (int i = 0; i < lineInfo.length; ++i) {
            RawIdePath ideAbsPath = lineInfo[i].ideAbsPath;
            CanonicalServerAbsPath serverAbsPath = lineInfo[i].serverAbsPath;
            int line = lineInfo[i].line;
            DapBreakpointID id = lineInfo[i].id;
            Location maybeNull_location = klassMap.lineMap.get(line);
            String expr = lineInfo[i].expr;
            if (maybeNull_location == null) {
                replayable.add(new ReplayableCfBreakpointRequest(ideAbsPath, serverAbsPath, line, id, expr));
                result.add(Breakpoint.Unbound(line, id));
                continue;
            }
            BreakpointRequest bpRequest = this.vm_.eventRequestManager().createBreakpointRequest(maybeNull_location);
            bpRequest.setSuspendPolicy(1);
            bpRequest.putProperty(LUCEEDEBUG_BREAKPOINT_ID, id);
            if (expr != null) {
                bpRequest.putProperty(LUCEEDEBUG_BREAKPOINT_EXPR, expr);
            }
            bpRequest.setEnabled(true);
            replayable.add(new ReplayableCfBreakpointRequest(ideAbsPath, serverAbsPath, line, id, expr, bpRequest));
            result.add(Breakpoint.Bound(line, id));
        }
        this.replayableBreakpointRequestsByAbsPath_.put(klassMap.sourceName, replayable);
        return (IBreakpoint[])result.toArray(IBreakpoint[]::new);
    }

    private void clearExistingBreakpoints(CanonicalServerAbsPath absPath) {
        Set<ReplayableCfBreakpointRequest> replayable = this.replayableBreakpointRequestsByAbsPath_.get(absPath);
        this.replayableBreakpointRequestsByAbsPath_.remove(absPath);
        if (replayable == null) {
            return;
        }
        List<BreakpointRequest> bpRequests = ReplayableCfBreakpointRequest.getJdwpRequests(replayable);
        int[] result = new int[bpRequests.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bpRequests.get(i).location().lineNumber();
        }
        this.vm_.eventRequestManager().deleteEventRequests(bpRequests);
    }

    @Override
    public void clearAllBreakpoints() {
        if (NativeDebuggerListener.isNativeMode()) {
            NativeDebuggerListener.clearAllBreakpoints();
            return;
        }
        this.replayableBreakpointRequestsByAbsPath_.clear();
        this.vm_.eventRequestManager().deleteAllBreakpoints();
    }

    public void continue_(JdwpThreadID jdwpThreadID) {
        ThreadReference threadRef = this.threadMap_.getThreadRefByJdwpIdOrFail(jdwpThreadID);
        this.continue_(threadRef);
    }

    private void continue_(ThreadReference threadRef) {
        this.suspendedThreads.remove(JdwpThreadID.of(threadRef));
        for (int suspendCount = threadRef.suspendCount(); suspendCount > 0; --suspendCount) {
            threadRef.resume();
        }
    }

    @Override
    public void continueAll() {
        if (NativeDebuggerListener.isNativeMode()) {
            NativeDebuggerListener.resumeAllNativeThreads();
            return;
        }
        Arrays.asList((JdwpThreadID[])this.suspendedThreads.toArray(JdwpThreadID[]::new)).forEach(jdwpThreadID -> this.continue_((JdwpThreadID)jdwpThreadID));
    }

    @Override
    public void stepOut(long jdwpThreadID) {
        this.stepOut(new JdwpThreadID(jdwpThreadID));
    }

    @Override
    public void stepOver(long jdwpThreadID) {
        this.stepOver(new JdwpThreadID(jdwpThreadID));
    }

    @Override
    public void stepIn(long jdwpThreadID) {
        this.stepIn(new JdwpThreadID(jdwpThreadID));
    }

    @Override
    public void continue_(long threadID) {
        if (NativeDebuggerListener.isNativeMode()) {
            NativeDebuggerListener.resumeNativeThread(threadID);
            return;
        }
        this.continue_(new JdwpThreadID(threadID));
    }

    public void stepIn(JdwpThreadID jdwpThreadID) {
        if (this.steppingStatesByThread.containsKey(jdwpThreadID)) {
            return;
        }
        this.steppingStatesByThread.put(jdwpThreadID, SteppingState.stepping);
        Thread thread = this.threadMap_.getThreadByJdwpIdOrFail(jdwpThreadID);
        ThreadReference threadRef = this.threadMap_.getThreadRefByThreadOrFail(thread);
        if (threadRef.suspendCount() == 0) {
            System.out.println("step in handler expected thread " + String.valueOf(thread) + " to already be suspended, but suspendCount was 0.");
            System.exit(1);
            return;
        }
        GlobalIDebugManagerHolder.debugManager.registerStepRequest(thread, 0);
        this.continue_(threadRef);
    }

    public void stepOver(JdwpThreadID jdwpThreadID) {
        if (this.steppingStatesByThread.containsKey(jdwpThreadID)) {
            return;
        }
        this.steppingStatesByThread.put(jdwpThreadID, SteppingState.stepping);
        Thread thread = this.threadMap_.getThreadByJdwpIdOrFail(jdwpThreadID);
        ThreadReference threadRef = this.threadMap_.getThreadRefByThreadOrFail(thread);
        if (threadRef.suspendCount() == 0) {
            System.out.println("step over handler expected thread " + String.valueOf(thread) + " to already be suspended, but suspendCount was 0.");
            System.exit(1);
            return;
        }
        GlobalIDebugManagerHolder.debugManager.registerStepRequest(thread, 1);
        this.continue_(threadRef);
    }

    private void stepOut(JdwpThreadID jdwpThreadID) {
        if (this.steppingStatesByThread.containsKey(jdwpThreadID)) {
            return;
        }
        this.steppingStatesByThread.put(jdwpThreadID, SteppingState.stepping);
        Thread thread = this.threadMap_.getThreadByJdwpIdOrFail(jdwpThreadID);
        ThreadReference threadRef = this.threadMap_.getThreadRefByThreadOrFail(thread);
        if (threadRef.suspendCount() == 0) {
            System.out.println("step out handler expected thread " + String.valueOf(thread) + " to already be suspended, but suspendCount was 0.");
            System.exit(1);
            return;
        }
        GlobalIDebugManagerHolder.debugManager.registerStepRequest(thread, 2);
        this.continue_(threadRef);
    }

    private ArrayList<Thread> getSuspendedThreadListForDumpWorker() {
        ArrayList<Thread> suspendedThreadsList = new ArrayList<Thread>();
        this.suspendedThreads.iterator().forEachRemaining(jdwpThreadID -> {
            Thread thread = this.threadMap_.getThreadByJdwpId((JdwpThreadID)jdwpThreadID);
            if (thread != null) {
                suspendedThreadsList.add(thread);
            }
        });
        return suspendedThreadsList;
    }

    @Override
    public String dump(int dapVariablesReference) {
        return GlobalIDebugManagerHolder.debugManager.doDump(this.getSuspendedThreadListForDumpWorker(), dapVariablesReference);
    }

    @Override
    public String dumpAsJSON(int dapVariablesReference) {
        return GlobalIDebugManagerHolder.debugManager.doDumpAsJSON(this.getSuspendedThreadListForDumpWorker(), dapVariablesReference);
    }

    @Override
    public String getMetadata(int dapVariablesReference) {
        return "\"getMetadata not supported in JDWP mode\"";
    }

    @Override
    public String getApplicationSettings() {
        return "\"getApplicationSettings not supported in JDWP mode\"";
    }

    @Override
    public CompletionItem[] getCompletions(int frameId, String partialExpr) {
        return new CompletionItem[0];
    }

    @Override
    public String[] getTrackedCanonicalFileNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Set<KlassMap> klassMap : this.klassMap_.values()) {
            for (KlassMap mapping : klassMap) {
                result.add((String)mapping.sourceName.get());
            }
        }
        return (String[])result.toArray(String[]::new);
    }

    @Override
    public String[][] getBreakpointDetail() {
        ArrayList result = new ArrayList();
        for (Map.Entry<CanonicalServerAbsPath, Set<ReplayableCfBreakpointRequest>> bps : this.replayableBreakpointRequestsByAbsPath_.entrySet()) {
            for (ReplayableCfBreakpointRequest bp : bps.getValue()) {
                String commonSuffix = ":" + bp.line + (bp.maybeNull_jdwpBreakpointRequest == null ? " (unbound)" : " (bound)");
                ArrayList<CallSite> pair = new ArrayList<CallSite>();
                pair.add((CallSite)((Object)(String.valueOf(bp.ideAbsPath) + commonSuffix)));
                pair.add((CallSite)((Object)(String.valueOf(bp.serverAbsPath) + commonSuffix)));
                result.add(pair);
            }
        }
        return (String[][])result.stream().map(u -> u.toArray(new String[0])).toArray(x$0 -> new String[x$0][]);
    }

    @Override
    public String getSourcePathForVariablesRef(int variablesRef) {
        return GlobalIDebugManagerHolder.debugManager.getSourcePathForVariablesRef(variablesRef);
    }

    @Override
    public Either<String, Either<ICfValueDebuggerBridge, String>> evaluate(int frameID, String expr) {
        return GlobalIDebugManagerHolder.debugManager.evaluate(Long.valueOf(frameID), expr);
    }

    @Override
    public Either<String, Either<ICfValueDebuggerBridge, String>> setVariable(long variablesReference, String name, String value, long frameId) {
        return Either.Left("setVariable not yet supported in JDWP mode - use native debugger mode instead");
    }

    @Override
    public void registerExceptionEventCallback(Consumer<Long> cb) {
    }

    @Override
    public void registerPauseEventCallback(Consumer<Long> cb) {
    }

    @Override
    public void pause(long threadID) {
        System.out.println("[luceedebug] pause() not implemented for JDWP mode");
    }

    @Override
    public Throwable getExceptionForThread(long threadId) {
        return null;
    }

    private static class JdwpWorker {
        static ConcurrentHashMap<Long, Thread> threadBuffer_ = new ConcurrentHashMap();
        static AtomicLong threadBufferId_ = new AtomicLong();
        private static volatile boolean ack = false;

        private JdwpWorker() {
        }

        static void touch() {
        }

        private static void jdwp_stays_suspended_in_this_method_as_a_worker() {
        }

        static void spawnThreadForJdwpToSuspend() {
            new Thread(JdwpWorker::jdwp_stays_suspended_in_this_method_as_a_worker, "luceedebug-worker").start();
        }

        static long jdwp_getThread(Thread thread) {
            long nextId = threadBufferId_.incrementAndGet();
            threadBuffer_.put(nextId, thread);
            return nextId;
        }

        static Thread jdwp_getThreadResult(long id) {
            Thread thread = threadBuffer_.get(id);
            threadBuffer_.remove(id);
            return thread;
        }

        static void spinWaitForJdwpBpToSuspendWorkerThread() {
            while (!ack) {
            }
        }

        static void notifyJdwpSuspendedWorkerThread() {
            ack = true;
        }
    }

    private static class JdwpStaticCallable {
        public final ClassType classType;
        public final Method method;

        public JdwpStaticCallable(ClassType classType, Method method) {
            this.classType = classType;
            this.method = method;
        }
    }

    private static class ThreadMap {
        private final Cleaner cleaner = Cleaner.create();
        private final ConcurrentHashMap<JdwpThreadID, WeakReference<Thread>> threadByJdwpId = new ConcurrentHashMap();
        private final ConcurrentWeakKeyMap<Thread, ThreadReference> threadRefByThread = new ConcurrentWeakKeyMap();

        private ThreadMap() {
        }

        public Thread getThreadByJdwpId(JdwpThreadID jdwpId) {
            WeakReference<Thread> weakRef = this.threadByJdwpId.get(jdwpId);
            if (weakRef == null) {
                return null;
            }
            return (Thread)weakRef.get();
        }

        private Thread getThreadByJdwpIdOrFail(JdwpThreadID id) {
            Thread thread = this.getThreadByJdwpId(id);
            if (thread != null) {
                return thread;
            }
            System.out.println("[luceedebug] couldn't find thread with id '" + String.valueOf(id) + "'");
            System.exit(1);
            return null;
        }

        public ThreadReference getThreadRefByThread(Thread thread) {
            return this.threadRefByThread.get(thread);
        }

        public ThreadReference getThreadRefByThreadOrFail(Thread thread) {
            ThreadReference result = this.getThreadRefByThread(thread);
            if (result != null) {
                return result;
            }
            System.out.println("[luceedebug] couldn't find thread reference for thread " + String.valueOf(thread));
            System.exit(1);
            return null;
        }

        public ThreadReference getThreadRefByJdwpIdOrFail(JdwpThreadID jdwpID) {
            return this.getThreadRefByThreadOrFail(this.getThreadByJdwpIdOrFail(jdwpID));
        }

        public void register(Thread thread, ThreadReference threadRef) {
            JdwpThreadID threadID = JdwpThreadID.of(threadRef);
            this.threadByJdwpId.put(threadID, new WeakReference<Thread>(thread));
            this.threadRefByThread.put(thread, threadRef);
            this.cleaner.register(thread, () -> this.threadByJdwpId.remove(threadID));
        }

        public void unregister(ThreadReference threadRef) {
            JdwpThreadID threadID = JdwpThreadID.of(threadRef);
            Thread thread = this.getThreadByJdwpId(threadID);
            this.threadByJdwpId.remove(threadID);
            if (thread != null) {
                this.threadRefByThread.remove(thread);
            }
        }
    }

    private static enum SteppingState {
        stepping,
        finalizingViaAwaitedBreakpoint;

    }

    private static class ReplayableCfBreakpointRequest {
        final RawIdePath ideAbsPath;
        final CanonicalServerAbsPath serverAbsPath;
        final int line;
        final DapBreakpointID id;
        final String expr;
        final BreakpointRequest maybeNull_jdwpBreakpointRequest;

        public boolean equals(Object vv) {
            if (!(vv instanceof ReplayableCfBreakpointRequest)) {
                return false;
            }
            ReplayableCfBreakpointRequest v = (ReplayableCfBreakpointRequest)vv;
            return this.ideAbsPath.equals(v.ideAbsPath) && this.serverAbsPath.equals(v.serverAbsPath) && this.line == v.line && this.id == v.id && (this.expr == null ? v.expr == null : this.expr.equals(v.expr));
        }

        ReplayableCfBreakpointRequest(RawIdePath ideAbsPath, CanonicalServerAbsPath serverAbsPath, int line, DapBreakpointID id, String expr) {
            this.ideAbsPath = ideAbsPath;
            this.serverAbsPath = serverAbsPath;
            this.line = line;
            this.id = id;
            this.expr = expr;
            this.maybeNull_jdwpBreakpointRequest = null;
        }

        ReplayableCfBreakpointRequest(RawIdePath ideAbsPath, CanonicalServerAbsPath serverAbsPath, int line, DapBreakpointID id, String expr, BreakpointRequest jdwpBreakpointRequest) {
            this.ideAbsPath = ideAbsPath;
            this.serverAbsPath = serverAbsPath;
            this.line = line;
            this.id = id;
            this.expr = expr;
            this.maybeNull_jdwpBreakpointRequest = jdwpBreakpointRequest;
        }

        static List<BreakpointRequest> getJdwpRequests(Collection<ReplayableCfBreakpointRequest> vs) {
            return vs.stream().filter(v -> v.maybeNull_jdwpBreakpointRequest != null).map(v -> v.maybeNull_jdwpBreakpointRequest).collect(Collectors.toList());
        }

        static BpLineAndId[] getLineInfo(Collection<ReplayableCfBreakpointRequest> vs) {
            return (BpLineAndId[])vs.stream().map(v -> new BpLineAndId(v.ideAbsPath, v.serverAbsPath, v.line, v.id, v.expr)).toArray(BpLineAndId[]::new);
        }
    }

    static class BpLineAndId {
        final RawIdePath ideAbsPath;
        final CanonicalServerAbsPath serverAbsPath;
        final int line;
        final DapBreakpointID id;
        final String expr;

        public BpLineAndId(RawIdePath ideAbsPath, CanonicalServerAbsPath serverAbsPath, int line, DapBreakpointID id, String expr) {
            this.ideAbsPath = ideAbsPath;
            this.serverAbsPath = serverAbsPath;
            this.line = line;
            this.id = id;
            this.expr = expr;
        }
    }
}

