/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import jakarta.servlet.ServletConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lucee.runtime.PageContext;
import lucee.runtime.engine.ThreadLocalPageContext;
import lucee.runtime.exp.PageException;
import lucee.runtime.functions.conversion.SerializeJSON;
import lucee.runtime.functions.dynamicEvaluation.Evaluate;
import lucee.runtime.functions.system.CFFunction;
import lucee.runtime.op.Caster;
import lucee.runtime.type.Collection;
import lucee.runtime.type.FunctionValueImpl;
import lucee.runtime.type.util.KeyConstants;
import lucee.runtime.util.PageContextUtil;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.DapServer;
import org.lucee.extension.debugger.Either;
import org.lucee.extension.debugger.GlobalIDebugManagerHolder;
import org.lucee.extension.debugger.ICfValueDebuggerBridge;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.IDebugManager;
import org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge;
import org.lucee.extension.debugger.coreinject.ExprEvaluator;
import org.lucee.extension.debugger.coreinject.LuceeVm;
import org.lucee.extension.debugger.coreinject.ValTracker;
import org.lucee.extension.debugger.coreinject.frame.DebugFrame;
import org.lucee.extension.debugger.coreinject.frame.Frame;

public class DebugManager
implements IDebugManager {
    private Config config_ = null;
    private final Cleaner cleaner = Cleaner.create();
    private final ConcurrentHashMap<Thread, ArrayList<DebugFrame>> cfStackByThread = new ConcurrentHashMap();
    private final ConcurrentHashMap<Thread, WeakReference<PageContext>> pageContextByThread = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, DebugFrame> frameByFrameID = new ConcurrentHashMap();
    private ValTracker valTracker = new ValTracker(this.cleaner);
    private IDebugManager.CfStepCallback didStepCallback = null;
    private ConcurrentHashMap<Thread, CfStepRequest> stepRequestByThread = new ConcurrentHashMap();
    private volatile boolean hasAnyStepRequests = false;

    public DebugManager() {
        if (GlobalIDebugManagerHolder.luceeCoreLoader == null) {
            System.out.println("[luceedebug] fatal - expected org.lucee.extension.debugger.coreinject.DebugManager to be loaded with the Lucee core loader, but the Lucee core loader hasn't been loaded yet.");
            System.exit(1);
        } else if (GlobalIDebugManagerHolder.luceeCoreLoader != this.getClass().getClassLoader()) {
            System.out.println("[luceedebug] fatal - expected org.lucee.extension.debugger.coreinject.DebugManager to be loaded with the Lucee core loader, but it is being loaded with classloader='" + String.valueOf(this.getClass().getClassLoader()) + "'.");
            System.out.println("[luceedebug]         lucee coreLoader has been seen, and is " + String.valueOf(GlobalIDebugManagerHolder.luceeCoreLoader));
            System.exit(1);
        }
    }

    @Override
    public void spawnWorker(Config config, String jdwpHost, int jdwpPort, String debugHost, int debugPort) {
        this.config_ = config;
        String threadName = "luceedebug-worker";
        System.out.println("[luceedebug] attempting jdwp self connect to jdwp on " + jdwpHost + ":" + jdwpPort + "...");
        VirtualMachine vm = DebugManager.jdwpSelfConnect(jdwpHost, jdwpPort);
        LuceeVm luceeVm = new LuceeVm(config, vm);
        new Thread(() -> {
            System.out.println("[luceedebug] jdwp self connect OK");
            try {
                DapServer.createForSocket(luceeVm, config, debugHost, debugPort);
            }
            catch (Throwable t) {
                System.out.println("[luceedebug] DAP server thread failed: " + t.getMessage());
                t.printStackTrace();
            }
        }, "luceedebug-worker").start();
    }

    private static AttachingConnector getConnector() {
        VirtualMachineManager vmm;
        try {
            vmm = Bootstrap.virtualMachineManager();
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage().contains("com/sun/jdi/Bootstrap")) {
                System.out.println("[luceedebug]");
                System.out.println("[luceedebug]");
                System.out.println("[luceedebug] couldn't load a com.sun.jdi.VirtualMachineManager; you might not be running the JDK version of your Java release");
                System.out.println("[luceedebug]");
                System.out.println("[luceedebug]");
            }
            throw e;
        }
        List<AttachingConnector> attachingConnectors = vmm.attachingConnectors();
        for (AttachingConnector c : attachingConnectors) {
            if (!c.name().equals("com.sun.jdi.SocketAttach")) continue;
            return c;
        }
        System.out.println("no socket attaching connector?");
        System.exit(1);
        return null;
    }

    private static VirtualMachine jdwpSelfConnect(String host, int port) {
        AttachingConnector connector = DebugManager.getConnector();
        Map<String, Connector.Argument> args = connector.defaultArguments();
        args.get("hostname").setValue(host);
        args.get("port").setValue(Integer.toString(port));
        try {
            return connector.attach(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private String wrapDumpInHtmlDoc(String s) {
        return "<!DOCTYPE html><html><body>" + s + "</body></html>";
    }

    @Override
    public synchronized String doDump(ArrayList<Thread> suspendedThreads, int variableID) {
        PageContext pageContext = this.maybeNull_findPageContext(suspendedThreads);
        if (pageContext == null) {
            StringBuilder msgBuilder = new StringBuilder();
            suspendedThreads.forEach(thread -> msgBuilder.append("<div>" + String.valueOf(thread) + "</div>"));
            return "<div>couldn't get a page context, iterated over threads:</div>" + msgBuilder.toString();
        }
        Either<Object, String> entity = this.findEntity(variableID);
        if (entity.isRight()) {
            return "<div>" + (String)entity.right + "</div>";
        }
        return this.doDump(pageContext, entity.left);
    }

    @Override
    public synchronized String doDumpAsJSON(ArrayList<Thread> suspendedThreads, int variableID) {
        PageContext pageContext = this.maybeNull_findPageContext(suspendedThreads);
        if (pageContext == null) {
            return "\"couldn't find a page context to do work on\"";
        }
        Either<Object, String> entity = this.findEntity(variableID);
        if (entity.isRight()) {
            return "\"" + ((String)entity.right).replace("\"", "\\\"") + "\"";
        }
        return this.doDumpAsJSON(pageContext, entity.left);
    }

    private synchronized Either<Object, String> findEntity(int variableID) {
        return Either.fromOpt(this.valTracker.maybeGetFromId(variableID)).bimap(taggedObj -> taggedObj.obj, v -> "Lookup of ref having ID " + variableID + " found nothing.");
    }

    private synchronized PageContext maybeNull_findPageContext(ArrayList<Thread> suspendedThreads) {
        WeakReference pageContextRef = ((Supplier<WeakReference>)() -> {
            for (Thread thread : suspendedThreads) {
                WeakReference<PageContext> pageContextRef_ = this.pageContextByThread.get(thread);
                if (pageContextRef_ == null) continue;
                return pageContextRef_;
            }
            return null;
        }).get();
        return pageContextRef == null ? null : (PageContext)pageContextRef.get();
    }

    private synchronized String doDump(PageContext pageContext, Object someDumpable) {
        var result;
        block2: {
            result = new Object(){
                String value = "if this text is present, something went wrong when calling writeDump(...)";
            };
            Thread thread = new Thread(() -> {
                try {
                    PageContextAndOutputStream ephemeralContext = PageContextAndOutputStream.ephemeralPageContextFromOther(pageContext);
                    PageContext freshEphemeralPageContext = ephemeralContext.pageContext;
                    ByteArrayOutputStream outputStream = ephemeralContext.outStream;
                    ThreadLocalPageContext.register((PageContext)freshEphemeralPageContext);
                    CFFunction.call((PageContext)freshEphemeralPageContext, (Object[])new Object[]{FunctionValueImpl.newInstance((Collection.Key)KeyConstants.___filename, (Object)"writeDump.cfm"), FunctionValueImpl.newInstance((Collection.Key)KeyConstants.___name, (Object)"writeDump"), FunctionValueImpl.newInstance((Collection.Key)KeyConstants.___isweb, (Object)Boolean.FALSE), FunctionValueImpl.newInstance((Collection.Key)KeyConstants.___mapping, (Object)"/mapping-function"), someDumpable});
                    freshEphemeralPageContext.flush();
                    result.value = this.wrapDumpInHtmlDoc(new String(outputStream.toByteArray(), "UTF-8"));
                    PageContextUtil.releasePageContext((PageContext)freshEphemeralPageContext, (boolean)true);
                    outputStream.close();
                    ThreadLocalPageContext.release();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Throwable e) {
                if (!thread.isAlive()) break block2;
                e.printStackTrace();
                System.exit(1);
            }
        }
        return result.value;
    }

    private synchronized String doDumpAsJSON(PageContext pageContext, Object someDumpable) {
        var result;
        block2: {
            result = new Object(){
                String value = "\"Something went wrong when calling serializeJSON(...)\"";
            };
            Thread thread = new Thread(() -> {
                try {
                    PageContextAndOutputStream ephemeralContext = PageContextAndOutputStream.ephemeralPageContextFromOther(pageContext);
                    PageContext freshEphemeralPageContext = ephemeralContext.pageContext;
                    ByteArrayOutputStream outputStream = ephemeralContext.outStream;
                    ThreadLocalPageContext.register((PageContext)freshEphemeralPageContext);
                    result.value = SerializeJSON.call((PageContext)freshEphemeralPageContext, (Object)someDumpable, (Object)"struct");
                    PageContextUtil.releasePageContext((PageContext)freshEphemeralPageContext, (boolean)true);
                    outputStream.close();
                    ThreadLocalPageContext.release();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Throwable e) {
                if (!thread.isAlive()) break block2;
                e.printStackTrace();
                System.exit(1);
            }
        }
        return result.value;
    }

    @Override
    public Either<String, Either<ICfValueDebuggerBridge, String>> evaluate(Long frameID, String expr) {
        DebugFrame zzzframe = this.frameByFrameID.get(frameID);
        if (!(zzzframe instanceof Frame)) {
            return Either.Left("<<no such frame>>");
        }
        Frame frame = (Frame)zzzframe;
        return this.doEvaluate(frame, expr).bimap(err -> err, ok -> {
            if (ok == null) {
                return Either.Right("null");
            }
            if (ok instanceof String) {
                return Either.Right("\"" + ((String)ok).replaceAll("\"", "\\\"") + "\"");
            }
            if (ok instanceof Number || ok instanceof Boolean) {
                return Either.Right(ok.toString());
            }
            return Either.Left(frame.trackEvalResult(ok));
        });
    }

    private Either<String, Object> doEvaluate(Frame frame, String expr) {
        try {
            return CompletableFuture.supplyAsync(() -> frame.getFrameContext().doWorkInThisFrame(() -> {
                try {
                    ThreadLocalPageContext.register((PageContext)frame.getFrameContext().pageContext);
                    Either<String, Object> either = ExprEvaluator.eval(frame, expr);
                    return either;
                }
                catch (Throwable e) {
                    Either either = Either.Left(e.getMessage());
                    return either;
                }
                finally {
                    ThreadLocalPageContext.release();
                }
            })).get(5L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            return Either.Left(e.getMessage());
        }
    }

    @Override
    public boolean evaluateAsBooleanForConditionalBreakpoint(Thread thread, String expr) {
        ArrayList<DebugFrame> stack = this.cfStackByThread.get(thread);
        if (stack == null) {
            return false;
        }
        try {
            if (stack.isEmpty()) {
                return false;
            }
            DebugFrame frame = stack.get(stack.size() - 1);
            if (frame instanceof Frame) {
                return this.doEvaluateAsBoolean((Frame)frame, expr);
            }
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("[luceedebug]: evaluateAsBooleanForConditionalBreakpoint oob stack read, returning `false`");
            return false;
        }
    }

    private boolean doEvaluateAsBoolean(Frame frame, String expr) {
        try {
            return CompletableFuture.supplyAsync(() -> frame.getFrameContext().doWorkInThisFrame(() -> {
                try {
                    ThreadLocalPageContext.register((PageContext)frame.getFrameContext().pageContext);
                    Object obj = Evaluate.call((PageContext)frame.getFrameContext().pageContext, (Object[])new String[]{expr});
                    Boolean bl = Caster.toBoolean((Object)obj);
                    return bl;
                }
                catch (PageException e) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    ThreadLocalPageContext.release();
                }
            })).get(5L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void registerCfStepHandler(IDebugManager.CfStepCallback cb) {
        this.didStepCallback = cb;
    }

    private void notifyStep(Thread thread, int minDistanceToLuceedebugStepNotificationEntryFrame) {
        if (this.didStepCallback != null) {
            this.didStepCallback.call(thread, minDistanceToLuceedebugStepNotificationEntryFrame + 1);
        }
    }

    @Override
    public synchronized IDebugEntity[] getScopesForFrame(long frameID) {
        DebugFrame frame = this.frameByFrameID.get(frameID);
        if (frame == null) {
            return new IDebugEntity[0];
        }
        return frame.getScopes();
    }

    @Override
    public synchronized IDebugEntity[] getVariables(long id, IDebugEntity.DebugEntityType maybeNull_which) {
        return this.valTracker.maybeGetFromId(id).map(taggedObj -> CfValueDebuggerBridge.getAsDebugEntity(this.valTracker, taggedObj.obj, maybeNull_which)).orElseGet(() -> new IDebugEntity[0]);
    }

    @Override
    public synchronized IDebugFrame[] getCfStack(Thread thread) {
        System.out.println("[luceedebug] getCfStack: looking for thread=" + thread.getName() + " (id=" + thread.getId() + ") identity=" + System.identityHashCode(thread));
        System.out.println("[luceedebug] getCfStack: cfStackByThread has " + this.cfStackByThread.size() + " entries:");
        for (Map.Entry<Thread, ArrayList<DebugFrame>> entry : this.cfStackByThread.entrySet()) {
            Thread t = entry.getKey();
            System.out.println("[luceedebug]   thread=" + t.getName() + " (id=" + t.getId() + ") identity=" + System.identityHashCode(t) + " frames=" + entry.getValue().size());
        }
        ArrayList<DebugFrame> stack = this.cfStackByThread.get(thread);
        if (stack == null || stack.isEmpty()) {
            System.out.println("[luceedebug] getCfStack: no instrumented frames for thread " + String.valueOf(thread));
            return new Frame[0];
        }
        ArrayList<DebugFrame> result = new ArrayList<DebugFrame>();
        result.ensureCapacity(stack.size());
        for (int i = stack.size() - 1; i >= 0; --i) {
            DebugFrame frame = stack.get(i);
            System.out.println("[luceedebug] getCfStack: frame[" + i + "] line=" + frame.getLine() + " source=" + frame.getSourceFilePath());
            if (frame.getLine() == 0) {
                System.out.println("[luceedebug] getCfStack: skipping frame with line=0");
                continue;
            }
            result.add(frame);
        }
        return result.toArray(new Frame[result.size()]);
    }

    @Override
    public void registerStepRequest(Thread thread, int type) {
        DebugFrame frame = this.getTopmostFrame(thread);
        if (frame == null) {
            System.out.println("[luceedebug] registerStepRequest found no frames");
            System.exit(1);
            return;
        }
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                this.stepRequestByThread.put(thread, new CfStepRequest(frame.getDepth(), type));
                this.hasAnyStepRequests = true;
                return;
            }
        }
        System.out.println("[luceedebug] bad step type");
        System.exit(1);
    }

    @Override
    public void clearStepRequest(Thread thread) {
        this.stepRequestByThread.remove(thread);
        this.hasAnyStepRequests = !this.stepRequestByThread.isEmpty();
    }

    @Override
    public void luceedebug_stepNotificationEntry_step(int lineNumber) {
        Thread currentThread = Thread.currentThread();
        DebugFrame frame = this.maybeUpdateTopmostFrame(currentThread, lineNumber);
        if (!this.hasAnyStepRequests) {
            return;
        }
        boolean minDistanceToLuceedebugStepNotificationEntryFrame = false;
        CfStepRequest request = this.stepRequestByThread.get(currentThread);
        if (request == null) {
            return;
        }
        if (frame instanceof Frame) {
            ++request.__debug__steps;
            this.maybeNotifyOfStepCompletion(currentThread, (Frame)frame, request, 1, System.nanoTime());
        }
    }

    @Override
    public void luceedebug_stepNotificationEntry_stepAfterCompletedUdfCall() {
        if (!this.hasAnyStepRequests) {
            return;
        }
        boolean minDistanceToLuceedebugStepNotificationEntryFrame = false;
        Thread currentThread = Thread.currentThread();
        DebugFrame frame = this.getTopmostFrame(currentThread);
        if (frame == null) {
            return;
        }
        CfStepRequest request = this.stepRequestByThread.get(currentThread);
        if (request == null) {
            return;
        }
        if (frame instanceof Frame) {
            ++request.__debug__steps;
            this.maybeNotifyOfStepCompletion(currentThread, (Frame)frame, request, 1, System.nanoTime());
        }
    }

    private void maybeNotifyOfStepCompletion(Thread currentThread, Frame frame, CfStepRequest request, int minDistanceToLuceedebugStepNotificationEntryFrame, long start) {
        if (frame.isUdfDefaultValueInitFrame && !this.config_.getStepIntoUdfDefaultValueInitFrames()) {
            return;
        }
        if (request.type == 0) {
            this.clearStepRequest(currentThread);
            this.notifyStep(currentThread, minDistanceToLuceedebugStepNotificationEntryFrame + 1);
        } else if (request.type == 1) {
            if (frame.getDepth() > request.startDepth) {
                long end = System.nanoTime();
                request.__debug__stepOverhead += end - start;
                return;
            }
            this.clearStepRequest(currentThread);
            this.notifyStep(currentThread, minDistanceToLuceedebugStepNotificationEntryFrame + 1);
        } else if (request.type == 2) {
            if (frame.getDepth() >= request.startDepth) {
                return;
            }
            this.clearStepRequest(currentThread);
            this.notifyStep(currentThread, minDistanceToLuceedebugStepNotificationEntryFrame + 1);
        }
    }

    private DebugFrame maybeUpdateTopmostFrame(Thread thread, int lineNumber) {
        DebugFrame frame = this.getTopmostFrame(thread);
        if (frame == null) {
            return null;
        }
        frame.setLine(lineNumber);
        return frame;
    }

    private DebugFrame getTopmostFrame(Thread thread) {
        ArrayList<DebugFrame> stack = this.cfStackByThread.get(thread);
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.get(stack.size() - 1);
    }

    @Override
    public void pushCfFrame(PageContext pageContext, String sourceFilePath) {
        Thread t = Thread.currentThread();
        System.out.println("[luceedebug] pushCfFrame: thread=" + t.getName() + " (id=" + t.getId() + ") identity=" + System.identityHashCode(t) + " file=" + sourceFilePath);
        this.maybe_pushCfFrame_worker(pageContext, sourceFilePath);
    }

    private DebugFrame maybe_pushCfFrame_worker(PageContext pageContext, String sourceFilePath) {
        Thread currentThread = Thread.currentThread();
        ArrayList<DebugFrame> stack = this.cfStackByThread.get(currentThread);
        if (stack == null || stack.size() == 0) {
            ArrayList list = new ArrayList();
            this.cfStackByThread.put(currentThread, list);
            stack = list;
            this.pageContextByThread.put(currentThread, new WeakReference<PageContext>(pageContext));
        }
        int depth = stack.size();
        Frame.FrameContext maybeBaseFrame = stack.size() == 0 ? null : (stack.get(0) instanceof Frame ? ((Frame)stack.get(0)).getFrameContext() : null);
        DebugFrame frame = DebugFrame.makeFrame(sourceFilePath, depth, this.valTracker, pageContext, maybeBaseFrame);
        stack.add(frame);
        this.frameByFrameID.put(frame.getId(), frame);
        return frame;
    }

    @Override
    public void pushCfFunctionDefaultValueInitializationFrame(PageContext pageContext, String sourceFilePath) {
        DebugFrame frame = this.maybe_pushCfFrame_worker(pageContext, sourceFilePath);
        if (frame instanceof Frame) {
            ((Frame)frame).isUdfDefaultValueInitFrame = true;
        }
    }

    @Override
    public void popCfFrame() {
        Thread currentThread = Thread.currentThread();
        ArrayList<DebugFrame> maybeNull_frameListing = this.cfStackByThread.get(currentThread);
        if (maybeNull_frameListing == null) {
            return;
        }
        DebugFrame poppedFrame = null;
        if (maybeNull_frameListing.isEmpty()) {
            System.out.println("Popping from an empty stack?");
            System.exit(1);
        } else {
            poppedFrame = maybeNull_frameListing.remove(maybeNull_frameListing.size() - 1);
            this.frameByFrameID.remove(poppedFrame.getId());
        }
        if (maybeNull_frameListing.size() == 0) {
            this.cfStackByThread.remove(currentThread);
            this.pageContextByThread.remove(currentThread);
        }
    }

    @Override
    public String getSourcePathForVariablesRef(int variablesRef) {
        return this.valTracker.maybeGetFromId(variablesRef).map(taggedObj -> CfValueDebuggerBridge.getSourcePath(taggedObj.obj)).orElseGet(() -> null);
    }

    static class CfStepRequest {
        static final int STEP_INTO = 0;
        static final int STEP_OVER = 1;
        static final int STEP_OUT = 2;
        final long __debug__startTime = System.nanoTime();
        long __debug__stepOverhead = 0L;
        int __debug__steps = 0;
        final int startDepth;
        final int type;

        CfStepRequest(int startDepth, int type) {
            this.startDepth = startDepth;
            this.type = type;
        }

        public String toString() {
            String s_type = this.type == 0 ? "into" : (this.type == 1 ? "over" : "out");
            return "(stepRequest // startDepth=" + this.startDepth + " type=" + s_type + ")";
        }
    }

    public static class PageContextAndOutputStream {
        public final PageContext pageContext;
        public final ByteArrayOutputStream outStream;

        public PageContextAndOutputStream(PageContext pageContext, ByteArrayOutputStream outStream) {
            this.pageContext = pageContext;
            this.outStream = outStream;
        }

        public static PageContextAndOutputStream ephemeralPageContextFromOther(PageContext pc) throws Exception {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PageContext freshEphemeralPageContext = PageContextUtil.getPageContext((lucee.runtime.config.Config)pc.getConfig(), (ServletConfig)pc.getServletConfig(), (File)new File("."), (String)"", (String)"", (String)"", null, new HashMap(), new HashMap(), new HashMap(), (OutputStream)outputStream, (boolean)false, (long)99999L, (boolean)true);
            return new PageContextAndOutputStream(freshEphemeralPageContext, outputStream);
        }
    }
}

