/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger.coreinject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lucee.runtime.Component;
import lucee.runtime.type.Array;
import org.lucee.extension.debugger.ICfValueDebuggerBridge;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.coreinject.ComponentScopeMarkerTraitShim;
import org.lucee.extension.debugger.coreinject.DebugEntity;
import org.lucee.extension.debugger.coreinject.ValTracker;
import org.lucee.extension.debugger.coreinject.frame.Frame;
import org.lucee.extension.debugger.util.ExpiringLruCache;

public class CfValueDebuggerBridge
implements ICfValueDebuggerBridge {
    private static final ExpiringLruCache<Integer, Object> pinnedObjects = new ExpiringLruCache(50, 10L, TimeUnit.MINUTES);
    private final Frame frame;
    private final ValTracker valTracker;
    public final Object obj;
    public final long id;
    private static Comparator<IDebugEntity> xscopeByName = Comparator.comparing(v -> v.getName().toLowerCase());

    public static void pin(Object obj) {
        pinnedObjects.put(System.identityHashCode(obj), obj);
    }

    public CfValueDebuggerBridge(Frame frame, Object obj) {
        this.frame = Objects.requireNonNull(frame);
        this.valTracker = frame.valTracker;
        this.obj = Objects.requireNonNull(obj);
        this.id = frame.valTracker.idempotentRegisterObject((Object)obj).id;
    }

    public CfValueDebuggerBridge(ValTracker valTracker, Object obj) {
        this.frame = null;
        this.valTracker = Objects.requireNonNull(valTracker);
        this.obj = Objects.requireNonNull(obj);
        this.id = valTracker.idempotentRegisterObject((Object)obj).id;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public static IDebugEntity[] getAsDebugEntity(Frame frame, Object obj, IDebugEntity.DebugEntityType maybeNull_which) {
        return CfValueDebuggerBridge.getAsDebugEntity(frame.valTracker, obj, maybeNull_which, null);
    }

    public static IDebugEntity[] getAsDebugEntity(ValTracker valTracker, Object obj, IDebugEntity.DebugEntityType maybeNull_which) {
        return CfValueDebuggerBridge.getAsDebugEntity(valTracker, obj, maybeNull_which, null);
    }

    public static IDebugEntity[] getAsDebugEntity(ValTracker valTracker, Object obj, IDebugEntity.DebugEntityType maybeNull_which, String parentPath) {
        return CfValueDebuggerBridge.getAsDebugEntity(valTracker, obj, maybeNull_which, parentPath, null);
    }

    public static IDebugEntity[] getAsDebugEntity(ValTracker valTracker, Object obj, IDebugEntity.DebugEntityType maybeNull_which, String parentPath, Long frameId) {
        boolean indexedOK;
        boolean namedOK = maybeNull_which == null || maybeNull_which == IDebugEntity.DebugEntityType.NAMED;
        boolean bl = indexedOK = maybeNull_which == null || maybeNull_which == IDebugEntity.DebugEntityType.INDEXED;
        if (obj instanceof MarkerTrait.Scope && namedOK) {
            Map<String, Object> m = ((MarkerTrait.Scope)obj).scopelike;
            return CfValueDebuggerBridge.getAsMaplike(valTracker, m, parentPath, frameId);
        }
        if (obj instanceof Map && namedOK) {
            if (obj instanceof Component) {
                return new IDebugEntity[]{CfValueDebuggerBridge.maybeNull_asValue(valTracker, "this", obj, true, true, parentPath, frameId), CfValueDebuggerBridge.maybeNull_asValue(valTracker, "variables", ((Component)obj).getComponentScope(), parentPath, frameId), CfValueDebuggerBridge.maybeNull_asValue(valTracker, "static", ((Component)obj).staticScope(), parentPath, frameId)};
            }
            Map m = (Map)obj;
            return CfValueDebuggerBridge.getAsMaplike(valTracker, m, parentPath, frameId);
        }
        if (obj instanceof Array && indexedOK) {
            return CfValueDebuggerBridge.getAsCfArray(valTracker, (Array)obj, parentPath, frameId);
        }
        return new IDebugEntity[0];
    }

    private static boolean isNoisyComponentFunction(Object obj) {
        String className = obj.getClass().getName();
        boolean isNoisyUdf = className.equals("lucee.runtime.type.UDFGetterProperty") || className.equals("lucee.runtime.type.UDFSetterProperty") || className.equals("lucee.runtime.type.UDFImpl");
        boolean isLambdaOrClosure = className.equals("lucee.runtime.type.Lambda") || className.equals("lucee.runtime.type.Closure");
        return isNoisyUdf && !isLambdaOrClosure;
    }

    private static boolean isInstanceOf(Object obj, String className) {
        if (obj == null) {
            return false;
        }
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (clazz.getName().equals(className)) {
                return true;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!iface.getName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    private static IDebugEntity[] getAsMaplike(ValTracker valTracker, Map<String, Object> map, String parentPath, Long frameId) {
        ArrayList<IDebugEntity> results = new ArrayList<IDebugEntity>();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        boolean skipNoisyComponentFunctions = true;
        for (Map.Entry<String, Object> entry : entries) {
            IDebugEntity val = CfValueDebuggerBridge.maybeNull_asValue(valTracker, entry.getKey(), entry.getValue(), true, false, parentPath, frameId);
            if (val == null) continue;
            results.add(val);
        }
        results.sort(xscopeByName);
        return results.toArray(new IDebugEntity[results.size()]);
    }

    private static IDebugEntity[] getAsCfArray(ValTracker valTracker, Array array, String parentPath, Long frameId) {
        ArrayList<IDebugEntity> result = new ArrayList<IDebugEntity>();
        for (int i = 1; i <= array.size(); ++i) {
            IDebugEntity val = CfValueDebuggerBridge.maybeNull_asValue(valTracker, Integer.toString(i), array.get(i, null), parentPath, frameId);
            if (val == null) continue;
            result.add(val);
        }
        return result.toArray(new IDebugEntity[result.size()]);
    }

    @Override
    public IDebugEntity maybeNull_asValue(String name) {
        return CfValueDebuggerBridge.maybeNull_asValue(this.valTracker, name, this.obj, true, false, null, null);
    }

    private static IDebugEntity maybeNull_asValue(ValTracker valTracker, String name, Object obj, String parentPath, Long frameId) {
        return CfValueDebuggerBridge.maybeNull_asValue(valTracker, name, obj, true, false, parentPath, frameId);
    }

    private static IDebugEntity maybeNull_asValue(ValTracker valTracker, String name, Object obj, boolean skipNoisyComponentFunctions, boolean treatDiscoveredComponentsAsScopes, String parentPath, Long frameId) {
        String childPath = parentPath != null ? parentPath + "." + name : null;
        DebugEntity val = new DebugEntity();
        val.name = name;
        if (obj == null) {
            val.value = "<<java-null>>";
        } else if (obj instanceof String) {
            val.value = "\"" + String.valueOf(obj) + "\"";
        } else if (obj instanceof Number) {
            val.value = obj.toString();
        } else if (obj instanceof Boolean) {
            val.value = obj.toString();
        } else if (obj instanceof Date) {
            val.value = obj.toString();
        } else if (obj instanceof Array) {
            int len = ((Array)obj).size();
            val.value = "Array (" + len + ")";
            val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)obj, (String)childPath, (Long)frameId).id;
        } else {
            if (skipNoisyComponentFunctions && CfValueDebuggerBridge.isNoisyComponentFunction(obj)) {
                return null;
            }
            if (CfValueDebuggerBridge.isInstanceOf(obj, "lucee.runtime.type.QueryImpl")) {
                try {
                    Method toQueryArrayMethod = Class.forName("lucee.runtime.type.query.QueryArray", true, obj.getClass().getClassLoader()).getMethod("toQueryArray", Class.forName("lucee.runtime.type.QueryImpl", true, obj.getClass().getClassLoader()));
                    Object queryAsArrayOfStructs = toQueryArrayMethod.invoke(null, obj);
                    Method sizeMethod = queryAsArrayOfStructs.getClass().getMethod("size", new Class[0]);
                    int size = (Integer)sizeMethod.invoke(queryAsArrayOfStructs, new Object[0]);
                    val.value = "Query (" + size + " rows)";
                    CfValueDebuggerBridge.pin(queryAsArrayOfStructs);
                    val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)queryAsArrayOfStructs, (String)childPath, (Long)frameId).id;
                }
                catch (Throwable e) {
                    try {
                        val.value = obj.getClass().toString();
                        val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)obj, (String)childPath, (Long)frameId).id;
                    }
                    catch (Throwable x) {
                        val.value = "<?> (no string representation available)";
                        val.variablesReference = 0L;
                    }
                }
            } else if (obj instanceof Map) {
                if (obj instanceof Component) {
                    val.value = "cfc<" + ((Component)obj).getName() + ">";
                    if (treatDiscoveredComponentsAsScopes) {
                        MarkerTrait.Scope v = new MarkerTrait.Scope((Map<?, ?>)((Component)obj));
                        ((ComponentScopeMarkerTraitShim)obj).__luceedebug__pinComponentScopeMarkerTrait(v);
                        val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)v, (String)childPath, (Long)frameId).id;
                    } else {
                        val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)obj, (String)childPath, (Long)frameId).id;
                    }
                } else {
                    int len = ((Map)obj).size();
                    val.value = "{} (" + len + " members)";
                    val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)obj, (String)childPath, (Long)frameId).id;
                }
            } else {
                try {
                    val.value = obj.getClass().toString();
                    val.variablesReference = valTracker.registerObjectWithPathAndFrameId((Object)obj, (String)childPath, (Long)frameId).id;
                }
                catch (Throwable x) {
                    val.value = "<?> (no string representation available)";
                    val.variablesReference = 0L;
                }
            }
        }
        return val;
    }

    @Override
    public int getNamedVariablesCount() {
        if (this.obj instanceof Map) {
            return ((Map)this.obj).size();
        }
        return 0;
    }

    @Override
    public int getIndexedVariablesCount() {
        if (CfValueDebuggerBridge.isInstanceOf(this.obj, "lucee.runtime.type.scope.Argument")) {
            return 0;
        }
        if (this.obj instanceof Array) {
            return ((Array)this.obj).size();
        }
        return 0;
    }

    public static String getSourcePath(Object obj) {
        if (obj instanceof Component) {
            return ((Component)obj).getPageSource().getPhyscalFile().getAbsolutePath();
        }
        if (CfValueDebuggerBridge.isInstanceOf(obj, "lucee.runtime.type.UDFImpl")) {
            try {
                Field propsField = obj.getClass().getField("properties");
                Object props = propsField.get(obj);
                Method getPageSourceMethod = props.getClass().getMethod("getPageSource", new Class[0]);
                Object pageSource = getPageSourceMethod.invoke(props, new Object[0]);
                Method getPhyscalFileMethod = pageSource.getClass().getMethod("getPhyscalFile", new Class[0]);
                Object file = getPhyscalFileMethod.invoke(pageSource, new Object[0]);
                Method getAbsolutePathMethod = file.getClass().getMethod("getAbsolutePath", new Class[0]);
                return (String)getAbsolutePathMethod.invoke(file, new Object[0]);
            }
            catch (Throwable e) {
                return null;
            }
        }
        if (CfValueDebuggerBridge.isInstanceOf(obj, "lucee.runtime.type.UDFGSProperty")) {
            try {
                Method getPageSourceMethod = obj.getClass().getMethod("getPageSource", new Class[0]);
                Object pageSource = getPageSourceMethod.invoke(obj, new Object[0]);
                Method getPhyscalFileMethod = pageSource.getClass().getMethod("getPhyscalFile", new Class[0]);
                Object file = getPhyscalFileMethod.invoke(pageSource, new Object[0]);
                Method getAbsolutePathMethod = file.getClass().getMethod("getAbsolutePath", new Class[0]);
                return (String)getAbsolutePathMethod.invoke(file, new Object[0]);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static class MarkerTrait {

        public static class Scope {
            public final Map<?, ?> scopelike;

            public Scope(Map<?, ?> scopelike) {
                this.scopelike = scopelike;
            }
        }
    }
}

