/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.lucee.extension.debugger.Either;
import org.lucee.extension.debugger.IBreakpoint;
import org.lucee.extension.debugger.ICfValueDebuggerBridge;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.ThreadInfo;
import org.lucee.extension.debugger.shaded.lsp4j.debug.CompletionItem;
import org.lucee.extension.debugger.strong.CanonicalServerAbsPath;
import org.lucee.extension.debugger.strong.DapBreakpointID;
import org.lucee.extension.debugger.strong.RawIdePath;

public interface ILuceeVm {
    public void registerStepEventCallback(Consumer<Long> var1);

    public void registerBreakpointEventCallback(BiConsumer<Long, DapBreakpointID> var1);

    public void registerNativeBreakpointEventCallback(BiConsumer<Long, String> var1);

    public void registerBreakpointsChangedCallback(Consumer<BreakpointsChangedEvent> var1);

    public ThreadInfo[] getThreadListing();

    public IDebugFrame[] getStackTrace(long var1);

    public IDebugEntity[] getScopes(long var1);

    public IDebugEntity[] getVariables(long var1);

    public IDebugEntity[] getNamedVariables(long var1);

    public IDebugEntity[] getIndexedVariables(long var1);

    public IBreakpoint[] bindBreakpoints(RawIdePath var1, CanonicalServerAbsPath var2, int[] var3, String[] var4);

    public void continue_(long var1);

    public void continueAll();

    public void stepIn(long var1);

    public void stepOver(long var1);

    public void stepOut(long var1);

    public void pause(long var1);

    public void clearAllBreakpoints();

    public String dump(int var1);

    public String dumpAsJSON(int var1);

    public String getMetadata(int var1);

    public String getApplicationSettings();

    public CompletionItem[] getCompletions(int var1, String var2);

    public String[] getTrackedCanonicalFileNames();

    public String[][] getBreakpointDetail();

    public String getSourcePathForVariablesRef(int var1);

    public Either<String, Either<ICfValueDebuggerBridge, String>> evaluate(int var1, String var2);

    public Either<String, Either<ICfValueDebuggerBridge, String>> setVariable(long var1, String var3, String var4, long var5);

    public void registerExceptionEventCallback(Consumer<Long> var1);

    public void registerPauseEventCallback(Consumer<Long> var1);

    public Throwable getExceptionForThread(long var1);

    public static class BreakpointsChangedEvent {
        IBreakpoint[] newBreakpoints = new IBreakpoint[0];
        IBreakpoint[] changedBreakpoints = new IBreakpoint[0];
        int[] deletedBreakpointIDs = new int[0];

        public static BreakpointsChangedEvent justChanges(IBreakpoint[] changes) {
            BreakpointsChangedEvent result = new BreakpointsChangedEvent();
            result.changedBreakpoints = changes;
            return result;
        }
    }
}

