/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.lang.reflect.Method;
import org.lucee.extension.debugger.Log;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String getFirstCfmlLocation(Throwable ex) {
        String tagContextLocation = ExceptionUtil.getFirstTagContextLocation(ex);
        if (tagContextLocation != null) {
            return tagContextLocation;
        }
        for (StackTraceElement ste : ex.getStackTrace()) {
            if (!ste.getClassName().endsWith("$cf")) continue;
            return ste.getFileName() + ":" + ste.getLineNumber();
        }
        return null;
    }

    public static String getCfmlStackTrace(Throwable ex) {
        try {
            ClassLoader loader = ex.getClass().getClassLoader();
            Class<?> tlpcClass = loader.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
            Method getConfig = tlpcClass.getMethod("getConfig", new Class[0]);
            Object config = getConfig.invoke(null, new Object[0]);
            if (config == null) {
                return null;
            }
            Class<?> configClass = loader.loadClass("lucee.runtime.config.Config");
            Method getTagContext = ex.getClass().getMethod("getTagContext", configClass);
            Object tagContext = getTagContext.invoke((Object)ex, config);
            if (tagContext == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            Method size = tagContext.getClass().getMethod("size", new Class[0]);
            Method getE = tagContext.getClass().getMethod("getE", Integer.TYPE);
            int len = (Integer)size.invoke(tagContext, new Object[0]);
            Class<?> keyImplClass = loader.loadClass("lucee.runtime.type.KeyImpl");
            Method keyInit = keyImplClass.getMethod("init", String.class);
            Object templateKey = keyInit.invoke(null, "template");
            Object lineKey = keyInit.invoke(null, "line");
            Class<?> keyClass = loader.loadClass("lucee.runtime.type.Collection$Key");
            for (int i = 1; i <= len; ++i) {
                Object item = getE.invoke(tagContext, i);
                Method get = item.getClass().getMethod("get", keyClass, Object.class);
                String template = (String)get.invoke(item, templateKey, "");
                Object lineObj = get.invoke(item, lineKey, 0);
                int line = lineObj instanceof Number ? ((Number)lineObj).intValue() : 0;
                sb.append(template).append(":").append(line).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            Log.debug("getCfmlStackTrace failed: " + e.getMessage());
            return null;
        }
    }

    private static String getFirstTagContextLocation(Throwable ex) {
        try {
            ClassLoader loader = ex.getClass().getClassLoader();
            Class<?> tlpcClass = loader.loadClass("lucee.runtime.engine.ThreadLocalPageContext");
            Method getConfig = tlpcClass.getMethod("getConfig", new Class[0]);
            Object config = getConfig.invoke(null, new Object[0]);
            if (config == null) {
                return null;
            }
            Class<?> configClass = loader.loadClass("lucee.runtime.config.Config");
            Method getTagContext = ex.getClass().getMethod("getTagContext", configClass);
            Object tagContext = getTagContext.invoke((Object)ex, config);
            if (tagContext == null) {
                return null;
            }
            Method size = tagContext.getClass().getMethod("size", new Class[0]);
            int len = (Integer)size.invoke(tagContext, new Object[0]);
            if (len == 0) {
                return null;
            }
            Method getE = tagContext.getClass().getMethod("getE", Integer.TYPE);
            Object item = getE.invoke(tagContext, 1);
            Class<?> keyImplClass = loader.loadClass("lucee.runtime.type.KeyImpl");
            Method keyInit = keyImplClass.getMethod("init", String.class);
            Object templateKey = keyInit.invoke(null, "template");
            Object lineKey = keyInit.invoke(null, "line");
            Class<?> keyClass = loader.loadClass("lucee.runtime.type.Collection$Key");
            Method get = item.getClass().getMethod("get", keyClass, Object.class);
            String template = (String)get.invoke(item, templateKey, "");
            Object lineObj = get.invoke(item, lineKey, 0);
            int line = lineObj instanceof Number ? ((Number)lineObj).intValue() : 0;
            return template + ":" + line;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCfmlStackTraceOrFallback(Throwable ex) {
        String stackTrace = ExceptionUtil.getCfmlStackTrace(ex);
        if (stackTrace != null && !stackTrace.isEmpty()) {
            return stackTrace;
        }
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : ex.getStackTrace()) {
            if (!ste.getClassName().endsWith("$cf")) continue;
            sb.append(ste.getFileName()).append(":").append(ste.getLineNumber()).append("\n");
        }
        return sb.toString();
    }

    public static String getDetail(Throwable ex) {
        try {
            Method getDetail = ex.getClass().getMethod("getDetail", new Class[0]);
            return (String)getDetail.invoke((Object)ex, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

