/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.lang.reflect.Field;

public final class EnvUtil {
    private EnvUtil() {
    }

    public static String getSystemPropOrEnvVar(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        String envName = propertyName.toUpperCase().replace('.', '_');
        return System.getenv(envName);
    }

    public static String getDebuggerSecret() {
        String secret = EnvUtil.getSystemPropOrEnvVar("lucee.dap.secret");
        if (secret != null && !secret.trim().isEmpty()) {
            return secret.trim();
        }
        return null;
    }

    public static boolean isDebuggerEnabled() {
        try {
            Class<?> configImpl = Class.forName("lucee.runtime.config.ConfigImpl");
            Field field = configImpl.getField("DEBUGGER");
            return (Boolean)field.get(null);
        }
        catch (Exception e) {
            if (EnvUtil.getDebuggerSecret() == null) {
                return false;
            }
            String bp = EnvUtil.getSystemPropOrEnvVar("lucee.dap.breakpoint");
            return bp == null || "true".equalsIgnoreCase(bp.trim());
        }
    }

    public static int getDebuggerPort() {
        if (EnvUtil.getDebuggerSecret() == null) {
            return -1;
        }
        String port = EnvUtil.getSystemPropOrEnvVar("lucee.dap.port");
        if (port == null || port.isEmpty()) {
            return 10000;
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return 10000;
        }
    }
}

