/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.util.Optional;
import java.util.function.Function;

public class Either<L, R> {
    private final Which which;
    public final L left;
    public final R right;

    private Either(Which which, L L, R R) {
        if (which == Which.left) {
            this.which = which;
            this.left = L;
            this.right = null;
        } else if (which == Which.right) {
            this.which = which;
            this.left = null;
            this.right = R;
        } else {
            assert (false) : "unreachable";
            throw new RuntimeException("unreachable");
        }
    }

    public static <L, R> Either<L, R> Left(L v) {
        return new Either<L, Object>(Which.left, v, null);
    }

    public static <L, R> Either<L, R> Right(R v) {
        return new Either<Object, R>(Which.right, null, v);
    }

    public static <T> Either<T, Void> fromOpt(Optional<T> opt) {
        return opt.isPresent() ? Either.Left(opt.get()) : Either.Right(null);
    }

    public boolean isLeft() {
        return this.which == Which.left;
    }

    public L getLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.which == Which.right;
    }

    public R getRight() {
        return this.right;
    }

    public <L2, R2> Either<L2, R2> bimap(Function<L, L2> l, Function<R, R2> r) {
        return this.isLeft() ? Either.Left(l.apply(this.getLeft())) : Either.Right(r.apply(this.getRight()));
    }

    public <Result> Result collapse(Function<L, Result> l, Function<R, Result> r) {
        return this.isLeft() ? l.apply(this.getLeft()) : r.apply(this.getRight());
    }

    private static enum Which {
        left,
        right;

    }
}

