/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lucee.Info;
import lucee.loader.engine.CFMLEngineFactory;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.EnvUtil;
import org.lucee.extension.debugger.ExceptionUtil;
import org.lucee.extension.debugger.IBreakpoint;
import org.lucee.extension.debugger.IDebugEntity;
import org.lucee.extension.debugger.IDebugFrame;
import org.lucee.extension.debugger.ILuceeVm;
import org.lucee.extension.debugger.IPathTransform;
import org.lucee.extension.debugger.Log;
import org.lucee.extension.debugger.PrefixPathTransform;
import org.lucee.extension.debugger.ThreadInfo;
import org.lucee.extension.debugger.coreinject.NativeDebuggerListener;
import org.lucee.extension.debugger.coreinject.NativeLuceeVm;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Breakpoint;
import org.lucee.extension.debugger.shaded.lsp4j.debug.BreakpointEventArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.BreakpointLocation;
import org.lucee.extension.debugger.shaded.lsp4j.debug.BreakpointLocationsArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.BreakpointLocationsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Capabilities;
import org.lucee.extension.debugger.shaded.lsp4j.debug.CompletionItem;
import org.lucee.extension.debugger.shaded.lsp4j.debug.CompletionsArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.CompletionsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ConfigurationDoneArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ContinueArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ContinueResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.DisconnectArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.EvaluateArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.EvaluateResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ExceptionBreakMode;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ExceptionBreakpointsFilter;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ExceptionDetails;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ExceptionInfoArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ExceptionInfoResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.FunctionBreakpoint;
import org.lucee.extension.debugger.shaded.lsp4j.debug.InitializeRequestArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.NextArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.PauseArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Scope;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ScopesArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ScopesResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetBreakpointsArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetBreakpointsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetFunctionBreakpointsArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetFunctionBreakpointsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetVariableArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SetVariableResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Source;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SourceArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.SourceResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StackFrame;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StackTraceArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StackTraceResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StepInArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StepOutArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.StoppedEventArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Thread;
import org.lucee.extension.debugger.shaded.lsp4j.debug.ThreadsResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.Variable;
import org.lucee.extension.debugger.shaded.lsp4j.debug.VariablesArguments;
import org.lucee.extension.debugger.shaded.lsp4j.debug.VariablesArgumentsFilter;
import org.lucee.extension.debugger.shaded.lsp4j.debug.VariablesResponse;
import org.lucee.extension.debugger.shaded.lsp4j.debug.launch.DSPLauncher;
import org.lucee.extension.debugger.shaded.lsp4j.debug.services.IDebugProtocolClient;
import org.lucee.extension.debugger.shaded.lsp4j.debug.services.IDebugProtocolServer;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.Launcher;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.ResponseErrorException;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.messages.ResponseError;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.services.JsonRequest;
import org.lucee.extension.debugger.shaded.lsp4j.jsonrpc.util.ToStringBuilder;
import org.lucee.extension.debugger.strong.CanonicalServerAbsPath;
import org.lucee.extension.debugger.strong.RawIdePath;

public class DapServer
implements IDebugProtocolServer {
    private final ILuceeVm luceeVm_;
    private final Config config_;
    private ArrayList<IPathTransform> pathTransforms = new ArrayList();
    private boolean evaluationEnabled = true;
    private static final Logger logger = Logger.getLogger("luceedebug");
    private static volatile ServerSocket activeServerSocket;
    private static final String SOCKET_PROPERTY = "luceedebug.dap.serverSocket";
    private IDebugProtocolClient clientProxy_;
    private boolean secretValidated = false;
    static final Pattern threadNamePrefixAndDigitSuffix;
    private static AtomicLong anonymousID;

    private String applyPathTransformsIdeToCf(String s) {
        for (IPathTransform transform : this.pathTransforms) {
            Optional<String> result = transform.ideToServer(s);
            if (!result.isPresent()) continue;
            return Config.canonicalizeFileName(result.get());
        }
        return Config.canonicalizeFileName(s);
    }

    private String applyPathTransformsServerToIde(String s) {
        for (IPathTransform transform : this.pathTransforms) {
            Optional<String> result = transform.serverToIde(s);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return s;
    }

    private DapServer(ILuceeVm luceeVm, Config config) {
        this.luceeVm_ = luceeVm;
        this.config_ = config;
        this.luceeVm_.registerStepEventCallback(threadID -> {
            int i32_threadID = (int)threadID.longValue();
            StoppedEventArguments event = new StoppedEventArguments();
            event.setReason("step");
            event.setThreadId(i32_threadID);
            this.clientProxy_.stopped(event);
        });
        this.luceeVm_.registerBreakpointEventCallback((threadID, bpID) -> {
            int i32_threadID = (int)threadID.longValue();
            StoppedEventArguments event = new StoppedEventArguments();
            event.setReason("breakpoint");
            event.setThreadId(i32_threadID);
            event.setHitBreakpointIds(new Integer[]{(Integer)bpID.get()});
            this.clientProxy_.stopped(event);
        });
        this.luceeVm_.registerBreakpointsChangedCallback(bpChangedEvent -> {
            BreakpointEventArguments bpEvent;
            for (IBreakpoint newBreakpoint : bpChangedEvent.newBreakpoints) {
                bpEvent = new BreakpointEventArguments();
                bpEvent.setBreakpoint(this.map_cfBreakpoint_to_lsp4jBreakpoint(newBreakpoint));
                bpEvent.setReason("new");
                this.clientProxy_.breakpoint(bpEvent);
            }
            for (IBreakpoint changedBreakpoint : bpChangedEvent.changedBreakpoints) {
                bpEvent = new BreakpointEventArguments();
                bpEvent.setBreakpoint(this.map_cfBreakpoint_to_lsp4jBreakpoint(changedBreakpoint));
                bpEvent.setReason("changed");
                this.clientProxy_.breakpoint(bpEvent);
            }
            for (int oldBreakpointID : bpChangedEvent.deletedBreakpointIDs) {
                bpEvent = new BreakpointEventArguments();
                Breakpoint bp = new Breakpoint();
                bp.setId(oldBreakpointID);
                bpEvent.setBreakpoint(bp);
                bpEvent.setReason("removed");
                this.clientProxy_.breakpoint(bpEvent);
            }
        });
        this.luceeVm_.registerNativeBreakpointEventCallback((javaThreadId, label) -> {
            int i32_threadID = (int)javaThreadId.longValue();
            StoppedEventArguments event = new StoppedEventArguments();
            event.setReason("breakpoint");
            event.setThreadId(i32_threadID);
            if (label != null && !label.isEmpty()) {
                event.setDescription((String)label);
            }
            this.clientProxy_.stopped(event);
            Log.debug("Stopped event sent: thread=" + javaThreadId + (String)(label != null ? " label=" + label : ""));
        });
        this.luceeVm_.registerExceptionEventCallback(javaThreadId -> {
            int i32_threadID = (int)javaThreadId.longValue();
            StoppedEventArguments event = new StoppedEventArguments();
            event.setReason("exception");
            event.setThreadId(i32_threadID);
            Throwable ex = this.luceeVm_.getExceptionForThread((long)javaThreadId);
            if (ex != null) {
                event.setDescription(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                event.setText(ex.getMessage());
            }
            this.clientProxy_.stopped(event);
            Log.debug("Sent DAP stopped event for exception, thread=" + javaThreadId + (String)(ex != null ? " exception=" + ex.getClass().getName() : ""));
        });
        this.luceeVm_.registerPauseEventCallback(javaThreadId -> {
            int i32_threadID = (int)javaThreadId.longValue();
            StoppedEventArguments event = new StoppedEventArguments();
            event.setReason("pause");
            event.setThreadId(i32_threadID);
            this.clientProxy_.stopped(event);
            Log.debug("Sent DAP stopped event for pause, thread=" + javaThreadId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DapEntry createForSocket(ILuceeVm luceeVm, Config config, String host, int port) {
        System.out.println("[luceedebug] createForSocket entered: host=" + host + ", port=" + port);
        DapServer.shutdown();
        ServerSocket server = null;
        try {
            try {
                System.out.println("[luceedebug] Creating ServerSocket...");
                server = new ServerSocket();
                InetSocketAddress addr = new InetSocketAddress(host, port);
                server.setReuseAddress(true);
                System.out.println("[luceedebug] Binding to " + host + ":" + port);
                logger.finest("binding cf dap server socket on " + host + ":" + port);
                int maxRetries = 5;
                BindException lastBindError = null;
                for (int attempt = 1; attempt <= maxRetries; ++attempt) {
                    try {
                        server.bind(addr);
                        lastBindError = null;
                        break;
                    }
                    catch (BindException e) {
                        lastBindError = e;
                        if (attempt >= maxRetries) continue;
                        Log.info("Port " + port + " in use, retrying in 1s (attempt " + attempt + "/" + maxRetries + ")");
                        try {
                            java.lang.Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
                if (lastBindError != null) {
                    throw lastBindError;
                }
                activeServerSocket = server;
                System.getProperties().put(SOCKET_PROPERTY, server);
                System.out.println("[luceedebug] DAP server socket bound successfully on " + host + ":" + port);
                logger.finest("dap server socket bind OK");
                while (true) {
                    System.out.println("[luceedebug] Waiting for DAP client connection on " + host + ":" + port + "...");
                    System.out.println("[luceedebug] ServerSocket state: bound=" + server.isBound() + ", closed=" + server.isClosed() + ", localPort=" + server.getLocalPort());
                    logger.finest("listening for inbound debugger connection on " + host + ":" + port + "...");
                    System.out.println("[luceedebug] Calling server.accept()...");
                    Socket socket = server.accept();
                    System.out.println("[luceedebug] accept() returned!");
                    String clientAddr = socket.getInetAddress().getHostAddress();
                    int clientPort = socket.getPort();
                    Log.info("DAP client connected from " + clientAddr + ":" + clientPort);
                    logger.finest("accepted debugger connection from " + clientAddr + ":" + clientPort);
                    if (luceeVm instanceof NativeLuceeVm) {
                        NativeDebuggerListener.setDapClientConnected(true);
                    }
                    try {
                        InputStream rawIn = socket.getInputStream();
                        OutputStream rawOut = socket.getOutputStream();
                        DapEntry dapEntry = DapServer.create(luceeVm, config, rawIn, rawOut);
                        Log.setDapClient(dapEntry.server.clientProxy_);
                        Future<Void> future = dapEntry.launcher.startListening();
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            Log.error("Launcher future exception", e);
                        }
                        Log.debug("DAP client disconnected from " + clientAddr + ":" + clientPort);
                    }
                    catch (Exception e) {
                        Log.error("DAP client error: " + e.getClass().getName(), e);
                    }
                    finally {
                        Log.setDapClient(null);
                        if (luceeVm instanceof NativeLuceeVm) {
                            NativeDebuggerListener.setDapClientConnected(false);
                        }
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                        System.out.println("[luceedebug] Client socket closed, returning to accept loop");
                    }
                    logger.finest("debugger connection closed");
                }
            }
            catch (SocketException e) {
                System.out.println("[luceedebug] DAP server SocketException: " + e.getMessage());
                Log.info("DAP server socket closed");
                DapEntry dapEntry = null;
                return dapEntry;
            }
            catch (Throwable e) {
                DapEntry dapEntry;
                block31: {
                    System.out.println("[luceedebug] DAP server fatal error: " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace(System.out);
                    e.printStackTrace();
                    System.exit(1);
                    dapEntry = null;
                    System.out.println("[luceedebug] DAP server finally block executing");
                    if (activeServerSocket != server) break block31;
                    activeServerSocket = null;
                    System.getProperties().remove(SOCKET_PROPERTY);
                }
                return dapEntry;
            }
        }
        finally {
            System.out.println("[luceedebug] DAP server finally block executing");
            if (activeServerSocket == server) {
                activeServerSocket = null;
                System.getProperties().remove(SOCKET_PROPERTY);
            }
        }
    }

    public static void shutdown() {
        System.out.println("[luceedebug] DapServer.shutdown() called");
        System.out.println("[luceedebug] shutdown() caller stack trace:");
        for (StackTraceElement ste : java.lang.Thread.currentThread().getStackTrace()) {
            System.out.println("[luceedebug]   " + String.valueOf(ste));
        }
        System.out.flush();
        Object storedSocket = System.getProperties().get(SOCKET_PROPERTY);
        if (storedSocket != null) {
            System.out.println("[luceedebug] shutdown() - found socket in system properties, closing via reflection...");
            Log.debug("shutdown() - found socket in system properties, closing via reflection...");
            try {
                Method closeMethod = storedSocket.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke(storedSocket, new Object[0]);
                System.out.println("[luceedebug] shutdown() - socket closed");
                Log.debug("shutdown() - socket closed");
            }
            catch (Exception e) {
                System.out.println("[luceedebug] shutdown() - socket close error: " + String.valueOf(e));
                Log.error("shutdown() - socket close error", e);
            }
            System.getProperties().remove(SOCKET_PROPERTY);
        } else {
            System.out.println("[luceedebug] shutdown() - no socket in system properties");
            Log.debug("shutdown() - no socket in system properties");
        }
        if (activeServerSocket != null) {
            System.out.println("[luceedebug] shutdown() - closing activeServerSocket");
            try {
                activeServerSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            activeServerSocket = null;
        }
    }

    public static DapEntry create(ILuceeVm luceeVm, Config config, InputStream in, OutputStream out) {
        DapServer server = new DapServer(luceeVm, config);
        Launcher<IDebugProtocolClient> serverLauncher = DSPLauncher.createServerLauncher(server, in, out);
        server.clientProxy_ = serverLauncher.getRemoteProxy();
        return new DapEntry(server, serverLauncher);
    }

    @Override
    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        boolean isNativeMode;
        Log.debug("initialize() called with args: " + String.valueOf(args));
        Capabilities c = new Capabilities();
        c.setSupportsEvaluateForHovers(true);
        c.setSupportsConfigurationDoneRequest(true);
        c.setSupportsSingleThreadExecutionRequests(true);
        c.setSupportsConditionalBreakpoints(true);
        c.setSupportsHitConditionalBreakpoints(false);
        c.setSupportsLogPoints(false);
        boolean bl = isNativeMode = this.luceeVm_ instanceof NativeLuceeVm && EnvUtil.isDebuggerEnabled();
        if (isNativeMode) {
            ExceptionBreakpointsFilter uncaughtFilter = new ExceptionBreakpointsFilter();
            uncaughtFilter.setFilter("uncaught");
            uncaughtFilter.setLabel("Uncaught Exceptions");
            uncaughtFilter.setDescription("Break when an exception is not caught by a try/catch block");
            c.setExceptionBreakpointFilters(new ExceptionBreakpointsFilter[]{uncaughtFilter});
        }
        c.setSupportsExceptionInfoRequest(isNativeMode);
        c.setSupportsBreakpointLocationsRequest(isNativeMode);
        c.setSupportsSetVariable(isNativeMode);
        c.setSupportsCompletionsRequest(isNativeMode);
        c.setSupportsFunctionBreakpoints(isNativeMode);
        Log.debug("Returning capabilities (nativeMode=" + isNativeMode + ") with exceptionBreakpointFilters: " + Arrays.toString(c.getExceptionBreakpointFilters()));
        return CompletableFuture.completedFuture(c);
    }

    @Override
    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        CompletableFuture<SourceResponse> exceptionalResult = new CompletableFuture<SourceResponse>();
        ResponseError error = new ResponseError(ResponseErrorCode.MethodNotFound, "'source' requests are not supported", null);
        exceptionalResult.completeExceptionally(new ResponseErrorException(error));
        return exceptionalResult;
    }

    private IPathTransform mungeOnePathTransform(Map<?, ?> map) {
        Object maybeServerPrefix;
        Object maybeIdePrefix = map.get("idePrefix");
        Object obj = maybeServerPrefix = map.containsKey("cfPrefix") ? map.get("cfPrefix") : map.get("serverPrefix");
        if (maybeServerPrefix instanceof String && maybeIdePrefix instanceof String) {
            return new PrefixPathTransform((String)maybeIdePrefix, (String)maybeServerPrefix);
        }
        return null;
    }

    private ArrayList<IPathTransform> tryMungePathTransforms(Object maybeNull_val) {
        IPathTransform maybeNull_result;
        ArrayList<IPathTransform> result = new ArrayList<IPathTransform>();
        if (maybeNull_val instanceof List) {
            for (Object e : (List)maybeNull_val) {
                IPathTransform maybeNull_result2;
                if (!(e instanceof Map) || (maybeNull_result2 = this.mungeOnePathTransform((Map)e)) == null) continue;
                result.add(maybeNull_result2);
            }
            return result;
        }
        if (maybeNull_val instanceof Map && (maybeNull_result = this.mungeOnePathTransform((Map)maybeNull_val)) != null) {
            result.add(maybeNull_result);
        }
        return result;
    }

    private boolean getBoolOrFalseIfNonBool(Object obj) {
        return this.getAsBool(obj, false);
    }

    private boolean getAsBool(Object obj, boolean defaultValue) {
        return obj instanceof Boolean ? (Boolean)obj : defaultValue;
    }

    @Override
    public CompletableFuture<Void> attach(Map<String, Object> args) {
        this.configureLogging(args);
        String luceeVersion = DapServer.getLuceeVersion();
        Log.info("luceedebug 3.0.0.0-SNAPSHOT connected to Lucee " + luceeVersion);
        if (!this.validateSecret(args)) {
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, "Invalid or missing secret", null);
            result.completeExceptionally(new ResponseErrorException(error));
            return result;
        }
        this.pathTransforms = this.tryMungePathTransforms(args.get("pathTransforms"));
        this.config_.setStepIntoUdfDefaultValueInitFrames(this.getBoolOrFalseIfNonBool(args.get("stepIntoUdfDefaultValueInitFrames")));
        this.evaluationEnabled = this.getAsBool(args.get("evaluation"), true);
        if (!this.evaluationEnabled) {
            Log.info("Expression evaluation disabled");
        }
        this.clientProxy_.initialized();
        if (this.pathTransforms.size() == 0) {
            Log.info("No path transforms configured");
        } else {
            for (IPathTransform transform : this.pathTransforms) {
                Log.info(transform.asTraceString());
                if (!(transform instanceof PrefixPathTransform)) continue;
                Config.setBasePath(((PrefixPathTransform)transform).getServerPrefix());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean validateSecret(Map<String, Object> args) {
        String clientSecret;
        Object secretObj = args.get("secret");
        String string = clientSecret = secretObj instanceof String ? ((String)secretObj).trim() : null;
        if (clientSecret == null || clientSecret.isEmpty()) {
            Log.error("No secret provided in launch.json");
            return false;
        }
        try {
            Class<?> activatorClass = Class.forName("org.lucee.extension.debugger.extension.ExtensionActivator");
            Method isNativeMethod = activatorClass.getMethod("isNativeModeActive", new Class[0]);
            Boolean isNative = (Boolean)isNativeMethod.invoke(null, new Object[0]);
            if (isNative.booleanValue()) {
                Method registerMethod = activatorClass.getMethod("registerListener", String.class);
                Boolean registered = (Boolean)registerMethod.invoke(null, clientSecret);
                if (registered.booleanValue()) {
                    this.secretValidated = true;
                    return true;
                }
                Log.error("Failed to register debugger - invalid secret");
                return false;
            }
        }
        catch (ClassNotFoundException activatorClass) {
        }
        catch (Exception e) {
            Log.error("Error checking native mode status", e);
            return false;
        }
        String expectedSecret = EnvUtil.getDebuggerSecret();
        if (expectedSecret == null) {
            Log.error("LUCEE_DAP_SECRET not set on server");
            return false;
        }
        if (!expectedSecret.equals(clientSecret)) {
            Log.error("Invalid secret");
            return false;
        }
        this.secretValidated = true;
        return true;
    }

    private <T> CompletableFuture<T> notAuthorized() {
        CompletableFuture result = new CompletableFuture();
        ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, "Not authorized - call 'attach' with valid secret first", null);
        result.completeExceptionally(new ResponseErrorException(error));
        return result;
    }

    private static boolean toBooleanValue(Object obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            String s = ((String)obj).toLowerCase().trim();
            if ("true".equals(s) || "yes".equals(s) || "1".equals(s)) {
                return true;
            }
            if ("false".equals(s) || "no".equals(s) || "0".equals(s)) {
                return false;
            }
        }
        return defaultValue;
    }

    private void configureLogging(Map<String, Object> args) {
        Log.setColorLogs(DapServer.toBooleanValue(args.get("logColor"), true));
        Object logLevel = args.get("logLevel");
        if (logLevel instanceof String) {
            String level;
            switch (level = ((String)logLevel).toLowerCase()) {
                case "error": {
                    Log.setLogLevel(Log.LogLevel.ERROR);
                    break;
                }
                case "debug": {
                    Log.setLogLevel(Log.LogLevel.DEBUG);
                    break;
                }
                default: {
                    Log.setLogLevel(Log.LogLevel.INFO);
                }
            }
        }
        Log.setLogExceptions(DapServer.toBooleanValue(args.get("logExceptions"), false));
        if (this.luceeVm_ instanceof NativeLuceeVm) {
            NativeDebuggerListener.setConsoleOutput(DapServer.toBooleanValue(args.get("consoleOutput"), false));
        }
    }

    @Override
    public CompletableFuture<ThreadsResponse> threads() {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        ArrayList<Thread> lspThreads = new ArrayList<Thread>();
        for (ThreadInfo threadInfo : this.luceeVm_.getThreadListing()) {
            Thread lspThread = new Thread();
            lspThread.setId((int)threadInfo.id);
            lspThread.setName(threadInfo.name);
            lspThreads.add(lspThread);
        }
        lspThreads.sort((lthread, rthread) -> {
            String l = lthread.getName().toLowerCase();
            String r = rthread.getName().toLowerCase();
            Matcher ml = threadNamePrefixAndDigitSuffix.matcher(l);
            Matcher mr = threadNamePrefixAndDigitSuffix.matcher(r);
            if (ml.matches() && mr.matches() && ml.group(1).equals(mr.group(1))) {
                try {
                    int intl = Integer.parseInt(ml.group(2));
                    int intr = Integer.parseInt(mr.group(2));
                    return intl < intr ? -1 : (intl == intr ? 0 : 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return l.compareTo(r);
        });
        ThreadsResponse response = new ThreadsResponse();
        response.setThreads(lspThreads.toArray(new Thread[lspThreads.size()]));
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        ArrayList<StackFrame> lspFrames = new ArrayList<StackFrame>();
        for (IDebugFrame cfFrame : this.luceeVm_.getStackTrace(args.getThreadId())) {
            Source source = new Source();
            String rawPath = cfFrame.getSourceFilePath();
            String transformedPath = this.applyPathTransformsServerToIde(rawPath);
            Log.debug("stackTrace: raw=" + rawPath + " -> transformed=" + transformedPath);
            source.setPath(transformedPath);
            StackFrame lspFrame = new StackFrame();
            lspFrame.setId((int)cfFrame.getId());
            lspFrame.setName(cfFrame.getName());
            lspFrame.setLine(cfFrame.getLine());
            lspFrame.setSource(source);
            lspFrames.add(lspFrame);
        }
        StackTraceResponse response = new StackTraceResponse();
        response.setStackFrames(lspFrames.toArray(new StackFrame[lspFrames.size()]));
        response.setTotalFrames(lspFrames.size());
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (IDebugEntity entity : this.luceeVm_.getScopes(args.getFrameId())) {
            Scope scope = new Scope();
            scope.setName(entity.getName());
            scope.setVariablesReference((int)entity.getVariablesReference());
            scope.setIndexedVariables(entity.getIndexedVariables());
            scope.setNamedVariables(entity.getNamedVariables());
            scope.setExpensive(entity.getExpensive());
            scopes.add(scope);
        }
        ScopesResponse result = new ScopesResponse();
        result.setScopes((Scope[])scopes.toArray(Scope[]::new));
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        IDebugEntity[] entities;
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (IDebugEntity entity : entities = args.getFilter() == null ? this.luceeVm_.getVariables(args.getVariablesReference()) : (args.getFilter() == VariablesArgumentsFilter.INDEXED ? this.luceeVm_.getIndexedVariables(args.getVariablesReference()) : (args.getFilter() == VariablesArgumentsFilter.NAMED ? this.luceeVm_.getNamedVariables(args.getVariablesReference()) : new IDebugEntity[]{}))) {
            Variable variable = new Variable();
            variable.setName(entity.getName());
            variable.setVariablesReference((int)entity.getVariablesReference());
            variable.setIndexedVariables(entity.getIndexedVariables());
            variable.setNamedVariables(entity.getNamedVariables());
            variable.setValue(entity.getValue());
            variables.add(variable);
        }
        VariablesResponse result = new VariablesResponse();
        result.setVariables((Variable[])variables.toArray(Variable[]::new));
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        Log.debug("setVariable() called: variablesReference=" + args.getVariablesReference() + ", name=" + args.getName() + ", value=" + args.getValue());
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        return this.luceeVm_.setVariable(args.getVariablesReference(), args.getName(), args.getValue(), 0L).collapse(errMsg -> {
            Log.info("setVariable() - error: " + errMsg);
            CompletableFuture exceptionalResult = new CompletableFuture();
            ResponseError error = new ResponseError(ResponseErrorCode.InternalError, (String)errMsg, (Object)null);
            exceptionalResult.completeExceptionally(new ResponseErrorException(error));
            return exceptionalResult;
        }, someResult -> someResult.collapse(bridgeObj -> {
            IDebugEntity value = bridgeObj.maybeNull_asValue(args.getName());
            SetVariableResponse response = new SetVariableResponse();
            if (value == null) {
                response.setValue("<?>");
                response.setVariablesReference(0);
            } else {
                response.setValue(value.getValue());
                response.setVariablesReference((int)value.getVariablesReference());
                response.setNamedVariables(bridgeObj.getNamedVariablesCount());
                response.setIndexedVariables(bridgeObj.getIndexedVariablesCount());
            }
            Log.debug("setVariable() - success (object): value=" + response.getValue() + ", ref=" + response.getVariablesReference());
            return CompletableFuture.completedFuture(response);
        }, stringValue -> {
            SetVariableResponse response = new SetVariableResponse();
            response.setValue((String)stringValue);
            response.setVariablesReference(0);
            Log.debug("setVariable() - success (simple): value=" + stringValue);
            return CompletableFuture.completedFuture(response);
        }));
    }

    @Override
    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        RawIdePath idePath = new RawIdePath(args.getSource().getPath());
        CanonicalServerAbsPath serverAbsPath = new CanonicalServerAbsPath(this.applyPathTransformsIdeToCf(args.getSource().getPath()));
        logger.finest("bp for " + (String)idePath.get() + " -> " + (String)serverAbsPath.get());
        int size = args.getBreakpoints().length;
        int[] lines = new int[size];
        String[] exprs = new String[size];
        for (int i = 0; i < size; ++i) {
            lines[i] = args.getBreakpoints()[i].getLine();
            exprs[i] = args.getBreakpoints()[i].getCondition();
        }
        ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
        for (IBreakpoint bp : this.luceeVm_.bindBreakpoints(idePath, serverAbsPath, lines, exprs)) {
            result.add(this.map_cfBreakpoint_to_lsp4jBreakpoint(bp));
        }
        SetBreakpointsResponse response = new SetBreakpointsResponse();
        response.setBreakpoints((Breakpoint[])result.toArray(Breakpoint[]::new));
        return CompletableFuture.completedFuture(response);
    }

    private Breakpoint map_cfBreakpoint_to_lsp4jBreakpoint(IBreakpoint cfBreakpoint) {
        Breakpoint bp = new Breakpoint();
        bp.setLine(cfBreakpoint.getLine());
        bp.setId(cfBreakpoint.getID());
        bp.setVerified(cfBreakpoint.getIsBound());
        return bp;
    }

    @Override
    public CompletableFuture<BreakpointLocationsResponse> breakpointLocations(BreakpointLocationsArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        BreakpointLocationsResponse response = new BreakpointLocationsResponse();
        if (!(this.luceeVm_ instanceof NativeLuceeVm)) {
            response.setBreakpoints(new BreakpointLocation[0]);
            return CompletableFuture.completedFuture(response);
        }
        NativeLuceeVm nativeVm = (NativeLuceeVm)this.luceeVm_;
        String serverPath = this.applyPathTransformsIdeToCf(args.getSource().getPath());
        int[] executableLines = nativeVm.getExecutableLines(serverPath);
        int startLine = args.getLine();
        int endLine = args.getEndLine() != null ? args.getEndLine() : startLine;
        ArrayList<BreakpointLocation> locations = new ArrayList<BreakpointLocation>();
        for (int line : executableLines) {
            if (line < startLine || line > endLine) continue;
            BreakpointLocation loc = new BreakpointLocation();
            loc.setLine(line);
            locations.add(loc);
        }
        response.setBreakpoints(locations.toArray(new BreakpointLocation[0]));
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        Object[] filters = args.getFilters();
        Log.debug("setExceptionBreakpoints: filters=" + Arrays.toString(filters));
        boolean breakOnUncaught = false;
        if (filters != null) {
            for (Object filter : filters) {
                if (!"uncaught".equals(filter)) continue;
                breakOnUncaught = true;
                break;
            }
        }
        if (this.luceeVm_ instanceof NativeLuceeVm) {
            NativeDebuggerListener.setBreakOnUncaughtExceptions(breakOnUncaught);
        }
        return CompletableFuture.completedFuture(new SetExceptionBreakpointsResponse());
    }

    @Override
    public CompletableFuture<SetFunctionBreakpointsResponse> setFunctionBreakpoints(SetFunctionBreakpointsArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        if (!(this.luceeVm_ instanceof NativeLuceeVm)) {
            return CompletableFuture.completedFuture(new SetFunctionBreakpointsResponse());
        }
        FunctionBreakpoint[] bps = args.getBreakpoints();
        Log.debug("setFunctionBreakpoints: " + (bps != null ? bps.length : 0) + " breakpoints");
        if (bps == null || bps.length == 0) {
            NativeDebuggerListener.clearFunctionBreakpoints();
            return CompletableFuture.completedFuture(new SetFunctionBreakpointsResponse());
        }
        String[] names = new String[bps.length];
        String[] conditions = new String[bps.length];
        for (int i = 0; i < bps.length; ++i) {
            names[i] = bps[i].getName();
            conditions[i] = bps[i].getCondition();
            Log.debug("  Function breakpoint: " + names[i] + (String)(conditions[i] != null ? " condition=" + conditions[i] : ""));
        }
        NativeDebuggerListener.setFunctionBreakpoints(names, conditions);
        Breakpoint[] result = new Breakpoint[bps.length];
        for (int i = 0; i < bps.length; ++i) {
            Breakpoint bp = new Breakpoint();
            bp.setId(i + 1);
            bp.setVerified(true);
            bp.setMessage("Function breakpoint: " + names[i]);
            result[i] = bp;
        }
        SetFunctionBreakpointsResponse response = new SetFunctionBreakpointsResponse();
        response.setBreakpoints(result);
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<ExceptionInfoResponse> exceptionInfo(ExceptionInfoArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        Log.debug("exceptionInfo() called for thread " + args.getThreadId());
        Throwable ex = this.luceeVm_.getExceptionForThread(args.getThreadId());
        ExceptionInfoResponse response = new ExceptionInfoResponse();
        if (ex != null) {
            response.setExceptionId(ex.getClass().getName());
            response.setDescription(ex.getMessage());
            response.setBreakMode(ExceptionBreakMode.UNHANDLED);
            ExceptionDetails details = new ExceptionDetails();
            Object message = ex.getMessage();
            String detail = ExceptionUtil.getDetail(ex);
            if (detail != null && !detail.isEmpty()) {
                message = (String)message + "\n\nDetail: " + detail;
            }
            details.setMessage((String)message);
            details.setTypeName(ex.getClass().getName());
            details.setStackTrace(ExceptionUtil.getCfmlStackTraceOrFallback(ex));
            if (ex.getCause() != null) {
                ExceptionDetails inner = new ExceptionDetails();
                inner.setMessage(ex.getCause().getMessage());
                inner.setTypeName(ex.getCause().getClass().getName());
                details.setInnerException(new ExceptionDetails[]{inner});
            }
            response.setDetails(details);
            Log.debug("exceptionInfo() returning: " + ex.getClass().getName() + " - " + ex.getMessage());
        } else {
            response.setExceptionId("unknown");
            response.setDescription("No exception information available");
            response.setBreakMode(ExceptionBreakMode.UNHANDLED);
            Log.debug("exceptionInfo() - no exception found for thread");
        }
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<Void> pause(PauseArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        long threadId = args.getThreadId();
        Log.info("pause() called for thread " + threadId);
        this.luceeVm_.pause(threadId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        Log.info("DAP client disconnected");
        this.luceeVm_.clearAllBreakpoints();
        this.luceeVm_.continueAll();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        this.luceeVm_.continue_(args.getThreadId());
        return CompletableFuture.completedFuture(new ContinueResponse());
    }

    @Override
    public CompletableFuture<Void> next(NextArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        this.luceeVm_.stepOver(args.getThreadId());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepIn(StepInArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        this.luceeVm_.stepIn(args.getThreadId());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        this.luceeVm_.stepOut(args.getThreadId());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return CompletableFuture.completedFuture(null);
    }

    @JsonRequest
    CompletableFuture<DumpResponse> dump(DumpArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        DumpResponse response = new DumpResponse();
        response.setContent(this.luceeVm_.dump(args.variablesReference));
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    CompletableFuture<DumpResponse> dumpAsJSON(DumpArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        DumpResponse response = new DumpResponse();
        response.setContent(this.luceeVm_.dumpAsJSON(args.variablesReference));
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    CompletableFuture<DumpResponse> getMetadata(DumpArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        DumpResponse response = new DumpResponse();
        response.setContent(this.luceeVm_.getMetadata(args.variablesReference));
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    CompletableFuture<DumpResponse> getApplicationSettings(DumpArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        DumpResponse response = new DumpResponse();
        response.setContent(this.luceeVm_.getApplicationSettings());
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    CompletableFuture<DebugBreakpointBindingsResponse> debugBreakpointBindings(DebugBreakpointBindingsArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        DebugBreakpointBindingsResponse response = new DebugBreakpointBindingsResponse();
        response.setCanonicalFilenames(this.luceeVm_.getTrackedCanonicalFileNames());
        response.setBreakpoints(this.luceeVm_.getBreakpointDetail());
        ArrayList<String> transforms = new ArrayList<String>();
        for (IPathTransform v : this.pathTransforms) {
            transforms.add(v.asTraceString());
        }
        response.setPathTransforms(transforms.toArray(new String[0]));
        return CompletableFuture.completedFuture(response);
    }

    @JsonRequest
    CompletableFuture<GetSourcePathResponse> getSourcePath(GetSourcePathArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        GetSourcePathResponse response = new GetSourcePathResponse();
        String serverPath = this.luceeVm_.getSourcePathForVariablesRef(args.getVariablesReference());
        if (serverPath != null) {
            response.setPath(this.applyPathTransformsServerToIde(serverPath));
        } else {
            response.setPath(null);
        }
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        String expr = args.getExpression();
        String context = args.getContext();
        boolean isHover = "hover".equals(context);
        if (!this.evaluationEnabled) {
            CompletableFuture<EvaluateResponse> exceptionalResult = new CompletableFuture<EvaluateResponse>();
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, "evaluation disabled", null);
            exceptionalResult.completeExceptionally(new ResponseErrorException(error));
            return exceptionalResult;
        }
        if (args.getFrameId() == null) {
            if (!isHover) {
                Log.info("evaluate(\"" + expr + "\") - error: missing frameID");
            }
            CompletableFuture<EvaluateResponse> exceptionalResult = new CompletableFuture<EvaluateResponse>();
            ResponseError error = new ResponseError(ResponseErrorCode.InvalidRequest, "missing frameID", null);
            exceptionalResult.completeExceptionally(new ResponseErrorException(error));
            return exceptionalResult;
        }
        return this.luceeVm_.evaluate(args.getFrameId(), expr).collapse(errMsg -> {
            if (!isHover) {
                Log.info("evaluate(\"" + expr + "\") - error: " + errMsg);
            }
            CompletableFuture exceptionalResult = new CompletableFuture();
            ResponseError error = new ResponseError(ResponseErrorCode.InternalError, (String)errMsg, (Object)null);
            exceptionalResult.completeExceptionally(new ResponseErrorException(error));
            return exceptionalResult;
        }, someResult -> someResult.collapse(someObj -> {
            IDebugEntity value = someObj.maybeNull_asValue("anonymous value " + anonymousID.incrementAndGet());
            EvaluateResponse response = new EvaluateResponse();
            if (value == null) {
                Log.info("evaluate(\"" + expr + "\") = ???");
                response.setVariablesReference(0);
                response.setIndexedVariables(0);
                response.setNamedVariables(0);
                response.setResult("???");
            } else {
                Log.info("evaluate(\"" + expr + "\") = " + value.getValue());
                response.setVariablesReference((int)value.getVariablesReference());
                response.setIndexedVariables(value.getIndexedVariables());
                response.setNamedVariables(value.getNamedVariables());
                response.setResult(value.getValue());
            }
            return CompletableFuture.completedFuture(response);
        }, string -> {
            Log.info("evaluate(\"" + expr + "\") = " + string);
            EvaluateResponse response = new EvaluateResponse();
            response.setResult((String)string);
            return CompletableFuture.completedFuture(response);
        }));
    }

    @Override
    public CompletableFuture<CompletionsResponse> completions(CompletionsArguments args) {
        CompletionItem[] items;
        char c;
        int wordStart;
        if (!this.secretValidated) {
            return this.notAuthorized();
        }
        String text = args.getText();
        int column = args.getColumn();
        Integer frameId = args.getFrameId();
        int cursorPos = Math.min(column - 1, text.length());
        String prefix = text.substring(0, cursorPos);
        for (wordStart = cursorPos; wordStart > 0 && (Character.isLetterOrDigit(c = prefix.charAt(wordStart - 1)) || c == '_' || c == '.' || c == '[' || c == ']' || c == '\"' || c == '\''); --wordStart) {
        }
        String partialExpr = prefix.substring(wordStart);
        for (CompletionItem item : items = this.luceeVm_.getCompletions(frameId != null ? frameId : 0, partialExpr)) {
            item.setStart(wordStart);
            item.setLength(partialExpr.length());
        }
        CompletionsResponse response = new CompletionsResponse();
        response.setTargets(items);
        return CompletableFuture.completedFuture(response);
    }

    private static String getLuceeVersion() {
        try {
            Info info = CFMLEngineFactory.getInstance().getInfo();
            return info.getVersion().toString();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    static {
        threadNamePrefixAndDigitSuffix = Pattern.compile("^(.+?)(\\d+)$");
        anonymousID = new AtomicLong();
    }

    static class DapEntry {
        public final DapServer server;
        public final Launcher<IDebugProtocolClient> launcher;

        private DapEntry(DapServer server, Launcher<IDebugProtocolClient> launcher) {
            this.server = server;
            this.launcher = launcher;
        }
    }

    class DumpResponse {
        private String content;

        DumpResponse() {
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String htmlDocument) {
            this.content = htmlDocument;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("content", this.content);
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DumpResponse other = (DumpResponse)obj;
            return this.content.equals(other.content);
        }
    }

    class DumpArguments {
        private int variablesReference;

        DumpArguments() {
        }

        public int getVariablesReference() {
            return this.variablesReference;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("variablesReference", this.variablesReference);
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DumpArguments other = (DumpArguments)obj;
            return this.variablesReference == other.variablesReference;
        }
    }

    class DebugBreakpointBindingsResponse {
        private String[] canonicalFilenames;
        private String[][] breakpoints;
        private String[] pathTransforms;

        DebugBreakpointBindingsResponse() {
        }

        public String[] getCanonicalFilenames() {
            return this.canonicalFilenames;
        }

        public void setCanonicalFilenames(String[] v) {
            this.canonicalFilenames = v;
        }

        public String[][] getBreakpoints() {
            return this.breakpoints;
        }

        public void setBreakpoints(String[][] v) {
            this.breakpoints = v;
        }

        public String[] getPathTransforms() {
            return this.pathTransforms;
        }

        public void setPathTransforms(String[] v) {
            this.pathTransforms = v;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("canonicalFilenames", this.canonicalFilenames);
            b.add("breakpoints", this.breakpoints);
            b.add("pathTransforms", this.pathTransforms);
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DebugBreakpointBindingsResponse other = (DebugBreakpointBindingsResponse)obj;
            if (this.canonicalFilenames == null ? other.canonicalFilenames != null : !Arrays.deepEquals(this.canonicalFilenames, other.canonicalFilenames)) {
                return false;
            }
            if (this.breakpoints == null ? other.breakpoints != null : !Arrays.deepEquals((Object[])this.breakpoints, (Object[])other.breakpoints)) {
                return false;
            }
            return !(this.pathTransforms == null ? other.pathTransforms != null : !Arrays.deepEquals(this.pathTransforms, other.pathTransforms));
        }
    }

    class GetSourcePathResponse {
        private String path;

        GetSourcePathResponse() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("path", this.path);
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetSourcePathResponse other = (GetSourcePathResponse)obj;
            return this.path.equals(other.path);
        }
    }

    class GetSourcePathArguments {
        private int variablesReference;

        GetSourcePathArguments() {
        }

        public int getVariablesReference() {
            return this.variablesReference;
        }

        public void setBreakpoints(int v) {
            this.variablesReference = v;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder(this);
            b.add("variablesReference", this.variablesReference);
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetSourcePathArguments other = (GetSourcePathArguments)obj;
            return this.variablesReference == other.variablesReference;
        }
    }

    class DebugBreakpointBindingsArguments {
        DebugBreakpointBindingsArguments() {
        }
    }
}

