/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.io.File;

public class Config {
    private final boolean fsIsCaseSensitive_;
    private boolean stepIntoUdfDefaultValueInitFrames_ = false;
    private static volatile boolean staticFsIsCaseSensitive = false;
    private static volatile String basePath = null;

    public Config(boolean fsIsCaseSensitive) {
        this.fsIsCaseSensitive_ = fsIsCaseSensitive;
        staticFsIsCaseSensitive = fsIsCaseSensitive;
    }

    public boolean getStepIntoUdfDefaultValueInitFrames() {
        return this.stepIntoUdfDefaultValueInitFrames_;
    }

    public void setStepIntoUdfDefaultValueInitFrames(boolean v) {
        this.stepIntoUdfDefaultValueInitFrames_ = v;
    }

    private static String invertCase(String path) {
        int c;
        int strLen = path.length();
        StringBuilder builder = new StringBuilder();
        for (int offset = 0; offset < strLen; offset += Character.charCount(c)) {
            c = path.codePointAt(offset);
            if (Character.isUpperCase(c)) {
                builder.append(Character.toString(Character.toLowerCase(c)));
                continue;
            }
            if (Character.isLowerCase(c)) {
                builder.append(Character.toString(Character.toUpperCase(c)));
                continue;
            }
            builder.append(Character.toString(c));
        }
        return builder.toString();
    }

    public static boolean checkIfFileSystemIsCaseSensitive(String absPath) {
        if (!new File(absPath).exists()) {
            throw new IllegalArgumentException("File '" + absPath + "' doesn't exist, so it cannot be used to check for file system case sensitivity.");
        }
        return !new File(Config.invertCase(absPath)).exists();
    }

    public boolean getFsIsCaseSensitive() {
        return this.fsIsCaseSensitive_;
    }

    public static String canonicalizeFileName(String s) {
        String normalized = s.replaceAll("[\\\\/]+", "/");
        return staticFsIsCaseSensitive ? normalized : normalized.toLowerCase();
    }

    public static void setBasePath(String path) {
        basePath = path != null ? Config.canonicalizeFileName(path) : null;
    }

    public static String shortenPath(String path) {
        if (basePath == null || path == null) {
            return path;
        }
        String canon = Config.canonicalizeFileName(path);
        if (canon.startsWith(basePath)) {
            Object relative = canon.substring(basePath.length());
            if (!((String)relative).startsWith("/")) {
                relative = "/" + (String)relative;
            }
            return relative;
        }
        return path;
    }
}

