/*
 * Decompiled with CFR 0.152.
 */
package org.lucee.extension.debugger;

import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.lucee.extension.debugger.Config;
import org.lucee.extension.debugger.LuceeTransformer;

public class Agent {
    public static void premain(String argString, Instrumentation inst) throws Throwable {
        AgentArgs parsedArgs = new AgentArgs(argString);
        if (!new File(parsedArgs.jarPath).exists()) {
            System.err.println("[luceedebug] couldn't find agent/instrumentation jar to add to bootstrap classloader");
            System.err.println("[luceedebug] (target jarpath was '" + parsedArgs.jarPath + "', maybe it was a relative path, rather than absolute?");
            System.exit(1);
        }
        System.setProperty("lucee.requesttimeout", "false");
        System.setProperty("org.osgi.framework.bootdelegation", "com.sun.jdi,com.sun.jdi.connect,com.sun.jdi.event,com.sun.jdi.request,org.lucee.extension.debugger,org.lucee.extension.debugger.strong,org.lucee.extension.debugger.util,org.lucee.extension.debugger.shaded.*");
        System.out.println("[luceedebug] version 3.0.0.0-SNAPSHOT");
        try (JarFile jarFile = new JarFile(parsedArgs.jarPath);){
            inst.appendToSystemClassLoaderSearch(jarFile);
            LuceeTransformer.ClassInjection[] classInjections = (LuceeTransformer.ClassInjection[])jarFile.stream().filter(jarEntry -> !jarEntry.isDirectory() && (jarEntry.getName().startsWith("org/lucee/extension/debugger/coreinject") || jarEntry.getName().startsWith("org/lucee/extension/debugger/util")) && jarEntry.getName().endsWith(".class")).map(jarEntry -> {
                LuceeTransformer.ClassInjection classInjection;
                block8: {
                    InputStream is = jarFile.getInputStream((ZipEntry)jarEntry);
                    try {
                        LuceeTransformer.ClassInjection result;
                        String name = jarEntry.getName().replace(".class", "").replaceAll("/", ".");
                        byte[] bytes = is.readAllBytes();
                        classInjection = result = new LuceeTransformer.ClassInjection(name, bytes);
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            System.exit(1);
                            return null;
                        }
                    }
                    is.close();
                }
                return classInjection;
            }).sorted(CoreInjectionLinearization.comparator()).toArray(LuceeTransformer.ClassInjection[]::new);
            Config config = new Config(Config.checkIfFileSystemIsCaseSensitive(parsedArgs.jarPath));
            LuceeTransformer transformer = new LuceeTransformer(classInjections, parsedArgs.jdwpHost, parsedArgs.jdwpPort, parsedArgs.debugHost, parsedArgs.debugPort, config);
            inst.addTransformer(transformer);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("[luceedebug] agent premain complete");
    }

    static class AgentArgs {
        String jdwpHost;
        int jdwpPort;
        String debugHost;
        int debugPort;
        String jarPath;

        AgentArgs(String argString) {
            boolean gotJdwpHost = false;
            boolean gotJdwpPort = false;
            boolean gotDebugHost = false;
            boolean gotDebugPort = false;
            boolean gotJarPath = false;
            block20: for (String eachArg : argString.split(",")) {
                String[] nameAndValue = eachArg.split("=");
                if (nameAndValue.length != 2) {
                    throw new IllegalArgumentException("Invalid agent args string.");
                }
                String name = nameAndValue[0];
                String value = nameAndValue[1];
                switch (name.toLowerCase()) {
                    case "jdwphost": {
                        this.jdwpHost = value;
                        gotJdwpHost = true;
                        continue block20;
                    }
                    case "cfhost": 
                    case "debughost": {
                        this.debugHost = value;
                        gotDebugHost = true;
                        continue block20;
                    }
                    case "jdwpport": {
                        try {
                            this.jdwpPort = Integer.parseInt(value);
                            gotJdwpPort = true;
                            continue block20;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid jdwpPort value in agent args string (got '" + value + "' but expected an integer).");
                        }
                    }
                    case "cfport": 
                    case "debugport": {
                        try {
                            this.debugPort = Integer.parseInt(value);
                            gotDebugPort = true;
                            continue block20;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid debugPort value in agent args string (got '" + value + "' but expected an integer).");
                        }
                    }
                    case "jarpath": {
                        this.jarPath = value;
                        gotJarPath = true;
                    }
                }
            }
            boolean doThrow = false;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("Missing agent args:");
            if (!gotJdwpHost) {
                doThrow = true;
                errMsg.append(" jdwphost");
            }
            if (!gotDebugHost) {
                doThrow = true;
                errMsg.append(" debughost");
            }
            if (!gotJdwpPort) {
                doThrow = true;
                errMsg.append(" jdwpport");
            }
            if (!gotDebugPort) {
                doThrow = true;
                errMsg.append(" debugport");
            }
            if (!gotJarPath) {
                doThrow = true;
                errMsg.append(" jarpath");
            }
            if (doThrow) {
                throw new IllegalArgumentException(errMsg.toString());
            }
        }
    }

    private static class CoreInjectionLinearization {
        private CoreInjectionLinearization() {
        }

        private static Map<String, Integer> linearizedCoreInjectClasses() {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$BpLineAndId", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugManager$2", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugManager$CfStepRequest", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$ReplayableCfBreakpointRequest", 0);
            result.put("org.lucee.extension.debugger.coreinject.Utils", 0);
            result.put("org.lucee.extension.debugger.coreinject.ValTracker$WeakTaggedObject", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugManager$1", 0);
            result.put("org.lucee.extension.debugger.coreinject.ClosureScopeLocalScopeAccessorShim", 0);
            result.put("org.lucee.extension.debugger.coreinject.ComponentScopeMarkerTraitShim", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$SteppingState", 0);
            result.put("org.lucee.extension.debugger.coreinject.KlassMap", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$JdwpWorker", 0);
            result.put("org.lucee.extension.debugger.coreinject.ValTracker$TaggedObject", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugEntity", 0);
            result.put("org.lucee.extension.debugger.coreinject.Breakpoint", 0);
            result.put("org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge$MarkerTrait", 0);
            result.put("org.lucee.extension.debugger.coreinject.ValTracker", 0);
            result.put("org.lucee.extension.debugger.coreinject.UnsafeUtils", 0);
            result.put("org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge$MarkerTrait$Scope", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugManager$PageContextAndOutputStream", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$ThreadMap", 0);
            result.put("org.lucee.extension.debugger.coreinject.DebugManager", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm$JdwpStaticCallable", 0);
            result.put("org.lucee.extension.debugger.coreinject.CfValueDebuggerBridge", 0);
            result.put("org.lucee.extension.debugger.coreinject.LuceeVm", 0);
            result.put("org.lucee.extension.debugger.coreinject.ValTracker$CleanerRunner", 0);
            result.put("org.lucee.extension.debugger.coreinject.ExprEvaluator", 0);
            result.put("org.lucee.extension.debugger.coreinject.Iife", 0);
            result.put("org.lucee.extension.debugger.coreinject.Iife$Supplier2", 0);
            result.put("org.lucee.extension.debugger.coreinject.ExprEvaluator$Evaluator", 0);
            result.put("org.lucee.extension.debugger.coreinject.ExprEvaluator$Lucee6Evaluator", 1);
            result.put("org.lucee.extension.debugger.coreinject.ExprEvaluator$Lucee5Evaluator", 1);
            result.put("org.lucee.extension.debugger.coreinject.frame.DebugFrame", 0);
            result.put("org.lucee.extension.debugger.coreinject.frame.Frame", 1);
            result.put("org.lucee.extension.debugger.coreinject.frame.Frame$FrameContext", 1);
            result.put("org.lucee.extension.debugger.coreinject.frame.Frame$FrameContext$SupplierOrNull", 1);
            result.put("org.lucee.extension.debugger.coreinject.frame.DummyFrame", 1);
            result.put("org.lucee.extension.debugger.coreinject.frame.NativeDebugFrame", 1);
            result.put("org.lucee.extension.debugger.coreinject.NativeLuceeVm", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeLuceeVm$1", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeLuceeVm$2", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeLuceeVm$3", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeDebuggerListener", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeDebuggerListener$1", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeDebuggerListener$CachedExecutableLines", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeDebuggerListener$StepState", 0);
            result.put("org.lucee.extension.debugger.coreinject.NativeDebuggerListener$SuspendLocation", 0);
            result.put("org.lucee.extension.debugger.coreinject.StepMode", 0);
            result.put("org.lucee.extension.debugger.util.ConcurrentWeakKeyMap", 0);
            result.put("org.lucee.extension.debugger.util.ConcurrentWeakKeyMap$IdentityWeakReference", 0);
            result.put("org.lucee.extension.debugger.util.ConcurrentWeakKeyMap$LookupKey", 0);
            result.put("org.lucee.extension.debugger.util.ExpiringLruCache", 0);
            result.put("org.lucee.extension.debugger.util.ExpiringLruCache$Entry", 0);
            return result;
        }

        public static Comparator<LuceeTransformer.ClassInjection> comparator() {
            Map<String, Integer> ordering = CoreInjectionLinearization.linearizedCoreInjectClasses();
            return Comparator.comparing(injection -> {
                Integer v = (Integer)ordering.get(injection.name);
                if (v == null) {
                    throw new RuntimeException("Missing linearized sort order information for class '" + injection.name + "'");
                }
                return v;
            });
        }
    }
}

