/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.StopIteration;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Enumerator::Producer"})
public class RubyProducer
extends RubyObject {
    private IRubyObject init;
    private Block producerBlock;
    private IRubyObject size;

    public static RubyClass createProducerClass(ThreadContext context, RubyClass Object2, RubyClass Enumerator2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)Enumerator2.defineClassUnder(context, "Producer", Object2, RubyProducer::new)).include(context, Enumerable)).defineMethods(context, RubyProducer.class);
    }

    public RubyProducer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyProducer(Ruby runtime2, RubyClass klass, IRubyObject init, Block block) {
        this(runtime2, klass, init, block, runtime2.getNil());
    }

    public RubyProducer(Ruby runtime2, RubyClass klass, IRubyObject init, Block block, IRubyObject size2) {
        super(runtime2, klass);
        this.init = init;
        this.producerBlock = block;
        this.size = size2;
    }

    public static RubyProducer newProducer(ThreadContext context, IRubyObject init, Block block) {
        return RubyProducer.newProducer(context, init, block, context.nil);
    }

    public static RubyProducer newProducer(ThreadContext context, IRubyObject init, Block block, IRubyObject size2) {
        return new RubyProducer(context.runtime, context.runtime.getProducer(), init, block, size2);
    }

    public static IRubyObject size(ThreadContext context, RubyProducer self2, IRubyObject[] args2) {
        IRubyObject size2 = self2.size;
        if (size2.isNil()) {
            return size2;
        }
        if (size2 instanceof RubyInteger || size2 instanceof RubyFloat) {
            return size2;
        }
        return RubyProducer.sites((ThreadContext)context).call.call(context, self2, size2);
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject cur;
        if (this.init == null) {
            cur = context.nil;
        } else {
            cur = this.init;
            block.yield(context, cur);
        }
        try {
            while (true) {
                cur = this.producerBlock.call(context, cur);
                block.yield(context, cur);
            }
        }
        catch (StopIteration si) {
            return this;
        }
    }

    private static JavaSites.ProducerSites sites(ThreadContext context) {
        return context.sites.Producer;
    }
}

