/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Objects;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Appendable;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.Block;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.SimpleHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.cli.Options;
import org.jruby.util.io.RubyInputStream;

public abstract class RubyFixnum
extends RubyInteger
implements Constantizable,
Appendable,
SimpleHash {
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    private static final BigInteger MIN_NEGATED = BigInteger.valueOf(Long.MIN_VALUE).negate();
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    public static final boolean USE_CACHE = Options.USE_FIXNUM_CACHE.load();
    public static final int CACHE_OFFSET;

    public static RubyClass createFixnumClass(ThreadContext context, RubyClass fixnum) {
        RubyFixnum[] cache = context.runtime.fixnumCache;
        for (int i2 = 0; i2 < cache.length; ++i2) {
            cache[i2] = RubyFixnum.newFixnumForCache(fixnum, i2 - CACHE_OFFSET);
        }
        return fixnum;
    }

    private static IRubyObject fixCoerce(ThreadContext context, IRubyObject x) {
        while (!((x = Convert.toInteger(context, x)) instanceof RubyFixnum) && !(x instanceof RubyBignum)) {
        }
        return x;
    }

    @Deprecated(since="10.0.3.0", forRemoval=true)
    public RubyFixnum(Ruby runtime2) {
        this(runtime2, 0L);
    }

    @Deprecated(since="10.0.3.0", forRemoval=true)
    public RubyFixnum(Ruby runtime2, long value2) {
        super(runtime2.getFixnum());
        this.setFrozen(true);
    }

    private RubyFixnum(RubyClass klazz) {
        super(klazz);
        this.setFrozen(true);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.FIXNUM;
    }

    @Override
    public Object constant() {
        Object[] fixnumConstants;
        Object constant = null;
        long value2 = this.getValue();
        if (value2 < (long)CACHE_OFFSET && value2 >= (long)(-CACHE_OFFSET) && (constant = (fixnumConstants = this.metaClass.runtime.fixnumConstants)[(int)value2 + CACHE_OFFSET]) == null) {
            fixnumConstants[(int)value2 + RubyFixnum.CACHE_OFFSET] = constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
        }
        return constant;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.getValue() == ((RubyFixnum)other).getValue();
    }

    @Override
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        long value2 = this.getValue();
        if (RubyFixnum.fixnumable(value2)) {
            return Convert.asBoolean(context, this == obj || this.eql(obj));
        }
        return super.equal_p(context, obj);
    }

    private static boolean fixnumable(long value2) {
        return value2 <= 0x3FFFFFFFFFFFFFFFL && value2 >= -4611686018427387904L;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        throw Error.typeError(context, "can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    @JRubyAPI
    public BigInteger asBigInteger(ThreadContext context) {
        return BigInteger.valueOf(this.getValue());
    }

    @Override
    @JRubyAPI
    public double asDouble(ThreadContext context) {
        return this.getValue();
    }

    @Override
    @JRubyAPI
    public int asInt(ThreadContext context) {
        return (int)this.getValue();
    }

    @Override
    @JRubyAPI
    public long asLong(ThreadContext context) {
        return this.getValue();
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public double getDoubleValue() {
        return this.getValue();
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public long getLongValue() {
        return this.getValue();
    }

    @JRubyAPI
    public abstract long getValue();

    @Override
    @JRubyAPI
    public int signum(ThreadContext context) {
        return Long.signum(this.getValue());
    }

    @Override
    public RubyInteger negate(ThreadContext context) {
        return RubyFixnum.negate(context, this.getValue());
    }

    public static RubyFixnum newFixnum(Ruby runtime2, long value2) {
        if (value2 > Integer.MAX_VALUE || value2 < Integer.MIN_VALUE) {
            return new LongFixnum(runtime2.getInteger(), value2);
        }
        return RubyFixnum.newFixnum(runtime2, (int)value2);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, int value2) {
        if (value2 > Short.MAX_VALUE || value2 < Short.MIN_VALUE) {
            return new IntFixnum(runtime2.getInteger(), value2);
        }
        return RubyFixnum.newFixnum(runtime2, (short)value2);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, short value2) {
        if (value2 > 127 || value2 < -128) {
            return USE_CACHE && RubyFixnum.isInCacheRange(value2) ? RubyFixnum.cachedFixnum(runtime2, value2) : new ShortFixnum(runtime2.getInteger(), value2);
        }
        return RubyFixnum.newFixnum(runtime2, (byte)value2);
    }

    public static RubyFixnum newFixnum(Ruby runtime2, byte value2) {
        return USE_CACHE && RubyFixnum.isInCacheRange(value2) ? RubyFixnum.cachedFixnum(runtime2, value2) : new ShortFixnum(runtime2.getInteger(), value2);
    }

    private static RubyFixnum newFixnumForCache(RubyClass fixnum, int value2) {
        if (value2 > Short.MAX_VALUE || value2 < Short.MIN_VALUE) {
            return new IntFixnum(fixnum, value2);
        }
        if (value2 > 127 || value2 < -128) {
            return new ShortFixnum(fixnum, (short)value2);
        }
        return new ShortFixnum(fixnum, (byte)value2);
    }

    private static boolean isInCacheRange(int value2) {
        return value2 <= CACHE_OFFSET - 1 && value2 >= -CACHE_OFFSET;
    }

    private static RubyFixnum cachedFixnum(Ruby runtime2, int value2) {
        return runtime2.fixnumCache[value2 + CACHE_OFFSET];
    }

    @Deprecated(since="9.2.1.0")
    public final RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getCurrentContext().runtime, newValue);
    }

    public static RubyFixnum zero(Ruby runtime2) {
        return CACHE_OFFSET > 0 ? runtime2.fixnumCache[CACHE_OFFSET] : new ShortFixnum(runtime2.getInteger(), 0);
    }

    public static RubyFixnum one(Ruby runtime2) {
        return CACHE_OFFSET > 1 ? runtime2.fixnumCache[CACHE_OFFSET + 1] : new ShortFixnum(runtime2.getInteger(), 1);
    }

    public static RubyFixnum two(Ruby runtime2) {
        return CACHE_OFFSET > 2 ? runtime2.fixnumCache[CACHE_OFFSET + 2] : new ShortFixnum(runtime2.getInteger(), 2);
    }

    public static RubyFixnum three(Ruby runtime2) {
        return CACHE_OFFSET > 3 ? runtime2.fixnumCache[CACHE_OFFSET + 3] : new ShortFixnum(runtime2.getInteger(), 3);
    }

    public static RubyFixnum four(Ruby runtime2) {
        return CACHE_OFFSET > 4 ? runtime2.fixnumCache[CACHE_OFFSET + 4] : new ShortFixnum(runtime2.getInteger(), 4);
    }

    public static RubyFixnum five(Ruby runtime2) {
        return CACHE_OFFSET > 5 ? runtime2.fixnumCache[CACHE_OFFSET + 5] : new ShortFixnum(runtime2.getInteger(), 5);
    }

    public static RubyFixnum minus_one(Ruby runtime2) {
        return -CACHE_OFFSET <= -1 ? runtime2.fixnumCache[CACHE_OFFSET - 1] : new ShortFixnum(runtime2.getInteger(), -1);
    }

    @Override
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.longHashCode());
    }

    @Override
    public final int hashCode() {
        return (int)this.longHashCode();
    }

    @Override
    public long longHashCode() {
        return Helpers.multAndMix(Ruby.getHashSeed0(), this.getValue());
    }

    @Override
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            long value2 = this.getValue();
            boolean checkArity = block.type.checkArity;
            if (block.getSignature() == Signature.NO_ARGUMENTS) {
                if (checkArity) {
                    IRubyObject nil = context.nil;
                    for (long i2 = 0L; i2 < value2; ++i2) {
                        block.yieldSpecific(context, nil);
                    }
                } else {
                    for (long i3 = 0L; i3 < value2; ++i3) {
                        block.yieldSpecific(context);
                    }
                }
            } else {
                for (long i4 = 0L; i4 < value2; ++i4) {
                    block.yield(context, Convert.asFixnum(context, i4));
                }
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "times", RubyInteger::timesSize);
    }

    @Override
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        long ndigits = Convert.toLong(context, arg2);
        if (ndigits >= 0L) {
            return this;
        }
        RubyNumeric f = Numeric.int_pow(context, 10L, -ndigits);
        if (f instanceof RubyFixnum) {
            boolean neg;
            RubyFixnum fixnum = (RubyFixnum)f;
            long x = this.getValue();
            long y = fixnum.getValue();
            boolean bl = neg = x < 0L;
            x = neg ? -x : (x += y - 1L);
            x = x / y * y;
            if (neg) {
                x = -x;
            }
            return Convert.asFixnum(context, x);
        }
        return this.integerCeil(context, f);
    }

    @Override
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        long ndigits = Convert.toLong(context, arg2);
        if (ndigits >= 0L) {
            return this;
        }
        RubyInteger f = (RubyInteger)Numeric.int_pow(context, 10L, -ndigits);
        if (f instanceof RubyFixnum) {
            boolean neg;
            RubyFixnum fixnum = (RubyFixnum)f;
            long x = this.getValue();
            long y = fixnum.getValue();
            boolean bl = neg = x < 0L;
            if (neg) {
                x = -x + y - 1L;
            }
            x = x / y * y;
            if (neg) {
                x = -x;
            }
            return Convert.asFixnum(context, x);
        }
        return this.integerFloor(context, f);
    }

    @Override
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        long self2 = this.getValue();
        if (self2 > 0L) {
            return this.floor(context, arg2);
        }
        if (self2 < 0L) {
            return this.ceil(context, arg2);
        }
        return this;
    }

    @Override
    public RubyArray digits(ThreadContext context, IRubyObject baseArg) {
        long value2 = this.getValue();
        if (value2 < 0L) {
            throw context.runtime.newMathDomainError("out of domain");
        }
        RubyInteger base = Convert.toInteger(context, baseArg);
        if (base instanceof RubyBignum) {
            RubyBignum bigBase = (RubyBignum)base;
            return RubyBignum.newBignum(context.runtime, value2).digits(context, bigBase);
        }
        long longBase = ((RubyFixnum)base).getValue();
        if (longBase < 0L) {
            throw Error.argumentError(context, "negative radix");
        }
        if (longBase < 2L) {
            throw Error.argumentError(context, "invalid radix: " + longBase);
        }
        if (value2 == 0L) {
            return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, 0));
        }
        RubyArray<?> res = Create.allocArray(context, (int)(Math.log(value2) / Math.log(longBase)) + 1);
        do {
            res.append(context, Convert.asFixnum(context, value2 % longBase));
        } while ((value2 /= longBase) > 0L);
        return res;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString to_s(IRubyObject[] args2) {
        ThreadContext context = this.getCurrentContext();
        return switch (args2.length) {
            case 0 -> this.to_s(context);
            case 1 -> this.to_s(context, args2[0]);
            default -> throw Error.argumentError(context, args2.length, 1);
        };
    }

    @Override
    public RubyString to_s(ThreadContext context) {
        return this.longToString(context, this.getValue(), 10);
    }

    @Override
    public RubyString to_s(ThreadContext context, IRubyObject arg0) {
        int base = Convert.toInt(context, arg0);
        if (base < 2 || base > 36) {
            throw Error.argumentError(context, "illegal radix " + base);
        }
        return this.longToString(context, this.getValue(), base);
    }

    private RubyString longToString(ThreadContext context, long value2, int base) {
        return base == 10 && value2 >= -256L && value2 < 256L ? Create.newSharedString(context, ConvertBytes.byteToSharedByteList((short)value2), USASCIIEncoding.INSTANCE) : Create.newString(context, ConvertBytes.longToByteList(value2, base), (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Deprecated(since="9.0.0.0")
    public IRubyObject to_sym() {
        ThreadContext context = this.getCurrentContext();
        RubySymbol symbol = RubySymbol.getSymbolLong(context.runtime, this.getValue());
        return symbol != null ? symbol : context.nil;
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyFixnum.negate(context, this.getValue());
    }

    private static RubyInteger negate(ThreadContext context, long value2) {
        return value2 == Long.MIN_VALUE ? RubyBignum.newBignum(context.runtime, MIN_NEGATED) : Convert.asFixnum(context, -value2);
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            return this.op_plus(context, fixnum.getValue());
        }
        return this.addOther(context, other);
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, long other) {
        long result2;
        long value2 = this.getValue();
        if (RubyFixnum.addOverflowed(other, value2, result2 = value2 + other)) {
            return RubyFixnum.addAsBignum(context, value2, other);
        }
        return Convert.asFixnum(context, result2);
    }

    private static boolean addOverflowed(long other, long value2, long result2) {
        return ((value2 ^ result2) & (other ^ result2)) < 0L;
    }

    public IRubyObject op_plus(ThreadContext context, double other) {
        return Convert.asFloat(context, (double)this.getValue() + other);
    }

    public IRubyObject op_plus_one(ThreadContext context) {
        long value2 = this.getValue();
        if (value2 == Long.MAX_VALUE) {
            return RubyFixnum.addAsBignum(context, value2, BigInteger.ONE);
        }
        return Convert.asFixnum(context, value2 + 1L);
    }

    public IRubyObject op_plus_two(ThreadContext context) {
        long value2 = this.getValue();
        if (value2 >= 0x7FFFFFFFFFFFFFFDL) {
            return RubyFixnum.addAsBignum(context, value2, BigInteger.TWO);
        }
        return Convert.asFixnum(context, value2 + 2L);
    }

    private static RubyInteger addAsBignum(ThreadContext context, long value2, long other) {
        return RubyBignum.bignorm(context.runtime, BigInteger.valueOf(value2).add(BigInteger.valueOf(other)));
    }

    private static RubyInteger addAsBignum(ThreadContext context, long value2, BigInteger other) {
        return RubyBignum.bignorm(context.runtime, BigInteger.valueOf(value2).add(other));
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield bignum.op_plus(context, this.getValue());
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield this.op_plus(context, flote.value);
            }
            default -> this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_plus, other);
        };
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            return this.op_minus(context, fixnum.getValue());
        }
        return this.subtractOther(context, other);
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, long other) {
        long result2;
        long value2 = this.getValue();
        if (((value2 ^ other) & (value2 ^ (result2 = value2 - other))) < 0L) {
            return this.subtractAsBignum(context, other);
        }
        return Convert.asFixnum(context, result2);
    }

    public IRubyObject op_minus(ThreadContext context, double other) {
        return Convert.asFloat(context, (double)this.getValue() - other);
    }

    public IRubyObject op_minus_one(ThreadContext context) {
        long value2 = this.getValue();
        if (value2 == Long.MIN_VALUE) {
            return this.subtractAsBignum(context, BigInteger.ONE);
        }
        return Convert.asFixnum(context, value2 - 1L);
    }

    public IRubyObject op_minus_two(ThreadContext context) {
        long value2 = this.getValue();
        if (value2 <= -9223372036854775807L) {
            return this.subtractAsBignum(context, 2L);
        }
        return Convert.asFixnum(context, value2 - 2L);
    }

    private RubyInteger subtractAsBignum(ThreadContext context, long other) {
        return RubyBignum.bignorm(context.runtime, BigInteger.valueOf(this.getValue()).subtract(BigInteger.valueOf(other)));
    }

    private RubyInteger subtractAsBignum(ThreadContext context, BigInteger other) {
        return RubyBignum.bignorm(context.runtime, BigInteger.valueOf(this.getValue()).subtract(other));
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield RubyBignum.bignorm(context.runtime, BigInteger.valueOf(this.getValue()).subtract(((RubyBignum)other).value));
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield this.op_minus(context, flote.value);
            }
            default -> this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_minus, other);
        };
    }

    @Override
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            iRubyObject = this.op_mul(context, fixnum.getValue());
        } else {
            iRubyObject = this.multiplyOther(context, other);
        }
        return iRubyObject;
    }

    private IRubyObject multiplyOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            return bignum.op_mul(context, this.getValue());
        }
        if (other instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)other;
            return this.op_mul(context, flote.value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_times, other);
    }

    @Override
    public IRubyObject op_mul(ThreadContext context, long other) {
        long value2 = this.getValue();
        long low = value2 * other;
        long high = Math.multiplyHigh(value2, other);
        if (high == 0L && low >= 0L || high == -1L && low < 0L) {
            return Convert.asFixnum(context, low);
        }
        return RubyFixnum.multiplyAsBignum(context, value2, other);
    }

    private static RubyInteger multiplyAsBignum(ThreadContext context, long value2, long other) {
        return RubyBignum.bignorm(context.runtime, BigInteger.valueOf(value2).multiply(BigInteger.valueOf(other)));
    }

    public IRubyObject op_mul(ThreadContext context, double other) {
        return context.runtime.newFloat((double)this.getValue() * other);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        this.checkZeroDivisionError(context, other);
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.getValue(), ((RubyFixnum)other).getValue());
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).div, other);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, long other) {
        return this.idivLong(context, this.getValue(), other);
    }

    @Override
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.getValue(), ((RubyFixnum)other).getValue());
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_quo, other);
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.idivLong(context, this.getValue(), other);
    }

    @Override
    public RubyBoolean odd_p(ThreadContext context) {
        return (this.getValue() & 1L) != 0L ? context.tru : context.fals;
    }

    @Override
    public RubyBoolean even_p(ThreadContext context) {
        return (this.getValue() & 1L) == 0L ? context.tru : context.fals;
    }

    @Override
    public IRubyObject pred(ThreadContext context) {
        return this.op_minus_one(context);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject idiv(ThreadContext context, IRubyObject other, String method2) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.getValue(), ((RubyFixnum)other).getValue());
        }
        return this.coerceBin(context, method2, other);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other, CallSite site) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.getValue(), ((RubyFixnum)other).getValue());
        }
        return this.coerceBin(context, site, other);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject idiv(ThreadContext context, long y, String method2) {
        long x = this.getValue();
        return this.idivLong(context, x, y);
    }

    private RubyInteger idivLong(ThreadContext context, long x, long y) {
        long result2;
        if (y == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        if (y > 0L) {
            result2 = x >= 0L ? x / y : (x + 1L) / y - 1L;
        } else if (x > 0L) {
            result2 = (x - 1L) / y - 1L;
        } else if (y == -1L) {
            if (x == Long.MIN_VALUE) {
                return RubyBignum.newBignum(context.runtime, MIN_NEGATED);
            }
            result2 = -x;
        } else {
            result2 = x / y;
        }
        return Convert.asFixnum(context, result2);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.moduloFixnum(context, (RubyFixnum)other);
        }
        this.checkZeroDivisionError(context, other);
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_mod, other);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.moduloFixnum(context, other);
    }

    @Override
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    IRubyObject modulo(ThreadContext context, long other) {
        return this.op_mod(context, other);
    }

    private IRubyObject moduloFixnum(ThreadContext context, RubyFixnum other) {
        return this.moduloFixnum(context, other.getValue());
    }

    private IRubyObject moduloFixnum(ThreadContext context, long other) {
        long x = this.getValue();
        long y = other;
        if (y == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            mod += y;
        }
        return Convert.asFixnum(context, mod);
    }

    @Override
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.divmodFixnum(context, (RubyFixnum)other);
        }
        this.checkZeroDivisionError(context, other);
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).divmod, other);
    }

    private IRubyObject divmodFixnum(ThreadContext context, RubyFixnum other) {
        long mod;
        RubyInteger integerDiv;
        long x = this.getValue();
        long y = other.getValue();
        if (y == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        if (y == -1L) {
            integerDiv = x == Long.MIN_VALUE ? RubyBignum.newBignum(context.runtime, MIN_NEGATED) : Convert.asFixnum(context, -x);
            mod = 0L;
        } else {
            long div2 = x / y;
            mod = x - y * div2;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div2;
                mod += y;
            }
            integerDiv = Convert.asFixnum(context, div2);
        }
        RubyFixnum fixMod = Convert.asFixnum(context, mod);
        return Create.newArray(context, (IRubyObject)integerDiv, (IRubyObject)fixMod);
    }

    @Override
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.powerFixnum(context, (RubyFixnum)other);
        }
        if (other instanceof RubyBignum) {
            return this.powerOther(context, other);
        }
        if (other instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)other;
            double d_other = flote.asDouble(context);
            if (this.getValue() < 0L && d_other != (double)Math.round(d_other)) {
                RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                return RubyFixnum.numFuncall(context, complex, RubyFixnum.sites((ThreadContext)context).op_exp_complex, other);
            }
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_exp, other);
    }

    public IRubyObject op_pow(ThreadContext context, long other) {
        return this.powerFixnum(context, Convert.asFixnum(context, other));
    }

    private IRubyObject powerOther(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        long a = this.getValue();
        if (other instanceof RubyBignum) {
            if (a == 1L) {
                return RubyFixnum.one(runtime2);
            }
            if (a == -1L) {
                return ((RubyBignum)other).even_p(context).isTrue() ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
            }
            if (RubyFixnum.sites((ThreadContext)context).op_lt_bignum.call(context, other, other, (IRubyObject)RubyFixnum.zero(runtime2)).isTrue()) {
                RubyRational rational = RubyRational.newRationalRaw(runtime2, this);
                return RubyFixnum.numFuncall(context, rational, RubyFixnum.sites((ThreadContext)context).op_exp_rational, other);
            }
            if (a == 0L) {
                return RubyFixnum.zero(runtime2);
            }
            return RubyBignum.newBignum(runtime2, RubyBignum.long2big(a)).op_pow(context, other);
        }
        if (other instanceof RubyFloat) {
            double b2 = ((RubyFloat)other).value;
            if (b2 == 0.0 || a == 1L) {
                return runtime2.newFloat(1.0);
            }
            if (a == 0L) {
                return runtime2.newFloat(b2 < 0.0 ? Double.POSITIVE_INFINITY : 0.0);
            }
            return RubyFloat.newFloat(runtime2, Math.pow(a, b2));
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).op_exp, other);
    }

    private RubyNumeric powerFixnum(ThreadContext context, RubyFixnum other) {
        long a = this.getValue();
        long b2 = other.getValue();
        if (a == 1L) {
            return Convert.asFixnum(context, 1);
        }
        if (a == -1L) {
            return Convert.asFixnum(context, b2 % 2L != 0L ? -1 : 1);
        }
        if (b2 < 0L) {
            return this.fixPowInverted(context, -b2);
        }
        if (b2 == 0L) {
            return Convert.asFixnum(context, 1);
        }
        if (b2 == 1L) {
            return this;
        }
        if (a == 0L) {
            return Convert.asFixnum(context, 0);
        }
        return Numeric.int_pow(context, a, b2);
    }

    private RubyNumeric fixPowInverted(ThreadContext context, long minusb) {
        if (this.getValue() == 0L) {
            throw Error.zeroDivisionError(context);
        }
        IRubyObject y = this.op_pow(context, minusb);
        if (y instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)y;
            double d = Math.pow(this.getValue(), flote.value);
            return Convert.asFloat(context, 1.0 / d);
        }
        return RubyRational.newRationalRaw(context.runtime, Convert.asFixnum(context, 1), y);
    }

    protected IRubyObject intPowTmp1(ThreadContext context, RubyInteger y, long mm, boolean negaFlg) {
        long xx = this.getValue();
        long tmp = 1L;
        RubyFixnum one = Convert.asFixnum(context, 1);
        while (!(y instanceof RubyFixnum)) {
            if (Numeric.f_odd_p(context, y)) {
                tmp = tmp * xx % mm;
            }
            xx = xx * xx % mm;
            y = (RubyInteger)RubyFixnum.sites((ThreadContext)context).op_rshift.call(context, (IRubyObject)y, (IRubyObject)y, (IRubyObject)one);
        }
        for (long yy = y.asLong(context); yy != 0L; yy >>= 1) {
            if ((yy & 1L) != 0L) {
                tmp = tmp * xx % mm;
            }
            xx = xx * xx % mm;
        }
        if (negaFlg && tmp != 0L) {
            tmp -= mm;
        }
        return Convert.asFixnum(context, tmp);
    }

    @Deprecated(since="9.2.7.0")
    protected IRubyObject intPowTmp2(ThreadContext context, IRubyObject y, long mm, boolean negaFlg) {
        return this.intPowTmp2(context, (RubyInteger)y, mm, negaFlg);
    }

    IRubyObject intPowTmp2(ThreadContext context, RubyInteger y, long mm, boolean negaFlg) {
        long tmp = 1L;
        RubyFixnum tmp2 = Convert.asFixnum(context, tmp);
        RubyFixnum xx = this;
        while (!(y instanceof RubyFixnum)) {
            if (Numeric.f_odd_p(context, y)) {
                tmp2 = RubyFixnum.mulModulo(context, tmp2, xx, mm);
            }
            xx = RubyFixnum.mulModulo(context, xx, xx, mm);
            y = (RubyInteger)RubyFixnum.sites((ThreadContext)context).op_rshift.call(context, (IRubyObject)y, (IRubyObject)y, (IRubyObject)RubyFixnum.one(context.runtime));
        }
        for (long yy = ((RubyFixnum)y).getValue(); yy != 0L; yy >>= 1) {
            if ((yy & 1L) != 0L) {
                tmp2 = RubyFixnum.mulModulo(context, tmp2, xx, mm);
            }
            xx = RubyFixnum.mulModulo(context, xx, xx, mm);
        }
        tmp = tmp2.getValue();
        if (negaFlg && tmp != 0L) {
            tmp -= mm;
        }
        return Convert.asFixnum(context, tmp);
    }

    private static RubyFixnum mulModulo(ThreadContext context, RubyFixnum a, RubyFixnum b2, long c) {
        return (RubyFixnum)((RubyInteger)a.op_mul(context, b2.getValue())).modulo(context, c);
    }

    @Override
    public IRubyObject abs(ThreadContext context) {
        if (this.getValue() < 0L) {
            if (this.getValue() == Long.MIN_VALUE) {
                return RubyBignum.newBignum(context.runtime, MIN_NEGATED);
            }
            return Convert.asFixnum(context, -this.getValue());
        }
        return this;
    }

    @Override
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return other instanceof RubyFixnum ? this.op_equal(context, ((RubyFixnum)other).getValue()) : this.op_equalOther(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() == other);
    }

    public IRubyObject op_equal(ThreadContext context, double other) {
        return Convert.asBoolean(context, (double)this.getValue() == other);
    }

    @Override
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return other instanceof RubyFixnum ? this.op_not_equal(context, ((RubyFixnum)other).getValue()) : super.op_not_equal(context, other);
    }

    public IRubyObject op_not_equal(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() != other);
    }

    public IRubyObject op_not_equal(ThreadContext context, double other) {
        return Convert.asBoolean(context, (double)this.getValue() != other);
    }

    public boolean op_equal_boolean(ThreadContext context, long other) {
        return this.getValue() == other;
    }

    public final boolean fastEqual(RubyFixnum other) {
        return this.getValue() == other.getValue();
    }

    private IRubyObject op_equalOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            return Convert.asBoolean(context, BigInteger.valueOf(this.getValue()).compareTo(bignum.value) == 0);
        }
        if (other instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)other;
            return this.op_equal(context, flote.value);
        }
        return super.op_num_equal(context, other);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            return this.getValue() == ((RubyFixnum)other).getValue();
        }
        return false;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            long otherValue = fixnum.getValue();
            return this.getValue() == otherValue ? 0 : (this.getValue() > otherValue ? 1 : -1);
        }
        return this.compareToOther(other);
    }

    private int compareToOther(IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield BigInteger.valueOf(this.getValue()).compareTo(bignum.value);
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Double.compare(this.getValue(), flote.value);
            }
            default -> {
                ThreadContext context = this.getRuntime().getCurrentContext();
                yield Convert.toInt(context, this.coerceCmp(context, RubyFixnum.sites((ThreadContext)context).op_cmp, other));
            }
        };
    }

    @Override
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            iRubyObject = this.op_cmp(context, fixnum.getValue());
        } else {
            iRubyObject = this.compareOther(context, other);
        }
        return iRubyObject;
    }

    public IRubyObject op_cmp(ThreadContext context, long other) {
        return this.getValue() == other ? Convert.asFixnum(context, 0) : Convert.asFixnum(context, this.getValue() > other ? 1 : -1);
    }

    public IRubyObject op_cmp(ThreadContext context, double other) {
        return RubyFixnum.dbl_cmp(context.runtime, this.getValue(), other);
    }

    private IRubyObject compareOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.asFixnum(context, BigInteger.valueOf(this.getValue()).compareTo(bignum.value));
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield RubyFixnum.dbl_cmp(context.runtime, this.getValue(), flote.value);
            }
            default -> this.coerceCmp(context, RubyFixnum.sites((ThreadContext)context).op_cmp, other);
        };
    }

    @Override
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            iRubyObject = Convert.asBoolean(context, this.getValue() > fixnum.getValue());
        } else {
            iRubyObject = this.op_gtOther(context, other);
        }
        return iRubyObject;
    }

    public IRubyObject op_gt(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() > other);
    }

    public boolean op_gt_boolean(ThreadContext context, long other) {
        return this.getValue() > other;
    }

    private IRubyObject op_gtOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.asBoolean(context, BigInteger.valueOf(this.getValue()).compareTo(bignum.value) > 0);
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Convert.asBoolean(context, (double)this.getValue() > flote.value);
            }
            default -> this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_gt, other);
        };
    }

    @Override
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            iRubyObject = Convert.asBoolean(context, this.getValue() >= fixnum.getValue());
        } else {
            iRubyObject = this.op_geOther(context, other);
        }
        return iRubyObject;
    }

    public IRubyObject op_ge(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() >= other);
    }

    public boolean op_ge_boolean(ThreadContext context, long other) {
        return this.getValue() >= other;
    }

    private IRubyObject op_geOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.asBoolean(context, BigInteger.valueOf(this.getValue()).compareTo(bignum.value) >= 0);
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Convert.asBoolean(context, (double)this.getValue() >= flote.value);
            }
            default -> this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_ge, other);
        };
    }

    @Override
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_lt(context, ((RubyFixnum)other).getValue());
        }
        return this.op_ltOther(context, other);
    }

    public IRubyObject op_lt(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() < other);
    }

    public boolean op_lt_boolean(ThreadContext context, long other) {
        return this.getValue() < other;
    }

    private IRubyObject op_ltOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return Convert.asBoolean(context, BigInteger.valueOf(this.getValue()).compareTo(((RubyBignum)other).value) < 0);
        }
        if (other instanceof RubyFloat) {
            return Convert.asBoolean(context, (double)this.getValue() < ((RubyFloat)other).value);
        }
        return this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_lt, other);
    }

    @Override
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return Convert.asBoolean(context, this.getValue() <= ((RubyFixnum)other).getValue());
        }
        return this.op_leOther(context, other);
    }

    public IRubyObject op_le(ThreadContext context, long other) {
        return Convert.asBoolean(context, this.getValue() <= other);
    }

    public boolean op_le_boolean(ThreadContext context, long other) {
        return this.getValue() <= other;
    }

    private IRubyObject op_leOther(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.asBoolean(context, BigInteger.valueOf(this.getValue()).compareTo(bignum.value) <= 0);
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Convert.asBoolean(context, (double)this.getValue() <= flote.value);
            }
            default -> this.coerceRelOp(context, RubyFixnum.sites((ThreadContext)context).op_le, other);
        };
    }

    @Override
    public IRubyObject op_neg(ThreadContext context) {
        return Convert.asFixnum(context, this.getValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield Convert.asFixnum(context, this.getValue() & fixnum.getValue());
            }
            case 1 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield bignum.op_and(context, this);
            }
            default -> this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_and, other);
        };
    }

    public IRubyObject op_and(ThreadContext context, long other) {
        return Convert.asFixnum(context, this.getValue() & other);
    }

    @Override
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield Convert.asFixnum(context, this.getValue() | fixnum.getValue());
            }
            case 1 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield bignum.op_or(context, this);
            }
            default -> this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_or, other);
        };
    }

    public IRubyObject op_or(ThreadContext context, long other) {
        return Convert.asFixnum(context, this.getValue() | other);
    }

    @Override
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield Convert.asFixnum(context, this.getValue() ^ fixnum.getValue());
            }
            case 1 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield bignum.op_xor(context, this);
            }
            default -> this.coerceBit(context, RubyFixnum.sites((ThreadContext)context).checked_op_xor, other);
        };
    }

    public IRubyObject op_xor(ThreadContext context, long other) {
        return Convert.asFixnum(context, this.getValue() ^ other);
    }

    @Override
    protected IRubyObject op_aref_subclass(ThreadContext context, IRubyObject other) {
        BigInteger big;
        if (!(other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(context, other)) instanceof RubyFixnum || (other = RubyBignum.bignorm(context.runtime, big = ((RubyBignum)other).value)) instanceof RubyFixnum)) {
            return Convert.asFixnum(context, big.signum() == 0 || this.getValue() >= 0L ? 0 : 1);
        }
        long otherValue = ((RubyFixnum)other).getValue();
        if (otherValue < 0L) {
            return Convert.asFixnum(context, 0);
        }
        if (63L < otherValue) {
            return Convert.asFixnum(context, this.getValue() < 0L ? 1 : 0);
        }
        return Convert.asFixnum(context, (this.getValue() & 1L << (int)otherValue) == 0L ? 0 : 1);
    }

    @Override
    public IRubyObject op_lshift(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(context.runtime, this.getValue()).op_lshift(context, other);
        }
        return this.op_lshift(context, ((RubyFixnum)other).getValue());
    }

    @Override
    public RubyInteger op_lshift(ThreadContext context, long width) {
        return width < 0L ? this.rshift(context, -width) : this.lshift(context, width);
    }

    private RubyInteger lshift(ThreadContext context, long width) {
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.getValue()) != 0L) {
            return RubyBignum.newBignum(context.runtime, this.getValue()).op_lshift(context, width);
        }
        return Convert.asFixnum(context, this.getValue() << (int)width);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_lshift(long width) {
        return this.op_lshift(this.getCurrentContext(), width);
    }

    @Override
    public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            iRubyObject = this.op_rshift(context, fix2.getValue());
        } else {
            iRubyObject = RubyBignum.newBignum(context.runtime, this.getValue()).op_rshift(context, other);
        }
        return iRubyObject;
    }

    @Override
    public RubyInteger op_rshift(ThreadContext context, long width) {
        if (width == 0L) {
            return this;
        }
        return width < 0L ? this.lshift(context, -width) : this.rshift(context, width);
    }

    private RubyFixnum rshift(ThreadContext context, long width) {
        return width >= 63L ? Convert.asFixnum(context, this.getValue() < 0L ? -1 : 0) : Convert.asFixnum(context, this.getValue() >> (int)width);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_rshift(long width) {
        return this.op_rshift(this.getCurrentContext(), width);
    }

    @Override
    public IRubyObject to_f(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getValue());
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.metaClass.runtime, this.getValue());
    }

    @Override
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, 8L);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject zero_p() {
        return this.zero_p(this.getCurrentContext());
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return Convert.asBoolean(context, this.getValue() == 0L);
    }

    @Override
    public final boolean isZero(ThreadContext context) {
        return this.getValue() == 0L;
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero(context) ? context.nil : this;
    }

    @Override
    final boolean isOne(ThreadContext context) {
        return this.getValue() == 1L;
    }

    @Override
    public IRubyObject succ(ThreadContext context) {
        return this.op_plus_one(context);
    }

    @Override
    public IRubyObject bit_length(ThreadContext context) {
        long tmpValue = this.getValue();
        if (tmpValue < 0L) {
            tmpValue = this.getValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Convert.asFixnum(context, 64 - Long.numberOfLeadingZeros(tmpValue));
    }

    @Override
    @Deprecated(since="10.0.3.0")
    public IRubyObject id() {
        long value2 = this.getValue();
        if (RubyFixnum.fixnumable(value2)) {
            return RubyFixnum.newFixnum(this.metaClass.runtime, 2L * value2 + 1L);
        }
        return super.id();
    }

    @Override
    public RubyInteger __id__(ThreadContext context) {
        long value2 = this.getValue();
        if (RubyFixnum.fixnumable(value2)) {
            return Convert.asFixnum(context, 2L * value2 + 1L);
        }
        return super.__id__(context);
    }

    @Override
    public String asJavaString() {
        throw Error.typeError(this.getRuntime().getCurrentContext(), "", this, " is not a symbol");
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    public static RubyFixnum unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        return Convert.asFixnum(context, input.unmarshalInt(context, in));
    }

    private void checkZeroDivisionError(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
    }

    @Override
    public RubyInteger convertToInteger(String method2) {
        return this;
    }

    @Override
    public IRubyObject fdivDouble(ThreadContext context, IRubyObject y) {
        if (y instanceof RubyFixnum) {
            RubyFixnum yy = (RubyFixnum)y;
            return context.runtime.newFloat((double)this.getValue() / (double)yy.getValue());
        }
        if (y instanceof RubyBignum) {
            return RubyBignum.newBignum(context.runtime, this.getValue()).fdivDouble(context, (RubyBignum)y);
        }
        if (y instanceof RubyFloat) {
            return context.runtime.newFloat((double)this.getValue() / ((RubyFloat)y).value);
        }
        return this.coerceBin(context, RubyFixnum.sites((ThreadContext)context).fdiv, y);
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        if (Builtins.checkIntegerLt(context)) {
            return Convert.asBoolean(context, this.getValue() < 0L);
        }
        return RubyFixnum.sites((ThreadContext)context).basic_op_lt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)Convert.asFixnum(context, 0));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        if (Builtins.checkIntegerGt(context)) {
            return Convert.asBoolean(context, this.getValue() > 0L);
        }
        return RubyFixnum.sites((ThreadContext)context).basic_op_gt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)Convert.asFixnum(context, 0));
    }

    @Override
    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = 8L;
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    @Override
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    public RubyRational convertToRational(ThreadContext context) {
        return RubyRational.newRationalRaw(context.runtime, this, Convert.asFixnum(context, 1));
    }

    @Override
    public IRubyObject remainder(ThreadContext context, IRubyObject y) {
        return this.numRemainder(context, y);
    }

    @Override
    public IRubyObject sqrt(ThreadContext context) {
        if (this.isNegativeNumber(context)) {
            throw context.runtime.newMathDomainError("isqrt");
        }
        return Convert.asFixnum(context, RubyFixnum.floorSqrt(this.getValue()));
    }

    @Override
    public void appendIntoString(RubyString target2) {
        if (target2.getEncoding().isAsciiCompatible()) {
            ConvertBytes.longIntoString(target2, this.getValue());
        } else {
            target2.catWithCodeRange(ConvertBytes.longToByteListCached(this.getValue()), 16);
        }
    }

    private static JavaSites.FixnumSites sites(ThreadContext context) {
        return context.sites.Fixnum;
    }

    @Deprecated(since="9.1.3.0")
    public static IRubyObject induced_from(IRubyObject recv2, IRubyObject other) {
        return RubyNumeric.num2fix(recv2.getRuntime().getCurrentContext(), other);
    }

    @Override
    @Deprecated(since="9.4.0.0")
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    static {
        int cacheRange = 0;
        if (USE_CACHE && (cacheRange = Options.FIXNUM_CACHE_RANGE.load().intValue()) < 0) {
            cacheRange = 0;
        }
        CACHE_OFFSET = cacheRange;
    }

    private static class LongFixnum
    extends RubyFixnum {
        final long value;

        public LongFixnum(RubyClass fixnum, long value2) {
            super(fixnum);
            this.value = value2;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static class IntFixnum
    extends RubyFixnum {
        final int value;

        public IntFixnum(RubyClass fixnum, int value2) {
            super(fixnum);
            this.value = value2;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static class ShortFixnum
    extends RubyFixnum {
        final short value;

        public ShortFixnum(RubyClass fixnum, short value2) {
            super(fixnum);
            this.value = value2;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static class ByteFixnum
    extends RubyFixnum {
        final byte value;

        public ByteFixnum(RubyClass fixnum, byte value2) {
            super(fixnum);
            this.value = value2;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }
}

