/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyMethods {
    private JavaProxyMethods() {
    }

    public static RubyModule createJavaProxyMethods(ThreadContext context) {
        return Define.defineModule(context, "JavaProxyMethods").defineMethods(context, JavaProxyMethods.class);
    }

    @JRubyMethod
    public static IRubyObject java_class(ThreadContext context, IRubyObject recv2) {
        return JavaProxy.getJavaClass(recv2.getMetaClass().getRealClass());
    }

    @JRubyMethod(name={"java_object", "to_java_object"})
    public static IRubyObject java_object(ThreadContext context, IRubyObject recv2) {
        Object javaObj = recv2.dataGetStruct();
        if (javaObj instanceof IRubyObject) {
            return (IRubyObject)javaObj;
        }
        return Java.getInstance(context.runtime, javaObj);
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject op_eql(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        return JavaProxyMethods.op_equal(context, recv2, obj);
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (recv2 instanceof JavaProxy) {
            return JavaProxyMethods.equals(context.runtime, ((JavaProxy)recv2).getObject(), other);
        }
        if (recv2.dataGetStruct() instanceof RubyBasicObject) {
            return ((RubyBasicObject)recv2.dataGetStruct()).op_equal(context, other);
        }
        return context.nil;
    }

    static RubyBoolean equals(Ruby runtime2, Object thisValue, IRubyObject other) {
        IRubyObject otherValue = JavaUtil.unwrapJava(other, RubyBasicObject.NEVER);
        if (otherValue == RubyBasicObject.NEVER) {
            return runtime2.getFalse();
        }
        if (thisValue == null) {
            return runtime2.newBoolean(otherValue == null);
        }
        return runtime2.newBoolean(thisValue.equals(otherValue));
    }

    @JRubyMethod
    public static IRubyObject to_s(ThreadContext context, IRubyObject recv2) {
        if (recv2 instanceof JavaProxy) {
            return JavaProxyMethods.to_s(context, ((JavaProxy)recv2).getObject());
        }
        Object data2 = recv2.dataGetStruct();
        return data2 instanceof IRubyObject ? ((RubyBasicObject)data2).to_s(context) : ((RubyBasicObject)recv2).to_s(context);
    }

    static IRubyObject to_s(ThreadContext context, Object javaObject) {
        if (javaObject == null) {
            return Create.newEmptyString(context);
        }
        String stringValue = javaObject.toString();
        return stringValue == null ? context.nil : RubyString.newUnicodeString(context.runtime, stringValue);
    }

    @Deprecated(since="10.0.0.0")
    static IRubyObject to_s(Ruby runtime2, Object javaObject) {
        return JavaProxyMethods.to_s(runtime2.getCurrentContext(), javaObject);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject inspect(IRubyObject recv2) {
        return JavaProxyMethods.inspect(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod
    public static IRubyObject inspect(ThreadContext context, IRubyObject recv2) {
        IRubyObject iRubyObject;
        if (recv2 instanceof RubyBasicObject) {
            RubyBasicObject basic = (RubyBasicObject)recv2;
            iRubyObject = basic.hashyInspect(context);
        } else {
            iRubyObject = recv2.inspect(context);
        }
        return iRubyObject;
    }

    @JRubyMethod
    public static IRubyObject hash(ThreadContext context, IRubyObject recv2) {
        RubyFixnum rubyFixnum;
        if (recv2 instanceof JavaProxy) {
            JavaProxy proxy2 = (JavaProxy)recv2;
            return Convert.asFixnum(context, proxy2.getObject().hashCode());
        }
        Object object = recv2.dataGetStruct();
        if (object instanceof IRubyObject) {
            IRubyObject dataStruct = (IRubyObject)object;
            rubyFixnum = ((RubyBasicObject)dataStruct).hash(context);
        } else {
            rubyFixnum = ((RubyBasicObject)recv2).hash(context);
        }
        return rubyFixnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"})
    public static IRubyObject rbSynchronized(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject value2;
        Object lock2;
        if (recv2 instanceof JavaProxy) {
            JavaProxy proxy2 = (JavaProxy)recv2;
            lock2 = proxy2.getObject();
            value2 = recv2;
        } else {
            IRubyObject dataStruct;
            Object object = recv2.dataGetStruct();
            value2 = object instanceof IRubyObject ? (dataStruct = (IRubyObject)object) : recv2;
            lock2 = value2;
        }
        Object object = lock2;
        synchronized (object) {
            return block.yield(context, value2);
        }
    }
}

