/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.cgi.escape;

import org.jcodings.Encoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Define;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public class CGIEscape
implements Library {
    public static final String ACCEPT_CHARSET = "@@accept_charset";
    public static final byte[] NO39 = "&#39;".getBytes(RubyEncoding.UTF8);
    public static final byte[] AMP = "&amp;".getBytes(RubyEncoding.UTF8);
    public static final byte[] QUOT = "&quot;".getBytes(RubyEncoding.UTF8);
    public static final byte[] LT = "&lt;".getBytes(RubyEncoding.UTF8);
    public static final byte[] GT = "&gt;".getBytes(RubyEncoding.UTF8);
    public static final int UNICODE_MAX = 0x10FFFF;
    public static final byte[] TSEMI = "t;".getBytes(RubyEncoding.UTF8);
    public static final byte[] UOTSEMI = "uot;".getBytes(RubyEncoding.UTF8);
    public static final byte[] MPSEMI = "mp;".getBytes(RubyEncoding.UTF8);
    public static final byte[] POSSEMI = "pos;".getBytes(RubyEncoding.UTF8);
    static final byte[] upper_hexdigits = "0123456789ABCDEF".getBytes(RubyEncoding.UTF8);
    private static final int[] ruby_digit36_to_number_table = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    static void html_escaped_cat(RubyString str, byte c) {
        switch (c) {
            case 39: {
                str.cat(NO39);
                break;
            }
            case 38: {
                str.cat(AMP);
                break;
            }
            case 34: {
                str.cat(QUOT);
                break;
            }
            case 60: {
                str.cat(LT);
                break;
            }
            case 62: {
                str.cat(GT);
            }
        }
    }

    static void preserve_original_state(RubyString orig, RubyString dest) {
        dest.setEncoding(orig.getEncoding());
    }

    static IRubyObject optimized_escape_html(Ruby runtime2, RubyString str) {
        int beg = 0;
        RubyString dest = null;
        int len = str.size();
        ByteList byteList = str.getByteList();
        byte[] cstrBytes = byteList.unsafeBytes();
        int cstr = byteList.begin();
        for (int i2 = 0; i2 < len; ++i2) {
            switch (cstrBytes[cstr + i2]) {
                case 34: 
                case 38: 
                case 39: 
                case 60: 
                case 62: {
                    if (dest == null) {
                        dest = RubyString.newStringLight(runtime2, len);
                    }
                    dest.cat(cstrBytes, cstr + beg, i2 - beg);
                    beg = i2 + 1;
                    CGIEscape.html_escaped_cat(dest, cstrBytes[cstr + i2]);
                }
            }
        }
        if (dest != null) {
            dest.cat(cstrBytes, cstr + beg, len - beg);
            CGIEscape.preserve_original_state(str, dest);
            return dest;
        }
        return str.strDup(runtime2);
    }

    static boolean MATCH(byte[] s2, int len, int i2, byte[] cstrBytes, int cstr) {
        return len - i2 >= s2.length && ByteList.memcmp(cstrBytes, cstr + i2, s2, 0, s2.length) == 0;
    }

    static IRubyObject optimized_unescape_html(Ruby runtime2, RubyString str) {
        Encoding enc = str.getEncoding();
        int charlimit = enc instanceof UTF8Encoding ? 0x10FFFF : (enc instanceof ISO8859_1Encoding ? 256 : 128);
        int beg = 0;
        int clen = 0;
        boolean overflow = false;
        byte[] buf = new byte[6];
        RubyString dest = null;
        int len = str.size();
        ByteList byteList = str.getByteList();
        byte[] cstrBytes = byteList.getUnsafeBytes();
        int cstr = byteList.begin();
        block7: for (int i2 = 0; i2 < len; ++i2) {
            int c = cstrBytes[cstr + i2];
            if (c != 38) continue;
            int plen = i2 - beg;
            if (++i2 >= len) break;
            c = cstrBytes[cstr + i2] & 0xFF;
            int j = i2++;
            switch (c) {
                case 97: {
                    if (CGIEscape.MATCH(POSSEMI, len, i2, cstrBytes, cstr)) {
                        i2 += POSSEMI.length - 1;
                        c = 39;
                        break;
                    }
                    if (CGIEscape.MATCH(MPSEMI, len, i2, cstrBytes, cstr)) {
                        i2 += MPSEMI.length - 1;
                        c = 38;
                        break;
                    }
                    i2 = j;
                    continue block7;
                }
                case 113: {
                    if (CGIEscape.MATCH(UOTSEMI, len, ++i2, cstrBytes, cstr)) {
                        i2 += UOTSEMI.length - 1;
                        c = 34;
                        break;
                    }
                    i2 = j;
                    continue block7;
                }
                case 103: {
                    if (CGIEscape.MATCH(TSEMI, len, ++i2, cstrBytes, cstr)) {
                        i2 += TSEMI.length - 1;
                        c = 62;
                        break;
                    }
                    i2 = j;
                    continue block7;
                }
                case 108: {
                    if (CGIEscape.MATCH(TSEMI, len, ++i2, cstrBytes, cstr)) {
                        i2 += TSEMI.length - 1;
                        c = 60;
                        break;
                    }
                    i2 = j;
                    continue block7;
                }
                case 35: {
                    int cc;
                    if (len - ++i2 >= 2 && Character.isDigit(cstrBytes[cstr + i2])) {
                        clenOverflow = new int[]{clen, overflow ? 1 : 0};
                        cc = CGIEscape.ruby_scan_digits(cstrBytes, cstr + i2, len - i2, 10, clenOverflow);
                        clen = clenOverflow[0];
                        overflow = clenOverflow[1] == 1;
                    } else if (i2 < len && (cstrBytes[cstr + i2] == 120 || cstrBytes[cstr + i2] == 88) && len - ++i2 >= 2 && CGIEscape.ISXDIGIT(cstrBytes, cstr + i2)) {
                        clenOverflow = new int[]{clen, overflow ? 1 : 0};
                        cc = CGIEscape.ruby_scan_digits(cstrBytes, cstr + i2, len - i2, 16, clenOverflow);
                        clen = clenOverflow[0];
                        overflow = clenOverflow[1] == 1;
                    } else {
                        i2 = j;
                        continue block7;
                    }
                    if (overflow || cc >= charlimit || (i2 += clen) >= len || cstrBytes[cstr + i2] != 59) {
                        i2 = j;
                        continue block7;
                    }
                    if (dest == null) {
                        dest = RubyString.newStringLight(runtime2, len);
                    }
                    dest.cat(cstrBytes, cstr + beg, plen);
                    if (charlimit > 256) {
                        dest.cat(buf, 0, enc.codeToMbc(cc, buf, 0));
                    } else {
                        c = cc;
                        dest.cat(c);
                    }
                    beg = i2 + 1;
                    continue block7;
                }
                default: {
                    --i2;
                    continue block7;
                }
            }
            if (dest == null) {
                dest = RubyString.newStringLight(runtime2, len);
            }
            dest.cat(cstrBytes, cstr + beg, plen);
            dest.cat(c);
            beg = i2 + 1;
        }
        if (dest != null) {
            dest.cat(cstrBytes, cstr + beg, len - beg);
            CGIEscape.preserve_original_state(str, dest);
            return dest;
        }
        return str.strDup(runtime2);
    }

    static boolean ISXDIGIT(byte[] cstrBytes, int i2) {
        byte cstrByte = cstrBytes[i2];
        return cstrByte >= 48 && cstrByte <= 57 || cstrByte >= 97 && cstrByte <= 102 || cstrByte >= 65 && cstrByte <= 70;
    }

    static boolean url_unreserved_char(int c) {
        switch (c) {
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    static IRubyObject optimized_escape(Ruby runtime2, RubyString str, boolean escapePlus) {
        int beg = 0;
        RubyString dest = null;
        byte[] buf = new byte[]{37, 0, 0};
        int len = str.size();
        ByteList byteList = str.getByteList();
        byte[] cstrBytes = byteList.unsafeBytes();
        int cstr = byteList.begin();
        for (int i2 = 0; i2 < len; ++i2) {
            int c = cstrBytes[cstr + i2] & 0xFF;
            if (CGIEscape.url_unreserved_char(c)) continue;
            if (dest == null) {
                dest = RubyString.newStringLight(runtime2, len);
            }
            dest.cat(cstrBytes, cstr + beg, i2 - beg);
            beg = i2 + 1;
            if (escapePlus && c == 32) {
                dest.cat(43);
                continue;
            }
            buf[1] = upper_hexdigits[c >> 4 & 0xF];
            buf[2] = upper_hexdigits[c & 0xF];
            dest.cat(buf, 0, 3);
        }
        if (dest != null) {
            dest.cat(cstrBytes, cstr + beg, len - beg);
            CGIEscape.preserve_original_state(str, dest);
            return dest;
        }
        return str.strDup(runtime2);
    }

    static IRubyObject optimized_unescape(ThreadContext context, RubyString str, IRubyObject encoding2, boolean unescapePlus) {
        int cr;
        int beg = 0;
        RubyString dest = null;
        Encoding encidx = EncodingUtils.rbToEncoding(context, encoding2);
        int len = str.size();
        ByteList byteList = str.getByteList();
        byte[] cstrBytes = byteList.unsafeBytes();
        int cstr = byteList.begin();
        int buf = 0;
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < len; ++i2) {
            int c = cstrBytes[cstr + i2] & 0xFF;
            int clen = 0;
            if (c == 37) {
                if (i2 + 3 > len) break;
                if (!CGIEscape.ISXDIGIT(cstrBytes, cstr + i2 + 1) || !CGIEscape.ISXDIGIT(cstrBytes, cstr + i2 + 2)) continue;
                buf = CGIEscape.char_to_number(cstrBytes[cstr + i2 + 1]) << 4 | CGIEscape.char_to_number(cstrBytes[cstr + i2 + 2]);
                clen = 2;
            } else {
                if (!unescapePlus || c != 43) continue;
                buf = 32;
            }
            if (dest == null) {
                dest = RubyString.newStringLight(runtime2, len);
            }
            dest.cat(cstrBytes, cstr + beg, i2 - beg);
            beg = (i2 += clen) + 1;
            dest.cat(buf);
        }
        if (dest != null) {
            dest.cat(cstrBytes, cstr + beg, len - beg);
            CGIEscape.preserve_original_state(str, dest);
            cr = 0;
        } else {
            dest = str.strDup(runtime2);
            cr = str.getCodeRange();
        }
        Encoding origenc = str.getEncoding();
        if (origenc != encidx) {
            dest.setEncoding(encidx);
            if (StringSupport.encCoderangeClean(dest.scanForCodeRange()) == 0) {
                EncodingUtils.encAssociateIndex(dest, origenc);
                if (cr != 0) {
                    dest.setCodeRange(cr);
                }
            }
        }
        return dest;
    }

    @JRubyMethod(name={"escapeHTML"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape_html(ThreadContext context, IRubyObject self2, IRubyObject _str) {
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape_html(context.runtime, str);
        }
        return Helpers.invokeSuper(context, self2, _str, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unescapeHTML"}, module=true, frame=true)
    public static IRubyObject cgiesc_unescape_html(ThreadContext context, IRubyObject self2, IRubyObject _str) {
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_unescape_html(context.runtime, str);
        }
        return Helpers.invokeSuper(context, self2, _str, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"escape"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape(ThreadContext context, IRubyObject self2, IRubyObject _str) {
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape(context.runtime, str, true);
        }
        return Helpers.invokeSuper(context, self2, _str, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"escapeURIComponent"}, alias={"escape_uri_component"}, module=true, frame=true)
    public static IRubyObject cgiesc_escape_uri_component(ThreadContext context, IRubyObject self2, IRubyObject _str) {
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            return CGIEscape.optimized_escape(context.runtime, str, false);
        }
        return Helpers.invokeSuper(context, self2, _str, Block.NULL_BLOCK);
    }

    static IRubyObject accept_charset(IRubyObject[] args2, int argc, int argv2, IRubyObject self2) {
        if (argc > 0) {
            return args2[argv2];
        }
        return self2.getMetaClass().getClassVar(ACCEPT_CHARSET);
    }

    @JRubyMethod(name={"unescape"}, required=1, optional=1, module=true, frame=true)
    public static IRubyObject cgiesc_unescape(ThreadContext context, IRubyObject self2, IRubyObject[] argv2) {
        IRubyObject _str = argv2[0];
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            IRubyObject enc = CGIEscape.accept_charset(argv2, argv2.length - 1, 1, self2);
            return CGIEscape.optimized_unescape(context, str, enc, true);
        }
        return Helpers.invokeSuper(context, self2, argv2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unescapeURIComponent"}, alias={"unescape_uri_component"}, required=1, optional=1, module=true, frame=true)
    public static IRubyObject cgiesc_unescape_uri_component(ThreadContext context, IRubyObject self2, IRubyObject[] argv2) {
        IRubyObject _str = argv2[0];
        RubyString str = _str.convertToString();
        if (str.getEncoding().isAsciiCompatible()) {
            IRubyObject enc = CGIEscape.accept_charset(argv2, argv2.length - 1, 1, self2);
            return CGIEscape.optimized_unescape(context, str, enc, false);
        }
        return Helpers.invokeSuper(context, self2, argv2, Block.NULL_BLOCK);
    }

    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass rb_cCGI = Define.defineClass(context, "CGI", runtime2.getObject(), runtime2.getObject().getAllocator());
        RubyModule rb_mEscapeExt = ((RubyModule)Define.defineModuleUnder(context, rb_cCGI, "EscapeExt").defineMethods(context, CGIEscape.class)).extendObject(context, rb_cCGI);
        Define.defineModuleUnder(context, rb_cCGI, "Escape").prependModule(context, rb_mEscapeExt);
    }

    static int ruby_scan_digits(byte[] strBytes, int str, int len, int base, int[] retlenOverflow) {
        int start2 = str;
        int ret = 0;
        int mul_overflow = Integer.MAX_VALUE / base;
        retlenOverflow[1] = 0;
        if (len == 0) {
            retlenOverflow[0] = 0;
            return 0;
        }
        do {
            int x;
            int d;
            if ((d = ruby_digit36_to_number_table[strBytes[str++]]) == -1 || base <= d) {
                --str;
                break;
            }
            if (mul_overflow < ret) {
                retlenOverflow[1] = 1;
            }
            ret *= base;
            if ((ret += d) >= (x = ret)) continue;
            retlenOverflow[1] = 1;
        } while (len < 0 || --len != 0);
        retlenOverflow[0] = str - start2;
        return ret;
    }

    static int char_to_number(int c) {
        return ruby_digit36_to_number_table[c];
    }
}

