/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.api;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFrozenError;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.EncodingError;
import org.jruby.exceptions.Exception;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;

public class Error {
    public static ArgumentError argumentError(ThreadContext context, String message2) {
        return (ArgumentError)context.runtime.newRaiseException(Access.argumentErrorClass(context), message2);
    }

    public static ArgumentError argumentError(ThreadContext context, int got, int expected) {
        return Error.argumentError(context, got, expected, expected);
    }

    public static ArgumentError argumentError(ThreadContext context, int length2, int min2, int max2) {
        return (ArgumentError)context.runtime.newArgumentError(length2, min2, max2);
    }

    public static RaiseException floatDomainError(ThreadContext context, String message2) {
        return context.runtime.newRaiseException(context.runtime.getFloatDomainError(), message2);
    }

    public static RaiseException frozenError(ThreadContext context, IRubyObject object, String message2) {
        return RubyFrozenError.newFrozenError(context, Create.newString(context, message2), object).toThrowable();
    }

    public static RaiseException indexError(ThreadContext context, String message2) {
        return context.runtime.newRaiseException(context.runtime.getIndexError(), message2);
    }

    public static RaiseException nameError(ThreadContext context, String message2, String name2) {
        return context.runtime.newNameError(message2, name2, null, false);
    }

    public static RaiseException nameError(ThreadContext context, String message2, IRubyObject name2) {
        return context.runtime.newNameError(message2, name2, (Throwable)null, false);
    }

    public static RaiseException nameError(ThreadContext context, String message2, String name2, Throwable throwable) {
        return context.runtime.newNameError(message2, name2, throwable, false);
    }

    public static RaiseException rangeError(ThreadContext context, String message2) {
        return context.runtime.newRaiseException(context.runtime.getRangeError(), message2);
    }

    public static RaiseException runtimeError(ThreadContext context, String message2) {
        return context.runtime.newRaiseException(context.runtime.getRuntimeError(), message2);
    }

    public static TypeError typeError(ThreadContext context, IRubyObject object, String expectedType) {
        return Error.createTypeError(context, RubyStringBuilder.str(context.runtime, "wrong argument type ", Error.typeFor(context.runtime, object), " (expected " + expectedType + ")"));
    }

    public static TypeError typeError(ThreadContext context, String startOfMessage, IRubyObject object, String restOfMessage) {
        return Error.createTypeError(context, RubyStringBuilder.str(context.runtime, startOfMessage, Error.typeFor(context.runtime, object), restOfMessage));
    }

    public static TypeError typeError(ThreadContext context, IRubyObject object, RubyModule expectedType) {
        return Error.createTypeError(context, Error.createTypeErrorMessage(context, object, expectedType));
    }

    public static TypeError typeError(ThreadContext context, String message2) {
        return Error.createTypeError(context, message2);
    }

    public static RaiseException zeroDivisionError(ThreadContext context) {
        return context.runtime.newRaiseException(context.runtime.getZeroDivisionError(), "divided by 0");
    }

    public static TypeError createTypeError(ThreadContext context, String message2) {
        return (TypeError)context.runtime.newRaiseException(context.runtime.getTypeError(), message2);
    }

    public static String createTypeErrorMessage(ThreadContext context, IRubyObject object, RubyModule expectedType) {
        return RubyStringBuilder.str(context.runtime, "wrong argument type ", Error.typeFor(context.runtime, object), " (expected ", RubyStringBuilder.types(context.runtime, expectedType), ")");
    }

    public static RaiseException withException(RaiseException error2, java.lang.Exception exception2) {
        error2.initCause(exception2);
        return error2;
    }

    public static NotImplementedError notImplementedError(ThreadContext context, String message2) {
        return (NotImplementedError)context.runtime.newNotImplementedError(message2);
    }

    public static ArgumentError keywordError(ThreadContext context, String error2, RubyArray keys2) {
        long i2 = 0L;
        long len = keys2.size();
        StringBuilder message2 = new StringBuilder(error2).append(" keyword");
        if (len > 1L) {
            message2.append('s');
        }
        if (len > 0L) {
            message2.append(": ");
            while (true) {
                Object key2 = keys2.eltOk(i2);
                message2.append(key2.inspect(context).toString());
                if (++i2 >= len) break;
                message2.append(", ");
            }
        }
        return Error.argumentError(context, message2.toString());
    }

    public static Exception toRubyException(ThreadContext context, IOException ioe) {
        return (Exception)Helpers.newIOErrorFromException(context.runtime, ioe);
    }

    private static IRubyObject typeFor(Ruby runtime2, IRubyObject object) {
        return object instanceof RubyModule ? RubyStringBuilder.types(runtime2, (RubyModule)object) : object.getMetaClass().getRealClass();
    }

    public static EOFError eofError(ThreadContext context, String message2) {
        return (EOFError)context.runtime.newEOFError(message2);
    }

    public static EncodingError.CompatibilityError encodingCompatibilityError(ThreadContext context, String s2) {
        return (EncodingError.CompatibilityError)context.runtime.newEncodingCompatibilityError(s2);
    }
}

