/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.io.wait;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) {
        RubyClass rubyClass = ruby.getIO();
        rubyClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_readable(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        OpenFile openFile = rubyIO.getOpenFileChecked();
        openFile.checkReadable(threadContext);
        long l = IOWaitLibrary.prepareTimeout(threadContext, iRubyObjectArray);
        if (openFile.readPending() != 0) {
            return threadContext.tru;
        }
        return IOWaitLibrary.doWait(threadContext, rubyIO, openFile, l, 17);
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_writable(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        OpenFile openFile = rubyIO.getOpenFileChecked();
        openFile.checkWritable(threadContext);
        long l = IOWaitLibrary.prepareTimeout(threadContext, iRubyObjectArray);
        return IOWaitLibrary.doWait(threadContext, rubyIO, openFile, l, 12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(optional=2)
    public static IRubyObject wait(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        RubyIO rubyIO = (RubyIO)iRubyObject;
        OpenFile openFile = rubyIO.getOpenFileChecked();
        int n = 0;
        if (iRubyObjectArray.length == 2) {
            if (!(iRubyObjectArray[1] instanceof RubySymbol)) throw threadContext.runtime.newArgumentError("unsupported mode: " + iRubyObjectArray[1].getType());
            RubySymbol rubySymbol = (RubySymbol)iRubyObjectArray[1];
            switch (rubySymbol.asJavaString()) {
                case "r": 
                case "read": 
                case "readable": {
                    n |= 0x11;
                    break;
                }
                case "w": 
                case "write": 
                case "writable": {
                    n |= 0xC;
                    break;
                }
                case "rw": 
                case "read_write": 
                case "readable_writable": {
                    n |= 0x1D;
                    break;
                }
                default: {
                    throw threadContext.runtime.newArgumentError("unsupported mode: " + rubySymbol);
                }
            }
        } else {
            n |= 0x11;
        }
        if ((n & 1) == 1 && openFile.readPending() != 0) {
            return threadContext.tru;
        }
        long l = IOWaitLibrary.prepareTimeout(threadContext, iRubyObjectArray);
        return IOWaitLibrary.doWait(threadContext, rubyIO, openFile, l, n);
    }

    private static IRubyObject doWait(ThreadContext threadContext, RubyIO rubyIO, OpenFile openFile, long l, int n) {
        boolean bl = openFile.ready(threadContext.runtime, threadContext.getThread(), n, l);
        openFile.checkClosed();
        if (bl) {
            return rubyIO;
        }
        return threadContext.nil;
    }

    private static long prepareTimeout(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        long l;
        IRubyObject iRubyObject;
        switch (iRubyObjectArray.length) {
            case 1: 
            case 2: {
                iRubyObject = iRubyObjectArray[0];
                break;
            }
            default: {
                iRubyObject = threadContext.nil;
            }
        }
        if (iRubyObject.isNil()) {
            l = -1L;
        } else {
            l = (long)(RubyTime.convertTimeInterval((ThreadContext)threadContext, (IRubyObject)iRubyObject) * 1000.0);
            if (l < 0L) {
                throw threadContext.runtime.newArgumentError("time interval must be positive");
            }
        }
        return l;
    }
}

