/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.specialized.RubyObjectSpecializer;

public class FieldVariableAccessor
extends VariableAccessor {
    protected final MethodHandle getter;
    protected final MethodHandle setter;
    private static final MethodHandle ENSURE_SETTABLE = Binder.from(Object.class, Object.class, Object.class).dropLast().cast(Void.TYPE, RubyBasicObject.class).invokeVirtualQuiet(RubyObjectSpecializer.LOOKUP, "ensureInstanceVariablesSettable");

    public FieldVariableAccessor(RubyClass realClass, String name2, int index2, int classId, MethodHandle getter, MethodHandle setter) {
        super(realClass, name2, index2, classId);
        this.getter = getter;
        this.setter = this.wrapSetter(setter);
    }

    @Override
    public FieldVariableAccessor cloneFor(RubyClass newRealClass) {
        return new FieldVariableAccessor(newRealClass, this.name, this.index, this.classId, this.getter, this.setter);
    }

    protected MethodHandle wrapSetter(MethodHandle setter) {
        return MethodHandles.foldArguments(setter, ENSURE_SETTABLE.asType(setter.type()));
    }

    public MethodHandle getGetter() {
        return this.getter;
    }

    public MethodHandle getSetter() {
        return this.setter;
    }

    @Override
    public Object get(Object object) {
        try {
            return this.getter.invoke(object);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject getOrNil(Object object, ThreadContext context) {
        try {
            Object value2 = this.getter.invoke(object);
            return value2 == null ? context.nil : (IRubyObject)value2;
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public void set(Object object, Object value2) {
        try {
            this.setter.invoke(object, value2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
        }
    }
}

