/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.backport9.buffer.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyArrayNative;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.util.ByteList;
import org.jruby.util.Inspector;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Hash"}, include={"Enumerable"})
public class RubyHashLinkedBuckets
extends RubyHash {
    protected int size = 0;
    private int threshold;
    private byte hashFlags;
    private IRubyObject ifNone;
    private int generation = 0;
    private final RubyHash.RubyHashEntry head;
    public static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 2;
    private static final boolean MRI_HASH = true;
    private static final boolean MRI_HASH_RESIZE = true;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHash.RubyHashEntry entry, Object obj) {
            IRubyObject key2 = entry.key;
            return obj == key2 || ((IRubyObject)obj).eql(key2);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHash.RubyHashEntry entry, Object obj) {
            return entry.equals(obj);
        }
    };
    private static final RubyHash.VisitorWithState<RubyString> InspectVisitor = new RubyHash.VisitorWithState<RubyString>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyString str) {
            RubyString keyStr;
            boolean isSymbol = key2 instanceof RubySymbol;
            boolean quote2 = false;
            if (key2 instanceof RubySymbol) {
                RubySymbol symbol = (RubySymbol)key2;
                keyStr = symbol.fstring();
                quote2 = this.symbolKeyNeedsQuote(context, symbol);
            } else {
                keyStr = RubyObject.inspect(context, key2);
            }
            if (str.size() > 1) {
                str.catString(", ");
            } else {
                str.setEncoding(keyStr.getEncoding());
            }
            if (quote2) {
                str.append(keyStr.inspect(context));
            } else {
                str.append(keyStr);
            }
            str.catString(isSymbol ? ": " : " => ");
            RubyString valStr = RubyObject.inspect(context, value2);
            str.append(valStr);
        }

        boolean symbolKeyNeedsQuote(ThreadContext context, RubySymbol sym) {
            RubyString str = sym.fstring();
            int len = str.size();
            if (len == 0 || !sym.isSimpleName(context)) {
                return true;
            }
            ByteList bytes2 = str.getByteList();
            int first2 = bytes2.get(0);
            if (first2 == 64 || first2 == 36 || first2 == 33) {
                return true;
            }
            if (!RubyString.atCharBoundary(bytes2.unsafeBytes(), bytes2.begin(), bytes2.begin() + bytes2.getRealSize() - 1, bytes2.begin() + bytes2.realSize(), bytes2.getEncoding())) {
                return false;
            }
            switch (bytes2.get(len - 1)) {
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 64: 
                case 93: 
                case 94: 
                case 96: 
                case 124: 
                case 126: {
                    return true;
                }
            }
            return false;
        }
    };
    private static final RubyHash.VisitorWithState<RubyArray> StoreKeyValueVisitor = new RubyHash.VisitorWithState<RubyArray>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray result2) {
            result2.storeInternal(context, index2, Create.newArray(context, key2, value2));
        }
    };
    private static final RubyHash.VisitorWithState<RubyHash> FindMismatchUsingEqualVisitor = new RubyHash.VisitorWithState<RubyHash>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash otherHash) {
            IRubyObject value22 = otherHash.fastARef(key2);
            if (value22 == null) {
                throw MISMATCH;
            }
            if (!Helpers.rbEqual(context, value2, value22).isTrue()) {
                throw MISMATCH;
            }
        }
    };
    private static final RubyHash.VisitorWithState<RubyHash> FindMismatchUsingEqlVisitor = new RubyHash.VisitorWithState<RubyHash>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash otherHash) {
            IRubyObject value22 = otherHash.fastARef(key2);
            if (value22 == null) {
                throw MISMATCH;
            }
            if (!Helpers.rbEql(context, value2, value22).isTrue()) {
                throw MISMATCH;
            }
        }
    };
    private static final ThreadLocal<ByteBuffer> HASH_16_BYTE = ThreadLocal.withInitial(() -> ByteBuffer.allocate(16));
    private static final RubyHash.VisitorWithState<long[]> CalculateHashVisitor = new RubyHash.VisitorWithState<long[]>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, long[] hval) {
            long keyHash = Helpers.safeHashLong(context, key2);
            long valueHash = Helpers.safeHashLong(context, value2);
            ByteBuffer buffer = HASH_16_BYTE.get();
            Buffers.clearBuffer(buffer).putLong(keyHash).putLong(valueHash);
            hval[0] = hval[0] ^ Helpers.multAndMix(Ruby.getHashSeed0(), Arrays.hashCode(buffer.array()));
        }
    };
    private static final Found FOUND = new Found();
    private static final RubyHash.VisitorWithState<IRubyObject> FoundIfEqualVisitor = new RubyHash.VisitorWithState<IRubyObject>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject expected) {
            if (RubyObject.equalInternal(context, value2, expected)) {
                throw FOUND;
            }
        }
    };
    private volatile int iteratorCount;
    private static final AtomicIntegerFieldUpdater<RubyHashLinkedBuckets> ITERATOR_UPDATER;
    private static final RubyHash.VisitorWithState<Block> YieldArrayVisitor;
    private static final RubyHash.VisitorWithState<Block> YieldKeyValueArrayVisitor;
    private static final RubyHash.VisitorWithState<Block> YieldValueVisitor;
    private static final RubyHash.VisitorWithState<Block> YieldKeyVisitor;
    private static final RubyHash.VisitorWithState<IRubyObject> FoundKeyIfEqual;
    private static final RubyHash.VisitorWithState<RubyArray> StoreKeyVisitor;
    private static final Mismatch MISMATCH;
    private static final RubyHash.VisitorWithState<Block> DeleteIfVisitor;
    private static final RubyHash.VisitorWithState<RubyHashLinkedBuckets> InvertVisitor;
    private static final RubyHash.VisitorWithState<RubyHash> ReplaceVisitor;
    private static final RubyHash.VisitorWithState<IRubyObject> FoundPairIfEqualKeyVisitor;
    private static final RubyHash.VisitorWithState<IRubyObject> FoundPairIfEqualValueVisitor;
    private static final EntryView DIRECT_KEY_VIEW;
    private static final EntryView KEY_VIEW;
    private static final EntryView DIRECT_VALUE_VIEW;
    private static final EntryView VALUE_VIEW;
    private static final EntryView DIRECT_ENTRY_VIEW;
    private static final EntryView ENTRY_VIEW;

    RubyHashLinkedBuckets(Ruby runtime2, RubyClass klass, RubyHash other) {
        super(runtime2, klass, true, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = UNDEF;
        RubyHashLinkedBuckets.copyFrom(this, other, false);
    }

    protected RubyHashLinkedBuckets(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass, true, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = UNDEF;
        this.allocFirst();
    }

    RubyHashLinkedBuckets(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = UNDEF;
        this.allocFirst();
    }

    protected RubyHashLinkedBuckets(Ruby runtime2, int buckets) {
        this(runtime2, UNDEF, buckets);
    }

    protected RubyHashLinkedBuckets(Ruby runtime2) {
        this(runtime2, UNDEF);
    }

    protected RubyHashLinkedBuckets(Ruby runtime2, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash(), true, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = defaultValue;
        this.allocFirst();
    }

    protected RubyHashLinkedBuckets(Ruby runtime2, IRubyObject defaultValue, int buckets) {
        this(runtime2, buckets, true);
        this.ifNone = defaultValue;
    }

    protected RubyHashLinkedBuckets(Ruby runtime2, RubyClass metaClass, IRubyObject defaultValue, RubyHash.RubyHashEntry[] initialTable, int threshold) {
        super(runtime2, metaClass, true, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = defaultValue;
        this.threshold = threshold;
        this.setTable(initialTable);
    }

    RubyHashLinkedBuckets(Ruby runtime2, int buckets, boolean objectSpace) {
        super(runtime2, runtime2.getHash(), objectSpace, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = UNDEF;
        if (buckets <= 0) {
            buckets = 1;
        }
        this.allocFirst(buckets);
    }

    RubyHashLinkedBuckets(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash(), true, 0);
        this.head.prevAdded = this.head.nextAdded = (this.head = new RubyHash.RubyHashEntry());
        this.ifNone = defaultValue;
        this.allocFirst();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private static void copyFrom(RubyHashLinkedBuckets self2, RubyHash other, boolean identity) {
        if (other instanceof RubyHashLinkedBuckets) {
            RubyHashLinkedBuckets lbOther = (RubyHashLinkedBuckets)other;
            self2.threshold = lbOther.threshold;
            self2.setTable(lbOther.internalCopyTable(self2.head));
            self2.size = other.size();
        }
        self2.setComparedByIdentity(identity);
    }

    public static RubyHashLinkedBuckets newLBHash(Ruby runtime2, int buckets) {
        return new RubyHashLinkedBuckets(runtime2, buckets);
    }

    public static RubyHashLinkedBuckets newLBHash(Ruby runtime2, int buckets, boolean objectSpace) {
        return new RubyHashLinkedBuckets(runtime2, buckets, objectSpace);
    }

    public static RubyHashLinkedBuckets newLBHash(Ruby runtime2) {
        return new RubyHashLinkedBuckets(runtime2);
    }

    public static RubyHashLinkedBuckets newLBHash(Ruby runtime2, IRubyObject defaultValue) {
        return new RubyHashLinkedBuckets(runtime2, defaultValue);
    }

    public static RubyHashLinkedBuckets newLBHash(Ruby runtime2, IRubyObject defaultValue, int buckets) {
        return new RubyHashLinkedBuckets(runtime2, defaultValue, buckets);
    }

    @Override
    protected void set(int flag, boolean set2) {
        this.hashFlags = set2 ? (byte)(this.hashFlags | flag) : (byte)(this.hashFlags & ~flag);
    }

    @Override
    protected boolean get(int flag) {
        return (this.hashFlags & flag) != 0;
    }

    private final void allocFirst() {
        this.threshold = 6;
        this.setTable(new RubyHash.RubyHashEntry[MRI_INITIAL_CAPACITY]);
    }

    private final void allocFirst(int buckets) {
        if (buckets <= 0) {
            throw new ArrayIndexOutOfBoundsException("invalid bucket size: " + buckets);
        }
        this.threshold = 6;
        this.setTable(new RubyHash.RubyHashEntry[buckets]);
    }

    private final void alloc() {
        ++this.generation;
        this.head.prevAdded = this.head.nextAdded = this.head;
        this.allocFirst();
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length2) {
        return h & length2 - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length2) {
        return (h & Integer.MAX_VALUE) % length2;
    }

    private final synchronized void resize(int newCapacity) {
        RubyHash.RubyHashEntry[] oldTable = this.getTable();
        RubyHash.RubyHashEntry[] newTable = new RubyHash.RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHash.RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHash.RubyHashEntry next2 = entry.next;
                int i2 = RubyHashLinkedBuckets.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i2];
                newTable[i2] = entry;
                entry = next2;
            }
        }
        this.setTable(newTable);
    }

    private final void JavaSoftCheckResize() {
        if (this.overThreshold()) {
            RubyHash.RubyHashEntry[] tbl = this.getTable();
            if (tbl.length == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            this.resizeAndAdjustThreshold(this.getTable());
        }
    }

    private boolean overThreshold() {
        return this.size > this.threshold;
    }

    private void resizeAndAdjustThreshold(RubyHash.RubyHashEntry[] oldTable) {
        int newCapacity = oldTable.length << 1;
        this.resize(newCapacity);
        this.threshold = newCapacity - (newCapacity >> 2);
    }

    private final void MRICheckResize() {
        if (this.size / this.getTable().length > 2) {
            int forSize = this.getTable().length + 1;
            int i2 = 0;
            int newCapacity = 8;
            while (i2 < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i2]);
                    return;
                }
                ++i2;
                newCapacity <<= 1;
            }
            return;
        }
    }

    protected final int hashValue(IRubyObject key2) {
        int h = this.isComparedByIdentity() ? System.identityHashCode(key2) : key2.hashCode();
        return RubyHashLinkedBuckets.MRIHashValue(h);
    }

    private static int bucketIndex(int h, int length2) {
        return RubyHashLinkedBuckets.MRIBucketIndex(h, length2);
    }

    private void checkResize() {
        this.MRICheckResize();
    }

    protected final void checkIterating() {
        if (this.iteratorCount > 0) {
            throw this.metaClass.runtime.newRuntimeError("can't add a new key into hash during iteration");
        }
    }

    @Override
    public IRubyObject internalPut(IRubyObject key2, IRubyObject value2) {
        this.checkResize();
        return this.internalPutNoResize(key2, value2, true);
    }

    private void internalPutSmall(IRubyObject key2, IRubyObject value2) {
        this.internalPutNoResize(key2, value2, true);
    }

    private void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        this.checkResize();
        this.internalPutNoResize(key2, value2, checkForExisting);
    }

    @Override
    final boolean internalPutIfNoKey(IRubyObject key2, IRubyObject value2) {
        if (this.internalGetEntry(key2) == NULL_ENTRY) {
            this.internalPut(key2, value2);
            return true;
        }
        return false;
    }

    protected IRubyObject internalPutNoResize(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        int hash2 = this.hashValue(key2);
        RubyHash.RubyHashEntry[] table = this.getTable();
        int i2 = RubyHashLinkedBuckets.bucketIndex(hash2, table.length);
        if (checkForExisting) {
            RubyHash.RubyHashEntry entry = table[i2];
            while (entry != null) {
                if (this.internalKeyExist(entry.hash, entry.key, hash2, key2)) {
                    IRubyObject existing = entry.value;
                    entry.value = value2;
                    return existing;
                }
                entry = entry.next;
            }
        }
        this.checkIterating();
        table[i2] = new RubyHash.RubyHashEntry(hash2, key2, value2, table[i2], this.head);
        ++this.size;
        return null;
    }

    @Override
    protected IRubyObject internalGet(IRubyObject key2) {
        return this.internalGetEntry((IRubyObject)key2).value;
    }

    protected RubyHash.RubyHashEntry internalGetEntry(IRubyObject key2) {
        if (this.size == 0) {
            return NULL_ENTRY;
        }
        int hash2 = this.hashValue(key2);
        RubyHash.RubyHashEntry[] table = this.getTable();
        RubyHash.RubyHashEntry entry = table[RubyHashLinkedBuckets.bucketIndex(hash2, table.length)];
        while (entry != null) {
            if (this.internalKeyExist(entry.hash, entry.key, hash2, key2)) {
                return entry;
            }
            entry = entry.next;
        }
        return NULL_ENTRY;
    }

    @Override
    @Deprecated
    final RubyHash.RubyHashEntry getEntry(IRubyObject key2) {
        return this.internalGetEntry(key2);
    }

    private boolean internalKeyExist(int entryHash, IRubyObject entryKey, int hash2, IRubyObject key2) {
        return entryHash == hash2 && (entryKey == key2 || !this.isComparedByIdentity() && key2.eql(entryKey));
    }

    protected RubyHash.RubyHashEntry internalDelete(IRubyObject key2) {
        if (this.size == 0) {
            return NULL_ENTRY;
        }
        return this.internalDelete(this.hashValue(key2), MATCH_KEY, key2);
    }

    protected RubyHash.RubyHashEntry internalDeleteEntry(RubyHash.RubyHashEntry entry) {
        return this.internalDelete(this.hashValue(entry.key), MATCH_ENTRY, entry);
    }

    private final RubyHash.RubyHashEntry internalDelete(int hash2, EntryMatchType matchType, Object obj) {
        int i2 = RubyHashLinkedBuckets.bucketIndex(hash2, this.getTable().length);
        RubyHash.RubyHashEntry entry = this.getTable()[i2];
        if (entry != null) {
            RubyHash.RubyHashEntry prior = null;
            while (entry != null) {
                if (entry.hash == hash2 && matchType.matches(entry, obj)) {
                    if (prior != null) {
                        prior.next = entry.next;
                    } else {
                        this.getTable()[i2] = entry.next;
                    }
                    entry.detach();
                    --this.size;
                    return entry;
                }
                prior = entry;
                entry = entry.next;
            }
        }
        return NULL_ENTRY;
    }

    private RubyHash.RubyHashEntry[] getTable() {
        return (RubyHash.RubyHashEntry[])this.state;
    }

    private void setTable(RubyHash.RubyHashEntry[] table) {
        this.state = table;
    }

    private final RubyHash.RubyHashEntry[] internalCopyTable(RubyHash.RubyHashEntry destHead) {
        RubyHash.RubyHashEntry[] newTable = new RubyHash.RubyHashEntry[this.getTable().length];
        RubyHash.RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            int i2 = RubyHashLinkedBuckets.bucketIndex(entry.hash, this.getTable().length);
            newTable[i2] = new RubyHash.RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i2], destHead);
            entry = entry.nextAdded;
        }
        return newTable;
    }

    @Override
    public <T> void visitAll(ThreadContext context, RubyHash.VisitorWithStateI visitor) {
        int startGeneration = this.generation;
        long count2 = this.size;
        int index2 = 0;
        RubyHash.RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head && count2 != 0L) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry != null && entry.isLive()) {
                visitor.visit(context, this, entry.key, entry.value, index2++);
                --count2;
            }
            entry = entry.nextAdded;
        }
        if (count2 > 0L) {
            throw this.concurrentModification();
        }
    }

    @Override
    public <T> void visitAll(ThreadContext context, RubyHash.VisitorWithState visitor, T state2) {
        this.visitLimited(context, visitor, -1L, state2);
    }

    @Override
    protected <T> void visitLimited(ThreadContext context, RubyHash.VisitorWithState visitor, long size2, T state2) {
        int startGeneration = this.generation;
        long count2 = size2;
        int index2 = 0;
        RubyHash.RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head && count2 != 0L) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry != null && entry.isLive()) {
                visitor.visit(context, this, entry.key, entry.value, index2++, state2);
                --count2;
            }
            entry = entry.nextAdded;
        }
        if (count2 > 0L) {
            throw this.concurrentModification();
        }
    }

    @Override
    public <T> boolean allSymbols() {
        int startGeneration = this.generation;
        RubyHash.RubyHashEntry head = this.head;
        RubyHash.RubyHashEntry entry = head.nextAdded;
        while (entry != head) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = head.nextAdded;
                if (entry == head) break;
            }
            if (entry != null && entry.isLive() && !(entry.key instanceof RubySymbol)) {
                return false;
            }
            entry = entry.nextAdded;
        }
        return true;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.modify();
        if (block.isGiven()) {
            this.ifNone = context.runtime.newProc(Block.Type.PROC, block);
            this.set(4, true);
        } else {
            this.ifNone = UNDEF;
        }
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _default, Block block) {
        boolean keywords = ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context));
        this.modify();
        if (keywords) {
            RubyFixnum fixnum;
            IRubyObject[] opts = ArgsUtil.extractKeywordArgs(context, (RubyHashLinkedBuckets)_default, "capacity");
            IRubyObject iRubyObject = opts[0];
            if (iRubyObject instanceof RubyFixnum && (fixnum = (RubyFixnum)iRubyObject).asInt(context) > 0) {
                this.allocFirst(fixnum.asInt(context));
            }
            if (block.isGiven()) {
                this.ifNone = context.runtime.newProc(Block.Type.PROC, block);
                this.set(4, true);
            } else {
                this.ifNone = UNDEF;
            }
        } else {
            if (block.isGiven()) {
                throw Error.argumentError(context, 1, 0);
            }
            this.ifNone = _default;
        }
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject _default, IRubyObject hash2, Block block) {
        RubyFixnum fixnum;
        if (!ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context))) {
            throw Error.argumentError(context, 2, 0, 1);
        }
        IRubyObject[] opts = ArgsUtil.extractKeywordArgs(context, (RubyHashLinkedBuckets)hash2, "capacity");
        IRubyObject iRubyObject = opts[0];
        if (iRubyObject instanceof RubyFixnum && (fixnum = (RubyFixnum)iRubyObject).asInt(context) > 0) {
            this.allocFirst(fixnum.asInt(context));
        }
        this.modify();
        if (block.isGiven()) {
            throw Error.argumentError(context, 1, 0);
        }
        this.ifNone = _default;
        return this;
    }

    @Override
    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        if (this.get(4)) {
            return context.nil;
        }
        return this.ifNone == UNDEF ? context.nil : this.ifNone;
    }

    @Override
    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        if (this.get(4)) {
            return RubyHashLinkedBuckets.sites((ThreadContext)context).call.call(context, this.ifNone, this.ifNone, (IRubyObject)this, arg2);
        }
        return this.ifNone == UNDEF ? context.nil : this.ifNone;
    }

    @Override
    @JRubyMethod(name={"default="})
    public IRubyObject default_value_set(ThreadContext context, IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.set(4, false);
        return this.ifNone;
    }

    @Override
    @JRubyMethod
    public IRubyObject default_proc(ThreadContext context) {
        return this.get(4) ? this.ifNone : context.nil;
    }

    private void checkDefaultProcArity(ThreadContext context, Block block) {
        int n = block.getSignature().arityValue();
        if (block.type == Block.Type.LAMBDA && n != 2 && (n >= 0 || n < -3)) {
            if (n < 0) {
                n = -n - 1;
            }
            throw Error.typeError(context, "default_proc takes two arguments (2 for " + n + ")");
        }
    }

    @Override
    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(ThreadContext context, IRubyObject proc2) {
        this.modify();
        if (proc2.isNil()) {
            this.ifNone = proc2;
            this.set(4, false);
            return proc2;
        }
        IRubyObject b2 = TypeConverter.convertToType(proc2, context.runtime.getProc(), "to_proc");
        if (b2.isNil() || !(b2 instanceof RubyProc)) {
            throw Error.typeError(context, "wrong default_proc type ", proc2, " (expected Proc)");
        }
        proc2 = b2;
        this.checkDefaultProcArity(context, ((RubyProc)proc2).getBlock());
        this.ifNone = proc2;
        this.set(4, true);
        return proc2;
    }

    @Override
    public void modify() {
        this.testFrozen("Hash");
    }

    protected RubyString inspectHash(ThreadContext context) {
        RubyString str = RubyString.newStringLight(context.runtime, 20, USASCIIEncoding.INSTANCE);
        str.cat((byte)123);
        this.visitAll(context, InspectVisitor, str);
        str.cat((byte)125);
        return str;
    }

    protected void appendAssociation(boolean keyIsSymbol, ByteList bytes2) {
        if (keyIsSymbol) {
            bytes2.append(58).append(32);
        } else {
            bytes2.append(32).append(61).append(62).append(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (this.size() == 0) {
            return Create.newSharedString(context, Inspector.EMPTY_HASH_BL);
        }
        if (runtime2.isInspecting(this)) {
            return Create.newSharedString(context, Inspector.RECURSIVE_HASH_BL);
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = this.inspectHash(context);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    @Override
    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size(ThreadContext context) {
        return Convert.asFixnum(context, this.size);
    }

    private static IRubyObject size(ThreadContext context, RubyHashLinkedBuckets recv2, IRubyObject[] args2) {
        return recv2.rb_size(context);
    }

    @Override
    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.size == 0 ? context.tru : context.fals;
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        try {
            RubyArrayNative result2 = RubyArrayNative.newBlankArrayInternal(runtime2, this.size);
            this.visitAll(context, StoreKeyValueVisitor, result2);
            return result2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.inspect(context);
    }

    @Override
    @JRubyMethod(name={"rehash"})
    public RubyHash rehash(ThreadContext context) {
        if (this.iteratorCount > 0) {
            throw Error.runtimeError(context, "rehash during iteration");
        }
        this.modify();
        RubyHash.RubyHashEntry[] oldTable = this.getTable();
        RubyHash.RubyHashEntry[] newTable = new RubyHash.RubyHashEntry[oldTable.length];
        HashSet<Integer> rehashedIndexes = new HashSet<Integer>();
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHash.RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHash.RubyHashEntry next2 = entry.next;
                int oldHash = entry.hash;
                IRubyObject key2 = entry.key;
                int newHash = this.hashValue(key2);
                int i2 = RubyHashLinkedBuckets.bucketIndex(newHash, newTable.length);
                RubyHash.RubyHashEntry newEntry = newTable[i2];
                if (newEntry != null && this.internalKeyExist(newEntry.hash, newEntry.key, newHash, key2)) {
                    RubyHash.RubyHashEntry tmpNext = entry.nextAdded;
                    RubyHash.RubyHashEntry tmpPrev = entry.prevAdded;
                    tmpPrev.nextAdded = tmpNext;
                    tmpPrev.prevAdded = tmpPrev;
                    --this.size;
                } else {
                    if (oldHash != newHash) {
                        entry = new RubyHash.RubyHashEntry(entry, newHash);
                        rehashedIndexes.add(newHash);
                    }
                    entry.next = newEntry;
                    newTable[i2] = entry;
                }
                entry = next2;
            }
        }
        this.setTable(newTable);
        Iterator iterator = rehashedIndexes.iterator();
        while (iterator.hasNext()) {
            int hash2 = (Integer)iterator.next();
            RubyHash.RubyHashEntry entry = this.getTable()[RubyHashLinkedBuckets.bucketIndex(hash2, newTable.length)];
            while (entry != null) {
                if (entry.hash == hash2) {
                    RubyHash.RubyHashEntry nextEntry = entry.next;
                    while (nextEntry != null) {
                        if (this.internalKeyExist(entry.hash, entry.key, nextEntry.hash, nextEntry.key)) {
                            RubyHash.RubyHashEntry tmpNext = entry.nextAdded;
                            RubyHash.RubyHashEntry tmpPrev = entry.prevAdded;
                            tmpPrev.nextAdded = tmpNext;
                            tmpPrev.prevAdded = tmpPrev;
                            --this.size;
                        }
                        nextEntry = nextEntry.next;
                    }
                }
                entry = entry.next;
            }
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod
    public RubyHash to_h(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.to_h_block(context, block);
        }
        return this.getType() == Access.hashClass(context) ? this : Create.newHash(context).replace(context, this);
    }

    @Override
    protected RubyHash to_h_block(ThreadContext context, Block block) {
        RubyHash result2 = Create.newHash(context);
        this.visitAll(context, (ctxt, self2, key2, value2, index2) -> {
            IRubyObject elt = block.yieldArray(ctxt, Create.newArray(ctxt, key2, value2), null);
            IRubyObject keyValue = elt.checkArrayType();
            if (keyValue == ctxt.nil) {
                throw Error.typeError(context, "wrong element type ", elt, " (expected array)");
            }
            RubyArray ary = (RubyArray)keyValue;
            if (ary.getLength() != 2) {
                throw Error.argumentError(context, "element has wrong array length (expected 2, was " + ary.getLength() + ")");
            }
            result2.fastASet((IRubyObject)ary.eltInternal(0), (IRubyObject)ary.eltInternal(1));
        });
        return result2;
    }

    @Override
    public RubyHashLinkedBuckets convertToHash() {
        return this;
    }

    @Override
    public final void fastASet(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2);
    }

    @Override
    public final void fastASetSmall(IRubyObject key2, IRubyObject value2) {
        this.internalPutSmall(key2, value2);
    }

    @Override
    public final void fastASetSmallPair(ThreadContext context, IRubyObject _pair) {
        IRubyObject pair = TypeConverter.checkArrayType(context, _pair);
        if (pair.isNil()) {
            throw Error.typeError(context, "wrong element type " + String.valueOf(_pair.getType()) + " (expected array)");
        }
        RubyArray pairAry = (RubyArray)pair;
        int len = pairAry.size();
        if (len != 2) {
            throw Error.argumentError(context, "element has wrong array length (expected 2, was " + len + ")");
        }
        this.fastASetSmall((IRubyObject)pairAry.eltOk(0L), (IRubyObject)pairAry.eltOk(1L));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void fastASetCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString) {
            RubyString strKey = (RubyString)key2;
            if (!this.isComparedByIdentity()) {
                this.op_asetForString(runtime2, strKey, value2);
                return;
            }
        }
        this.internalPut(key2, value2);
    }

    @Override
    public final void fastASetSmallCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString) {
            RubyString strKey = (RubyString)key2;
            this.op_asetSmallForString(runtime2, strKey, value2);
        } else {
            this.internalPutSmall(key2, value2);
        }
    }

    @Override
    public final void fastASet(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        if (prepareString) {
            this.fastASetCheckString(runtime2, key2, value2);
        } else {
            this.fastASet(key2, value2);
        }
    }

    @Override
    public final void fastASetSmall(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        if (prepareString) {
            this.fastASetSmallCheckString(runtime2, key2, value2);
        } else {
            this.fastASetSmall(key2, value2);
        }
    }

    @Override
    @JRubyMethod(name={"[]=", "store"})
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.modify();
        this.fastASetCheckString(context.runtime, key2, value2);
        return value2;
    }

    protected void op_asetForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
        RubyHash.RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NULL_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = RubyHashLinkedBuckets.hashKeyString(runtime2.getCurrentContext(), key2);
            }
            this.internalPut(key2, value2, false);
        }
    }

    protected void op_asetSmallForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
        RubyHash.RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NULL_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = RubyHashLinkedBuckets.hashKeyString(runtime2.getCurrentContext(), key2);
            }
            this.internalPutNoResize(key2, value2, false);
        }
    }

    private static RubyString hashKeyString(ThreadContext context, RubyString key2) {
        return key2.isBare(context) ? context.runtime.freezeAndDedupString(key2) : (RubyString)key2.dupFrozen();
    }

    @Override
    public final IRubyObject fastARef(IRubyObject key2) {
        return this.internalGet(key2);
    }

    @Override
    public RubyBoolean compare(ThreadContext context, RubyHash.VisitorWithState<RubyHash> visitor, IRubyObject other, boolean eql2) {
        if (!(other instanceof RubyHash)) {
            if (!RubyHashLinkedBuckets.sites((ThreadContext)context).respond_to_to_hash.respondsTo(context, other, other)) {
                return context.fals;
            }
            if (eql2) {
                return Helpers.rbEql(context, other, this);
            }
            return Helpers.rbEqual(context, other, this);
        }
        RubyHashLinkedBuckets otherHash = (RubyHashLinkedBuckets)other;
        if (this.size() != otherHash.size()) {
            return context.fals;
        }
        try {
            this.visitAll(context, visitor, otherHash);
        }
        catch (Mismatch e) {
            return context.fals;
        }
        return context.tru;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return RubyHashLinkedBuckets.hashEqual(context, this, other, false);
    }

    static IRubyObject hashEqual(ThreadContext context, RubyHash hash1, IRubyObject _hash2, boolean eql2) {
        if (hash1 == _hash2) {
            return context.tru;
        }
        if (!(_hash2 instanceof RubyHash)) {
            if (!_hash2.respondsTo("to_hash")) {
                return context.fals;
            }
            if (eql2) {
                if (Helpers.rbEql(context, _hash2, hash1).isTrue()) {
                    return context.tru;
                }
                return context.fals;
            }
            return Helpers.rbEqual(context, _hash2, hash1);
        }
        RubyHash hash2 = (RubyHash)_hash2;
        if (hash1.size() != hash2.size()) {
            return context.fals;
        }
        if (!hash1.isEmpty() && !hash2.isEmpty()) {
            if (hash1.isComparedByIdentity() != hash2.isComparedByIdentity()) {
                return context.fals;
            }
            return RecursiveComparator.compare(context, eql2 ? FindMismatchUsingEqlVisitor : FindMismatchUsingEqualVisitor, hash1, hash2, eql2);
        }
        return context.tru;
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return RubyHashLinkedBuckets.hashEqual(context, this, other, true);
    }

    @Override
    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        IRubyObject value2 = this.internalGet(key2);
        return value2 == null ? RubyHashLinkedBuckets.sites((ThreadContext)context).self_default.call(context, (IRubyObject)this, (IRubyObject)this, key2) : value2;
    }

    private boolean hash_le(RubyHash other) {
        return other.directEntrySet().containsAll(this.directEntrySet());
    }

    @Override
    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = ((RubyBasicObject)other).convertToHash();
        if (this.size() >= otherHash.size()) {
            return context.fals;
        }
        return Convert.asBoolean(context, this.hash_le(otherHash));
    }

    @Override
    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        if (this.size() > otherHash.size()) {
            return context.fals;
        }
        return Convert.asBoolean(context, this.hash_le(otherHash));
    }

    @Override
    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        return otherHash.op_lt(context, this);
    }

    @Override
    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        return otherHash.op_le(context, this);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        int size2 = this.size();
        long hash2 = Helpers.hashStart(context.runtime, size2);
        if (size2 != 0) {
            long[] hval = new long[]{hash2};
            this.iteratorVisitAll(context, CalculateHashVisitor, hval);
            hash2 = hval[0];
        }
        return Convert.asFixnum(context, hash2);
    }

    @Override
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2.length, 1, 2);
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        return null;
    }

    @Override
    @JRubyMethod(rest=true)
    public IRubyObject except(ThreadContext context, IRubyObject[] keys2) {
        RubyHashLinkedBuckets result2 = this.hashCopyWithIdentity(context);
        for (int i2 = 0; i2 < keys2.length; ++i2) {
            result2.delete(context, keys2[i2]);
        }
        return result2;
    }

    @Override
    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        IRubyObject value2 = this.internalGet(key2);
        if (value2 != null) {
            return value2;
        }
        if (block.isGiven()) {
            return block.yield(context, key2);
        }
        throw context.runtime.newKeyError("key not found: " + String.valueOf(key2.inspect(context)), this, key2);
    }

    @Override
    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        IRubyObject value2;
        if (block.isGiven()) {
            Warn.warn(context, "block supersedes default value argument");
        }
        if ((value2 = this.internalGet(key2)) == null) {
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            return _default;
        }
        return value2;
    }

    @Override
    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"})
    public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
        return this.hasKey(key2) ? context.tru : context.fals;
    }

    @Override
    public boolean hasKey(IRubyObject key2) {
        return this.internalGetEntry(key2) != NULL_ENTRY;
    }

    private boolean hasValue(ThreadContext context, IRubyObject expected) {
        try {
            this.visitAll(context, FoundIfEqualVisitor, expected);
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @Override
    @JRubyMethod(name={"has_value?", "value?"})
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return Convert.asBoolean(context, this.hasValue(context, expected));
    }

    private void iteratorEntry() {
        if (ITERATOR_UPDATER == null) {
            this.iteratorEntrySync();
            return;
        }
        ITERATOR_UPDATER.incrementAndGet(this);
    }

    private void iteratorExit() {
        if (ITERATOR_UPDATER == null) {
            this.iteratorExitSync();
            return;
        }
        ITERATOR_UPDATER.decrementAndGet(this);
    }

    private synchronized void iteratorEntrySync() {
        ++this.iteratorCount;
    }

    private synchronized void iteratorExitSync() {
        --this.iteratorCount;
    }

    private void iteratorVisitAll(ThreadContext context, RubyHash.VisitorWithStateI visitor) {
        try {
            this.iteratorEntry();
            this.visitAll(context, visitor);
        }
        finally {
            this.iteratorExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void iteratorVisitAll(ThreadContext context, RubyHash.VisitorWithState<T> visitor, T state2) {
        try {
            this.iteratorEntry();
            this.visitAll(context, visitor, state2);
        }
        finally {
            this.iteratorExit();
        }
    }

    @Override
    public RubyHashLinkedBuckets eachCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldArrayVisitor, block);
        return this;
    }

    @Override
    @JRubyMethod(name={"each", "each_pair"})
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyHashLinkedBuckets::size);
    }

    @Override
    public RubyHashLinkedBuckets each_pairCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldKeyValueArrayVisitor, block);
        return this;
    }

    @Override
    public RubyHashLinkedBuckets each_valueCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldValueVisitor, block);
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject each_value(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_valueCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_value", RubyHashLinkedBuckets::size);
    }

    @Override
    public RubyHashLinkedBuckets each_keyCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldKeyVisitor, block);
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject each_key(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_keyCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_key", RubyHashLinkedBuckets::size);
    }

    @Override
    @JRubyMethod(name={"transform_keys"}, rest=true)
    public IRubyObject transform_keys(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0 && !block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_keys", RubyHashLinkedBuckets::size);
        }
        IRubyObject transformHash = args2.length > 0 ? TypeConverter.convertToTypeWithCheck(args2[0], Access.hashClass(context), "to_hash") : context.nil;
        RubyHash result2 = Create.newHash(context);
        if (!this.isEmpty()) {
            if (!transformHash.isNil()) {
                this.visitAll(context, (ctxt, self2, key2, value2, index2) -> {
                    IRubyObject newKey = ((RubyHashLinkedBuckets)transformHash).internalGet(key2);
                    if (newKey == null) {
                        newKey = block.isGiven() ? block.yield(ctxt, key2) : key2;
                    }
                    result2.fastASet(newKey, value2);
                });
            } else {
                this.visitAll(context, (ctxt, self2, key2, value2, index2) -> result2.fastASet(block.yield(ctxt, key2), value2));
            }
        }
        return result2;
    }

    private RubyHashLinkedBuckets hashCopyWithIdentity(ThreadContext context) {
        RubyHashLinkedBuckets copy2 = new RubyHashLinkedBuckets(context.runtime, Access.hashClass(context));
        copy2.replaceWith(context, this);
        return copy2;
    }

    @Override
    @JRubyMethod(name={"transform_values"})
    public IRubyObject transform_values(ThreadContext context, Block block) {
        return this.hashCopyWithIdentity(context).transform_values_bang(context, block);
    }

    @Override
    @JRubyMethod(name={"transform_keys!"}, rest=true)
    public IRubyObject transform_keys_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0 && !block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_keys!", RubyHashLinkedBuckets::size);
        }
        IRubyObject transformHash = args2.length > 0 ? TypeConverter.convertToTypeWithCheck(args2[0], Access.hashClass(context), "to_hash") : context.nil;
        this.modify();
        if (!this.isEmpty()) {
            RubyArray pairs = (RubyArray)this.flatten(context);
            RubyHash newKeys = Create.newHash(context);
            int length2 = pairs.size();
            boolean aborted = false;
            for (int i2 = 0; i2 < length2; i2 += 2) {
                Object newKey;
                Object oldKey;
                block13: {
                    oldKey = pairs.eltOk(i2);
                    if (aborted) {
                        newKey = oldKey;
                    } else {
                        if (transformHash.isNil()) {
                            try {
                                newKey = block.yield(context, (IRubyObject)oldKey);
                                break block13;
                            }
                            catch (IRBreakJump e) {
                                aborted = true;
                                continue;
                            }
                        }
                        newKey = ((RubyHashLinkedBuckets)transformHash).internalGet((IRubyObject)oldKey);
                        if (newKey == null) {
                            if (block.isGiven()) {
                                try {
                                    newKey = block.yield(context, (IRubyObject)oldKey);
                                    break block13;
                                }
                                catch (IRBreakJump e) {
                                    aborted = true;
                                    continue;
                                }
                            }
                            newKey = oldKey;
                        }
                    }
                }
                if (!newKeys.hasKey((IRubyObject)oldKey)) {
                    this.fastDelete((IRubyObject)oldKey);
                }
                this.fastASet((IRubyObject)newKey, (IRubyObject)pairs.eltOk(i2 + 1));
                newKeys.fastASet((IRubyObject)newKey, null);
            }
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"transform_values!"})
    public IRubyObject transform_values_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_values!", RubyHashLinkedBuckets::size);
        }
        this.testFrozen("Hash");
        this.iteratorVisitAll(context, (ctxt, self2, key2, value2, index2) -> self2.op_aset(ctxt, key2, block.yield(ctxt, value2)));
        return this;
    }

    @Override
    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", RubyHashLinkedBuckets::size);
        }
        return this.keep_ifCommon(context, block) ? this : context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", RubyHashLinkedBuckets::size);
        }
        this.keep_ifCommon(context, block);
        return this;
    }

    @Override
    public boolean keep_ifCommon(ThreadContext context, Block block) {
        this.testFrozen("Hash");
        boolean[] modified = new boolean[]{false};
        this.iteratorVisitAll(context, (ctxt, self2, key2, value2, index2) -> {
            if (!block.yieldArray(ctxt, Create.newArray(ctxt, key2, value2), null).isTrue()) {
                this.testFrozen();
                modified[0] = true;
                self2.remove(key2);
            }
        });
        return modified[0];
    }

    @Override
    @JRubyMethod
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        IRubyObject key2 = this.internalIndex(context, expected);
        return key2 != null ? key2 : context.nil;
    }

    private IRubyObject internalIndex(ThreadContext context, IRubyObject expected) {
        try {
            this.visitAll(context, FoundKeyIfEqual, expected);
            return null;
        }
        catch (FoundKey found) {
            return found.key;
        }
    }

    @Override
    @JRubyMethod(name={"keys"})
    public RubyArray keys(ThreadContext context) {
        try {
            RubyArrayNative keys2 = RubyArrayNative.newBlankArrayInternal(context.runtime, this.size());
            this.visitAll(context, StoreKeyVisitor, keys2);
            return keys2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @Override
    public final RubyArray keys() {
        return this.keys(this.metaClass.runtime.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"values"})
    public RubyArray values(ThreadContext context) {
        try {
            RubyArrayNative values2 = RubyArrayNative.newBlankArrayInternal(context.runtime, this.size());
            this.visitAll(context, StoreValueVisitor, values2);
            return values2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @Override
    public final RubyArray rb_values(ThreadContext context) {
        return this.values(context);
    }

    @Override
    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.modify();
        if (this.isEmpty()) {
            return context.nil;
        }
        RubyHash.RubyHashEntry entry = this.head.nextAdded;
        if (entry != this.head) {
            RubyArray<?> result2 = Create.newArray(context, entry.key, entry.value);
            this.internalDeleteEntry(entry);
            return result2;
        }
        CachingCallSite self_default = RubyHashLinkedBuckets.sites((ThreadContext)context).self_default;
        if (this.metaClass == context.runtime.getHash() && Builtins.checkHashDefault(context)) {
            return this.default_value_get(context, context.nil);
        }
        return self_default.call(context, (IRubyObject)this, (IRubyObject)this, context.nil);
    }

    @Override
    public final boolean fastDelete(IRubyObject key2) {
        return this.internalDelete(key2) != NULL_ENTRY;
    }

    @Override
    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        this.modify();
        IRubyObject value2 = this.delete(key2);
        if (value2 != null) {
            return value2;
        }
        return block.isGiven() ? block.yield(context, key2) : context.nil;
    }

    @Override
    public IRubyObject delete(IRubyObject key2) {
        RubyHash.RubyHashEntry entry = this.internalDelete(key2);
        return entry != NULL_ENTRY ? entry.value : null;
    }

    @Override
    public IRubyObject delete(ThreadContext context, IRubyObject key2) {
        return this.delete(context, key2, Block.NULL_BLOCK);
    }

    @Override
    @JRubyMethod(name={"select"}, alias={"filter"})
    public IRubyObject select(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select", RubyHashLinkedBuckets::size);
        }
        RubyHashLinkedBuckets result2 = this.hashCopyWithIdentity(context);
        if (!this.isEmpty()) {
            result2.keep_ifCommon(context, block);
        }
        return result2;
    }

    @Override
    @JRubyMethod(name={"slice"}, rest=true)
    public RubyHash slice(ThreadContext context, IRubyObject[] args2) {
        RubyHash result2 = Create.newHash(context);
        result2.setComparedByIdentity(this.isComparedByIdentity());
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject key2 = args2[i2];
            IRubyObject value2 = this.internalGet(key2);
            if (value2 == null) continue;
            result2.op_aset(context, key2, value2);
        }
        return result2;
    }

    @Override
    public RubyHashLinkedBuckets delete_ifInternal(ThreadContext context, Block block) {
        this.modify();
        this.iteratorVisitAll(context, DeleteIfVisitor, block);
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.delete_ifInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", RubyHashLinkedBuckets::size);
    }

    @Override
    public RubyHashLinkedBuckets rejectInternal(ThreadContext context, Block block) {
        RubyHashLinkedBuckets result2 = this.hashCopyWithIdentity(context);
        if (!this.isEmpty()) {
            result2.delete_ifInternal(context, block);
        }
        return result2;
    }

    @Override
    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject", RubyHashLinkedBuckets::size);
    }

    @Override
    public IRubyObject reject_bangInternal(ThreadContext context, Block block) {
        int n = this.size();
        this.delete_if(context, block);
        if (n == this.size()) {
            return context.nil;
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.reject_bangInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", RubyHashLinkedBuckets::size);
    }

    @Override
    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear(ThreadContext context) {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        RubyHash result2 = Create.newHash(context);
        this.visitAll(context, InvertVisitor, result2);
        return result2;
    }

    @Override
    @JRubyMethod(name={"merge!", "update"}, rest=true)
    public RubyHashLinkedBuckets merge_bang(ThreadContext context, IRubyObject[] others, Block block) {
        this.modify();
        if (others.length == 0) {
            return this;
        }
        for (int i2 = 0; i2 < others.length; ++i2) {
            RubyHash otherHash = others[i2].convertToHash();
            if (otherHash.empty_p(context).isTrue()) continue;
            otherHash.visitAll(context, (ctxt, self2, key2, value2, index2) -> {
                IRubyObject existing;
                if (block.isGiven() && (existing = this.internalGet(key2)) != null) {
                    value2 = block.yield(ctxt, Create.newArray(ctxt, key2, existing, value2));
                }
                this.op_aset(ctxt, key2, value2);
            });
        }
        return this;
    }

    @Override
    public void addAll(ThreadContext context, RubyHash otherHash) {
        if (!otherHash.empty_p(context).isTrue()) {
            otherHash.visitAll(context, (ctxt, self2, key2, value2, index2) -> this.op_aset(ctxt, key2, value2));
        }
    }

    @Override
    @JRubyMethod(rest=true)
    public RubyHash merge(ThreadContext context, IRubyObject[] others, Block block) {
        RubyHash dup2 = (RubyHash)this.dup(context);
        return dup2.merge_bang(context, others, block);
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @Override
    @JRubyMethod(name={"replace"})
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        this.modify();
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.replaceWith(context, otherHash);
        this.ifNone = otherHash.getIfNone();
        if (otherHash.get(4)) {
            this.set(4, true);
        } else {
            this.set(4, false);
        }
        return this;
    }

    protected void replaceWith(ThreadContext context, RubyHash otherHash) {
        if (otherHash.getClass() == RubyHashLinkedBuckets.class) {
            this.alloc();
            RubyHashLinkedBuckets.copyFrom(this, otherHash, otherHash.isComparedByIdentity());
        } else {
            this.replaceExternally(context, otherHash);
        }
    }

    protected void replaceExternally(ThreadContext context, RubyHash otherHash) {
        this.rb_clear(context);
        if (!this.isComparedByIdentity() && otherHash.isComparedByIdentity()) {
            this.setComparedByIdentity(true);
        }
        otherHash.visitAll(context, ReplaceVisitor, this);
    }

    @Override
    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        RubyArrayNative result2 = RubyArrayNative.newBlankArrayInternal(context.runtime, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ((RubyArray)result2).storeInternal(context, i2, this.op_aref(context, args2[i2]));
        }
        return result2;
    }

    @Override
    @JRubyMethod(name={"fetch_values"}, rest=true)
    public RubyArray fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyArrayNative result2 = RubyArrayNative.newBlankArrayInternal(context.runtime, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ((RubyArray)result2).storeInternal(context, i2, this.fetch(context, args2[i2], block));
        }
        return result2;
    }

    @Override
    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        try {
            this.visitAll(context, FoundPairIfEqualKeyVisitor, obj);
            return context.nil;
        }
        catch (FoundPair found) {
            return Create.newArray(context, found.key, found.value);
        }
    }

    @Override
    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        try {
            this.visitAll(context, FoundPairIfEqualValueVisitor, obj);
            return context.nil;
        }
        catch (FoundPair found) {
            return Create.newArray(context, found.key, found.value);
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject flatten(ThreadContext context) {
        RubyArray ary = this.to_a(context);
        RubyHashLinkedBuckets.sites((ThreadContext)context).flatten_bang.call(context, (IRubyObject)ary, (IRubyObject)ary, (IRubyObject)RubyFixnum.one(context.runtime));
        return ary;
    }

    @Override
    @JRubyMethod
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        RubyArray ary = this.to_a(context);
        RubyHashLinkedBuckets.sites((ThreadContext)context).flatten_bang.call(context, (IRubyObject)ary, (IRubyObject)ary, level2);
        return ary;
    }

    @Override
    @JRubyMethod(name={"compact"})
    public IRubyObject compact(ThreadContext context) {
        IRubyObject res = this.dup();
        ((RubyHashLinkedBuckets)res).compact_bang(context);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang(ThreadContext context) {
        boolean changed = false;
        this.modify();
        this.iteratorEntry();
        try {
            RubyHash.RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                if (entry.value == context.nil) {
                    this.internalDelete(entry.key);
                    changed = true;
                }
                entry = entry.nextAdded;
            }
        }
        finally {
            this.iteratorExit();
        }
        return changed ? this : context.nil;
    }

    @Override
    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject compare_by_identity(ThreadContext context) {
        this.modify();
        this.setComparedByIdentity(true);
        return this.rehash(context);
    }

    @Override
    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isComparedByIdentity());
    }

    @Override
    @JRubyMethod
    public IRubyObject dup(ThreadContext context) {
        RubyHashLinkedBuckets dup2 = (RubyHashLinkedBuckets)super.dup();
        dup2.setComparedByIdentity(this.isComparedByIdentity());
        return dup2;
    }

    @Override
    public IRubyObject rbClone(ThreadContext context, IRubyObject opts) {
        RubyHash clone2 = (RubyHash)super.rbClone(context, opts);
        clone2.setComparedByIdentity(this.isComparedByIdentity());
        return clone2;
    }

    @Override
    public IRubyObject rbClone(ThreadContext context) {
        return this.rbClone(context, context.nil);
    }

    @Override
    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, Block block) {
        if (this.isEmpty()) {
            return context.fals;
        }
        if (!block.isGiven()) {
            return context.tru;
        }
        if (block.getSignature().arityValue() > 1) {
            return this.any_p_i_fast(context, block);
        }
        return this.any_p_i(context, block);
    }

    @Override
    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, IRubyObject pattern, Block block) {
        if (this.isEmpty()) {
            return context.fals;
        }
        if (block.isGiven()) {
            Warn.warn(context, "given block not used");
        }
        return this.any_p_p(context, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject any_p_i(ThreadContext context, Block block) {
        this.iteratorEntry();
        try {
            RubyHash.RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                RubyArray<?> newAssoc = Create.newArray(context, entry.key, entry.value);
                if (block.yield(context, newAssoc).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject any_p_i_fast(ThreadContext context, Block block) {
        this.iteratorEntry();
        try {
            RubyHash.RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                if (block.yieldArray(context, Create.newArray(context, entry.key, entry.value), null).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject any_p_p(ThreadContext context, IRubyObject pattern) {
        this.iteratorEntry();
        try {
            RubyHash.RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                RubyArray<?> newAssoc = Create.newArray(context, entry.key, entry.value);
                if (pattern.callMethod(context, "===", newAssoc).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    @Override
    public RubyHashLinkedBuckets dupFast(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyHashLinkedBuckets dup2 = new RubyHashLinkedBuckets(runtime2, this.metaClass, this);
        dup2.setComparedByIdentity(this.isComparedByIdentity());
        dup2.ifNone = this.ifNone;
        if (this.get(4)) {
            dup2.set(4, true);
        } else {
            dup2.set(4, false);
        }
        return dup2;
    }

    @Override
    public RubyHashLinkedBuckets withRuby2Keywords(boolean ruby2Keywords) {
        this.setRuby2KeywordHash(ruby2Keywords);
        return this;
    }

    @Override
    public boolean hasDefaultProc() {
        return this.get(4);
    }

    @Override
    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    @Override
    @JRubyMethod
    public IRubyObject deconstruct_keys(ThreadContext context, IRubyObject _arg1) {
        return this;
    }

    @Override
    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0) {
        return this.op_aref(context, arg0);
    }

    @Override
    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject val = this.op_aref(context, arg0);
        return RubyObject.dig1(context, val, arg1);
    }

    @Override
    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject val = this.op_aref(context, arg0);
        return RubyObject.dig2(context, val, arg1, arg2);
    }

    @Override
    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject val = this.op_aref(context, args2[0]);
        return argc == 1 ? val : RubyObject.dig(context, val, args2, 1);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        Block block = CallBlock19.newCallClosure((IRubyObject)this, (RubyModule)this.metaClass, Signature.ONE_ARGUMENT, (context1, args2, procBlock) -> {
            Arity.checkArgumentCount(context1, args2, 1, 1);
            return this.op_aref(context1, args2[0]);
        }, context);
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ruby2_keywords_hash(ThreadContext context, IRubyObject _self, IRubyObject arg2) {
        TypeConverter.checkType(context, arg2, Access.hashClass(context));
        RubyHashLinkedBuckets hash2 = (RubyHashLinkedBuckets)arg2.dup();
        hash2.setRuby2KeywordHash(true);
        return hash2;
    }

    @JRubyMethod(meta=true, name={"ruby2_keywords_hash?"})
    public static IRubyObject ruby2_keywords_hash_p(ThreadContext context, IRubyObject _self, IRubyObject arg2) {
        TypeConverter.checkType(context, arg2, Access.hashClass(context));
        return Convert.asBoolean(context, ((RubyHashLinkedBuckets)arg2).isRuby2KeywordHash());
    }

    public static void marshalTo(ThreadContext context, final RubyOutputStream out, RubyHashLinkedBuckets hash2, MarshalDumper output) {
        output.registerObject(hash2);
        int hashSize = hash2.size();
        output.writeInt(out, hashSize);
        try {
            hash2.visitLimited(context, new RubyHash.VisitorWithState<MarshalDumper>(){

                @Override
                public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, MarshalDumper state2) {
                    state2.dumpObject(context, out, key2);
                    state2.dumpObject(context, out, value2);
                }
            }, hashSize, output);
        }
        catch (RubyHash.VisitorIOException e) {
            throw Error.toRubyException(context, (IOException)e.getCause());
        }
        if (hash2.ifNone != UNDEF) {
            output.dumpObject(context, out, hash2.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input, boolean defaultValue, boolean identity) {
        RubyHash result2 = Create.newHash(context);
        if (identity) {
            result2.setComparedByIdentity(true);
        }
        result2 = (RubyHashLinkedBuckets)input.entry(result2);
        int size2 = input.unmarshalInt(context, in);
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.fastASetCheckString(context.runtime, input.unmarshalObject(context, in), input.unmarshalObject(context, in));
        }
        if (defaultValue) {
            result2.default_value_set(context, input.unmarshalObject(context, in));
        }
        return result2;
    }

    @Override
    public Class getJavaClass() {
        return Map.class;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, key2)) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.hasValue(this.metaClass.runtime.getCurrentContext(), JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, value2));
    }

    @Override
    public Object get(Object key2) {
        IRubyObject gotten = this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, key2));
        return gotten == null ? null : gotten.toJava(Object.class);
    }

    @Override
    public Object put(Object key2, Object value2) {
        Ruby runtime2 = this.metaClass.runtime;
        IRubyObject existing = this.internalPutNoResize(JavaUtil.convertJavaToUsableRubyObject(runtime2, key2), JavaUtil.convertJavaToUsableRubyObject(runtime2, value2), true);
        return existing == null ? null : existing.toJava(Object.class);
    }

    @Override
    public Object remove(Object key2) {
        IRubyObject rubyKey = JavaUtil.convertJavaToUsableRubyObject(this.metaClass.runtime, key2);
        return this.internalDelete((IRubyObject)rubyKey).value;
    }

    @Override
    public void putAll(Map map2) {
        Ruby runtime2 = this.metaClass.runtime;
        for (Map.Entry entry : map2.entrySet()) {
            this.internalPut(JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey()), JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.rb_clear(this.getRuntime().getCurrentContext());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyHashLinkedBuckets)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.op_equal(this.metaClass.runtime.getCurrentContext(), (RubyHashLinkedBuckets)other).isTrue();
    }

    @Override
    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    @Override
    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    @Override
    public Collection values() {
        return new BaseCollection(VALUE_VIEW);
    }

    @Override
    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    @Override
    public Set entrySet() {
        return new BaseSet(ENTRY_VIEW);
    }

    @Override
    public Set directEntrySet() {
        return new BaseSet(DIRECT_ENTRY_VIEW);
    }

    private final RaiseException concurrentModification() {
        return this.metaClass.runtime.newConcurrencyError("Detected invalid hash contents due to unsynchronized modifications with concurrent users");
    }

    @Override
    public boolean isComparedByIdentity() {
        return this.get(1);
    }

    @Override
    public void setComparedByIdentity(boolean comparedByIdentity) {
        this.set(1, comparedByIdentity);
    }

    @Override
    public boolean isRuby2KeywordHash() {
        return this.get(2);
    }

    @Override
    public void setRuby2KeywordHash(boolean value2) {
        this.set(2, value2);
    }

    private static JavaSites.HashSites sites(ThreadContext context) {
        return context.sites.Hash;
    }

    static {
        AtomicIntegerFieldUpdater<RubyHashLinkedBuckets> iterUp = null;
        try {
            iterUp = AtomicIntegerFieldUpdater.newUpdater(RubyHashLinkedBuckets.class, "iteratorCount");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        ITERATOR_UPDATER = iterUp;
        YieldArrayVisitor = new RubyHash.VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yieldArray(context, Create.newArray(context, key2, value2), null);
            }
        };
        YieldKeyValueArrayVisitor = new RubyHash.VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                if (block.type == Block.Type.LAMBDA) {
                    block.call(context, Create.newArray(context, key2, value2));
                } else if (block.getSignature().isSpreadable()) {
                    block.yieldSpecific(context, key2, value2);
                } else {
                    block.yield(context, Create.newArray(context, key2, value2));
                }
            }
        };
        YieldValueVisitor = new RubyHash.VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yield(context, value2);
            }
        };
        YieldKeyVisitor = new RubyHash.VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yield(context, key2);
            }
        };
        FoundKeyIfEqual = new RubyHash.VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject expected) {
                if (RubyObject.equalInternal(context, value2, expected)) {
                    throw new FoundKey(key2);
                }
            }
        };
        StoreKeyVisitor = new RubyHash.VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray keys2) {
                keys2.storeInternal(context, index2, key2);
            }
        };
        MISMATCH = new Mismatch();
        DeleteIfVisitor = new RubyHash.VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                if (block.yieldArray(context, Create.newArray(context, key2, value2), null).isTrue()) {
                    self2.delete(context, key2, Block.NULL_BLOCK);
                }
            }
        };
        InvertVisitor = new RubyHash.VisitorWithState<RubyHashLinkedBuckets>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHashLinkedBuckets state2) {
                state2.op_aset(context, value2, key2);
            }
        };
        ReplaceVisitor = new RubyHash.VisitorWithState<RubyHash>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash target2) {
                target2.op_aset(context, key2, value2);
            }
        };
        FoundPairIfEqualKeyVisitor = new RubyHash.VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject obj) {
                if (RubyObject.equalInternal(context, obj, key2)) {
                    throw new FoundPair(key2, value2);
                }
            }
        };
        FoundPairIfEqualValueVisitor = new RubyHash.VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject obj) {
                if (RubyObject.equalInternal(context, obj, value2)) {
                    throw new FoundPair(key2, value2);
                }
            }
        };
        DIRECT_KEY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return entry.key;
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                return hash2.internalGet((IRubyObject)o) != null;
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                return hash2.internalDelete((IRubyObject)o) != RubyHash.NULL_ENTRY;
            }
        };
        KEY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return entry.key.toJava(Object.class);
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                return hash2.containsKey(o);
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                return hash2.remove(o) != null;
            }
        };
        DIRECT_VALUE_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return entry.value;
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                IRubyObject obj = (IRubyObject)o;
                return hash2.hasValue(obj.getRuntime().getCurrentContext(), obj);
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                IRubyObject obj = (IRubyObject)o;
                IRubyObject key2 = hash2.internalIndex(obj.getRuntime().getCurrentContext(), obj);
                if (key2 == null) {
                    return false;
                }
                return hash2.internalDelete(key2) != RubyHash.NULL_ENTRY;
            }
        };
        VALUE_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return entry.value.toJava(Object.class);
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                return hash2.containsValue(o);
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                Ruby runtime2 = hash2.metaClass.runtime;
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, o);
                IRubyObject key2 = hash2.internalIndex(runtime2.getCurrentContext(), value2);
                if (key2 == null) {
                    return false;
                }
                return hash2.internalDelete(key2) != RubyHash.NULL_ENTRY;
            }
        };
        DIRECT_ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return entry;
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof RubyHash.RubyHashEntry)) {
                    return false;
                }
                RubyHash.RubyHashEntry entry = (RubyHash.RubyHashEntry)o;
                RubyHash.RubyHashEntry candidate = hash2.internalGetEntry(entry.key);
                return candidate != RubyHash.NULL_ENTRY && entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof RubyHash.RubyHashEntry)) {
                    return false;
                }
                return hash2.internalDeleteEntry((RubyHash.RubyHashEntry)o) != RubyHash.NULL_ENTRY;
            }
        };
        ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
                return new ConvertingEntry(runtime2, entry);
            }

            @Override
            public boolean contains(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                RubyHash.RubyHashEntry candidate = hash2.internalGetEntry(entry.entry.key);
                return candidate != RubyHash.NULL_ENTRY && entry.entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHashLinkedBuckets hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                return hash2.internalDeleteEntry(entry.entry) != RubyHash.NULL_ENTRY;
            }
        };
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHash.RubyHashEntry var1, Object var2);
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class Found
    extends RuntimeException {
        private Found() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    private static class FoundKey
    extends Found {
        public final IRubyObject key;

        FoundKey(IRubyObject key2) {
            this.key = key2;
        }
    }

    private static class FoundPair
    extends FoundKey {
        public final IRubyObject value;

        FoundPair(IRubyObject key2, IRubyObject value2) {
            super(key2);
            this.value = value2;
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHashLinkedBuckets.this, o);
        }

        @Override
        public void clear() {
            RubyHashLinkedBuckets.this.clear();
        }

        @Override
        public int size() {
            return RubyHashLinkedBuckets.this.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHashLinkedBuckets.this, o);
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHash.RubyHashEntry var2);

        public abstract boolean contains(RubyHashLinkedBuckets var1, Object var2);

        public abstract boolean remove(RubyHashLinkedBuckets var1, Object var2);
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHashLinkedBuckets.this, o);
        }

        @Override
        public void clear() {
            RubyHashLinkedBuckets.this.clear();
        }

        @Override
        public int size() {
            return RubyHashLinkedBuckets.this.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHashLinkedBuckets.this, o);
        }
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHash.RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby runtime2, RubyHash.RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime2;
        }

        public Object getKey() {
            return this.entry.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.entry.value.toJava(Object.class);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(JavaUtil.convertJavaToUsableRubyObject(this.runtime, o));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry other = (ConvertingEntry)o;
            return this.entry.equals(other.entry);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHash.RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView view) {
            this.view = view;
            this.entry = RubyHashLinkedBuckets.this.head;
            this.startGeneration = RubyHashLinkedBuckets.this.generation;
        }

        private void advance(boolean consume) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHashLinkedBuckets.this.generation) {
                        this.startGeneration = RubyHashLinkedBuckets.this.generation;
                        this.entry = RubyHashLinkedBuckets.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHashLinkedBuckets.this.head && !this.entry.isLive());
            }
            this.peeking = !consume;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHashLinkedBuckets.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHashLinkedBuckets.this.getRuntime(), this.entry);
        }

        @Override
        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHashLinkedBuckets.this.head;
        }

        @Override
        public void remove() {
            if (this.entry == RubyHashLinkedBuckets.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHashLinkedBuckets.this.internalDeleteEntry(this.entry);
        }
    }
}

