/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProducer;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.StopIteration;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;

@JRubyModule(name={"Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject
implements Iterator<Object> {
    public static final String GENERATOR = "@__generator__";
    public static final String LOOKAHEAD = "@__lookahead__";
    public static final String FEEDVALUE = "@__feedvalue__";
    public static final String OBJECT = "@__object__";
    public static final String METHOD = "@__method__";
    public static final String ARGS = "@__args__";
    private IRubyObject object;
    private String method;
    private IRubyObject[] methodArgs;
    private boolean methodArgsHasKeywords;
    private IRubyObject size;
    private SizeFn sizeFn;
    private FeedValue feedValue;

    public static RubyClass defineEnumerator(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        RubyClass Enumerator2 = (RubyClass)((RubyModule)Define.defineClass(context, "Enumerator", Object2, RubyEnumerator::new).include(context, Enumerable)).defineMethods(context, RubyEnumerator.class);
        ((RubyModule)Enumerator2.defineClassUnder(context, "FeedValue", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, FeedValue.class);
        Enumerator2.setConstantVisibility(context, "FeedValue", true);
        return Enumerator2;
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.initialize(runtime2, runtime2.getNil(), RubyString.newEmptyString(runtime2), NULL_ARRAY);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2, IRubyObject object, RubySymbol method2, IRubyObject[] args2, IRubyObject size2, SizeFn sizeFn, boolean keywords) {
        super(runtime2, type2);
        this.initialize(runtime2, object, method2, args2, size2, sizeFn, keywords);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2, IRubyObject object, IRubyObject method2, IRubyObject[] args2) {
        super(runtime2, type2);
        this.initialize(runtime2, object, method2, args2);
    }

    public static <T extends IRubyObject> RubyEnumerator enumWithSize(ThreadContext context, T object, String method2, IRubyObject[] args2, SizeFn<T> sizeFn) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), args2, null, sizeFn, false);
    }

    public static <T extends IRubyObject> IRubyObject enumeratorizeWithSize(ThreadContext context, T object, String method2, IRubyObject[] args2, SizeFn<T> sizeFn, boolean keywords) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), args2, null, sizeFn, keywords);
    }

    public static <T extends IRubyObject> IRubyObject enumeratorizeWithSize(ThreadContext context, T object, String method2, IRubyObject[] args2, SizeFn<T> sizeFn) {
        return RubyEnumerator.enumeratorizeWithSize(context, object, method2, args2, sizeFn, false);
    }

    public static <T extends IRubyObject> IRubyObject enumeratorizeWithSize(ThreadContext context, T object, String method2, SizeFn<T> sizeFn) {
        return RubyEnumerator.enumeratorizeWithSize(context, object, method2, NULL_ARRAY, sizeFn);
    }

    public static <T extends IRubyObject> RubyEnumerator enumWithSize(ThreadContext context, T object, String method2, SizeFn<T> sizeFn) {
        return RubyEnumerator.enumWithSize(context, object, method2, NULL_ARRAY, sizeFn);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method2, IRubyObject arg2, IRubyObject size2) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2}, size2, null, false);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject ... args2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), args2);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2, IRubyObject[] args2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), args2);
    }

    @JRubyMethod(name={"__from"}, meta=true, required=2, optional=2, checkArity=false, visibility=Visibility.PRIVATE, keywords=true)
    public static IRubyObject __from(ThreadContext context, IRubyObject klass, IRubyObject[] args2) {
        IRubyObject[] methodArgs;
        int argc = Arity.checkArgumentCount(context, args2, 2, 4);
        boolean keywords = (context.callInfo & 2) != 0 && (context.callInfo & 8) == 0;
        ThreadContext.resetCallInfo(context);
        IRubyObject object = args2[0];
        IRubyObject method2 = args2[1];
        IRubyObject size2 = null;
        SizeFn<IRubyObject> sizeFn = null;
        if (argc > 2) {
            methodArgs = ((RubyArray)args2[2]).toJavaArrayMaybeUnsafe();
            if (argc > 3) {
                size2 = args2[3];
            }
        } else {
            methodArgs = NULL_ARRAY;
        }
        RubyEnumerator instance = (RubyEnumerator)((RubyClass)klass).allocate(context);
        if (size2 == null) {
            sizeFn = RubyEnumerable::size;
        }
        instance.initialize(context.runtime, object, method2, methodArgs, size2, sizeFn, keywords);
        instance.setInstanceVariable("@receiver", object);
        instance.setInstanceVariable("@method", method2);
        instance.setInstanceVariable("@args", RubyArray.newArrayNoCopyLight(context.runtime, methodArgs));
        return instance;
    }

    @Override
    public IRubyObject initialize(ThreadContext context) {
        return this.initialize(context, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        return this.initializeWithSize(context, null, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject size2, Block block) {
        return this.initializeWithSize(context, size2, block);
    }

    private static void checkSize(ThreadContext context, IRubyObject size2) {
        if (!(size2 == null || size2.isNil() || size2.respondsTo("call") || size2 instanceof RubyFloat && ((RubyFloat)size2).value == Double.POSITIVE_INFINITY || size2 instanceof RubyInteger)) {
            throw Error.typeError(context, size2, "Integer");
        }
    }

    private IRubyObject initializeWithSize(ThreadContext context, IRubyObject size2, Block block) {
        RubyEnumerator.checkSize(context, size2);
        IRubyObject object = context.runtime.getGenerator().newInstance(context, NULL_ARRAY, block);
        RubySymbol method2 = Convert.asSymbol(context, "each");
        return this.initialize(context.runtime, object, method2, NULL_ARRAY, size2, null, false);
    }

    private IRubyObject initialize(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs) {
        return this.initialize(runtime2, object, method2, methodArgs, null, null, false);
    }

    private IRubyObject initialize(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs, IRubyObject size2, SizeFn sizeFn, boolean keywords) {
        this.object = object;
        this.method = method2.asJavaString();
        this.methodArgs = methodArgs;
        this.methodArgsHasKeywords = keywords;
        this.size = size2;
        this.sizeFn = sizeFn;
        this.setInstanceVariable(OBJECT, object);
        this.setInstanceVariable(METHOD, method2);
        this.setInstanceVariable(ARGS, RubyArray.newArrayMayCopy(runtime2, methodArgs));
        this.setInstanceVariable(GENERATOR, runtime2.getNil());
        this.setInstanceVariable(LOOKAHEAD, RubyArray.newArray(runtime2, 4));
        this.feedValue = new FeedValue(runtime2);
        this.setInstanceVariable(FEEDVALUE, this.feedValue);
        return this;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyEnumerator copy2 = (RubyEnumerator)super.dup();
        copy2.object = this.object;
        copy2.method = this.method;
        copy2.methodArgs = this.methodArgs;
        copy2.methodArgsHasKeywords = this.methodArgsHasKeywords;
        copy2.size = this.size;
        copy2.sizeFn = this.sizeFn;
        copy2.feedValue = new FeedValue(this.getRuntime());
        return copy2;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this;
        }
        return this.__each__(context, block);
    }

    private IRubyObject __each__(ThreadContext context, Block block) {
        if (this.methodArgsHasKeywords) {
            context.callInfo = 2;
        }
        return this.object.callMethod(context, this.method, this.methodArgs, CallBlock.newCallClosure(context, this, block.getSignature(), (ctx, args2, blk) -> {
            IRubyObject ret = args2.length == 1 ? block.yield(ctx, args2[0]) : block.yieldValues(ctx, args2);
            IRubyObject val = this.feedValue.use_value(ctx);
            return val.isNil() ? ret : val;
        }));
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            return this.each(context, block);
        }
        int mlen = this.methodArgs.length;
        Object[] newArgs = new IRubyObject[mlen + args2.length];
        ArraySupport.copy(this.methodArgs, newArgs, 0, mlen);
        ArraySupport.copy(args2, newArgs, mlen, args2.length);
        return new RubyEnumerator(context.runtime, this.getType(), this.object, Convert.asSymbol(context, this.method), (IRubyObject[])newArgs, this.size, this.sizeFn, this.methodArgsHasKeywords).each(context, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        ByteList bytes2 = new ByteList(new byte[]{35, 60});
        bytes2.append(this.getMetaClass().getName(context).getBytes());
        bytes2.append((byte)58).append((byte)32);
        RubyString result2 = RubyString.newStringNoCopy(context.runtime, bytes2);
        if (recurse) {
            return result2.catString("...>");
        }
        result2.catWithCodeRange(RubyObject.inspect(context, this.object));
        result2.cat(58);
        result2.catWithCodeRange(this.getMethod().asString());
        if (this.methodArgs.length > 0) {
            result2.cat(40);
            for (int i2 = 0; !(i2 >= this.methodArgs.length || this.methodArgsHasKeywords && i2 == 0); ++i2) {
                result2.catWithCodeRange(RubyObject.inspect(context, this.methodArgs[i2]));
                if (i2 < this.methodArgs.length - 1) {
                    result2.catString(", ");
                    continue;
                }
                result2.cat(41);
            }
        }
        result2.cat(62);
        return result2;
    }

    @JRubyMethod
    public IRubyObject each_with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_with_object", new IRubyObject[]{arg2}, RubyEnumerator::size);
    }

    @JRubyMethod
    public IRubyObject with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, this, "with_object", new IRubyObject[]{arg2}, RubyEnumerator::size);
    }

    @JRubyMethod
    public IRubyObject each_entry(ThreadContext context, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, (IRubyObject)this, NULL_ARRAY, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_entry", NULL_ARRAY);
    }

    @JRubyMethod
    public IRubyObject each_entry(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, (IRubyObject)this, arg0, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_entry", Helpers.arrayOf(arg0));
    }

    @JRubyMethod(rest=true)
    public IRubyObject each_entry(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, (IRubyObject)this, args2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_entry", args2);
    }

    @JRubyMethod(name={"each_slice"})
    public IRubyObject each_slice(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = Convert.toInt(context, arg2);
        if (size2 <= 0) {
            throw Error.argumentError(context, "invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_sliceCommon(context, this, size2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_slice", arg2);
    }

    @JRubyMethod(name={"each_cons"})
    public IRubyObject each_cons(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = Convert.toInt(context, arg2);
        if (size2 <= 0) {
            throw Error.argumentError(context, "invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_consCommon(context, this, size2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_cons", arg2);
    }

    @JRubyMethod
    public final IRubyObject size(ThreadContext context) {
        if (this.sizeFn != null) {
            return this.sizeFn.size(context, this.object, this.methodArgs);
        }
        IRubyObject size2 = this.size;
        if (size2 != null) {
            return size2.respondsTo("call") ? size2.callMethod(context, "call") : size2;
        }
        return context.nil;
    }

    public long size() {
        long l;
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject size2 = this.size(context);
        if (size2 instanceof RubyNumeric) {
            RubyNumeric numeric = (RubyNumeric)size2;
            l = numeric.asLong(context);
        } else {
            l = -1L;
        }
        return l;
    }

    private static IRubyObject size(ThreadContext context, RubyEnumerator recv2, IRubyObject[] args2) {
        return recv2.size(context);
    }

    private IRubyObject with_index_common(ThreadContext context, Block block, String rubyMethodName, IRubyObject arg2) {
        int index2;
        int n = index2 = arg2.isNil() ? 0 : Convert.toInt(context, arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorizeWithSize(context, this, rubyMethodName, RubyEnumerator::size) : RubyEnumerator.enumeratorizeWithSize(context, this, rubyMethodName, new IRubyObject[]{Convert.asFixnum(context, index2)}, RubyEnumerator::size);
        }
        return RubyEnumerable.callEach(context, RubyEnumerator.sites((ThreadContext)context).each, this, (BlockCallback)new RubyEnumerable.EachWithIndex(block, index2));
    }

    @JRubyMethod
    public IRubyObject each_with_index(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "each_with_index", context.nil);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "with_index", context.nil);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, IRubyObject arg2, Block block) {
        return this.with_index_common(context, block, "with_index", arg2);
    }

    @Override
    public synchronized boolean hasNext() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        try {
            RubyEnumerator.sites((ThreadContext)context).peek.call(context, this, this);
            return true;
        }
        catch (StopIteration si) {
            return false;
        }
    }

    private IRubyObject getMethod() {
        return this.getInstanceVariable(METHOD);
    }

    @Override
    public Object next() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return RubyEnumerator.sites((ThreadContext)context).next.call(context, this, this).toJava(Object.class);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Stream<Object> stream() {
        return this.stream(false);
    }

    public Stream<Object> stream(boolean parallel) {
        return StreamSupport.stream(this.spliterator(), parallel);
    }

    public Spliterator<Object> spliterator() {
        long size2 = this.size();
        int mod = 1024;
        if (size2 >= 0L) {
            mod |= 0x40;
        }
        return Spliterators.spliterator(this, size2, mod);
    }

    public Spliterator<Object> spliterator(int mod) {
        return Spliterators.spliterator(this, this.size(), mod);
    }

    private static JavaSites.FiberSites sites(ThreadContext context) {
        return context.sites.Fiber;
    }

    @JRubyMethod(meta=true, optional=2, checkArity=false, keywords=true)
    public static IRubyObject produce(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject size2 = UNDEF;
        int argc = args2.length;
        if (ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context))) {
            --argc;
            IRubyObject maybeSize = ArgsUtil.extractKeywordArg(context, (RubyHash)args2[args2.length - 1], "size");
            if (maybeSize != null) {
                size2 = maybeSize;
            }
        }
        size2 = size2 == UNDEF ? context.runtime.getFloat().getConstant("INFINITY") : RubyEnumerator.convertToFeasibleSizeValue(context, size2);
        Arity.checkArgumentCount(context, argc, 0, 1);
        if (!block.isGiven()) {
            throw Error.argumentError(context, "no block given");
        }
        IRubyObject init = argc == 0 ? null : args2[0];
        RubyProducer producer = RubyProducer.newProducer(context, init, block, size2);
        return RubyEnumerator.enumeratorizeWithSize(context, producer, "each", RubyProducer::size);
    }

    private static IRubyObject convertToFeasibleSizeValue(ThreadContext context, IRubyObject obj) {
        if (obj.isNil()) {
            return obj;
        }
        if (obj.respondsTo("call")) {
            return obj;
        }
        if (obj instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)obj;
            if (flote.value == Double.POSITIVE_INFINITY) {
                return obj;
            }
        }
        return Convert.toInteger(context, obj);
    }

    @Deprecated(since="9.4.3.0")
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject size2 = Arity.checkArgumentCount(context, args2, 0, 1) == 1 ? args2[0] : null;
        return this.initializeWithSize(context, size2, block);
    }

    @Deprecated(since="9.4.3.0")
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        return this.initialize(context, args2, Block.NULL_BLOCK);
    }

    public static class FeedValue
    extends RubyObject {
        private volatile IRubyObject value;

        private FeedValue(ThreadContext context, RubyClass type2) {
            super(context.runtime, type2);
            this.value = context.nil;
        }

        @Deprecated(since="10.0.0.0")
        FeedValue(Ruby runtime2) {
            this(runtime2.getCurrentContext());
        }

        FeedValue(ThreadContext context) {
            this(context, (RubyClass)Access.enumeratorClass(context).getConstantAt(context, "FeedValue", true));
        }

        @JRubyMethod
        public IRubyObject value() {
            return this.value;
        }

        @JRubyMethod(name={"value="})
        public IRubyObject set_value(IRubyObject value2) {
            this.value = value2;
            return this.value;
        }

        @JRubyMethod
        public IRubyObject use_value(ThreadContext context) {
            IRubyObject value2 = this.value;
            this.value = context.nil;
            return value2;
        }
    }

    public static interface SizeFn<T extends IRubyObject> {
        public IRubyObject size(ThreadContext var1, T var2, IRubyObject[] var3);
    }
}

