/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.tls.TlsClientProtocol;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsClientProtocol
extends TlsClientProtocol {
    private static final boolean provAcceptRenegotiation = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.acceptRenegotiation", false);
    private final Closeable closeable;

    ProvTlsClientProtocol(InputStream inputStream, OutputStream outputStream, Closeable closeable) {
        super(inputStream, outputStream);
        this.closeable = closeable;
    }

    @Override
    protected void closeConnection() throws IOException {
        this.closeable.close();
    }

    @Override
    protected int getRenegotiationPolicy() {
        return provAcceptRenegotiation ? 2 : 0;
    }
}

