/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import com.headius.backport9.stack.StackWalker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.util.JavaNameMangler;

public class BacktraceData
implements Serializable {
    public static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private RubyStackTraceElement[] backtraceElements;
    private final Stream<StackWalker.StackFrame> stackStream;
    private final Stream<BacktraceElement> rubyTrace;
    private final boolean fullTrace;
    private final boolean rawTrace;
    private final boolean maskNative;
    private final boolean includeNonFiltered;
    private final boolean excludeInternal;
    public static final BacktraceData EMPTY = new BacktraceData(null);

    public BacktraceData(Stream<StackWalker.StackFrame> stackStream, Stream<BacktraceElement> rubyTrace, boolean fullTrace, boolean rawTrace, boolean maskNative, boolean includeNonFiltered, boolean excludeInternal) {
        this.stackStream = stackStream;
        this.rubyTrace = rubyTrace;
        this.fullTrace = fullTrace;
        this.rawTrace = rawTrace;
        this.maskNative = maskNative;
        this.includeNonFiltered = includeNonFiltered;
        this.excludeInternal = excludeInternal;
    }

    public BacktraceData(RubyStackTraceElement[] backtraceElements) {
        this.backtraceElements = backtraceElements;
        this.stackStream = Stream.empty();
        this.rubyTrace = Stream.empty();
        this.fullTrace = false;
        this.rawTrace = false;
        this.maskNative = false;
        this.includeNonFiltered = false;
        this.excludeInternal = false;
    }

    public final RubyStackTraceElement[] getBacktrace(Ruby runtime2) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime2.getBoundMethods());
        }
        return this.backtraceElements;
    }

    public final RubyStackTraceElement[] getPartialBacktrace(Ruby runtime2, int level2) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime2.getBoundMethods(), level2);
        }
        return this.backtraceElements;
    }

    public final void yieldPartialBacktrace(Ruby runtime2, Predicate<RubyStackTraceElement> consumer) {
        if (this.backtraceElements == null) {
            this.eachBacktrace(runtime2.getBoundMethods(), consumer);
        }
    }

    public RubyStackTraceElement[] getBacktraceWithoutRuby() {
        return this.constructBacktrace(Collections.EMPTY_MAP);
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods) {
        return this.constructBacktrace(boundMethods, Integer.MAX_VALUE);
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods, int count2) {
        ArrayList trace2 = new ArrayList();
        this.eachBacktrace(boundMethods, elt -> {
            trace2.add(elt);
            return trace2.size() < count2;
        });
        return (RubyStackTraceElement[])trace2.toArray(RubyStackTraceElement[]::new);
    }

    private void eachBacktrace(Map<String, Map<String, String>> boundMethods, Predicate<RubyStackTraceElement> consumer) {
        boolean dupFrame = false;
        Object dupFrameName = null;
        Iterator stackIter = this.stackStream.iterator();
        Iterator backIter = this.rubyTrace.iterator();
        StackWalker.StackFrame previousElement = null;
        while (stackIter.hasNext()) {
            FrameType frameType;
            StackWalker.StackFrame element = (StackWalker.StackFrame)stackIter.next();
            int line = element.getLineNumber();
            String filename2 = element.getFileName();
            String methodName = element.getMethodName();
            String className = element.getClassName();
            if (!this.rawTrace && filename2 != null && !filename2.endsWith(".java")) {
                FrameType type2;
                String decodedName;
                if (this.excludeInternal && TraceType.isExcludedInternal(filename2)) continue;
                List<String> mangledTuple = JavaNameMangler.decodeMethodTuple(methodName);
                if (mangledTuple != null && (decodedName = JavaNameMangler.decodeMethodName(type2 = JavaNameMangler.decodeFrameTypeFromMangledName(mangledTuple.get(1)), mangledTuple)) != null) {
                    if (previousElement != null && element.getMethodName().equals(previousElement.getMethodName() + "\u00a0**")) {
                        previousElement = null;
                        continue;
                    }
                    if (TraceType.isExcludedInternal(filename2)) {
                        if (this.excludeInternal) continue;
                        if (this.maskNative) {
                            dupFrame = true;
                            dupFrameName = decodedName;
                            continue;
                        }
                        filename2 = TraceType.maskInternalFiles(filename2);
                    }
                    RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, decodedName, filename2, line, false, type2);
                    if (this.maskNative && dupFrame) {
                        dupFrame = false;
                        if (!consumer.test(new RubyStackTraceElement(className, (String)dupFrameName, filename2, line, false, type2))) break;
                    }
                    if (!consumer.test(rubyElement)) break;
                    previousElement = element;
                    continue;
                }
            }
            String rubyName = methodName;
            if (this.fullTrace || (rubyName = BacktraceData.getBoundMethodName(boundMethods, className, methodName)) != null) {
                filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
                if (this.maskNative) {
                    dupFrame = true;
                    dupFrameName = rubyName;
                    continue;
                }
                if (!consumer.test(new RubyStackTraceElement(className, rubyName, filename2, line, false))) break;
                if (!this.fullTrace) continue;
            }
            if (backIter.hasNext() && (frameType = FrameType.getInterpreterFrame(className, methodName)) != null) {
                BacktraceElement rubyFrame = (BacktraceElement)backIter.next();
                Object translatedName = switch (frameType) {
                    case FrameType.METHOD -> rubyFrame.method;
                    case FrameType.BLOCK -> rubyFrame.method;
                    case FrameType.CLASS -> "<class:" + rubyFrame.method + ">";
                    case FrameType.MODULE -> "<module:" + rubyFrame.method + ">";
                    case FrameType.METACLASS -> "singleton class";
                    case FrameType.ROOT -> "<main>";
                    case FrameType.EVAL -> rubyFrame.method == null || rubyFrame.method.isEmpty() ? "<main>" : rubyFrame.method;
                    default -> rubyFrame.method;
                };
                filename2 = rubyFrame.filename;
                if (TraceType.isExcludedInternal(filename2)) {
                    if (this.excludeInternal) continue;
                    if (this.maskNative) {
                        dupFrame = true;
                        dupFrameName = translatedName;
                        continue;
                    }
                    filename2 = TraceType.maskInternalFiles(filename2);
                }
                RubyStackTraceElement rubyElement = new RubyStackTraceElement("RUBY", (String)translatedName, filename2, rubyFrame.line + 1, false, frameType);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    if (!consumer.test(new RubyStackTraceElement(rubyElement.getClassName(), (String)dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding(), rubyElement.getFrameType()))) break;
                }
                if (consumer.test(rubyElement)) continue;
                break;
            }
            if (!this.includeNonFiltered || BacktraceData.isFilteredClass(className) || consumer.test(new RubyStackTraceElement(className, methodName, filename2 = BacktraceData.packagedFilenameFromElement(filename2, className), line, false))) continue;
            break;
        }
    }

    public static String getBoundMethodName(Map<String, Map<String, String>> boundMethods, String className, String methodName) {
        Map<String, String> javaToRuby = boundMethods.get(className);
        return javaToRuby == null ? null : javaToRuby.get(methodName);
    }

    private static String packagedFilenameFromElement(String filename2, String className) {
        if (filename2 == null) {
            return className.replace('.', '/');
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return filename2;
        }
        String pkgPath = className.substring(0, lastDot + 1).replace('.', '/');
        if (filename2.indexOf(47) > -1 && filename2.startsWith(pkgPath)) {
            return filename2;
        }
        return pkgPath + filename2;
    }

    private static boolean isFilteredClass(String className) {
        if (className.startsWith("sun.reflect.")) {
            return true;
        }
        String org_jruby_ = "org.jruby.";
        if (className.startsWith("org.jruby.")) {
            String subPackage;
            int dot = className.indexOf(46, "org.jruby.".length());
            if (dot == -1) {
                return false;
            }
            switch (subPackage = className.substring("org.jruby.".length(), dot)) {
                case "anno": {
                    return true;
                }
                case "ast": {
                    return true;
                }
                case "exceptions": {
                    return true;
                }
                case "gen": {
                    return true;
                }
                case "ir": {
                    return true;
                }
                case "internal": {
                    return true;
                }
                case "java": {
                    return true;
                }
                case "parser": {
                    return true;
                }
                case "platform": {
                    return true;
                }
                case "runtime": {
                    return true;
                }
                case "util": {
                    return true;
                }
            }
        }
        return false;
    }
}

