/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.util.collections.IntList;

public class CoverageData {
    private volatile Map<String, IntList> coverage;
    private volatile int mode;
    private volatile int currentMode;
    private volatile CoverageDataState state = CoverageDataState.IDLE;
    public static final int NONE = 0;
    public static final int LINES = 1;
    public static final int BRANCHES = 2;
    public static final int METHODS = 4;
    public static final int ONESHOT_LINES = 8;
    public static final int EVAL = 16;
    public static final int ALL = 23;

    public boolean isCoverageEnabled() {
        return this.state != CoverageDataState.IDLE;
    }

    public boolean isEvalCovered() {
        return (this.mode & 0x10) != 0;
    }

    public boolean isRunning() {
        return this.state == CoverageDataState.RUNNING;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isOneshot() {
        return (this.mode & 8) != 0;
    }

    public Map<String, IntList> getCoverage() {
        return this.coverage;
    }

    public synchronized void coverLine(String filename2, int line) {
        Map<String, IntList> coverage2 = this.coverage;
        if (line < 0) {
            return;
        }
        if (coverage2 != null) {
            IntList lines2 = coverage2.get(filename2);
            if (lines2 == null) {
                return;
            }
            if (this.isOneshot()) {
                lines2.add(line);
            } else {
                if (lines2.size() <= line) {
                    return;
                }
                lines2.set(line, lines2.get(line) + 1);
            }
        }
    }

    public synchronized void clearCoverage() {
        block5: {
            Map<String, IntList> coverage2 = this.coverage;
            if (coverage2 == null) break block5;
            Map<String, IntList> cov = coverage2;
            if ((this.mode & 8) != 0) {
                for (IntList value2 : cov.values()) {
                    value2.clear();
                }
            } else {
                for (IntList value3 : cov.values()) {
                    for (int i2 = 0; i2 < value3.size(); ++i2) {
                        int v = value3.get(i2);
                        if (v == -1) continue;
                        value3.set(i2, 0);
                    }
                }
            }
        }
    }

    public synchronized void resumeCoverage() {
        this.setupLines();
        this.state = CoverageDataState.RUNNING;
    }

    public synchronized void suspendCoverage() {
        this.state = CoverageDataState.SUSPENDED;
    }

    public synchronized void setCoverage(int mode2, int currentMode, CoverageDataState state2) {
        this.state = state2;
        this.mode = mode2;
        this.currentMode = currentMode;
        this.setupLines();
    }

    private void setupLines() {
        Map<String, IntList> coverage2 = this.coverage;
        if (coverage2 == null && (this.mode & 0x19) != 0) {
            this.coverage = new HashMap<String, IntList>();
        }
    }

    public synchronized Map<String, IntList> resetCoverage() {
        Map<String, IntList> coverage2 = this.coverage;
        this.coverage = null;
        this.mode = 0;
        return coverage2;
    }

    private static boolean hasCodeBeenPartiallyCovered(IntList lines2) {
        for (int i2 = 0; i2 < lines2.size(); ++i2) {
            if (lines2.get(i2) <= 0) continue;
            return true;
        }
        return false;
    }

    public synchronized Map<String, IntList> prepareCoverage(String filename2, int[] startingLines) {
        Map<String, IntList> coverage2 = this.coverage;
        if (filename2 == null) {
            return coverage2;
        }
        if (coverage2 != null) {
            if (this.isOneshot()) {
                coverage2.put(filename2, new IntList());
            } else {
                IntList existing = coverage2.get(filename2);
                if (existing != null) {
                    coverage2.put(filename2, this.mergeLines(existing, startingLines));
                } else {
                    coverage2.put(filename2, new IntList(startingLines));
                }
            }
        }
        return coverage2;
    }

    private IntList mergeLines(IntList existing, int[] startingLines) {
        int startingLinesLength;
        IntList result2 = existing;
        int existingSize = existing.size();
        if (existingSize < (startingLinesLength = startingLines.length)) {
            int[] newLines = new int[startingLinesLength];
            System.arraycopy(existing.toIntArray(), 0, newLines, 0, existingSize);
            Arrays.fill(newLines, existingSize, startingLinesLength, -1);
            result2 = new IntList(newLines);
        }
        for (int i2 = 0; i2 < startingLinesLength; ++i2) {
            int existingValue = result2.get(i2);
            int newValue = startingLines[i2];
            if (newValue == -1) continue;
            if (existingValue == -1) {
                result2.set(i2, newValue);
                continue;
            }
            result2.set(i2, existingValue + newValue);
        }
        return result2;
    }

    public CoverageDataState getCurrentState() {
        return this.state;
    }

    public void setCurrentState(CoverageDataState state2) {
        this.state = state2;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public static enum CoverageDataState {
        IDLE,
        SUSPENDED,
        RUNNING;

    }
}

