/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVariable
extends AbstractVariable {
    private static final String VALID_NAME = "@@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(VALID_NAME)) {
            return new ClassVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private ClassVariable(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        this.updateByJavaObject(receiver2.getRuntime(), javaObjects);
    }

    ClassVariable(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        ClassVariable.updateClassVar(context, receiver2, vars);
        ClassVariable.updateClassVar(context, ClassVariable.getTopSelf(receiver2), vars);
    }

    private static void updateClassVar(ThreadContext context, RubyObject receiver2, BiVariableMap vars) {
        RubyClass metaClass = receiver2.getMetaClass();
        for (String name2 : metaClass.getClassVariableNameList()) {
            IRubyObject value2 = metaClass.getClassVar(context, name2);
            vars.updateVariable(receiver2, name2, value2, ClassVariable.class);
        }
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String name2) {
        RubyClass klazz = receiver2.getMetaClass();
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        IRubyObject value2 = null;
        if (receiver2 == receiver2.getRuntime().getTopSelf() && klazz.getClassVariableNameList().contains(name2)) {
            value2 = klazz.getClassVar(context, name2);
        } else if (klazz.hasClassVariable(name2)) {
            value2 = klazz.getClassVar(context, name2);
        }
        if (value2 == null) {
            return;
        }
        vars.updateVariable(receiver2, name2, value2, ClassVariable.class);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.ClassVariable;
    }

    public static boolean isValidName(Object name2) {
        return ClassVariable.isValidName(VALID_NAME, name2);
    }

    @Override
    public void inject() {
        ThreadContext context = this.receiver.getRuntime().getCurrentContext();
        RubyModule rubyClass = ClassVariable.getRubyClass(context.runtime);
        rubyClass.setClassVar(context, this.name, this.rubyObject);
    }

    @Override
    public void remove() {
        ThreadContext context = this.receiver.getRuntime().getCurrentContext();
        RubyModule rubyClass = ClassVariable.getRubyClass(context.runtime);
        rubyClass.removeClassVariable(context, this.name);
    }
}

