/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableTableManager;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

public class RubyData {
    private static final String MEMBERS_KEY = "__members__";
    private static final String ACCESSORS_KEY = "__accessors__";

    public static RubyClass createDataClass(ThreadContext context, RubyClass Object2) {
        RubyClass Data2 = (RubyClass)((RubyModule)Define.defineClass(context, "Data", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).classIndex(ClassIndex.DATA)).defineMethods(context, RubyData.class);
        Data2.getSingletonClass().undefMethods(context, "new");
        return Data2;
    }

    @JRubyMethod(meta=true, rest=true)
    public static RubyClass define(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        LinkedHashSet<RubySymbol> keySet = new LinkedHashSet<RubySymbol>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol mem = Convert.toSymbol(context, args2[i2]);
            if (mem.validAttrsetName()) {
                throw Error.argumentError(context, "invalid data member: " + String.valueOf(mem));
            }
            if (keySet.contains(mem)) {
                throw Error.argumentError(context, "duplicate member: " + String.valueOf(mem));
            }
            keySet.add(mem);
        }
        RubyClass dataClass = RubyData.newDataStruct(context, (RubyClass)self2, keySet);
        if (block.isGiven()) {
            dataClass.module_eval(context, block);
        }
        return dataClass;
    }

    @JRubyMethod(keywords=true, rest=true)
    public static void initialize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        RubyBasicObject selfObj = (RubyBasicObject)self2;
        selfObj.checkFrozen();
        RubyArray<RubySymbol> members2 = RubyData.getStructMembers(self2);
        int numMembers = members2.size();
        ThreadContext.clearCallInfo(context);
        if (args2.length == 0) {
            if (numMembers > 0) {
                throw Error.keywordError(context, "missing", members2);
            }
            selfObj.setFrozen(true);
            return;
        }
        if (args2.length > 1 || !(args2[0] instanceof RubyHash)) {
            throw Error.argumentError(context, args2.length, 0, 0);
        }
        RubyHash hash2 = (RubyHash)args2[0];
        if (hash2.size() < numMembers) {
            RubyArray missing = (RubyArray)members2.op_diff(context, hash2.keys(context));
            throw Error.keywordError(context, "missing", missing);
        }
        RubyArray[] unknownKeywordsPtr = new RubyArray[]{null};
        RubyClass metaClass = selfObj.getMetaClass();
        VariableTableManager vtm = RubyData.getVariableManagerFromClass(metaClass);
        Map<String, VariableAccessor> variableAccessors = vtm.getVariableAccessorsForRead();
        hash2.visitAll(context, (c, h, k, v, i2) -> {
            String keyString = Convert.toSymbol(context, k).idString();
            VariableAccessor variableAccessor = (VariableAccessor)variableAccessors.get(keyString);
            if (variableAccessor != null) {
                variableAccessor.set(self2, v);
            } else {
                RubyArray<?> unknownKeywords = unknownKeywordsPtr[0];
                if (unknownKeywords == null) {
                    unknownKeywordsPtr[0] = unknownKeywords = Create.newEmptyArray(context);
                }
                unknownKeywords.append(context, k);
            }
        });
        selfObj.setFrozen(true);
        if (unknownKeywordsPtr[0] != null) {
            throw Error.keywordError(context, "unknown", unknownKeywordsPtr[0]);
        }
    }

    @JRubyMethod(name={"initialize_copy"})
    public static IRubyObject initialize_copy(ThreadContext context, IRubyObject copy2, IRubyObject original) {
        if (original != copy2) {
            original.getMetaClass().getVariableTableManager().syncVariables((RubyBasicObject)copy2, original);
        }
        copy2.setFrozen(true);
        return copy2;
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return RubyData.checkDataEquality(context, (RubyBasicObject)self2, (RubyBasicObject)other, "==", RubyData::equalData);
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject eql(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return RubyData.checkDataEquality(context, (RubyBasicObject)self2, (RubyBasicObject)other, "eql?", RubyData::eqlData);
    }

    @JRubyMethod
    public static IRubyObject hash(ThreadContext context, IRubyObject self2) {
        RubyBasicObject selfObj = (RubyBasicObject)self2;
        int h = selfObj.getType().hashCode();
        VariableAccessor[] accessors = RubyData.getStructAccessors(selfObj);
        for (int i2 = 0; i2 < accessors.length; ++i2) {
            h = h << 1 | (h < 0 ? 1 : 0);
            IRubyObject hash2 = context.safeRecurse(RubyData::hashData, selfObj, (IRubyObject)accessors[i2].get(selfObj), "hash", true);
            h = (int)((long)h ^ Convert.toLong(context, hash2));
        }
        return Convert.asFixnum(context, h);
    }

    @JRubyMethod(alias={"to_s"})
    public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
        return context.safeRecurse(RubyData::inspectData, Create.newString(context, "#<data "), self2, "hash", true);
    }

    @JRubyMethod
    public static RubyHash to_h(ThreadContext context, IRubyObject self2, Block block) {
        RubyArray<RubySymbol> members2 = RubyData.getStructMembers(self2);
        VariableAccessor[] accessors = RubyData.getStructAccessors(self2);
        RubyHash h = Create.newSmallHash(context);
        for (int i2 = 0; i2 < accessors.length; ++i2) {
            RubySymbol k = members2.eltOk(i2);
            IRubyObject v = (IRubyObject)accessors[i2].get(self2);
            if (block.isGiven()) {
                h.fastASetSmallPair(context, block.yieldSpecific(context, k, v));
                continue;
            }
            h.fastASetSmall(k, v);
        }
        return h;
    }

    @JRubyMethod
    public static RubyArray members(ThreadContext context, IRubyObject self2) {
        return RubyData.getStructMembers(self2).aryDup();
    }

    @JRubyMethod
    public static RubyArray deconstruct(ThreadContext context, IRubyObject self2) {
        VariableAccessor[] accessors = RubyData.getStructAccessors(self2);
        RubyArray<?> ary = Create.allocArray(context, accessors.length);
        for (int i2 = 0; i2 < accessors.length; ++i2) {
            ary.append(context, (IRubyObject)accessors[i2].get(self2));
        }
        return ary;
    }

    @JRubyMethod
    public static RubyHash deconstruct_keys(ThreadContext context, IRubyObject self2, IRubyObject keys2) {
        if (keys2.isNil()) {
            return RubyData.to_h(context, self2, Block.NULL_BLOCK);
        }
        if (!(keys2 instanceof RubyArray)) {
            throw Error.typeError(context, "wrong argument type " + String.valueOf(keys2.getType()) + " (expected Array or nil)");
        }
        RubyArray keysAry = (RubyArray)keys2;
        RubyArray<RubySymbol> members2 = RubyData.getStructMembers(self2);
        VariableAccessor[] accessors = RubyData.getStructAccessors(self2);
        if (accessors.length < keysAry.size()) {
            return Create.newEmptyHash(context);
        }
        RubyHash h = Create.newSmallHash(context);
        for (int i2 = 0; i2 < keysAry.size(); ++i2) {
            Object key2 = keysAry.eltOk(i2);
            int memberIndex = members2.indexOf(key2);
            if (memberIndex == -1) {
                return h;
            }
            h.fastASetSmall((IRubyObject)key2, (IRubyObject)accessors[memberIndex].get(self2));
        }
        return h;
    }

    @JRubyMethod(keywords=true, optional=1, checkArity=false)
    public static IRubyObject with(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject kwargs = IRRuntimeHelpers.receiveKeywords(context, args2, false, true, false);
        if (kwargs == UndefinedValue.UNDEFINED || kwargs.isNil()) {
            Arity.checkArgumentCount(context, args2.length, 0, 0);
            return self2;
        }
        Arity.checkArgumentCount(context, args2.length - 1, 0, 0);
        RubyHash kwargsHash = (RubyHash)kwargs;
        RubyHash h = RubyData.to_h(context, self2, Block.NULL_BLOCK);
        h.addAll(context, kwargsHash);
        IRRuntimeHelpers.setCallInfo(context, 2);
        return DataMethods.rbNew(context, (IRubyObject)self2.getMetaClass(), h);
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, IRubyObject data2, MarshalDumper output) {
        output.registerObject(data2);
        output.dumpDefaultObjectHeader(context, out, 'S', data2.getMetaClass());
        RubyArray<RubySymbol> members2 = RubyData.getStructMembers(data2);
        VariableAccessor[] accessors = RubyData.getStructAccessors(data2);
        int size2 = members2.size();
        output.writeInt(out, size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            RubySymbol name2 = members2.eltInternal(i2);
            output.dumpObject(context, out, name2);
            output.dumpObject(context, out, (IRubyObject)accessors[i2].get(data2));
        }
    }

    public static IRubyObject unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input, RubyClass rbClass) {
        RubyArray<RubySymbol> members2 = RubyData.getMembersFromClass(rbClass);
        VariableAccessor[] accessors = RubyData.getAccessorsFromClass(rbClass);
        int len = input.unmarshalInt(context, in);
        IRubyObject result2 = input.entry(rbClass.allocate(context));
        for (int i2 = 0; i2 < len; ++i2) {
            RubySymbol slot = input.symbol(context, in);
            RubySymbol elem = members2.eltInternal(i2);
            if (!elem.equals(slot)) {
                throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "struct ", rbClass, " not compatible (:", slot, " for :", elem, ")").toString());
            }
            accessors[i2].set(result2, input.unmarshalObject(context, in));
        }
        result2.setFrozen(true);
        return result2;
    }

    private static RubyClass newDataStruct(ThreadContext context, RubyClass superClass, LinkedHashSet<RubySymbol> keySet) {
        Ruby runtime2 = context.runtime;
        RubyClass subclass = RubyClass.newClass(runtime2, superClass);
        VariableTableManager vtm = subclass.getVariableTableManager();
        VariableAccessor[] accessors = new VariableAccessor[keySet.size()];
        int i2 = 0;
        for (RubySymbol sym : keySet) {
            accessors[i2++] = vtm.getVariableAccessorForWrite(sym.idString());
        }
        ObjectAllocator allocator = runtime2.getObjectSpecializer().specializeForVariables(subclass, keySet.stream().map(RubySymbol::idString).collect(Collectors.toSet()));
        subclass.allocator(allocator);
        RubyArray<?> members2 = Create.newArray(context, keySet);
        members2.freeze(context);
        subclass.setInternalVariable(MEMBERS_KEY, members2);
        subclass.setInternalVariable(ACCESSORS_KEY, accessors);
        RubyClass dataSClass = subclass.getSingletonClass();
        ((RubyModule)dataSClass.undefMethods(context, "define")).defineMethods(context, DataMethods.class);
        for (RubySymbol sym : keySet) {
            VariableAccessor accessor = vtm.getVariableAccessorForWrite(sym.idString());
            subclass.addMethod(context, sym.idString(), new AttrReaderMethod((RubyModule)subclass, Visibility.PUBLIC, accessor));
        }
        return subclass;
    }

    private static IRubyObject checkDataEquality(ThreadContext context, RubyBasicObject self2, RubyBasicObject other, String name2, ThreadContext.RecursiveFunctionEx<RubyBasicObject> func) {
        RubyBasicObject selfObj = self2;
        RubyBasicObject otherObj = other;
        if (selfObj == otherObj) {
            return context.tru;
        }
        RubyClass metaClass = otherObj.getMetaClass();
        if (!metaClass.isKindOfModule(context.runtime.getData())) {
            return context.fals;
        }
        if (metaClass.getRealClass() != selfObj.getMetaClass().getRealClass()) {
            return context.fals;
        }
        return context.safeRecurse(func, selfObj, otherObj, name2, true);
    }

    private static IRubyObject inspectData(ThreadContext context, RubyString prefix, IRubyObject s2, boolean recur) {
        RubyString cname = s2.getMetaClass().rubyName(context);
        RubyString str = prefix;
        char first2 = cname.charAt(0);
        if (recur || first2 != '#') {
            str.append(cname);
        }
        if (recur) {
            return str.catString(":...>");
        }
        RubyArray<RubySymbol> members2 = RubyData.getStructMembers(s2);
        VariableAccessor[] accessors = RubyData.getStructAccessors(s2);
        int len = members2.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                str.catString(", ");
            } else if (first2 != '#') {
                str.catString(" ");
            }
            RubySymbol id = members2.eltOk(i2);
            if (id.validLocalVariableName() || id.validConstantName()) {
                str.append(id.fstring());
            } else {
                str.append(id.inspect(context));
            }
            str.catString("=");
            str.append(RubyBasicObject.rbInspect(context, (IRubyObject)accessors[i2].get(s2)));
        }
        str.catString(">");
        return str;
    }

    private static RubyArray<RubySymbol> getStructMembers(IRubyObject s2) {
        RubyClass metaClass = s2.getMetaClass();
        return RubyData.getMembersFromClass(metaClass);
    }

    private static RubyArray<RubySymbol> getMembersFromClass(RubyClass metaClass) {
        while (metaClass != null) {
            RubyArray members2 = (RubyArray)metaClass.getInternalVariable(MEMBERS_KEY);
            if (members2 != null) {
                return members2;
            }
            metaClass = metaClass.getSuperClass();
        }
        throw new RuntimeException("non-Data attempted to access Data members");
    }

    private static VariableAccessor[] getStructAccessors(IRubyObject s2) {
        RubyClass metaClass = s2.getMetaClass();
        return RubyData.getAccessorsFromClass(metaClass);
    }

    private static VariableAccessor[] getAccessorsFromClass(RubyClass metaClass) {
        while (metaClass != null) {
            VariableAccessor[] accessors = (VariableAccessor[])metaClass.getInternalVariable(ACCESSORS_KEY);
            if (accessors != null) {
                return accessors;
            }
            metaClass = metaClass.getSuperClass();
        }
        throw new RuntimeException("non-Data attempted to access Data accessors");
    }

    private static VariableTableManager getVariableManagerFromClass(RubyClass metaClass) {
        while (metaClass != null) {
            VariableAccessor[] accessors = (VariableAccessor[])metaClass.getInternalVariable(ACCESSORS_KEY);
            if (accessors != null) {
                return metaClass.getVariableTableManager();
            }
            metaClass = metaClass.getSuperClass();
        }
        throw new RuntimeException("non-Data attempted to access Data accessors");
    }

    private static IRubyObject hashData(ThreadContext ctx, RubyBasicObject state2, IRubyObject obj, boolean recur) {
        return recur ? Convert.asFixnum(ctx, 0) : Helpers.invokedynamic(ctx, obj, MethodNames.HASH);
    }

    private static IRubyObject eqlData(ThreadContext c, RubyBasicObject s2, IRubyObject o, boolean recur) {
        if (recur) {
            return c.tru;
        }
        VariableAccessor[] accessors = RubyData.getStructAccessors(s2);
        for (int i2 = 0; i2 < accessors.length; ++i2) {
            VariableAccessor accessor = accessors[i2];
            if (RubyBasicObject.eqlInternal(c, (RubyBasicObject)accessor.get(s2), (IRubyObject)accessor.get(o))) continue;
            return c.fals;
        }
        return c.tru;
    }

    private static IRubyObject equalData(ThreadContext c, RubyBasicObject s2, IRubyObject o, boolean recur) {
        if (recur) {
            return c.tru;
        }
        VariableAccessor[] accessors = RubyData.getStructAccessors(s2);
        for (int i2 = 0; i2 < accessors.length; ++i2) {
            VariableAccessor accessor = accessors[i2];
            if (RubyBasicObject.equalInternal(c, (RubyBasicObject)accessor.get(s2), (IRubyObject)accessor.get(o))) continue;
            return c.fals;
        }
        return c.tru;
    }

    public static class DataMethods {
        @JRubyMethod(name={"new", "[]"}, keywords=true, rest=true)
        public static IRubyObject rbNew(ThreadContext context, IRubyObject self2, IRubyObject[] values2) {
            RubyHash init;
            RubyClass klass = (RubyClass)self2;
            IRubyObject maybeKwargs = IRRuntimeHelpers.receiveKeywords(context, values2, true, true, false);
            if (maybeKwargs instanceof RubyHash) {
                init = (RubyHash)maybeKwargs;
            } else {
                RubyArray<RubySymbol> members2 = RubyData.getMembersFromClass(klass);
                Arity.checkArgumentCount(context, values2.length, 0, members2.size());
                init = RubyHash.newSmallHash(context.runtime);
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    RubySymbol sym = members2.eltOk(i2);
                    init.fastASetSmall(sym, values2[i2]);
                }
            }
            IRubyObject dataObject = klass.getAllocator().allocate(context.runtime, klass);
            IRRuntimeHelpers.setCallInfo(context, 2);
            dataObject.getMetaClass().getBaseCallSite(0).call(context, self2, dataObject, (IRubyObject)init);
            return dataObject;
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject rbNew(ThreadContext context, IRubyObject self2) {
            RubyClass klass = (RubyClass)self2;
            ThreadContext.clearCallInfo(context);
            IRubyObject dataObject = klass.getAllocator().allocate(context.runtime, klass);
            dataObject.getMetaClass().getBaseCallSite(0).call(context, self2, dataObject);
            return dataObject;
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject rbNew(ThreadContext context, IRubyObject self2, IRubyObject hashOrElt) {
            RubyHash init;
            RubyClass klass = (RubyClass)self2;
            int callInfo = ThreadContext.resetCallInfo(context);
            if (ThreadContext.hasNonemptyKeywords(callInfo)) {
                if (!(hashOrElt instanceof RubyHash)) {
                    throw Error.argumentError(context, 1, 0, 0);
                }
                init = (RubyHash)hashOrElt;
            } else {
                RubyArray<RubySymbol> members2 = RubyData.getMembersFromClass(klass);
                Arity.checkArgumentCount(context, 1, 0, members2.size());
                init = RubyHash.newSmallHash(context.runtime);
                RubySymbol sym = members2.eltOk(0L);
                init.fastASetSmall(sym, hashOrElt);
                callInfo = 2;
            }
            IRubyObject dataObject = klass.getAllocator().allocate(context.runtime, klass);
            IRRuntimeHelpers.setCallInfo(context, callInfo);
            dataObject.getMetaClass().getBaseCallSite(0).call(context, self2, dataObject, (IRubyObject)init);
            return dataObject;
        }

        @JRubyMethod(name={"members"})
        public static IRubyObject members(ThreadContext context, IRubyObject self2) {
            return RubyData.getMembersFromClass((RubyClass)self2).aryDup();
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject klass) {
            RubyString inspect2 = ((RubyClass)klass).rubyName(context);
            return inspect2;
        }
    }
}

