/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.Exception;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.CommonByteLists;
import org.jruby.util.Sprintf;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    private final Backtrace backtrace = new Backtrace();
    IRubyObject message;
    private IRubyObject cause = null;
    private RaiseException throwable;
    public static final ObjectAllocator EXCEPTION_ALLOCATOR = RubyException::new;
    private static final ObjectMarshal<RubyException> EXCEPTION_MARSHAL = new ObjectMarshal<RubyException>(){

        @Override
        @Deprecated(since="10.0.0.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, RubyException exc, RubyClass type2, MarshalStream marshalStream) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            marshalStream.registerLinkTarget(context, exc);
            List<Variable<Object>> attrs = exc.getMarshalVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.getMessage()));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public void marshalTo(ThreadContext context, RubyOutputStream out, RubyException exc, RubyClass type2, MarshalDumper marshalStream) {
            marshalStream.registerObject(exc);
            marshalStream.dumpVariables(context, out, exc, 2, (marshal, c, o, v, receiver2) -> {
                receiver2.receive(marshal, c, o, "mesg", v.getMessage());
                receiver2.receive(marshal, c, o, "bt", v.getBacktrace());
            });
        }

        @Override
        @Deprecated(since="10.0.0.0", forRemoval=true)
        public RubyException unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            RubyException exc = (RubyException)input.entry(type2.allocate(context));
            input.ivar(null, exc, null);
            exc.setMessage((IRubyObject)exc.removeInternalVariable("mesg"));
            exc.set_backtrace(context, (IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }

        @Override
        public RubyException unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader input) {
            RubyException exc = (RubyException)input.entry(type2.allocate(context));
            input.ivar(context, in, null, exc, null);
            exc.setMessage((IRubyObject)exc.removeInternalVariable("mesg"));
            exc.set_backtrace(context, (IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }
    };

    protected RubyException(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyException(Ruby runtime2, RubyClass rubyClass, String message2) {
        super(runtime2, rubyClass);
        this.setMessage(message2 == null ? runtime2.getNil() : runtime2.newString(message2));
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return ((RubyClass)recv2).newInstance(context, args2, block);
    }

    @JRubyMethod(name={"to_tty?"}, meta=true)
    public static IRubyObject to_tty_p(ThreadContext context, IRubyObject recv2) {
        IRubyObject STDERR;
        IRubyObject stderr = Access.globalVariables(context).get("$stderr");
        return RubyException.equalInternal(context, stderr, STDERR = Access.objectClass(context).getConstant(context, "STDERR")) ? ((RubyIO)STDERR).tty_p(context) : context.fals;
    }

    @JRubyMethod(name={"==="}, meta=true)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof ConcreteJavaProxy) {
            Object object;
            ConcreteJavaProxy proxy2 = (ConcreteJavaProxy)other;
            if (!(recv2 != Access.exceptionClass(context) && recv2 != Access.standardErrorClass(context) || !((object = proxy2.getObject()) instanceof Throwable) || object instanceof JumpException.FlowControlException || recv2 != Access.exceptionClass(context) && !(object instanceof java.lang.Exception))) {
                return context.tru;
            }
        }
        return ((RubyClass)recv2).op_eqq(context, other);
    }

    protected RaiseException constructThrowable(String message2) {
        return new Exception(message2, this);
    }

    public static RubyClass createExceptionClass(ThreadContext context, RubyClass Object2) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyClass)Define.defineClass(context, "Exception", Object2, EXCEPTION_ALLOCATOR).reifiedClass(RubyException.class)).marshalWith(EXCEPTION_MARSHAL)).classIndex(ClassIndex.EXCEPTION)).defineMethods(context, RubyException.class);
    }

    public static RubyException newException(Ruby runtime2, RubyClass exceptionClass, String msg) {
        if (msg == null) {
            msg = "No message available";
        }
        return (RubyException)exceptionClass.newInstance(runtime2.getCurrentContext(), RubyString.newString(runtime2, msg), Block.NULL_BLOCK);
    }

    public static RubyException newException(ThreadContext context, RubyClass exceptionClass, RubyString message2) {
        return (RubyException)exceptionClass.newInstance(context, message2, Block.NULL_BLOCK);
    }

    public static RubyException newException(ThreadContext context, RubyClass exceptionClass, IRubyObject ... args2) {
        return (RubyException)exceptionClass.newInstance(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context) {
        return this.full_message(context, null);
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context, IRubyObject opts) {
        return TraceType.printFullMessage(context, this, opts);
    }

    @JRubyMethod
    public IRubyObject detailed_message(ThreadContext context) {
        return this.detailed_message(context, (IRubyObject)null);
    }

    @JRubyMethod
    public IRubyObject detailed_message(ThreadContext context, IRubyObject opts) {
        return TraceType.printDetailedMessage(context, this, opts);
    }

    @JRubyMethod(optional=1)
    public IRubyObject detailed_message(ThreadContext context, IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.detailed_message(context);
            case 1 -> this.detailed_message(context, args2[0]);
            default -> throw Error.argumentError(context, args2.length, 0, 1);
        };
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        this.setMessage(arg0);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this;
    }

    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return switch (args2.length) {
            case 0 -> this.initialize(context);
            case 1 -> this.initialize(context, args2[0]);
            case 2 -> this.initialize(context, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 0, 2);
        };
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_backtrace(IRubyObject obj) {
        return this.set_backtrace(this.getCurrentContext(), obj);
    }

    @JRubyMethod
    public IRubyObject set_backtrace(ThreadContext context, IRubyObject obj) {
        this.setBacktrace(context, obj);
        return this.backtrace();
    }

    public void setBacktrace(ThreadContext context, IRubyObject obj) {
        BacktraceData backtraceData = this.locationArrayToBacktrace(obj);
        if (backtraceData != null) {
            this.backtrace.backtraceData = backtraceData;
            this.backtrace.backtraceObject = null;
            this.backtrace.backtraceLocations = obj;
        } else {
            this.backtrace.backtraceObject = RubyException.checkBacktrace(context, obj);
        }
    }

    private static IRubyObject checkBacktrace(ThreadContext context, IRubyObject obj) {
        if (obj.isNil() || RubyException.isArrayOfStrings(obj)) {
            return obj;
        }
        if (obj instanceof RubyString) {
            return RubyArray.newArray(context.runtime, obj);
        }
        throw Error.typeError(context, "backtrace must be an Array of String or an Array of Thread::Backtrace::Location");
    }

    private BacktraceData locationArrayToBacktrace(IRubyObject ary) {
        RubyArray array2;
        if (!(ary instanceof RubyArray) || (array2 = (RubyArray)ary).size() == 0 || RubyException.asBacktraceLocation(array2.eltOk(0L)) == null) {
            return null;
        }
        int num_frames = array2.size();
        RubyStackTraceElement[] backtrace2 = new RubyStackTraceElement[num_frames];
        for (int index2 = 0; index2 < num_frames; ++index2) {
            RubyThread.Location locobj = RubyException.asBacktraceLocation(array2.eltOk(index2));
            if (locobj == null) {
                return null;
            }
            backtrace2[index2] = locobj.getElement();
        }
        return new BacktraceData(backtrace2);
    }

    private static RubyThread.Location asBacktraceLocation(IRubyObject object) {
        if (object instanceof RubyThread.Location) {
            return (RubyThread.Location)object;
        }
        return null;
    }

    @JRubyMethod(omit=true)
    public IRubyObject backtrace_locations(ThreadContext context) {
        IRubyObject backtraceLocations = this.backtrace.backtraceLocations;
        if (backtraceLocations != null) {
            return backtraceLocations;
        }
        this.backtrace.backtraceLocations = this.backtrace.generateBacktraceLocations(context);
        return this.backtrace.backtraceLocations;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public RubyException exception(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args2[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args2, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw Error.argumentError(this.getRuntime().getCurrentContext(), "Wrong argument count");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        IRubyObject msg = this.getMessage();
        return !msg.isNil() ? msg.asString() : Create.newString(context, this.getMetaClass().getRealClass().getName(context));
    }

    @JRubyMethod(name={"message"})
    public IRubyObject message(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyClass klass = this.getMetaClass();
        RubyString exc = this.asString();
        if (exc.size() == 0) {
            return klass.rubyName(context);
        }
        RubyString str = Create.newString(context, "#<");
        str.append(klass.rubyName(context));
        if (exc.include_p(context, RubyString.newStringShared(context.runtime, CommonByteLists.NEWLINE)).isTrue()) {
            str.cat(Sprintf.sprintf(exc.getEncoding(), (CharSequence)":%p", (IRubyObject)exc));
        } else {
            str.catString(": ");
            str.append(exc);
        }
        str.cat(62);
        return str;
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        return Convert.asBoolean(context, Access.exceptionClass(context).isInstance(other) && this.getMetaClass().getRealClass() == other.getMetaClass().getRealClass() && this.callMethod(context, "message").equals(other.callMethod(context, "message")) && this.callMethod(context, "backtrace").equals(other.callMethod(context, "backtrace")));
    }

    @JRubyMethod(name={"cause"})
    public IRubyObject cause(ThreadContext context) {
        return this.cause == null ? context.nil : this.cause;
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2.isAssignableFrom(RaiseException.class)) {
            return target2.cast(this.toThrowable());
        }
        return super.toJava(target2);
    }

    public RaiseException toThrowable() {
        if (this.throwable == null) {
            this.throwable = this.constructThrowable(this.getMessageAsJavaString());
            return this.throwable;
        }
        return this.throwable;
    }

    public void setCause(IRubyObject cause2) {
        this.cause = cause2;
        if (cause2 == null || cause2.isNil()) {
            return;
        }
        RaiseException t = this.toThrowable();
        if (((Throwable)t).getCause() == null) {
            Object javaCause;
            if (cause2 instanceof RubyException) {
                t.initCause(((RubyException)cause2).toThrowable());
            } else if (cause2 instanceof ConcreteJavaProxy && (javaCause = ((ConcreteJavaProxy)cause2).getObject()) instanceof Throwable) {
                t.initCause((Throwable)javaCause);
            } else {
                Ruby runtime2 = this.getRuntime();
                throw Error.typeError(runtime2.getCurrentContext(), "exception object expected");
            }
        }
    }

    public Object getCause() {
        return this.cause == this ? null : this.cause;
    }

    public RubyStackTraceElement[] getBacktraceElements() {
        if (this.backtrace.backtraceData == null) {
            return RubyStackTraceElement.EMPTY_ARRAY;
        }
        return this.backtrace.backtraceData.getBacktrace(this.getRuntime());
    }

    public void captureBacktrace(ThreadContext context) {
        this.backtrace.backtraceData = Access.instanceConfig(context).getTraceType().getBacktrace(context);
    }

    public IRubyObject getBacktrace() {
        IRubyObject backtraceObject = this.backtrace.backtraceObject;
        if (backtraceObject != null) {
            return backtraceObject;
        }
        this.backtrace.backtraceObject = this.backtrace.generateBacktrace(this.getRuntime());
        return this.backtrace.backtraceObject;
    }

    public static IRubyObject retrieveBacktrace(RubyException exception2) {
        return exception2.backtrace.backtraceObject;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyException exception2 = (RubyException)clone2;
        exception2.backtrace.copy(this.backtrace);
        exception2.message = this.message;
    }

    public void printBacktrace(PrintStream errorStream) {
        this.printBacktrace(errorStream, 0);
    }

    public void printBacktrace(PrintStream errorStream, int skip2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject trace2 = this.callMethod(context, "backtrace");
        RubyString string2 = Create.newEmptyString(context);
        TraceType.printBacktraceToStream(context, trace2, string2, skip2);
        errorStream.print(string2);
    }

    private static boolean isArrayOfStrings(IRubyObject backtrace2) {
        if (!(backtrace2 instanceof RubyArray)) {
            return false;
        }
        RubyArray rTrace = (RubyArray)backtrace2;
        for (int i2 = 0; i2 < rTrace.getLength(); ++i2) {
            if (rTrace.eltInternal(i2) instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    public IRubyObject getMessage() {
        return this.message == null ? this.getRuntime().getNil() : this.message;
    }

    public void setMessage(IRubyObject message2) {
        this.message = message2;
    }

    public String getMessageAsJavaString() {
        IRubyObject msg = this.getMessage();
        return msg.isNil() ? null : msg.toString();
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        List<Variable<Object>> attrs = super.getVariableList();
        attrs.add(new VariableEntry<IRubyObject>("mesg", this.getMessage()));
        IRubyObject backtrace2 = this.getBacktrace();
        attrs.add(new VariableEntry<IRubyObject>("bt", backtrace2));
        return attrs;
    }

    @Override
    public List<String> getVariableNameList() {
        List<String> names2 = super.getVariableNameList();
        names2.add("mesg");
        names2.add("bt");
        return names2;
    }

    @Deprecated(since="9.2.7.0")
    public void prepareIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        if (this.backtrace.backtraceData == null) {
            this.backtrace.backtraceData = Access.instanceConfig(context).getTraceType().getIntegratedBacktrace(context, javaTrace);
        }
    }

    @Deprecated(since="9.3.0.0")
    public static IRubyObject newException(ThreadContext context, RubyClass exceptionClass, IRubyObject message2) {
        return RubyException.newException(context, exceptionClass, message2.convertToString());
    }

    private static class Backtrace {
        private BacktraceData backtraceData;
        private IRubyObject backtraceObject;
        private IRubyObject backtraceLocations;

        private Backtrace() {
        }

        public void copy(Backtrace clone2) {
            this.backtraceData = clone2.backtraceData;
            this.backtraceObject = clone2.backtraceObject;
            this.backtraceLocations = clone2.backtraceLocations;
        }

        public IRubyObject generateBacktrace(Ruby runtime2) {
            BacktraceData backtraceData = this.backtraceData;
            if (backtraceData == null || backtraceData == BacktraceData.EMPTY) {
                return runtime2.getNil();
            }
            return TraceType.generateMRIBacktrace(runtime2, backtraceData.getBacktrace(runtime2));
        }

        public IRubyObject generateBacktraceLocations(ThreadContext context) {
            BacktraceData backtraceData = this.backtraceData;
            if (backtraceData == null) {
                return context.nil;
            }
            Ruby runtime2 = context.runtime;
            return RubyThread.Location.newLocationArray(runtime2, backtraceData.getBacktrace(runtime2));
        }
    }
}

