/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;

public class RubyOutputStream {
    private final Ruby runtime;
    private final OutputStream wrap;

    public RubyOutputStream(Ruby runtime2, OutputStream wrap2) {
        this.runtime = runtime2;
        this.wrap = wrap2;
    }

    public void write(int b2) {
        try {
            this.wrap.write(b2);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void write(byte[] b2, int off, int len) {
        try {
            this.wrap.write(b2, off, len);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void write(byte[] b2) {
        try {
            this.wrap.write(b2);
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void writeMarshalInt(int value2) {
        if (value2 == 0) {
            this.write(0);
        } else if (0 < value2 && value2 < 123) {
            this.write(value2 + 5);
        } else if (-124 < value2 && value2 < 0) {
            this.write(value2 - 5 & 0xFF);
        } else {
            int i2;
            byte[] buf = new byte[4];
            for (i2 = 0; i2 < buf.length; ++i2) {
                buf[i2] = (byte)(value2 & 0xFF);
                if ((value2 >>= 8) == 0 || value2 == -1) break;
            }
            int len = i2 + 1;
            int b2 = value2 < 0 ? -len : len;
            this.write(b2);
            this.write(buf, 0, i2 + 1);
        }
    }

    public void flush() {
        try {
            this.wrap.flush();
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    public void close() {
        try {
            this.wrap.close();
        }
        catch (IOException ioe) {
            this.handle(ioe);
        }
    }

    private void handle(IOException ioe) {
        throw Helpers.newIOErrorFromException(this.runtime, ioe);
    }
}

