/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.EnumMap;
import java.util.HashMap;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;

public class Builtins {
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int STRING = 4;
    public static final int ARRAY = 8;
    public static final int HASH = 16;
    public static final int BIGNUM = 32;
    public static final int SYMBOL = 64;
    public static final int TIME = 128;
    public static final int REGEXP = 256;
    public static final int NIL = 512;
    public static final int TRUE = 1024;
    public static final int FALSE = 2048;
    public static final int PROC = 4096;
    public static final int RANGE = 8192;
    public static final int STRUCT = 16384;
    public static final int RATIONAL = 32768;
    public static final int BOP_PLUS = 0;
    public static final int BOP_MINUS = 1;
    public static final int BOP_MULT = 2;
    public static final int BOP_DIV = 3;
    public static final int BOP_MOD = 4;
    public static final int BOP_EQ = 5;
    public static final int BOP_EQQ = 6;
    public static final int BOP_LT = 7;
    public static final int BOP_LE = 8;
    public static final int BOP_LTLT = 9;
    public static final int BOP_AREF = 10;
    public static final int BOP_ASET = 11;
    public static final int BOP_LENGTH = 12;
    public static final int BOP_SIZE = 13;
    public static final int BOP_EMPTY_P = 14;
    public static final int BOP_NIL_P = 15;
    public static final int BOP_SUCC = 16;
    public static final int BOP_GT = 17;
    public static final int BOP_GE = 18;
    public static final int BOP_GTGT = 19;
    public static final int BOP_NOT = 20;
    public static final int BOP_NEQ = 21;
    public static final int BOP_MATCH = 22;
    public static final int BOP_FREEZE = 23;
    public static final int BOP_UMINUS = 24;
    public static final int BOP_MAX = 25;
    public static final int BOP_MIN = 26;
    public static final int BOP_HASH = 27;
    public static final int BOP_CALL = 28;
    public static final int BOP_AND = 29;
    public static final int BOP_OR = 30;
    public static final int BOP_CMP = 31;
    public static final int BOP_DEFAULT = 32;
    public static final int BOP_PACK = 33;
    public static final int BOP_INCLUDE_P = 34;
    public static final int BOP_TO_F = 35;
    public static final int BOP_DIG = 36;
    public static final int BOP_LAST_ = 37;
    public static final EnumMap<ClassIndex, Integer> CLASS_FLAGS = new EnumMap(ClassIndex.class);
    public static final HashMap<String, Integer> METHOD_IDS = new HashMap();

    public static int[] allocate() {
        return new int[37];
    }

    public static void invalidateBuiltin(int[] bits, ClassIndex classIndex, String method2) {
        Integer classFlag = CLASS_FLAGS.get((Object)classIndex);
        Integer methodId = METHOD_IDS.get(method2);
        if (classFlag != null && methodId != null) {
            int n = methodId;
            bits[n] = bits[n] | classFlag;
        }
    }

    public static void resetAll(short[] bits) {
        for (int i2 = 0; i2 < bits.length; ++i2) {
            bits[i2] = 0;
        }
    }

    public static boolean checkIntegerPlus(ThreadContext ctx) {
        return (ctx.builtinBits[0] & 1) == 0;
    }

    public static boolean checkIntegerMinus(ThreadContext ctx) {
        return (ctx.builtinBits[1] & 1) == 0;
    }

    public static boolean checkIntegerMult(ThreadContext ctx) {
        return (ctx.builtinBits[2] & 1) == 0;
    }

    public static boolean checkIntegerDiv(ThreadContext ctx) {
        return (ctx.builtinBits[3] & 1) == 0;
    }

    public static boolean checkIntegerMod(ThreadContext ctx) {
        return (ctx.builtinBits[4] & 1) == 0;
    }

    public static boolean checkIntegerEquals(ThreadContext ctx) {
        return (ctx.builtinBits[5] & 1) == 0;
    }

    public static boolean checkIntegerLt(ThreadContext ctx) {
        return (ctx.builtinBits[7] & 1) == 0;
    }

    public static boolean checkIntegerLe(ThreadContext ctx) {
        return (ctx.builtinBits[8] & 1) == 0;
    }

    public static boolean checkIntegerGt(ThreadContext ctx) {
        return (ctx.builtinBits[17] & 1) == 0;
    }

    public static boolean checkIntegerGe(ThreadContext ctx) {
        return (ctx.builtinBits[18] & 1) == 0;
    }

    public static boolean checkIntegerCompare(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[7] & 1) == 0 && (bits[8] & 1) == 0 && (bits[17] & 1) == 0 && (bits[18] & 1) == 0;
    }

    public static boolean checkIntegerLshift(ThreadContext ctx) {
        return (ctx.builtinBits[9] & 1) == 0;
    }

    public static boolean checkIntegerAnd(ThreadContext ctx) {
        return (ctx.builtinBits[29] & 1) == 0;
    }

    public static boolean checkIntegerOr(ThreadContext ctx) {
        return (ctx.builtinBits[30] & 1) == 0;
    }

    public static boolean checkIntegerUminus(ThreadContext ctx) {
        return (ctx.builtinBits[24] & 1) == 0;
    }

    public static boolean checkIntegerCmp(ThreadContext ctx) {
        return (ctx.builtinBits[31] & 1) == 0;
    }

    public static boolean checkIntegerToF(ThreadContext ctx) {
        return (ctx.builtinBits[35] & 1) == 0;
    }

    public static boolean checkFloatPlus(ThreadContext ctx) {
        return (ctx.builtinBits[0] & 2) == 0;
    }

    public static boolean checkFloatMinus(ThreadContext ctx) {
        return (ctx.builtinBits[1] & 2) == 0;
    }

    public static boolean checkFloatMult(ThreadContext ctx) {
        return (ctx.builtinBits[2] & 2) == 0;
    }

    public static boolean checkFloatDiv(ThreadContext ctx) {
        return (ctx.builtinBits[3] & 2) == 0;
    }

    public static boolean checkFloatEquals(ThreadContext ctx) {
        return (ctx.builtinBits[5] & 2) == 0;
    }

    public static boolean checkFloatCompare(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[7] & 2) == 0 && (bits[8] & 2) == 0 && (bits[17] & 2) == 0 && (bits[18] & 2) == 0;
    }

    public static boolean checkStringPlus(ThreadContext ctx) {
        return (ctx.builtinBits[0] & 4) == 0;
    }

    public static boolean checkStringEquals(ThreadContext ctx) {
        return (ctx.builtinBits[5] & 4) == 0;
    }

    public static boolean checkStringConcat(ThreadContext ctx) {
        return (ctx.builtinBits[9] & 4) == 0;
    }

    public static boolean checkStringAref(ThreadContext ctx) {
        return (ctx.builtinBits[10] & 4) == 0;
    }

    public static boolean checkStringLength(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[12] & 4) == 0 && (bits[13] & 4) == 0;
    }

    public static boolean checkStringEmpty(ThreadContext ctx) {
        return (ctx.builtinBits[14] & 4) == 0;
    }

    public static boolean checkStringFreeze(ThreadContext ctx) {
        return (ctx.builtinBits[23] & 4) == 0;
    }

    public static boolean checkStringMatch(ThreadContext ctx) {
        return (ctx.builtinBits[22] & 4) == 0;
    }

    public static boolean checkStringHash(ThreadContext ctx) {
        return (ctx.builtinBits[27] & 4) == 0;
    }

    public static boolean checkStringCmp(ThreadContext ctx) {
        return (ctx.builtinBits[31] & 4) == 0;
    }

    public static boolean checkArrayAref(ThreadContext ctx) {
        return (ctx.builtinBits[10] & 8) == 0;
    }

    public static boolean checkArrayAset(ThreadContext ctx) {
        return (ctx.builtinBits[11] & 8) == 0;
    }

    public static boolean checkArrayPush(ThreadContext ctx) {
        return (ctx.builtinBits[9] & 8) == 0;
    }

    public static boolean checkArrayLength(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[12] & 8) == 0 && (bits[13] & 8) == 0;
    }

    public static boolean checkArrayEmpty(ThreadContext ctx) {
        return (ctx.builtinBits[14] & 8) == 0;
    }

    public static boolean checkArrayMax(ThreadContext ctx) {
        return (ctx.builtinBits[25] & 8) == 0;
    }

    public static boolean checkArrayMin(ThreadContext ctx) {
        return (ctx.builtinBits[26] & 8) == 0;
    }

    public static boolean checkArrayHash(ThreadContext ctx) {
        return (ctx.builtinBits[27] & 8) == 0;
    }

    public static boolean checkArrayPack(ThreadContext ctx) {
        return (ctx.builtinBits[33] & 8) == 0;
    }

    public static boolean checkArrayDig(ThreadContext ctx) {
        return (ctx.builtinBits[36] & 8) == 0;
    }

    public static boolean checkHashAref(ThreadContext ctx) {
        return (ctx.builtinBits[10] & 0x10) == 0;
    }

    public static boolean checkHashAset(ThreadContext ctx) {
        return (ctx.builtinBits[11] & 0x10) == 0;
    }

    public static boolean checkHashLength(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[12] & 0x10) == 0 && (bits[13] & 0x10) == 0;
    }

    public static boolean checkHashEmpty(ThreadContext ctx) {
        return (ctx.builtinBits[14] & 0x10) == 0;
    }

    public static boolean checkHashDefault(ThreadContext ctx) {
        return (ctx.builtinBits[32] & 0x10) == 0;
    }

    public static boolean checkHashDig(ThreadContext ctx) {
        return (ctx.builtinBits[36] & 0x10) == 0;
    }

    public static boolean checkRangeInclude(ThreadContext ctx) {
        return (ctx.builtinBits[34] & 0x2000) == 0;
    }

    public static boolean checkRangeCover(ThreadContext ctx) {
        return (ctx.builtinBits[34] & 0x2000) == 0;
    }

    public static boolean checkRangeEqq(ThreadContext ctx) {
        return (ctx.builtinBits[6] & 0x2000) == 0;
    }

    public static boolean checkRangeMin(ThreadContext ctx) {
        return (ctx.builtinBits[26] & 0x2000) == 0;
    }

    public static boolean checkRangeMax(ThreadContext ctx) {
        return (ctx.builtinBits[25] & 0x2000) == 0;
    }

    public static boolean checkSymbolEquals(ThreadContext ctx) {
        return (ctx.builtinBits[5] & 0x40) == 0;
    }

    public static boolean checkProcCall(ThreadContext ctx) {
        return (ctx.builtinBits[28] & 0x1000) == 0;
    }

    public static boolean checkNilNot(ThreadContext ctx) {
        return (ctx.builtinBits[20] & 0x200) == 0;
    }

    public static boolean checkTrueNot(ThreadContext ctx) {
        return (ctx.builtinBits[20] & 0x400) == 0;
    }

    public static boolean checkFalseNot(ThreadContext ctx) {
        return (ctx.builtinBits[20] & 0x800) == 0;
    }

    public static boolean checkRegexpMatch(ThreadContext ctx) {
        return (ctx.builtinBits[22] & 0x100) == 0;
    }

    public static boolean checkRegexpEqq(ThreadContext ctx) {
        return (ctx.builtinBits[6] & 0x100) == 0;
    }

    public static boolean checkTimePlus(ThreadContext ctx) {
        return (ctx.builtinBits[0] & 0x80) == 0;
    }

    public static boolean checkTimeMinus(ThreadContext ctx) {
        return (ctx.builtinBits[1] & 0x80) == 0;
    }

    public static boolean checkTimeCompare(ThreadContext ctx) {
        int[] bits = ctx.builtinBits;
        return (bits[7] & 0x80) == 0 && (bits[8] & 0x80) == 0 && (bits[17] & 0x80) == 0 && (bits[18] & 0x80) == 0;
    }

    public static boolean checkTimeCmp(ThreadContext ctx) {
        return (ctx.builtinBits[31] & 0x80) == 0;
    }

    public static boolean checkStructDig(ThreadContext ctx) {
        return (ctx.builtinBits[36] & 0x4000) == 0;
    }

    public static boolean checkRationalToF(ThreadContext ctx) {
        return (ctx.builtinBits[35] & 0x8000) == 0;
    }

    public static boolean checkRationalPlus(ThreadContext ctx) {
        return (ctx.builtinBits[0] & 0x8000) == 0;
    }

    public static boolean checkRationalMult(ThreadContext ctx) {
        return (ctx.builtinBits[2] & 0x8000) == 0;
    }

    public static boolean checkRationalMinus(ThreadContext ctx) {
        return (ctx.builtinBits[1] & 0x8000) == 0;
    }

    static {
        CLASS_FLAGS.put(ClassIndex.INTEGER, 1);
        CLASS_FLAGS.put(ClassIndex.BIGNUM, 32);
        CLASS_FLAGS.put(ClassIndex.FLOAT, 2);
        CLASS_FLAGS.put(ClassIndex.STRING, 4);
        CLASS_FLAGS.put(ClassIndex.ARRAY, 8);
        CLASS_FLAGS.put(ClassIndex.HASH, 16);
        CLASS_FLAGS.put(ClassIndex.SYMBOL, 64);
        CLASS_FLAGS.put(ClassIndex.TIME, 128);
        CLASS_FLAGS.put(ClassIndex.REGEXP, 256);
        CLASS_FLAGS.put(ClassIndex.NIL, 512);
        CLASS_FLAGS.put(ClassIndex.TRUE, 1024);
        CLASS_FLAGS.put(ClassIndex.FALSE, 2048);
        CLASS_FLAGS.put(ClassIndex.PROC, 4096);
        CLASS_FLAGS.put(ClassIndex.RANGE, 8192);
        CLASS_FLAGS.put(ClassIndex.STRUCT, 16384);
        CLASS_FLAGS.put(ClassIndex.RATIONAL, 32768);
        METHOD_IDS.put("+", 0);
        METHOD_IDS.put("-", 1);
        METHOD_IDS.put("*", 2);
        METHOD_IDS.put("/", 3);
        METHOD_IDS.put("%", 4);
        METHOD_IDS.put("==", 5);
        METHOD_IDS.put("===", 6);
        METHOD_IDS.put("<", 7);
        METHOD_IDS.put("<=", 8);
        METHOD_IDS.put("<<", 9);
        METHOD_IDS.put("[]", 10);
        METHOD_IDS.put("[]=", 11);
        METHOD_IDS.put("length", 12);
        METHOD_IDS.put("size", 13);
        METHOD_IDS.put("empty?", 14);
        METHOD_IDS.put("succ", 16);
        METHOD_IDS.put(">", 17);
        METHOD_IDS.put(">=", 18);
        METHOD_IDS.put("!", 20);
        METHOD_IDS.put("!=", 21);
        METHOD_IDS.put("=~", 22);
        METHOD_IDS.put("freeze", 23);
        METHOD_IDS.put("-@", 24);
        METHOD_IDS.put("max", 25);
        METHOD_IDS.put("min", 26);
        METHOD_IDS.put("hash", 27);
        METHOD_IDS.put("call", 28);
        METHOD_IDS.put("&", 29);
        METHOD_IDS.put("|", 30);
        METHOD_IDS.put("pack", 33);
        METHOD_IDS.put("include?", 34);
        METHOD_IDS.put("cover?", 34);
        METHOD_IDS.put("to_f", 35);
        METHOD_IDS.put("dig", 36);
        METHOD_IDS.put("eql?", 5);
        METHOD_IDS.put("+@", 0);
    }
}

