/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.api;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jcodings.Encoding;
import org.jruby.RubyArray;
import org.jruby.RubyArrayNative;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyHashLinkedBuckets;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.api.Access;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Create {
    public static RubyArray<?> newArray(ThreadContext context) {
        return RubyArray.newArray(context);
    }

    public static RubyArray<?> allocArray(ThreadContext context, int length2) {
        return RubyArray.newArray(context, length2);
    }

    public static RubyArrayNative<?> allocNativeArray(ThreadContext context, int length2) {
        return RubyArrayNative.newArray(context, length2);
    }

    public static RubyArray<?> allocArray(ThreadContext context, long length2) {
        return Create.allocArray(context, RubyArray.checkLength(context, length2));
    }

    public static RubyArrayNative<?> allocNativeArray(ThreadContext context, long length2) {
        return Create.allocNativeArray(context, RubyArray.checkLength(context, length2));
    }

    public static RubyArray<?> newArray(ThreadContext context, IRubyObject one) {
        return RubyArray.newArray(context.runtime, one);
    }

    public static RubyArray<?> newArray(ThreadContext context, IRubyObject one, IRubyObject two) {
        return RubyArray.newArray(context.runtime, one, two);
    }

    public static RubyArray<?> newArray(ThreadContext context, IRubyObject ... elements) {
        return RubyArray.newArray(context.runtime, elements);
    }

    public static <T> RubyArray<?> newArrayFrom(ThreadContext context, T[] elements, BiFunction<ThreadContext, T, IRubyObject> func) {
        boolean direct = true;
        IRubyObject elt1 = null;
        int length2 = elements.length;
        switch (length2) {
            case 0: {
                return Create.newEmptyArray(context);
            }
            default: {
                direct = false;
            }
            case 2: {
                elt1 = func.apply(context, (ThreadContext)elements[1]);
            }
            case 1: 
        }
        IRubyObject elt0 = func.apply(context, (ThreadContext)elements[0]);
        if (direct) {
            if (elt1 == null) {
                return Create.newArray(context, elt0);
            }
            return Create.newArray(context, elt0, elt1);
        }
        IRubyObject[] ary = new IRubyObject[length2];
        ary[0] = elt0;
        ary[1] = elt1;
        for (int i2 = 2; i2 < length2; ++i2) {
            ary[i2] = func.apply(context, (ThreadContext)elements[i2]);
        }
        return RubyArray.newArrayNoCopy(context.runtime, ary);
    }

    public static RubyArray<?> newArray(ThreadContext context, IRubyObject elt1, IRubyObject elt2, IRubyObject elt3) {
        return RubyArray.newArray(context.runtime, elt1, elt2, elt3);
    }

    public static RubyArray<?> newArray(ThreadContext context, List<IRubyObject> list2) {
        return RubyArray.newArray(context.runtime, list2);
    }

    public static RubyArray<?> newArrayNoCopy(ThreadContext context, IRubyObject ... elements) {
        return RubyArray.newArrayNoCopy(context.runtime, elements);
    }

    public static RubyArray<?> newArray(ThreadContext context, Collection<? extends IRubyObject> elements) {
        return RubyArray.newArray(context.runtime, elements);
    }

    public static RubyHash newHash(ThreadContext context) {
        return RubyHashLinkedBuckets.newLBHash(context.runtime);
    }

    public static RubyHash newEmptyHash(ThreadContext context) {
        return Create.newSmallHash(context);
    }

    public static RubyHash newSmallHash(ThreadContext context) {
        return RubyHashLinkedBuckets.newLBHash(context.runtime, 1);
    }

    public static RubyHash newSmallHash(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        RubyHashLinkedBuckets hash2 = RubyHashLinkedBuckets.newLBHash(context.runtime, 1);
        ((RubyHash)hash2).fastASetSmall(context.runtime, key2, value2, true);
        return hash2;
    }

    public static RubyArray<?> newEmptyArray(ThreadContext context) {
        return RubyArray.newEmptyArray(context.runtime);
    }

    public static RubyString newString(ThreadContext context, byte[] bytes2) {
        return RubyString.newString(context.runtime, bytes2);
    }

    public static RubyString newString(ThreadContext context, byte[] bytes2, int start2, int length2) {
        return RubyString.newString(context.runtime, bytes2, start2, length2);
    }

    public static RubyString newString(ThreadContext context, ByteList bytes2) {
        return RubyString.newString(context.runtime, bytes2);
    }

    public static RubyString newString(ThreadContext context, ByteList bytes2, Encoding encoding2) {
        return RubyString.newString(context.runtime, bytes2, encoding2);
    }

    public static RubyString newSharedString(ThreadContext context, ByteList bytes2) {
        return RubyString.newStringShared(context.runtime, bytes2);
    }

    public static RubyString newSharedString(ThreadContext context, ByteList bytes2, Encoding encoding2) {
        return RubyString.newStringShared(context.runtime, bytes2, encoding2);
    }

    public static RubyString newString(ThreadContext context, String string2, Encoding encoding2) {
        return RubyString.newString(context.runtime, string2, encoding2);
    }

    public static RubyString newString(ThreadContext context, String string2) {
        return RubyString.newString(context.runtime, string2);
    }

    public static RubyString newFrozenString(ThreadContext context, String string2) {
        RubyString rubyString = RubyString.newString(context.runtime, string2);
        rubyString.setFrozen(true);
        return rubyString;
    }

    public static RubyString newEmptyString(ThreadContext context) {
        return RubyString.newEmptyString(context.runtime);
    }

    public static RubyString newEmptyString(ThreadContext context, Encoding encoding2) {
        return RubyString.newEmptyString(context.runtime, encoding2);
    }

    public static RubyString dupString(ThreadContext context, RubyString string2) {
        return string2.strDup(context.runtime, Access.stringClass(context));
    }

    public static RubyRational newRational(ThreadContext context, long num, long den) {
        return RubyRational.newRational(context.runtime, num, den);
    }

    public static RubyStruct newStruct(ThreadContext context, RubyClass structClass, Block block) {
        RubyStruct struct = new RubyStruct(context, structClass);
        struct.callInit(block);
        return struct;
    }

    public static RubyStruct newStruct(ThreadContext context, RubyClass structClass, IRubyObject arg0, Block block) {
        RubyStruct struct = new RubyStruct(context, structClass);
        struct.callInit(arg0, block);
        return struct;
    }

    public static RubyStruct newStruct(ThreadContext context, RubyClass structClass, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyStruct struct = new RubyStruct(context, structClass);
        struct.callInit(arg0, arg1, block);
        return struct;
    }

    public static RubyStruct newStruct(ThreadContext context, RubyClass structClass, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyStruct struct = new RubyStruct(context, structClass);
        struct.callInit(arg0, arg1, arg2, block);
        return struct;
    }

    public static RubyStruct newStruct(ThreadContext context, RubyClass structClass, IRubyObject[] args2, Block block) {
        RubyStruct struct = new RubyStruct(context, structClass);
        struct.callInit(args2, block);
        return struct;
    }
}

