/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import jnr.constants.platform.PRIO;
import jnr.constants.platform.RLIM;
import jnr.constants.platform.RLIMIT;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.byref.IntByReference;
import jnr.posix.Group;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.RLimit;
import jnr.posix.Times;
import jnr.posix.Timeval;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.WindowsFFI;
import org.jruby.util.cli.Options;
import org.jruby.util.io.PopenExecutor;
import org.jruby.util.io.PosixShim;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyModule(name={"Process"})
public class RubyProcess {
    public static final String CLOCK_MONOTONIC = "CLOCK_MONOTONIC";
    public static final String CLOCK_REALTIME = "CLOCK_REALTIME";
    public static final String CLOCK_UNIT_NANOSECOND = "nanosecond";
    public static final String CLOCK_UNIT_MICROSECOND = "microsecond";
    public static final String CLOCK_UNIT_MILLISECOND = "millisecond";
    public static final String CLOCK_UNIT_SECOND = "second";
    public static final String CLOCK_UNIT_FLOAT_MICROSECOND = "float_microsecond";
    public static final String CLOCK_UNIT_FLOAT_MILLISECOND = "float_millisecond";
    public static final String CLOCK_UNIT_FLOAT_SECOND = "float_second";
    public static final String CLOCK_UNIT_HERTZ = "hertz";
    private static final long PROCESS_STATUS_UNINITIALIZED = -1L;
    private static final ObjectMarshal PROCESS_STATUS_MARSHAL = new ObjectMarshal(){

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyStatus status2 = (RubyStatus)obj;
            ThreadContext context = runtime2.getCurrentContext();
            marshalStream.registerLinkTarget(context, status2);
            List<Variable<Object>> attrs = status2.getMarshalVariableList();
            attrs.add(new VariableEntry<RubyFixnum>("status", Convert.asFixnum(context, status2.status)));
            attrs.add(new VariableEntry<RubyFixnum>("pid", Convert.asFixnum(context, status2.pid)));
            marshalStream.dumpVariables(attrs);
        }

        public void marshalTo(ThreadContext context, RubyOutputStream out, Object obj, RubyClass type2, MarshalDumper marshalStream) {
            RubyStatus status2 = (RubyStatus)obj;
            marshalStream.registerObject(status2);
            marshalStream.dumpVariables(context, out, status2, 2, (marshal, c, o, v, receiver2) -> {
                receiver2.receive(marshal, c, o, "status", Convert.asFixnum(c, v.status));
                receiver2.receive(marshal, c, o, "pid", Convert.asFixnum(c, v.pid));
            });
        }

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            RubyStatus status2 = (RubyStatus)input.entry(type2.allocate(context));
            input.ivar(null, status2, null);
            RubyFixnum pstatus = (RubyFixnum)status2.removeInternalVariable("status");
            RubyFixnum pid2 = (RubyFixnum)status2.removeInternalVariable("pid");
            status2.status = pstatus.getValue();
            status2.pid = pid2.getValue();
            return status2;
        }

        public Object unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader input) {
            RubyStatus status2 = (RubyStatus)input.entry(type2.allocate(context));
            input.ivar(context, in, null, status2, null);
            RubyFixnum pstatus = (RubyFixnum)status2.removeInternalVariable("status");
            RubyFixnum pid2 = (RubyFixnum)status2.removeInternalVariable("pid");
            status2.status = pstatus.getValue();
            status2.pid = pid2.getValue();
            return status2;
        }
    };
    private static final MethodHandle NATIVE_THREAD_SIGNAL;
    private static final MethodHandle NATIVE_THREAD_CURRENT;
    private static final MethodHandles.Lookup LOOKUP;
    private static final NonNativeErrno ECHILD;
    private static final NonNativeErrno IGNORE;

    public static RubyModule createProcessModule(ThreadContext context, RubyClass Object2, RubyClass Struct2) {
        RubyModule Process2 = ((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineModule(context, "Process").defineMethods(context, RubyProcess.class)).defineConstant(context, "WNOHANG", Convert.asFixnum(context, 1))).defineConstant(context, "WUNTRACED", Convert.asFixnum(context, 2))).defineConstant(context, CLOCK_REALTIME, Convert.asSymbol(context, CLOCK_REALTIME))).defineConstant(context, CLOCK_MONOTONIC, Convert.asSymbol(context, CLOCK_MONOTONIC)).tap(c -> c.defineConstantsFrom(context, PRIO.class));
        RubyClass ProcessStatus = (RubyClass)((RubyModule)((RubyClass)Process2.defineClassUnder(context, "Status", Object2, RubyProcess::newAllocatedProcessStatus)).marshalWith(PROCESS_STATUS_MARSHAL)).defineMethods(context, RubyStatus.class);
        context.runtime.setProcStatus(ProcessStatus);
        context.runtime.setProcUID((RubyModule)Process2.defineModuleUnder(context, "UID").defineMethods(context, UserID.class));
        context.runtime.setProcGID((RubyModule)Process2.defineModuleUnder(context, "GID").defineMethods(context, GroupID.class));
        context.runtime.setProcSys((RubyModule)Process2.defineModuleUnder(context, "Sys").defineMethods(context, Sys.class));
        if (Platform.IS_WINDOWS) {
            RLIMIT[] singleton = Process2.singletonClass(context);
            singleton.retrieveMethod("getrlimit").setNotImplemented(true);
            singleton.retrieveMethod("setrlimit").setNotImplemented(true);
        } else {
            Process2.defineConstantsFrom(context, RLIM.class);
            for (RLIMIT r : RLIMIT.values()) {
                if (!r.defined()) continue;
                Process2.defineConstant(context, r.name(), Convert.asFixnum(context, r.intValue()));
            }
        }
        RubyClass tmsStruct = RubyStruct.newInstance(context, Struct2, new IRubyObject[]{Create.newString(context, "Tms"), Convert.asSymbol(context, "utime"), Convert.asSymbol(context, "stime"), Convert.asSymbol(context, "cutime"), Convert.asSymbol(context, "cstime")}, Block.NULL_BLOCK);
        Process2.defineConstant(context, "Tms", tmsStruct);
        context.runtime.setTmsStruct(tmsStruct);
        return Process2;
    }

    public static RubyStatus newAllocatedProcessStatus(Ruby runtime2, RubyClass metaClass) {
        return new RubyStatus(runtime2, metaClass, 0L, -1L);
    }

    @JRubyMethod(name={"abort"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.abort(context, recv2, args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.exit_bang(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"exit!"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit_bang(context, recv2, args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject groups(IRubyObject recv2) {
        return RubyProcess.groups(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(ThreadContext context, IRubyObject recv2) {
        long[] groups2 = context.runtime.getPosix().getgroups();
        if (groups2 == null) {
            throw Error.notImplementedError(context, "groups() function is unimplemented on this machine");
        }
        IRubyObject[] ary = new IRubyObject[groups2.length];
        for (int i2 = 0; i2 < groups2.length; ++i2) {
            ary[i2] = Convert.asFixnum(context, groups2[i2]);
        }
        return RubyArray.newArrayNoCopy(context.runtime, ary);
    }

    @JRubyMethod(name={"last_status"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject last_status(ThreadContext context, IRubyObject recv2) {
        return Helpers.nullToNil(context.getLastExitStatus(), context.nil);
    }

    @JRubyMethod(name={"setrlimit"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(ThreadContext context, IRubyObject recv2, IRubyObject resource, IRubyObject rlimCur) {
        return RubyProcess.setrlimit(context, recv2, resource, rlimCur, context.nil);
    }

    @JRubyMethod(name={"setrlimit"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(ThreadContext context, IRubyObject recv2, IRubyObject resource, IRubyObject rlimCur, IRubyObject rlimMax) {
        if (Platform.IS_WINDOWS) {
            throw Error.notImplementedError(context, "Process#setrlimit is not implemented on Windows");
        }
        POSIX posix = context.runtime.getPosix();
        if (!posix.isNative()) {
            Warn.warn(context, "Process#setrlimit not supported on this platform");
            return context.nil;
        }
        RLimit rlim = posix.getrlimit(0);
        if (rlimMax == context.nil) {
            rlimMax = rlimCur;
        }
        rlim.init(RubyProcess.rlimitResourceValue(context, rlimCur), RubyProcess.rlimitResourceValue(context, rlimMax));
        if (posix.setrlimit(RubyProcess.rlimitResourceType(context, resource), rlim) < 0) {
            throw context.runtime.newErrnoFromInt(posix.errno(), "setrlimit");
        }
        return context.nil;
    }

    private static long rlimitResourceValue(ThreadContext context, IRubyObject rval) {
        String name2;
        switch (((CoreObjectType)((Object)rval)).getNativeClassIndex()) {
            case SYMBOL: {
                name2 = rval.toString();
                break;
            }
            case STRING: {
                name2 = rval.toString();
                break;
            }
            default: {
                IRubyObject v = TypeConverter.checkStringType(context.runtime, rval);
                if (!v.isNil()) {
                    rval = v;
                    name2 = rval.convertToString().toString();
                    break;
                }
            }
            case INTEGER: {
                return Convert.toLong(context, rval);
            }
        }
        if (RLIM.RLIM_INFINITY.defined() && name2.equals("INFINITY")) {
            return RLIM.RLIM_INFINITY.intValue();
        }
        if (RLIM.RLIM_SAVED_MAX.defined() && name2.equals("SAVED_MAX")) {
            return RLIM.RLIM_SAVED_MAX.intValue();
        }
        if (RLIM.RLIM_SAVED_CUR.defined() && name2.equals("SAVED_CUR")) {
            return RLIM.RLIM_SAVED_CUR.intValue();
        }
        throw Error.argumentError(context, "invalid resource value: " + String.valueOf(rval));
    }

    private static int rlimitResourceType(ThreadContext context, IRubyObject rtype) {
        String name2;
        switch (((CoreObjectType)((Object)rtype)).getNativeClassIndex()) {
            case SYMBOL: {
                name2 = rtype.toString();
                break;
            }
            case STRING: {
                name2 = rtype.toString();
                break;
            }
            default: {
                IRubyObject v = TypeConverter.checkStringType(context.runtime, rtype);
                if (!v.isNil()) {
                    rtype = v;
                    name2 = rtype.toString();
                    break;
                }
            }
            case INTEGER: {
                return Convert.toInt(context, rtype);
            }
        }
        int r = RubyProcess.rlimitTypeByHname(name2);
        if (r != -1) {
            return r;
        }
        throw Error.argumentError(context, "invalid resource name: " + String.valueOf(rtype));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int rlimitResourceName2int(String name2, int casetype) {
        RLIMIT resource;
        block28: {
            switch (Character.toUpperCase(name2.charAt(0))) {
                case 'A': {
                    if (!RLIMIT.RLIMIT_AS.defined() || !name2.equalsIgnoreCase("AS")) break;
                    resource = RLIMIT.RLIMIT_AS;
                    break block28;
                }
                case 'C': {
                    if (RLIMIT.RLIMIT_CORE.defined() && name2.equalsIgnoreCase("CORE")) {
                        resource = RLIMIT.RLIMIT_CORE;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_CPU.defined() || !name2.equalsIgnoreCase("CPU")) break;
                        resource = RLIMIT.RLIMIT_CPU;
                    }
                    break block28;
                }
                case 'D': {
                    if (!RLIMIT.RLIMIT_DATA.defined() || !name2.equalsIgnoreCase("DATA")) break;
                    resource = RLIMIT.RLIMIT_DATA;
                    break block28;
                }
                case 'F': {
                    if (!RLIMIT.RLIMIT_FSIZE.defined() || !name2.equalsIgnoreCase("FSIZE")) break;
                    resource = RLIMIT.RLIMIT_FSIZE;
                    break block28;
                }
                case 'M': {
                    if (RLIMIT.RLIMIT_MEMLOCK.defined() && name2.equalsIgnoreCase("MEMLOCK")) {
                        resource = RLIMIT.RLIMIT_MEMLOCK;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_MSGQUEUE.defined() || !name2.equalsIgnoreCase("MSGQUEUE")) break;
                        resource = RLIMIT.RLIMIT_MSGQUEUE;
                    }
                    break block28;
                }
                case 'N': {
                    if (RLIMIT.RLIMIT_NOFILE.defined() && name2.equalsIgnoreCase("NOFILE")) {
                        resource = RLIMIT.RLIMIT_NOFILE;
                        break block28;
                    } else if (RLIMIT.RLIMIT_NPROC.defined() && name2.equalsIgnoreCase("NPROC")) {
                        resource = RLIMIT.RLIMIT_NPROC;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_NICE.defined() || !name2.equalsIgnoreCase("NICE")) break;
                        resource = RLIMIT.RLIMIT_NICE;
                    }
                    break block28;
                }
                case 'R': {
                    if (RLIMIT.RLIMIT_RSS.defined() && name2.equalsIgnoreCase("RSS")) {
                        resource = RLIMIT.RLIMIT_RSS;
                        break block28;
                    } else if (RLIMIT.RLIMIT_RTPRIO.defined() && name2.equalsIgnoreCase("RTPRIO")) {
                        resource = RLIMIT.RLIMIT_RTPRIO;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_RTTIME.defined() || !name2.equalsIgnoreCase("RTTIME")) break;
                        resource = RLIMIT.RLIMIT_RTTIME;
                    }
                    break block28;
                }
                case 'S': {
                    if (RLIMIT.RLIMIT_STACK.defined() && name2.equalsIgnoreCase("STACK")) {
                        resource = RLIMIT.RLIMIT_STACK;
                    } else {
                        if (!RLIMIT.RLIMIT_SIGPENDING.defined() || !name2.equalsIgnoreCase("SIGPENDING")) break;
                        resource = RLIMIT.RLIMIT_SIGPENDING;
                    }
                    break block28;
                }
            }
            return -1;
        }
        switch (casetype) {
            case 0: {
                if (name2.equals(name2.toUpperCase())) break;
                return -1;
            }
            case 1: {
                if (name2.equals(name2.toLowerCase())) break;
                return -1;
            }
            default: {
                throw new RuntimeException("unexpected casetype");
            }
        }
        return resource.intValue();
    }

    private static int rlimitTypeByHname(String name2) {
        return RubyProcess.rlimitResourceName2int(name2, 0);
    }

    @Deprecated(since="1.2")
    public static IRubyObject getpgrp(IRubyObject recv2) {
        return RubyProcess.getpgrp(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, context.runtime.getPosix().getpgrp());
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getpgrp(Ruby runtime2) {
        return Convert.asFixnum(runtime2.getCurrentContext(), runtime2.getPosix().getpgrp());
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject groups_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.groups_set(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"groups="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        throw Error.notImplementedError(context, "Process#groups not yet implemented");
    }

    @Deprecated(since="1.2")
    public static IRubyObject waitpid(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(((RubyBasicObject)recv2).getCurrentContext(), args2);
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(context, args2);
    }

    @JRubyMethod(module=true)
    public static IRubyObject warmup(ThreadContext context, IRubyObject recv2) {
        return context.tru;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject waitpid(Ruby runtime2, IRubyObject[] args2) {
        return RubyProcess.waitpid(runtime2.getCurrentContext(), args2);
    }

    public static IRubyObject waitpid(ThreadContext context, IRubyObject[] args2) {
        long pid2 = args2.length > 0 ? Convert.toLong(context, args2[0]) : -1L;
        int flags2 = args2.length > 1 ? Convert.toInt(context, args2[1]) : 0;
        long result2 = RubyProcess.waitpid(context, pid2, flags2);
        RubyProcess.checkErrno(context, result2, ECHILD);
        return result2 == 0L ? context.nil : Convert.asFixnum(context, result2);
    }

    static IRubyObject waitpidStatus(ThreadContext context, long pid2, int flags2) {
        Ruby runtime2 = context.runtime;
        int[] status2 = new int[1];
        POSIX posix = runtime2.getPosix();
        posix.errno(0);
        int res = RubyProcess.pthreadKillable(context, ctx -> posix.waitpid(pid2, status2, flags2));
        return RubyStatus.newProcessStatus(runtime2, status2[0], res);
    }

    @Deprecated(since="10.0.0.0")
    public static long waitpid(Ruby runtime2, long pid2, int flags2) {
        return RubyProcess.waitpid(runtime2.getCurrentContext(), pid2, flags2);
    }

    public static long waitpid(ThreadContext context, long pid2, int flags2) {
        POSIX posix = context.runtime.getPosix();
        posix.errno(0);
        int[] status2 = new int[1];
        int res = RubyProcess.pthreadKillable(context, ctx -> posix.waitpid(pid2, status2, flags2));
        context.setLastExitStatus(res > 0 ? RubyStatus.newProcessStatus(context.runtime, status2[0], res) : context.nil);
        return res;
    }

    private static int pthreadKillable(ThreadContext context, ToIntFunction<ThreadContext> blockingCall) {
        if (Platform.IS_WINDOWS || !Options.NATIVE_PTHREAD_KILL.load().booleanValue() || NATIVE_THREAD_SIGNAL == null || NATIVE_THREAD_CURRENT == null) {
            return blockingCall.applyAsInt(context);
        }
        while (true) {
            try {
                final long threadID = NATIVE_THREAD_CURRENT.invokeExact();
                return context.getThread().executeTaskBlocking(context, blockingCall, new RubyThread.Task<ToIntFunction<ThreadContext>, Integer>(){

                    @Override
                    public Integer run(ThreadContext context, ToIntFunction<ThreadContext> blockingCall) {
                        return blockingCall.applyAsInt(context);
                    }

                    @Override
                    public void wakeup(RubyThread thread2, ToIntFunction<ThreadContext> blockingCall) {
                        try {
                            NATIVE_THREAD_SIGNAL.invokeExact(threadID);
                        }
                        catch (Throwable t) {
                            Helpers.throwException(t);
                        }
                    }
                });
            }
            catch (InterruptedException ie) {
                context.pollThreadEvents();
                continue;
            }
            catch (Throwable t) {
                Helpers.throwException(t);
                continue;
            }
            break;
        }
    }

    @Deprecated(since="1.2")
    public static IRubyObject wait(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(((RubyBasicObject)recv2).getCurrentContext(), args2);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(context, args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject wait(Ruby runtime2, IRubyObject[] args2) {
        return RubyProcess.wait(((RubyBasicObject)args2[0]).getCurrentContext(), args2);
    }

    public static IRubyObject wait(ThreadContext context, IRubyObject[] args2) {
        if (args2.length > 0) {
            return RubyProcess.waitpid(context, args2);
        }
        int[] status2 = new int[1];
        POSIX posix = context.runtime.getPosix();
        posix.errno(0);
        int pid2 = RubyProcess.pthreadKillable(context, ctx -> posix.wait(status2));
        RubyProcess.checkErrno(context, pid2, ECHILD);
        context.setLastExitStatus(RubyStatus.newProcessStatus(context.runtime, status2[0], pid2));
        return Convert.asFixnum(context, pid2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject waitall(IRubyObject recv2) {
        return RubyProcess.waitall(((RubyBasicObject)recv2).getCurrentContext());
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.waitall(context);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject waitall(Ruby runtime2) {
        return RubyProcess.waitall(runtime2.getCurrentContext());
    }

    public static IRubyObject waitall(ThreadContext context) {
        POSIX posix = context.runtime.getPosix();
        RubyArray<?> results = Create.newArray(context);
        int[] status2 = new int[1];
        int result2 = RubyProcess.pthreadKillable(context, ctx -> posix.wait(status2));
        while (result2 != -1) {
            results.append(context, Create.newArray(context, (IRubyObject)Convert.asFixnum(context, result2), (IRubyObject)RubyStatus.newProcessStatus(context.runtime, status2[0], result2)));
            result2 = RubyProcess.pthreadKillable(context, ctx -> posix.wait(status2));
        }
        return results;
    }

    @Deprecated(since="1.2")
    public static IRubyObject setsid(IRubyObject recv2) {
        return RubyProcess.setsid(((RubyBasicObject)recv2).getCurrentContext().runtime);
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().setsid()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setsid(Ruby runtime2) {
        return RubyProcess.setsid(runtime2.getCurrentContext(), null);
    }

    @Deprecated(since="1.2")
    public static IRubyObject setpgrp(IRubyObject recv2) {
        return RubyProcess.setpgrp(((RubyBasicObject)recv2).getCurrentContext().runtime);
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().setpgid(0, 0)));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setpgrp(Ruby runtime2) {
        return RubyProcess.setpgrp(runtime2.getCurrentContext(), null);
    }

    @Deprecated(since="1.2")
    public static IRubyObject egid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(((RubyBasicObject)recv2).getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"egid="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(context, arg2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject egid_set(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.egid_set(runtime2.getCurrentContext(), arg2);
    }

    public static IRubyObject egid_set(ThreadContext context, IRubyObject arg2) {
        int gid2;
        if (arg2 instanceof RubyInteger || arg2.checkStringType().isNil()) {
            gid2 = Convert.toInt(context, arg2);
        } else {
            Group group2 = context.runtime.getPosix().getgrnam(arg2.asJavaString());
            if (group2 == null) {
                throw Error.argumentError(context, "can't find group for " + String.valueOf(arg2.inspect(context)));
            }
            gid2 = (int)group2.getGID();
        }
        RubyProcess.checkErrno(context, context.runtime.getPosix().setegid(gid2));
        return Convert.asFixnum(context, 0);
    }

    @Deprecated(since="1.2")
    public static IRubyObject euid(IRubyObject recv2) {
        return RubyProcess.euid(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().geteuid()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject euid(Ruby runtime2) {
        return RubyProcess.euid(runtime2.getCurrentContext(), null);
    }

    @Deprecated(since="1.2")
    public static IRubyObject uid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.uid_set(((RubyBasicObject)recv2).getCurrentContext(), null, arg2);
    }

    @JRubyMethod(name={"uid="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyProcess.checkErrno(context, context.runtime.getPosix().setuid(Convert.toInt(context, arg2)));
        return Convert.asFixnum(context, 0);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject uid_set(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.uid_set(runtime2.getCurrentContext(), null, arg2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject gid(IRubyObject recv2) {
        return RubyProcess.gid(((RubyBasicObject)recv2).getCurrentContext());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.gid(context);
    }

    public static IRubyObject gid(ThreadContext context) {
        return Platform.IS_WINDOWS ? RubyFixnum.zero(context.runtime) : Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().getgid()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject gid(Ruby runtime2) {
        return RubyProcess.gid(runtime2.getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject maxgroups(IRubyObject recv2) {
        return RubyProcess.maxgroups(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(ThreadContext context, IRubyObject recv2) {
        throw Error.notImplementedError(context, "Process#maxgroups not yet implemented");
    }

    @Deprecated(since="1.2")
    public static IRubyObject getpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg1, arg2);
    }

    @JRubyMethod(name={"getpriority"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        int which = Convert.toInt(context, arg1);
        int who = Convert.toInt(context, arg2);
        int result2 = RubyProcess.checkErrno(context, context.runtime.getPosix().getpriority(which, who));
        return Convert.asFixnum(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getpriority(Ruby runtime2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(runtime2.getCurrentContext(), null, arg1, arg2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject uid(IRubyObject recv2) {
        return RubyProcess.uid(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(ThreadContext context, IRubyObject recv2) {
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().getuid()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject uid(Ruby runtime2) {
        return RubyProcess.uid(runtime2.getCurrentContext(), null);
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject pid2 = RubyProcess.waitpid(context, recv2, args2);
        return pid2.isNil() ? context.nil : Create.newArray(context, pid2, context.getLastExitStatus());
    }

    public static IRubyObject waitpid2(Ruby runtime2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(runtime2.getCurrentContext(), runtime2.getProcess(), args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject initgroups(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.initgroups(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg1, arg2);
    }

    @JRubyMethod(name={"initgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        throw Error.notImplementedError(context, "Process#initgroups not yet implemented");
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject maxgroups_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.maxgroups_set(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"maxgroups="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        throw Error.notImplementedError(context, "Process#maxgroups_set not yet implemented");
    }

    @Deprecated(since="1.2")
    public static IRubyObject ppid(IRubyObject recv2) {
        return RubyProcess.ppid(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(ThreadContext context, IRubyObject recv2) {
        int result2 = RubyProcess.checkErrno(context, context.runtime.getPosix().getppid());
        return Convert.asFixnum(context, result2);
    }

    public static IRubyObject ppid(Ruby runtime2) {
        return RubyProcess.ppid(runtime2.getCurrentContext(), null);
    }

    @Deprecated(since="1.2")
    public static IRubyObject gid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.gid_set(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"gid="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        int result2 = RubyProcess.checkErrno(context, context.runtime.getPosix().setgid(Convert.toInt(context, arg2)));
        return Convert.asFixnum(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject gid_set(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.gid_set(runtime2.getCurrentContext(), null, arg2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject wait2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(context.runtime, args2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject euid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(((RubyBasicObject)recv2).getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"euid="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(context, arg2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject euid_set(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.euid_set(runtime2.getCurrentContext(), arg2);
    }

    public static IRubyObject euid_set(ThreadContext context, IRubyObject arg2) {
        int uid2;
        if (arg2 instanceof RubyInteger || arg2.checkStringType().isNil()) {
            uid2 = Convert.toInt(context, arg2);
        } else {
            Passwd password = context.runtime.getPosix().getpwnam(arg2.asJavaString());
            if (password == null) {
                throw Error.argumentError(context, "can't find user for " + String.valueOf(arg2.inspect(context)));
            }
            uid2 = (int)password.getUID();
        }
        RubyProcess.checkErrno(context, context.runtime.getPosix().seteuid(uid2));
        return Convert.asFixnum(context, 0);
    }

    @Deprecated(since="1.2")
    public static IRubyObject setpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg1, arg2, arg3);
    }

    @JRubyMethod(name={"setpriority"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int which = Convert.toInt(context, arg1);
        int who = Convert.toInt(context, arg2);
        int prio = Convert.toInt(context, arg3);
        POSIX posix = context.runtime.getPosix();
        posix.errno(0);
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, posix.setpriority(which, who, prio)));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setpriority(Ruby runtime2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(runtime2.getCurrentContext(), null, arg1, arg2, arg3);
    }

    @Deprecated(since="1.2")
    public static IRubyObject setpgid(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg1, arg2);
    }

    @JRubyMethod(name={"setpgid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        int pid2 = Convert.toInt(context, arg1);
        int gid2 = Convert.toInt(context, arg2);
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().setpgid(pid2, gid2)));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setpgid(Ruby runtime2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(runtime2.getCurrentContext(), null, arg1, arg2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject getpgid(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getpgid(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"getpgid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        int pgid = Convert.toInt(context, arg2);
        return Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().getpgid(pgid)));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getpgid(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.getpgid(runtime2.getCurrentContext(), null, arg2);
    }

    @Deprecated(since="1.2")
    public static IRubyObject getrlimit(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(((RubyBasicObject)recv2).getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"getrlimit"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(context, arg2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getrlimit(Ruby runtime2, IRubyObject arg2) {
        return RubyProcess.getrlimit(runtime2.getCurrentContext(), arg2);
    }

    public static IRubyObject getrlimit(ThreadContext context, IRubyObject arg2) {
        if (Platform.IS_WINDOWS) {
            throw Error.notImplementedError(context, "Process#getrlimit is not implemented on Windows");
        }
        if (!context.runtime.getPosix().isNative()) {
            Warn.warn(context, "Process#getrlimit not supported on this platform");
            RubyFixnum max2 = Convert.asFixnum(context, Long.MAX_VALUE);
            return Create.newArray(context, (IRubyObject)max2, (IRubyObject)max2);
        }
        RLimit rlimit = context.runtime.getPosix().getrlimit(RubyProcess.rlimitResourceType(context, arg2));
        return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, rlimit.rlimCur()), (IRubyObject)Convert.asFixnum(context, rlimit.rlimMax()));
    }

    @Deprecated(since="1.2")
    public static IRubyObject egid(IRubyObject recv2) {
        return RubyProcess.egid(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(ThreadContext context, IRubyObject recv2) {
        return Platform.IS_WINDOWS ? RubyFixnum.zero(context.runtime) : Convert.asFixnum(context, RubyProcess.checkErrno(context, context.runtime.getPosix().getegid()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject egid(Ruby runtime2) {
        return RubyProcess.egid(runtime2.getCurrentContext(), null);
    }

    private static int parseSignalString(ThreadContext context, String value2) {
        String signalName;
        int signalValue;
        boolean negative = value2.startsWith("-");
        if (negative) {
            value2 = value2.substring(1);
        }
        if ((signalValue = (int)RubySignal.signm2signo(signalName = value2.startsWith("SIG") ? value2.substring(3) : value2)) == 0) {
            throw Error.argumentError(context, "unsupported name '" + signalName + "'");
        }
        return negative ? -signalValue : signalValue;
    }

    @Deprecated(since="1.2")
    public static IRubyObject kill(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.kill(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        boolean processGroupKill;
        if (args2.length < 2) {
            throw Error.argumentError(context, "wrong number of arguments -- kill(sig, pid...)");
        }
        IRubyObject iRubyObject = args2[0];
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        int signal2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubySymbol.class, RubyString.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield fixnum.asInt(context);
            }
            case 1 -> {
                RubySymbol sym = (RubySymbol)iRubyObject2;
                yield RubyProcess.parseSignalString(context, sym.idString());
            }
            case 2 -> {
                RubyString str = (RubyString)iRubyObject2;
                yield RubyProcess.parseSignalString(context, str.asJavaString());
            }
            default -> RubyProcess.parseSignalString(context, args2[0].checkStringType().toString());
        };
        boolean bl = processGroupKill = signal2 < 0;
        if (processGroupKill) {
            if (Platform.IS_WINDOWS) {
                throw context.runtime.newErrnoEINVALError("group signals not implemented in windows");
            }
            signal2 = -signal2;
        }
        if (Platform.IS_WINDOWS) {
            for (int i2 = 1; i2 < args2.length; ++i2) {
                IntByReference status2;
                Pointer ptr;
                int pid2 = Convert.toInt(context, args2[i2]);
                if (signal2 == 0) {
                    ptr = WindowsFFI.kernel32().OpenProcess(1024, 0, pid2);
                    if (ptr != null && ptr.address() != -1L) {
                        try {
                            status2 = new IntByReference(0);
                            if (WindowsFFI.kernel32().GetExitCodeProcess(ptr, status2) == 0) {
                                throw context.runtime.newErrnoEPERMError("unable to call GetExitCodeProcess " + pid2);
                            }
                            if (status2.intValue() == 259) continue;
                            throw context.runtime.newErrnoEPERMError("Process exists but is not alive anymore " + pid2);
                        }
                        finally {
                            WindowsFFI.kernel32().CloseHandle(ptr);
                        }
                    }
                    if (WindowsFFI.kernel32().GetLastError() == 87) {
                        throw context.runtime.newErrnoESRCHError();
                    }
                    throw context.runtime.newErrnoEPERMError("Process does not exist " + pid2);
                }
                if (signal2 == 9) {
                    ptr = WindowsFFI.kernel32().OpenProcess(1025, 0, pid2);
                    if (ptr != null && ptr.address() != -1L) {
                        try {
                            status2 = new IntByReference(0);
                            if (WindowsFFI.kernel32().GetExitCodeProcess(ptr, status2) == 0) {
                                throw context.runtime.newErrnoEPERMError("unable to call GetExitCodeProcess " + pid2);
                            }
                            if (status2.intValue() != 259 || WindowsFFI.kernel32().TerminateProcess(ptr, 0) != 0) continue;
                            throw context.runtime.newErrnoEPERMError("unable to call TerminateProcess " + pid2);
                        }
                        finally {
                            WindowsFFI.kernel32().CloseHandle(ptr);
                        }
                    }
                    if (WindowsFFI.kernel32().GetLastError() == 87) {
                        throw context.runtime.newErrnoESRCHError();
                    }
                    throw context.runtime.newErrnoEPERMError("Process does not exist " + pid2);
                }
                throw Error.notImplementedError(context, "this signal not yet implemented in windows");
            }
        } else {
            POSIX posix = context.runtime.getPosix();
            for (int i3 = 1; i3 < args2.length; ++i3) {
                int pid3 = Convert.toInt(context, args2[i3]);
                if (pid3 == 0) {
                    pid3 = context.runtime.getPosix().getpid();
                }
                RubyProcess.checkErrno(context, posix.kill(processGroupKill ? -pid3 : pid3, signal2));
            }
        }
        return Convert.asFixnum(context, args2.length - 1);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject kill(Ruby runtime2, IRubyObject[] args2) {
        return RubyProcess.kill(runtime2.getCurrentContext(), null, args2);
    }

    @JRubyMethod(name={"detach"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        long pid2 = Convert.toLong(context, arg2);
        BlockCallback callback = (ctx, args2, block) -> {
            ctx.pushFrame();
            while (RubyProcess.waitpid(ctx.runtime, pid2, 0) == 0L) {
            }
            return RubyProcess.last_status(ctx, recv2);
        };
        return RubyThread.startWaiterThread(context.runtime, pid2, CallBlock.newCallClosure(context, recv2, Signature.NO_ARGUMENTS, callback));
    }

    @Deprecated(since="1.2")
    public static IRubyObject times(IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(((RubyBasicObject)recv2).getCurrentContext(), recv2, unusedBlock);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(ThreadContext context, IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(context);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject times(Ruby runtime2) {
        return RubyProcess.times(runtime2.getCurrentContext());
    }

    public static IRubyObject times(ThreadContext context) {
        Times tms = context.runtime.getPosix().times();
        double utime2 = 0.0;
        double stime = 0.0;
        double cutime = 0.0;
        double cstime = 0.0;
        if (tms == null) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean.isCurrentThreadCpuTimeSupported()) {
                cutime = utime2 = (double)bean.getCurrentThreadUserTime();
                cstime = stime = (double)(bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime());
            }
        } else {
            utime2 = tms.utime();
            stime = tms.stime();
            cutime = tms.cutime();
            cstime = tms.cstime();
        }
        long hz = context.runtime.getPosix().sysconf(Sysconf._SC_CLK_TCK);
        if (hz == -1L) {
            hz = 60L;
        }
        return Create.newStruct(context, (RubyClass)context.runtime.getTmsStruct(), new IRubyObject[]{Convert.asFloat(context, utime2 / (double)hz), Convert.asFloat(context, stime / (double)hz), Convert.asFloat(context, cutime / (double)hz), Convert.asFloat(context, cstime / (double)hz)}, Block.NULL_BLOCK);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_gettime(ThreadContext context, IRubyObject self2, IRubyObject _clock_id) {
        return RubyProcess.makeClockResult(context, RubyProcess.getTimeForClock(context, _clock_id), CLOCK_UNIT_FLOAT_SECOND);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_gettime(ThreadContext context, IRubyObject self2, IRubyObject _clock_id, IRubyObject _unit) {
        if (!(_unit instanceof RubySymbol) && !_unit.isNil()) {
            throw Error.argumentError(context, "unexpected unit: " + String.valueOf(_unit));
        }
        return RubyProcess.makeClockResult(context, RubyProcess.getTimeForClock(context, _clock_id), _unit.toString());
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject exec(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return RubyKernel.exec(context, self2, args2);
    }

    private static long getTimeForClock(ThreadContext context, IRubyObject _clock_id) throws RaiseException {
        if (_clock_id instanceof RubySymbol) {
            RubySymbol clock_id = (RubySymbol)_clock_id;
            if (clock_id.idString().equals(CLOCK_MONOTONIC)) {
                return System.nanoTime();
            }
            if (clock_id.idString().equals(CLOCK_REALTIME)) {
                long nanos;
                POSIX posix = context.runtime.getPosix();
                if (posix.isNative()) {
                    Timeval tv = posix.allocateTimeval();
                    posix.gettimeofday(tv);
                    nanos = tv.sec() * 1000000000L + tv.usec() * 1000L;
                } else {
                    nanos = System.currentTimeMillis() * 1000000L;
                }
                return nanos;
            }
        }
        throw RubyProcess.clockError(context, "gettime", _clock_id);
    }

    private static long getResolutionForClock(ThreadContext context, IRubyObject _clock_id) throws RaiseException {
        if (_clock_id instanceof RubySymbol) {
            RubySymbol clock_id = (RubySymbol)_clock_id;
            if (clock_id.idString().equals(CLOCK_MONOTONIC)) {
                return 1L;
            }
            if (clock_id.idString().equals(CLOCK_REALTIME)) {
                return 1000000L;
            }
        }
        throw RubyProcess.clockError(context, "getres", _clock_id);
    }

    private static RaiseException clockError(ThreadContext context, String clockMethod, IRubyObject _clock_id) {
        return context.runtime.newErrnoEINVALError("Process.clock_" + clockMethod + "(" + _clock_id.inspect().toString() + ")");
    }

    private static IRubyObject makeClockResult(ThreadContext context, long nanos, String unit) {
        if (unit.equals(CLOCK_UNIT_NANOSECOND)) {
            return Convert.asFixnum(context, nanos);
        }
        if (unit.equals(CLOCK_UNIT_MICROSECOND)) {
            return Convert.asFixnum(context, nanos / 1000L);
        }
        if (unit.equals(CLOCK_UNIT_MILLISECOND)) {
            return Convert.asFixnum(context, nanos / 1000000L);
        }
        if (unit.equals(CLOCK_UNIT_SECOND)) {
            return Convert.asFixnum(context, nanos / 1000000000L);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_MICROSECOND)) {
            return Convert.asFloat(context, (double)nanos / 1000.0);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_MILLISECOND)) {
            return Convert.asFloat(context, (double)nanos / 1000000.0);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_SECOND) || unit.equals("")) {
            return Convert.asFloat(context, (double)nanos / 1.0E9);
        }
        throw Error.argumentError(context, "unexpected unit: " + unit);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_getres(ThreadContext context, IRubyObject self2, IRubyObject _clock_id) {
        return RubyProcess.makeClockResolutionResult(context, RubyProcess.getResolutionForClock(context, _clock_id), CLOCK_UNIT_FLOAT_SECOND);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_getres(ThreadContext context, IRubyObject self2, IRubyObject _clock_id, IRubyObject _unit) {
        if (!(_unit instanceof RubySymbol) && !_unit.isNil()) {
            throw Error.argumentError(context, "unexpected unit: " + String.valueOf(_unit));
        }
        return RubyProcess.makeClockResolutionResult(context, RubyProcess.getResolutionForClock(context, _clock_id), _unit.toString());
    }

    private static IRubyObject makeClockResolutionResult(ThreadContext context, long nanos, String unit) {
        return unit.equals(CLOCK_UNIT_HERTZ) ? Convert.asFloat(context, 1.0E9 / (double)nanos) : RubyProcess.makeClockResult(context, nanos, unit);
    }

    @Deprecated(since="1.2")
    public static IRubyObject pid(IRubyObject recv2) {
        return RubyProcess.pid(((RubyBasicObject)recv2).getCurrentContext());
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.pid(context);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject pid(Ruby runtime2) {
        return RubyProcess.pid(runtime2.getCurrentContext());
    }

    public static IRubyObject pid(ThreadContext context) {
        return Convert.asFixnum(context, context.runtime.getPosix().getpid());
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, notImplemented=true)
    public static IRubyObject _fork(ThreadContext context, IRubyObject recv2, Block block) {
        throw Error.notImplementedError(context, "fork is not available on this platform");
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject fork19(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyProcess.fork(context, recv2, block);
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, notImplemented=true)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return PopenExecutor.nativePopenAvailable(context.runtime) ? PopenExecutor.spawn(context, args2) : Convert.asFixnum(context, ShellLauncher.runExternalWithoutWait(context.runtime, args2));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.exit(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"exit"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit(context, recv2, args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setproctitle(IRubyObject recv2, IRubyObject name2) {
        return RubyProcess.setproctitle(((RubyBasicObject)recv2).getCurrentContext(), recv2, name2);
    }

    @JRubyMethod(name={"setproctitle"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setproctitle(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        name2.convertToString();
        return name2;
    }

    public static void syswait(Ruby runtime2, int pid2) {
        int[] status2 = new int[]{0};
        runtime2.getPosix().waitpid(pid2, status2, 0);
    }

    private static int checkErrno(ThreadContext context, int result2) {
        return (int)RubyProcess.checkErrno(context, result2, IGNORE);
    }

    private static long checkErrno(ThreadContext context, long result2, NonNativeErrno nonNative) {
        if (result2 == -1L) {
            if (context.runtime.getPosix().isNative()) {
                RubyProcess.raiseErrnoIfSet(context.runtime, nonNative);
            } else {
                nonNative.handle(context.runtime, (int)result2);
            }
        }
        return result2;
    }

    private static void raiseErrnoIfSet(Ruby runtime2, NonNativeErrno nonNative) {
        if (runtime2.getPosix().errno() != 0) {
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno());
        }
    }

    @Deprecated(since="9.0.1.0")
    public static IRubyObject waitpid2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(((RubyBasicObject)recv2).getCurrentContext().runtime, args2);
    }

    static {
        LOOKUP = MethodHandles.lookup();
        MethodHandle signalHandle = null;
        MethodHandle currentHandle = null;
        try {
            Class<?> nativeThread = Class.forName("sun.nio.ch.NativeThread");
            Method signal2 = nativeThread.getDeclaredMethod("signal", Long.TYPE);
            Method current2 = nativeThread.getDeclaredMethod("current", new Class[0]);
            signalHandle = JavaUtil.getHandleSafe(signal2, RubyProcess.class, LOOKUP);
            currentHandle = JavaUtil.getHandleSafe(current2, RubyProcess.class, LOOKUP);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        NATIVE_THREAD_SIGNAL = signalHandle;
        NATIVE_THREAD_CURRENT = currentHandle;
        ECHILD = new NonNativeErrno(){

            @Override
            public int handle(Ruby runtime2, int result2) {
                throw runtime2.newErrnoECHILDError();
            }
        };
        IGNORE = new NonNativeErrno(){

            @Override
            public int handle(Ruby runtime2, int result2) {
                return result2;
            }
        };
    }

    @JRubyClass(name={"Process::Status"})
    public static class RubyStatus
    extends RubyObject {
        private long status;
        private long pid;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby runtime2, RubyClass metaClass, long status2, long pid2) {
            super(runtime2, metaClass);
            this.status = status2;
            this.pid = pid2;
        }

        public static RubyStatus newProcessStatus(Ruby runtime2, long status2, long pid2) {
            return new RubyStatus(runtime2, runtime2.getProcStatus(), status2, pid2);
        }

        @JRubyMethod(module=true, optional=2, checkArity=false)
        public static IRubyObject wait(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            int argc = Arity.checkArgumentCount(context, args2, 0, 2);
            long pid2 = argc > 0 ? (long)Convert.toInt(context, args2[0]) : -1L;
            int flags2 = argc > 1 ? Convert.toInt(context, args2[1]) : 0;
            return RubyProcess.waitpidStatus(context, pid2, flags2);
        }

        @JRubyMethod(name={"&"})
        public IRubyObject op_and(ThreadContext context, IRubyObject arg2) {
            long mask = Convert.toInt(context, arg2);
            if (mask < 0L) {
                throw Error.argumentError(context, "negative mask value: " + mask);
            }
            if (mask > Integer.MAX_VALUE || mask < Integer.MIN_VALUE) {
                throw Error.rangeError(context, "mask value out of range: " + mask);
            }
            String message2 = switch ((int)mask) {
                case 128 -> "Process::Status#coredump?";
                case 127 -> "Process::Status#signaled? or Process::Status#termsig";
                case 255 -> "Process::Status#exited?, Process::Status#stopped? or Process::Status#coredump?";
                case 65280 -> "Process::Status#exitstatus or Process::Status#stopsig";
                default -> "other Process::Status predicates";
            };
            RubyStatus.deprecateAndSuggest(context, "Process::Status#&", "3.5", message2);
            return Convert.asFixnum(context, this.status & mask);
        }

        private static void deprecateAndSuggest(ThreadContext context, String method2, String version, String suggest) {
            context.runtime.getWarnings().warnDeprecatedForRemovalAlternate(method2, version, suggest);
        }

        @JRubyMethod(name={"stopped?"})
        public IRubyObject stopped_p(ThreadContext context) {
            return Convert.asBoolean(context, PosixShim.WAIT_MACROS.WIFSTOPPED(this.status));
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject stopped_p() {
            return this.stopped_p(this.getCurrentContext());
        }

        @JRubyMethod(name={"signaled?"})
        public IRubyObject signaled(ThreadContext context) {
            return Convert.asBoolean(context, PosixShim.WAIT_MACROS.WIFSIGNALED(this.status));
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject signaled() {
            return this.signaled(this.getCurrentContext());
        }

        @JRubyMethod(name={"exited?"})
        public IRubyObject exited(ThreadContext context) {
            return Convert.asBoolean(context, PosixShim.WAIT_MACROS.WIFEXITED(this.status));
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject exited() {
            return this.exited(this.getCurrentContext());
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject stopsig() {
            return this.stopsig(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject stopsig(ThreadContext context) {
            return PosixShim.WAIT_MACROS.WIFSTOPPED(this.status) ? Convert.asFixnum(context, PosixShim.WAIT_MACROS.WSTOPSIG(this.status)) : context.nil;
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject termsig() {
            return this.termsig(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject termsig(ThreadContext context) {
            return PosixShim.WAIT_MACROS.WIFSIGNALED(this.status) ? Convert.asFixnum(context, PosixShim.WAIT_MACROS.WTERMSIG(this.status)) : context.nil;
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject exitstatus() {
            return this.exitstatus(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject exitstatus(ThreadContext context) {
            return PosixShim.WAIT_MACROS.WIFEXITED(this.status) ? Convert.asFixnum(context, PosixShim.WAIT_MACROS.WEXITSTATUS(this.status)) : context.nil;
        }

        @JRubyMethod(name={">>"})
        public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
            long places = Convert.toInt(context, other);
            if (places < 0L) {
                throw Error.argumentError(context, "negative shift value: " + places);
            }
            if (places > Integer.MAX_VALUE) {
                throw Error.rangeError(context, "shift value out of range: " + places);
            }
            String message2 = switch ((int)places) {
                case 7 -> "Process::Status#coredump?";
                case 8 -> "Process::Status#exitstatus or Process::Status#stopsig";
                default -> "other Process::Status attributes";
            };
            RubyStatus.deprecateAndSuggest(context, "Process::Status#>>", "3.5", message2);
            return Convert.asFixnum(context, this.status >> (int)places);
        }

        @Override
        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
            return this == other ? context.tru : Helpers.invokedynamic(context, (IRubyObject)Convert.asFixnum(context, this.status), MethodNames.OP_EQUAL, other);
        }

        @JRubyMethod
        public IRubyObject to_i(ThreadContext context) {
            return this.to_i(context.runtime);
        }

        @Override
        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            String className = this.getMetaClass().getName(context);
            return this.unitialized() ? Create.newString(context, "#<" + className + ": uninitialized>") : Create.newString(context, RubyStatus.pst_message("#<" + className + ": ", this.pid, this.status) + ">");
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p(ThreadContext context) {
            return !PosixShim.WAIT_MACROS.WIFEXITED(this.status) ? context.nil : Convert.asBoolean(context, (long)PosixShim.WAIT_MACROS.WEXITSTATUS(this.status) == 0L);
        }

        @JRubyMethod(name={"coredump?"})
        public IRubyObject coredump_p(ThreadContext context) {
            return Convert.asBoolean(context, PosixShim.WAIT_MACROS.WCOREDUMP(this.status));
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject coredump_p() {
            return this.coredump_p(this.getCurrentContext());
        }

        @JRubyMethod
        public IRubyObject pid(ThreadContext context) {
            return Convert.asFixnum(context, this.pid);
        }

        public long getStatus() {
            return this.status;
        }

        public IRubyObject to_i(Ruby runtime2) {
            return runtime2.newFixnum(this.status);
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject to_s(Ruby runtime2) {
            return this.to_s(this.getCurrentContext());
        }

        @Override
        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return Create.newString(context, RubyStatus.pst_message("", this.pid, this.status));
        }

        boolean unitialized() {
            return this.pid == -1L;
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject inspect(Ruby runtime2) {
            return this.inspect(runtime2.getCurrentContext());
        }

        public static String pst_message(String prefix, long pid2, long status2) {
            String signame2;
            StringBuilder sb = new StringBuilder(prefix);
            sb.append("pid ").append(pid2);
            if (PosixShim.WAIT_MACROS.WIFSTOPPED(status2)) {
                long stopsig2 = PosixShim.WAIT_MACROS.WSTOPSIG(status2);
                signame2 = RubySignal.signo2signm(stopsig2);
                if (signame2 != null) {
                    sb.append(" stopped ").append(signame2).append(" (signal ").append(stopsig2).append(")");
                } else {
                    sb.append(" stopped signal ").append(stopsig2);
                }
            }
            if (PosixShim.WAIT_MACROS.WIFSIGNALED(status2)) {
                long termsig2 = PosixShim.WAIT_MACROS.WTERMSIG(status2);
                signame2 = RubySignal.signo2signm(termsig2);
                if (signame2 != null) {
                    sb.append(" ").append(signame2).append(" (signal ").append(termsig2).append(")");
                } else {
                    sb.append(" signal ").append(termsig2);
                }
            }
            if (PosixShim.WAIT_MACROS.WIFEXITED(status2)) {
                sb.append(" exit ").append(PosixShim.WAIT_MACROS.WEXITSTATUS(status2));
            }
            if (PosixShim.WAIT_MACROS.WCOREDUMP(status2)) {
                sb.append(" (core dumped)");
            }
            return sb.toString();
        }

        @Deprecated(since="9.0.0.0")
        public IRubyObject to_i() {
            return this.to_i(this.getCurrentContext().runtime);
        }

        @Deprecated(since="9.0.0.0")
        public IRubyObject op_rshift(Ruby runtime2, IRubyObject other) {
            ThreadContext context = this.getCurrentContext();
            long shiftValue = Convert.toLong(context, other);
            return Convert.asFixnum(context, this.status >> (int)shiftValue);
        }

        @Deprecated(since="10.0.0.0")
        public IRubyObject op_and(IRubyObject arg2) {
            return this.op_and(this.getCurrentContext(), arg2);
        }
    }

    @JRubyModule(name={"Process::UID"})
    public static class UserID {
        @Deprecated(since="10.0.0.0")
        public static IRubyObject change_privilege(IRubyObject self2, IRubyObject arg2) {
            return UserID.change_privilege(((RubyBasicObject)self2).getCurrentContext(), self2, arg2);
        }

        @JRubyMethod(name={"change_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject change_privilege(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            throw Error.notImplementedError(context, "Process::UID::change_privilege not implemented yet");
        }

        @Deprecated(since="1.2")
        public static IRubyObject eid(IRubyObject self2) {
            return RubyProcess.euid(((RubyBasicObject)self2).getCurrentContext(), null);
        }

        @JRubyMethod(name={"eid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.euid(context, self2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject eid(IRubyObject self2, IRubyObject arg2) {
            return UserID.eid(((RubyBasicObject)self2).getCurrentContext(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return RubyProcess.euid_set(context, self2, arg2);
        }

        public static IRubyObject eid(Ruby runtime2, IRubyObject arg2) {
            return RubyProcess.euid_set(runtime2, arg2);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject grant_privilege(IRubyObject self2, IRubyObject arg2) {
            return UserID.grant_privilege(((RubyBasicObject)self2).getCurrentContext(), self2, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject grant_privilege(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            throw Error.notImplementedError(context, "Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self2) {
            return UserID.switch_rb(context, self2, Block.NULL_BLOCK);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject re_exchangeable_p(IRubyObject self2) {
            return UserID.re_exchangeable_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchangeable_p(ThreadContext context, IRubyObject self2) {
            throw Error.notImplementedError(context, "Process::UID::re_exchangeable? not implemented yet");
        }

        @Deprecated(since="1.2")
        public static IRubyObject rid(IRubyObject self2) {
            return UserID.rid(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"rid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject rid(ThreadContext context, IRubyObject self2) {
            return UserID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime2) {
            return RubyProcess.uid(runtime2);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject sid_available_p(IRubyObject self2) {
            return UserID.sid_available_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"sid_available?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject sid_available_p(ThreadContext context, IRubyObject self2) {
            throw Error.notImplementedError(context, "Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self2, Block block) {
            POSIX posix = context.runtime.getPosix();
            int uid2 = RubyProcess.checkErrno(context, posix.getuid());
            int euid2 = RubyProcess.checkErrno(context, posix.geteuid());
            if (block.isGiven()) {
                try {
                    RubyProcess.checkErrno(context, posix.seteuid(uid2));
                    RubyProcess.checkErrno(context, posix.setuid(euid2));
                    IRubyObject iRubyObject = block.yield(context, context.nil);
                    return iRubyObject;
                }
                finally {
                    RubyProcess.checkErrno(context, posix.seteuid(euid2));
                    RubyProcess.checkErrno(context, posix.setuid(uid2));
                }
            }
            RubyProcess.checkErrno(context, posix.seteuid(uid2));
            RubyProcess.checkErrno(context, posix.setuid(euid2));
            return RubyFixnum.zero(context.runtime);
        }
    }

    @JRubyModule(name={"Process::GID"})
    public static class GroupID {
        @Deprecated(since="10.0.0.0")
        public static IRubyObject change_privilege(IRubyObject self2, IRubyObject arg2) {
            return GroupID.change_privilege(((RubyBasicObject)self2).getCurrentContext(), self2, arg2);
        }

        @JRubyMethod(name={"change_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject change_privilege(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            throw Error.notImplementedError(context, "Process::GID::change_privilege not implemented yet");
        }

        @Deprecated(since="1.2")
        public static IRubyObject eid(IRubyObject self2) {
            return GroupID.eid(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"eid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2) {
            return GroupID.eid(context.runtime);
        }

        public static IRubyObject eid(Ruby runtime2) {
            return RubyProcess.egid(runtime2.getCurrentContext(), null);
        }

        @Deprecated(since="1.2")
        public static IRubyObject eid(IRubyObject self2, IRubyObject arg2) {
            return GroupID.eid(((RubyBasicObject)self2).getCurrentContext(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return GroupID.eid(context.runtime, arg2);
        }

        public static IRubyObject eid(Ruby runtime2, IRubyObject arg2) {
            return RubyProcess.egid_set(runtime2.getCurrentContext(), arg2);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject grant_privilege(IRubyObject self2, IRubyObject arg2) {
            return GroupID.grant_privilege(((RubyBasicObject)self2).getCurrentContext(), self2, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject grant_privilege(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            throw Error.notImplementedError(context, "Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self2) {
            return GroupID.switch_rb(context, self2, Block.NULL_BLOCK);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject re_exchangeable_p(IRubyObject self2) {
            return GroupID.re_exchangeable_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchangeable_p(ThreadContext context, IRubyObject self2) {
            throw Error.notImplementedError(context, "Process::GID::re_exchangeable? not implemented yet");
        }

        @Deprecated(since="1.2")
        public static IRubyObject rid(IRubyObject self2) {
            return GroupID.rid(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"rid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject rid(ThreadContext context, IRubyObject self2) {
            return GroupID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime2) {
            return RubyProcess.gid(runtime2);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject sid_available_p(IRubyObject self2) {
            return GroupID.sid_available_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"sid_available?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject sid_available_p(ThreadContext context, IRubyObject self2) {
            throw Error.notImplementedError(context, "Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self2, Block block) {
            POSIX posix = context.runtime.getPosix();
            int gid2 = RubyProcess.checkErrno(context, posix.getgid());
            int egid2 = RubyProcess.checkErrno(context, posix.getegid());
            if (block.isGiven()) {
                try {
                    RubyProcess.checkErrno(context, posix.setegid(gid2));
                    RubyProcess.checkErrno(context, posix.setgid(egid2));
                    IRubyObject iRubyObject = block.yield(context, context.nil);
                    return iRubyObject;
                }
                finally {
                    RubyProcess.checkErrno(context, posix.setegid(egid2));
                    RubyProcess.checkErrno(context, posix.setgid(gid2));
                }
            }
            RubyProcess.checkErrno(context, posix.setegid(gid2));
            RubyProcess.checkErrno(context, posix.setgid(egid2));
            return RubyFixnum.zero(context.runtime);
        }
    }

    @JRubyModule(name={"Process::Sys"})
    public static class Sys {
        @Deprecated(since="1.2")
        public static IRubyObject getegid(IRubyObject self2) {
            return RubyProcess.egid(((RubyBasicObject)self2).getCurrentContext(), null);
        }

        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.egid(context, self2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject geteuid(IRubyObject self2) {
            return RubyProcess.euid(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.euid(context, self2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject getgid(IRubyObject self2) {
            return RubyProcess.gid(((RubyBasicObject)self2).getCurrentContext());
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.gid(context, self2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject getuid(IRubyObject self2) {
            return RubyProcess.uid(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.uid(context, self2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject setegid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(((RubyBasicObject)recv2).getCurrentContext(), arg2);
        }

        @JRubyMethod(name={"setegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(context, recv2, arg2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject seteuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(((RubyBasicObject)recv2).getCurrentContext(), arg2);
        }

        @JRubyMethod(name={"seteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(context, arg2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject setgid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(((RubyBasicObject)recv2).getCurrentContext().runtime, arg2);
        }

        @JRubyMethod(name={"setgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(context.runtime, arg2);
        }

        @Deprecated(since="1.2")
        public static IRubyObject setuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(((RubyBasicObject)recv2).getCurrentContext(), null, arg2);
        }

        @JRubyMethod(name={"setuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(context, null, arg2);
        }
    }

    private static interface NonNativeErrno {
        public int handle(Ruby var1, int var2);
    }
}

